/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl.log;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.neeve.ods.IStoreObject;
import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryReflectionField;
import com.neeve.query.impl.QueryStaticField;
import com.neeve.query.impl.predicates.PredicatesImpl;
import com.neeve.query.predicates.Predicate;
import com.neeve.rog.IRogMetadata;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.log.RogLogQueryFieldResolver;
import com.neeve.rog.log.RogLogQueryEngine;
import com.neeve.rog.log.RogLogReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RogLogEntryField<T>
extends QueryReflectionField<RogLogReader.Entry, T>
implements RogLogQueryEngine.RogLogField<T> {
    private static final long serialVersionUID = 1L;
    private static boolean staticFieldsEnabled = true;
    public static final RogLogQueryEngine.RogLogField<RogLogReader.Entry> ENTRY = new StaticRogLogField<RogLogReader.Entry>("", RogLogReader.Entry.class){
        private static final long serialVersionUID = 1L;

        @Override
        protected RogLogReader.Entry applyUnchecked(RogLogReader.Entry record) {
            return record;
        }
    };
    public static final RogLogQueryEngine.RogLogField<Long> TIMESTAMP = new StaticRogLogField<Long>("timestamp", Long.class){
        private static final long serialVersionUID = 1L;

        @Override
        protected Long applyUnchecked(RogLogReader.Entry record) {
            return record.getTimestamp();
        }
    };
    public static final RogLogQueryEngine.RogLogField<IStoreObject> PAYLOAD = new StaticRogLogField<IStoreObject>("object", IStoreObject.class){
        private static final long serialVersionUID = 1L;
        {
            this.pathSelector = new Class[]{Object.class};
        }

        @Override
        protected IStoreObject applyUnchecked(RogLogReader.Entry record) {
            return record.getObject();
        }

        @Override
        public double getCost() {
            return 1.0;
        }
    };
    public static final RogLogQueryEngine.RogLogField<Class> PAYLOAD_TYPE = new StaticRogLogField<Class>("object.class", Class.class){
        private static final long serialVersionUID = 1L;
        {
            this.pathSelector = new Class[]{Object.class, Class.class};
        }

        @Override
        protected Class<?> applyUnchecked(RogLogReader.Entry entry) {
            return RogLogQueryFieldResolver.get().getType(entry.getOfid(), entry.getOtype());
        }
    };
    public static final RogLogQueryEngine.RogLogField<String> CLASS_NAME = new StaticRogLogField<String>("className", String.class){
        private static final long serialVersionUID = 1L;

        @Override
        protected String applyUnchecked(RogLogReader.Entry record) {
            Class type = (Class)PAYLOAD_TYPE.apply(record);
            return type.getCanonicalName();
        }
    };
    public static final RogLogQueryEngine.RogLogField<String> SIMPLE_CLASS_NAME = new StaticRogLogField<String>("simpleClassName", String.class){
        private static final long serialVersionUID = 1L;

        @Override
        protected String applyUnchecked(RogLogReader.Entry record) {
            Class type = (Class)PAYLOAD_TYPE.apply(record);
            return type.getSimpleName();
        }
    };
    private transient String canonicalName;
    private final String name;
    private Set<Class<?>> payloadTypes = Sets.newHashSet();
    private transient Predicate<RogLogReader.Entry> payloadTypePredicate = null;

    public static void enableStaticFields(boolean enable) {
        staticFieldsEnabled = enable;
    }

    public static <T> RogLogQueryEngine.RogLogField<T> create(String name, String fieldPath, Class<T> fieldType, Class<?>[] pathSelector) {
        if (staticFieldsEnabled) {
            if (Strings.isNullOrEmpty((String)fieldPath)) {
                return ENTRY;
            }
            if (fieldPath.equals("timestamp")) {
                return TIMESTAMP;
            }
            if (fieldPath.equals("object") && fieldType.isAssignableFrom(IRogNode.class)) {
                return PAYLOAD;
            }
            if (fieldPath.equals("object.class")) {
                return PAYLOAD_TYPE;
            }
            if (fieldPath.equals("className")) {
                return CLASS_NAME;
            }
            if (fieldPath.equals("simpleClassName")) {
                return SIMPLE_CLASS_NAME;
            }
        }
        return new RogLogEntryField<T>(name, fieldPath, fieldType, pathSelector);
    }

    protected RogLogEntryField(String name, String fieldPath, Class<T> fieldType, Class<?>[] pathSelector) {
        super(RogLogReader.Entry.class, fieldType, fieldPath, pathSelector);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    @Override
    public String getCanonicalName() {
        if (this.canonicalName == null) {
            if (this.fieldPath == null || this.fieldPath.length() == 0) {
                this.canonicalName = "Entry";
            } else if (this.fieldPath.equals("metadata")) {
                this.canonicalName = this.fieldPath;
            } else if (this.fieldPath.startsWith("metadata.")) {
                this.canonicalName = this.fieldPath;
            } else if (this.fieldPath.equals("object")) {
                this.canonicalName = this.fieldPath;
            } else if (this.fieldPath.startsWith("object.")) {
                if (this.isQualified()) {
                    Class recordType = this.pathSelector[0];
                    this.canonicalName = this.getCanonicalName(recordType) + this.fieldPath.substring(6);
                } else {
                    this.canonicalName = this.fieldPath;
                }
            } else {
                this.canonicalName = "Entry." + this.fieldPath;
            }
        }
        return this.canonicalName;
    }

    @Override
    public Class<?> getObjectType() {
        if (this.getFieldType() == IRogMetadata.class) {
            return IRogMetadata.class;
        }
        if (this.getFieldType() == RogLogReader.Entry.class) {
            return RogLogReader.Entry.class;
        }
        if (this.pathSelector != null && this.pathSelector.length > 0) {
            return this.pathSelector[0];
        }
        return Object.class;
    }

    @Override
    protected boolean isRecordTypeStatic() {
        return true;
    }

    @Override
    public boolean isQualified() {
        return this.pathSelector != null && this.pathSelector.length > 0 && this.pathSelector[0] != Object.class;
    }

    @Override
    protected boolean supportsPayloadTypeInference() {
        return true;
    }

    @Override
    protected String getPayloadPath() {
        return "object";
    }

    @Override
    public void registerPayloadType(Class<?> type) {
        this.payloadTypes.add(type);
    }

    @Override
    public Set<Class<?>> getPayloadTypes() {
        return this.payloadTypes;
    }

    @Override
    protected Predicate<RogLogReader.Entry> getPayloadTypePredicate() {
        if (this.payloadTypePredicate == null) {
            if (this.payloadTypes.isEmpty()) {
                this.payloadTypePredicate = PredicatesImpl.get().alwaysTrue();
            } else {
                HashSet types = Sets.newHashSet(this.payloadTypes);
                this.payloadTypePredicate = PAYLOAD_TYPE.in(types);
            }
        }
        return this.payloadTypePredicate;
    }

    @Override
    public T convertToFieldType(Object value) throws IllegalArgumentException {
        if (this.fieldType == Class.class && value instanceof String) {
            String className = (String)value;
            try {
                return (T)RogLogQueryFieldResolver.get().resolveType(className);
            }
            catch (QueryException queryException) {
                // empty catch block
            }
        }
        return super.convertToFieldType(value);
    }

    private static abstract class StaticRogLogField<T>
    extends QueryStaticField<RogLogReader.Entry, T>
    implements RogLogQueryEngine.RogLogField<T> {
        private static final long serialVersionUID = 1L;
        private transient String canonicalName;

        public StaticRogLogField(String fieldPath, Class<T> fieldType) {
            super(RogLogReader.Entry.class, fieldPath, fieldType);
        }

        @Override
        public Class<?> getObjectType() {
            if (this.getFieldType() == IRogMetadata.class) {
                return IRogMetadata.class;
            }
            if (this.getFieldType() == RogLogReader.Entry.class) {
                return RogLogReader.Entry.class;
            }
            if (this.pathSelector != null && this.pathSelector.length > 0) {
                return this.pathSelector[0];
            }
            return Object.class;
        }

        @Override
        public String getCanonicalName() {
            if (this.canonicalName == null) {
                if (this.fieldPath == null || this.fieldPath.length() == 0) {
                    this.canonicalName = "entry";
                } else if (this.fieldPath.equals("metadata")) {
                    this.canonicalName = this.fieldPath;
                } else if (this.fieldPath.startsWith("metadata.")) {
                    this.canonicalName = this.fieldPath;
                } else if (this.fieldPath.equals("object")) {
                    this.canonicalName = this.fieldPath;
                } else if (this.fieldPath.startsWith("object.")) {
                    if (this.isQualified()) {
                        Class recordType = this.pathSelector[0];
                        this.canonicalName = this.getCanonicalName(recordType) + this.fieldPath.substring(6);
                    } else {
                        this.canonicalName = this.fieldPath;
                    }
                } else {
                    this.canonicalName = "entry." + this.fieldPath;
                }
            }
            return this.canonicalName;
        }

        @Override
        public void registerPayloadType(Class<?> type) {
        }

        @Override
        public Set<Class<?>> getPayloadTypes() {
            return Collections.emptySet();
        }

        @Override
        public T convertToFieldType(Object value) throws IllegalArgumentException {
            if (this.fieldType == Class.class && value instanceof String) {
                String className = (String)value;
                try {
                    return (T)RogLogQueryFieldResolver.get().resolveType(className);
                }
                catch (QueryException queryException) {
                    // empty catch block
                }
            }
            return super.convertToFieldType(value);
        }
    }
}

