/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.neeve.config.Config;
import com.neeve.io.IOBufferPacket;
import com.neeve.io.IONativePacket;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.impl.RogPacketMessage;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import java.nio.ByteBuffer;
import java.util.Properties;

public class RogPacketMessageFactory
implements IStoreObjectFactory,
MessageViewFactory {
    private static final ThreadLocal<RogPacketMessage.PoolFactoryItemCreateArgument> _packetMessagePoolGetArgument = new ThreadLocal<RogPacketMessage.PoolFactoryItemCreateArgument>(){

        @Override
        protected final RogPacketMessage.PoolFactoryItemCreateArgument initialValue() {
            return new RogPacketMessage.PoolFactoryItemCreateArgument();
        }
    };
    static final short OFID = 4;
    static final short VFID = 7;
    public static final short ID_RogPacketMessage = 1;
    static final ObjectMapper mapper = new ObjectMapper();

    private RogPacketMessageFactory() {
    }

    public static final RogPacketMessageFactory create(Properties properties) {
        return new RogPacketMessageFactory();
    }

    public static final RogPacketMessage createPacketMessage(UUID id) {
        RogPacketMessage.PoolFactoryItemCreateArgument arg = _packetMessagePoolGetArgument.get();
        RogPacketMessage val = (RogPacketMessage)RogPacketMessage.POOL.get((Object)arg.init(id));
        if (!arg.wasCreated) {
            val.undispose(id);
        }
        return val;
    }

    public static final RogPacketMessage createPacketMessage() {
        RogPacketMessage val = RogPacketMessageFactory.createPacketMessage(null);
        val.ensureOId();
        return val;
    }

    @Override
    public short getOfid() {
        return 4;
    }

    @Override
    public final IStoreObject create(short type, UUID id, IStoreObject.EncodingType encodingType, PktPacket packet) {
        if (encodingType != IStoreObject.EncodingType.Custom) {
            throw new IllegalArgumentException("Packet messages only support the Custom encoding type");
        }
        if (type == 1) {
            return RogPacketMessageFactory.createPacketMessage().deserializeFromPacket(packet);
        }
        throw new IllegalArgumentException("Unsupported object type (" + type + ").");
    }

    public final short getVfid() {
        return 7;
    }

    public final MessageView create(short vid) {
        if (vid == 1) {
            return RogPacketMessage.create();
        }
        throw new IllegalArgumentException("unknown view id '" + vid + "'");
    }

    public final MessageView wrap(short type, int encodingType, Object message) {
        if (encodingType != 1) {
            throw new IllegalArgumentException("packet messages only support custom encoding formats");
        }
        RogPacketMessage view = RogPacketMessageFactory.createPacketMessage();
        if (message instanceof IONativePacket) {
            IONativePacket ioNativePacket = (IONativePacket)message;
            return view.deserializeFrom(ioNativePacket.addr, ioNativePacket.offset, ioNativePacket.length);
        }
        if (message instanceof IOBufferPacket) {
            IOBufferPacket iobufPacket = (IOBufferPacket)message;
            return view.deserializeFrom(iobufPacket.buf, iobufPacket.offset, iobufPacket.length);
        }
        if (message instanceof byte[]) {
            return view.deserializeFromByteArray((byte[])message);
        }
        if (message instanceof ByteBuffer) {
            return view.deserializeFromByteBuffer((ByteBuffer)message);
        }
        if (message instanceof PktPacket) {
            return view.deserializeFromPacket((PktPacket)message);
        }
        throw new IllegalArgumentException("unknown serialized form '" + message.getClass().getName() + "'");
    }

    static {
        mapper.configure(MapperFeature.USE_ANNOTATIONS, true).configure(MapperFeature.AUTO_DETECT_GETTERS, false).configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false).configure(MapperFeature.AUTO_DETECT_FIELDS, false).configure(MapperFeature.AUTO_DETECT_SETTERS, false).configure(MapperFeature.AUTO_DETECT_CREATORS, false).configure(MapperFeature.USE_GETTERS_AS_SETTERS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, Config.getValue((String)"nv.indent.json", (boolean)false));
    }
}

