/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.predicates;

import com.google.common.collect.Lists;
import com.neeve.query.impl.predicates.PredicateBase;
import com.neeve.query.impl.predicates.PredicateOperator;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxFieldPredicate;
import com.neeve.query.predicates.Predicate;
import com.neeve.util.UtlDataTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class FieldPredicate<REC, T, OP extends PredicateOperator>
extends PredicateBase<REC>
implements IdxFieldPredicate<REC, T> {
    private IdxField<REC, T> field;
    protected OP operator;

    public FieldPredicate(IdxField<REC, T> field, OP operator) {
        this.field = field;
        this.operator = operator;
    }

    @Override
    public IdxField<REC, T> getField() {
        return this.field;
    }

    public OP getOperator() {
        return this.operator;
    }

    @Override
    public abstract boolean applyToSubject(T var1);

    public abstract List<T> getValues();

    public final boolean apply(REC record) {
        Object subject = this.field.apply(record);
        return this.applyToSubject(subject);
    }

    @Override
    public double getCost() {
        return this.field.getCost();
    }

    @Override
    public void regularize() {
    }

    @Override
    public void prioritizeBy(Comparator<Predicate<?>> comparator) {
    }

    public static class NaryFieldPredicate<REC, T>
    extends FieldPredicate<REC, T, PredicateOperator.NaryOperator> {
        List<T> values;

        public NaryFieldPredicate(IdxField<REC, T> field, PredicateOperator.NaryOperator operator, T ... values) {
            super(field, operator);
            this.values = Lists.newArrayList((Object[])values);
        }

        public NaryFieldPredicate(IdxField<REC, T> field, PredicateOperator.NaryOperator operator, Collection<T> values) {
            super(field, operator);
            this.values = Lists.newArrayList(values);
        }

        @Override
        public List<T> getValues() {
            return this.values;
        }

        @Override
        public boolean applyToSubject(T subject) {
            return ((PredicateOperator.NaryOperator)this.operator).apply(subject, this.values);
        }

        public String toString() {
            return this.getField().getName() + " " + this.operator + " " + this.getValues();
        }
    }

    public static class TernaryFieldPredicate<REC, T>
    extends FieldPredicate<REC, T, PredicateOperator.TernaryOperator> {
        private T lowValue;
        private T highValue;

        public TernaryFieldPredicate(IdxField<REC, T> field, PredicateOperator.TernaryOperator operator, T lowValue, T highValue) {
            super(field, operator);
            this.lowValue = lowValue;
            this.highValue = highValue;
        }

        public T getLowValue() {
            return this.lowValue;
        }

        public T getHighValue() {
            return this.highValue;
        }

        @Override
        public List<T> getValues() {
            return Lists.newArrayList((Object[])new Object[]{this.lowValue, this.highValue});
        }

        @Override
        public boolean applyToSubject(T subject) {
            return ((PredicateOperator.TernaryOperator)this.operator).apply(subject, this.lowValue, this.highValue);
        }

        public String toString() {
            return this.getField().getName() + " " + this.lowValue + " " + this.operator + " " + this.highValue;
        }
    }

    public static class BinaryFieldPredicate<REC, T>
    extends FieldPredicate<REC, T, PredicateOperator.BinaryOperator> {
        private T value;

        public BinaryFieldPredicate(IdxField<REC, T> field, PredicateOperator.BinaryOperator operator, T value) {
            super(field, operator);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public List<T> getValues() {
            return Lists.newArrayList((Object[])new Object[]{this.value});
        }

        @Override
        public boolean applyToSubject(T subject) {
            if (this.value != null && subject != null && this.value.getClass() != subject.getClass()) {
                this.value = UtlDataTypes.convert(subject.getClass(), this.value);
            }
            return ((PredicateOperator.BinaryOperator)this.operator).apply(subject, this.value);
        }

        public String toString() {
            return this.getField().getName() + " " + this.operator + " " + this.value;
        }
    }

    public static class UnaryFieldPredicate<REC, T>
    extends FieldPredicate<REC, T, PredicateOperator.UnaryOperator> {
        public UnaryFieldPredicate(IdxField<REC, T> field, PredicateOperator.UnaryOperator operator) {
            super(field, operator);
        }

        @Override
        public boolean applyToSubject(T subject) {
            return ((PredicateOperator.UnaryOperator)this.operator).apply(subject);
        }

        @Override
        public List<T> getValues() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.getField().getName() + " " + this.operator;
        }
    }
}

