/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.AggregateNode;
import com.akiban.sql.parser.BetweenOperatorNode;
import com.akiban.sql.parser.BinaryLogicalOperatorNode;
import com.akiban.sql.parser.BinaryRelationalOperatorNode;
import com.akiban.sql.parser.CastNode;
import com.akiban.sql.parser.CursorNode;
import com.akiban.sql.parser.FromBaseTable;
import com.akiban.sql.parser.FromList;
import com.akiban.sql.parser.FromTable;
import com.akiban.sql.parser.InListOperatorNode;
import com.akiban.sql.parser.LikeEscapeOperatorNode;
import com.akiban.sql.parser.NotNode;
import com.akiban.sql.parser.ResultColumn;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.RowConstructorNode;
import com.akiban.sql.parser.SelectNode;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.UnaryComparisonOperatorNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.types.DataTypeDescriptor;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.neeve.query.QueryParseException;
import java.util.Set;

public class QueryValidator {
    private static final Set<String> supportedAggregates = Sets.newHashSet((Object[])new String[]{"COUNT", "MIN", "MAX", "SUM", "AVG"});

    public void validate() {
    }

    public void validateSelect(StatementNode stmt) throws StandardException {
        if (stmt.getNodeType() != 147) {
            throw new QueryParseException("Only SELECT statements are supported.", 0);
        }
        CursorNode cursor = (CursorNode)stmt;
        ResultSetNode resultSet = cursor.getResultSetNode();
        if (resultSet.getNodeType() != 129) {
            throw new QueryParseException("Only SELECT statements are supported.", 0);
        }
        SelectNode select = (SelectNode)resultSet;
        ResultColumnList resultColumns = select.getResultColumns();
        int numColumns = resultColumns.size();
        if (numColumns == 0) {
            throw new QueryParseException("No columns were selected.", resultColumns.getBeginOffset());
        }
        for (int i = 0; i < numColumns; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumns.get(i);
            this.validateColumn((ValueNode)resultColumn);
        }
        FromList fromList = select.getFromList();
        if (fromList == null || fromList.size() == 0) {
            int beginOffset = fromList == null ? select.getBeginOffset() : fromList.getBeginOffset();
            throw new QueryParseException("No FROM clause was specified", beginOffset);
        }
        int numTables = fromList.size();
        for (int i = 0; i < numTables; ++i) {
            FromTable fromTable = (FromTable)fromList.get(i);
            if (fromTable.getNodeType() == 135) {
                FromBaseTable fromBaseTable = (FromBaseTable)fromTable;
                TableName fromTableName = fromBaseTable.getTableName();
                String schemaName = fromTableName.getSchemaName();
                if (Strings.isNullOrEmpty((String)schemaName)) continue;
                throw new QueryParseException("A schema may not be specified when SELECTing FROM a repository alias", fromBaseTable.getBeginOffset());
            }
            throw new QueryParseException("May only select FROM query aliases", fromTable.getBeginOffset());
        }
        ValueNode where = select.getWhereClause();
        if (where != null) {
            this.validateCondition(where);
        }
        if (select.getWindows() != null) {
            throw new QueryParseException("WINDOW functions are not currently supported.", select.getWindows().getBeginOffset());
        }
    }

    private void validateCondition(ValueNode condition) {
        switch (condition.getNodeType()) {
            case 26: {
                NotNode not = (NotNode)condition;
                ValueNode operand = not.getOperand();
                this.validateCondition(operand);
                return;
            }
            case 39: 
            case 52: {
                BinaryLogicalOperatorNode binaryLogicalOperator = (BinaryLogicalOperatorNode)condition;
                this.validateCondition(binaryLogicalOperator.getLeftOperand());
                this.validateCondition(binaryLogicalOperator.getRightOperand());
                return;
            }
            case 24: 
            case 25: {
                UnaryComparisonOperatorNode unaryOperator = (UnaryComparisonOperatorNode)condition;
                this.validateColumn(unaryOperator.getOperand());
                return;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                BinaryRelationalOperatorNode binaryOperator = (BinaryRelationalOperatorNode)condition;
                this.validateColumn(binaryOperator.getLeftOperand());
                this.validateConstant(binaryOperator.getRightOperand());
                return;
            }
            case 51: {
                LikeEscapeOperatorNode likeOperator = (LikeEscapeOperatorNode)condition;
                this.validateColumn(likeOperator.getReceiver());
                this.validateConstant(likeOperator.getLeftOperand());
                return;
            }
            case 53: {
                BetweenOperatorNode between = (BetweenOperatorNode)condition;
                this.validateColumn(between.getLeftOperand());
                ValueNodeList lowHighValues = between.getRightOperandList();
                this.validateConstant((ValueNode)lowHighValues.get(0));
                this.validateConstant((ValueNode)lowHighValues.get(1));
                return;
            }
            case 55: {
                InListOperatorNode in = (InListOperatorNode)condition;
                RowConstructorNode left = in.getLeftOperand();
                ValueNodeList leftList = left.getNodeList();
                this.validateColumn((ValueNode)leftList.get(0));
                RowConstructorNode rightIn = in.getRightOperandList();
                ValueNodeList rightList = rightIn.getNodeList();
                int rightSize = rightList.size();
                for (int i = 0; i < rightSize; ++i) {
                    this.validateConstant((ValueNode)rightList.get(i));
                }
                return;
            }
            case 57: {
                throw new QueryParseException("The operator NOT IN is unsupported", condition.getBeginOffset());
            }
            case 56: {
                throw new QueryParseException("The operator NOT BETWEEN is unsupported", condition.getBeginOffset());
            }
        }
        throw new QueryParseException("Only conditions against class fields may be used in the WHERE clause", condition.getBeginOffset());
    }

    private void validateColumn(ValueNode expression) {
        int nodeType = expression.getNodeType();
        switch (nodeType) {
            case 80: {
                ResultColumn resultColumn = (ResultColumn)expression;
                this.validateColumn(resultColumn.getExpression());
                return;
            }
            case 62: {
                return;
            }
            case 16: {
                return;
            }
            case 115: {
                AggregateNode agg = (AggregateNode)expression;
                String aggregateName = agg.getAggregateName();
                if ("COUNT(*)".equalsIgnoreCase(aggregateName)) {
                    return;
                }
                this.validateColumn(agg.getOperand());
                if (!supportedAggregates.contains(aggregateName)) {
                    throw new QueryParseException(aggregateName + " is not a supported aggregate", expression.getBeginOffset());
                }
                return;
            }
        }
        throw new QueryParseException("Only classes or class fields may be used as query expressions", expression.getBeginOffset());
    }

    private void validateConstant(ValueNode constant) {
        int beginOffset = constant.getBeginOffset();
        switch (constant.getNodeType()) {
            case 61: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 75: 
            case 77: {
                return;
            }
            case 60: {
                CastNode castNode = (CastNode)constant;
                DataTypeDescriptor type = castNode.getType();
                String typeName = type.getTypeName();
                ValueNode castOperand = castNode.getCastOperand();
                if (typeName.equals("DATE") || typeName.equals("TIMESTAMP")) {
                    this.validateConstant(castOperand);
                    return;
                }
                if (beginOffset != -1) break;
                beginOffset = castOperand.getBeginOffset();
                break;
            }
        }
        throw new QueryParseException("Only constants may be use in the right side of a condition", constant.getBeginOffset());
    }
}

