/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import cern.colt.list.DoubleArrayList;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.neeve.lang.XString;
import com.neeve.query.QueryStats;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;

public class QueryStatsImpl
extends Stats
implements QueryStats {
    private List<DeltaLatencies> stepLatencies = Lists.newArrayList();

    public static <T> Iterator<T> timeIteration(final Iterator<T> iter, final DeltaLatencies latencies) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                latencies.start();
                boolean hasNext = iter.hasNext();
                if (!hasNext) {
                    latencies.cancel();
                    latencies.compute();
                } else {
                    latencies.suspend();
                }
                return hasNext;
            }

            @Override
            public T next() {
                latencies.startOrResume();
                Object next = iter.next();
                latencies.stop();
                return next;
            }

            @Override
            public void remove() {
                iter.remove();
            }
        };
    }

    public static <T> Iterable<T> timeIteration(final Iterable<T> iterable, final DeltaLatencies latencies) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return QueryStatsImpl.timeIteration(iterable.iterator(), latencies);
            }
        };
    }

    public QueryStatsImpl() {
        super("nv.query", QueryStatsImpl.class.getSimpleName(), "nv.query.stats", null);
        this.startPeriodicOutputIfConfigured();
    }

    protected void init() {
    }

    public void get(StringBuilder sb) {
        for (DeltaLatencies latencies : this.stepLatencies) {
            latencies.get(sb);
        }
    }

    public void addStepLatencies(DeltaLatencies latencies) {
        this.stepLatencies.add(latencies);
    }

    public List<DeltaLatencies> getStepLatencies() {
        return this.stepLatencies;
    }

    @Override
    public void compute() {
        for (DeltaLatencies latencies : this.stepLatencies) {
            latencies.compute();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("QueryStats\n");
        this.get(sb);
        return sb.toString();
    }

    public static class TimedPredicate<T>
    implements Predicate<T> {
        private Predicate<T> predicate;
        private DeltaLatencies latencies;

        public TimedPredicate(Predicate<T> predicate, DeltaLatencies latencies) {
            this.predicate = predicate;
            this.latencies = latencies;
        }

        public boolean apply(T input) {
            this.latencies.start();
            boolean result = this.predicate.apply(input);
            this.latencies.stop();
            return result;
        }
    }

    public static class DeltaLatencies
    implements IStats.Latencies {
        private final Stats.LatencyManager latencies;
        private State state = State.STOPPED;
        private long millis = 0L;
        private long start = -1L;

        public DeltaLatencies(String name) {
            this.latencies = new Stats.LatencyManager(name);
        }

        private long now() {
            return System.currentTimeMillis();
        }

        public void start() {
            this.start = this.now();
            this.millis = 0L;
            this.state = State.RUNNING;
        }

        public void suspend() {
            switch (this.state) {
                case RUNNING: {
                    this.millis += this.now() - this.start;
                    this.state = State.SUSPENDED;
                    break;
                }
                case SUSPENDED: {
                    break;
                }
            }
        }

        public void resume() {
            switch (this.state) {
                case RUNNING: {
                    break;
                }
                case SUSPENDED: {
                    this.start = this.now();
                    this.state = State.RUNNING;
                    break;
                }
            }
        }

        public void startOrResume() {
            switch (this.state) {
                case RUNNING: {
                    break;
                }
                case SUSPENDED: {
                    this.resume();
                    break;
                }
                case STOPPED: {
                    this.start();
                }
            }
        }

        public void cancel() {
            this.millis = 0L;
            this.state = State.STOPPED;
        }

        public void stop() {
            switch (this.state) {
                case RUNNING: {
                    this.millis += this.now() - this.start;
                    this.add(this.millis);
                    break;
                }
                case SUSPENDED: {
                    this.add(this.millis);
                    break;
                }
            }
            this.state = State.STOPPED;
        }

        public String getName() {
            return this.latencies.getName();
        }

        public final IStats.Series.Type getType() {
            return this.latencies.getType();
        }

        public long sequenceNumber() {
            return this.latencies.sequenceNumber();
        }

        public long sample() {
            return this.latencies.sample();
        }

        public double min() {
            return this.latencies.min();
        }

        public double max() {
            return this.latencies.max();
        }

        public double mean() {
            return this.latencies.mean();
        }

        public double median() {
            return this.latencies.median();
        }

        public double pct75() {
            return this.latencies.pct75();
        }

        public double pct90() {
            return this.latencies.pct90();
        }

        public double pct99() {
            return this.latencies.pct99();
        }

        public double pct999() {
            return this.latencies.pct999();
        }

        public double pct9999() {
            return this.latencies.pct9999();
        }

        public void compute() {
            this.latencies.compute();
        }

        public void get(StringBuilder builder, NumberFormat format) {
            this.latencies.get(builder, format);
        }

        public void get(StringBuilder builder, boolean csv) {
            this.latencies.get(builder, csv);
        }

        public void get(StringBuilder builder) {
            this.latencies.get(builder);
        }

        public long get(IStats.Series.Collector collector, DoubleArrayList temp, long minSeqNo) {
            return this.latencies.get(collector, temp, minSeqNo);
        }

        public long add(double latency) {
            return this.latencies.add(latency);
        }

        public int size() {
            return this.latencies.size();
        }

        public XString getNameAsRaw() {
            return this.latencies.getNameAsRaw();
        }

        public void reset() {
            this.latencies.reset();
        }

        private static enum State {
            RUNNING,
            SUSPENDED,
            STOPPED;

        }
    }
}

