/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.eaio.uuid.UUID;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.neeve.query.impl.QuerySortArea;
import com.neeve.query.impl.index.IdxIndexManager;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mapdb.BTreeMap;
import org.mapdb.DB;

public class QuerySortAreaImpl<ID, REC>
implements QuerySortArea<REC> {
    private final IdxIndexManager<ID, REC> indexManager;
    private Set<String> persistentCollectionNames = Sets.newConcurrentHashSet();
    private Map<String, Object> collections = Maps.newHashMap();
    private int inMemoryCardinality = 500;

    public QuerySortAreaImpl() {
        this.indexManager = IdxIndexManager.createTemp();
    }

    public void open() {
        this.indexManager.open();
    }

    public void close() {
        this.indexManager.close();
    }

    public boolean isOpen() {
        return this.indexManager.isOpen();
    }

    public boolean awaitShutdown(long millis) {
        return this.indexManager.awaitShutdown(millis);
    }

    public void awaitShutdown() throws InterruptedException {
        this.indexManager.awaitShutdown();
    }

    @Override
    public String createCollectionId() {
        return new UUID().toString();
    }

    private DB getMapdb() {
        return this.indexManager.getMapDb();
    }

    private <T> Set<T> createPersistentHashSet(String name) {
        this.persistentCollectionNames.add(name);
        return this.getMapdb().createHashSet(name).counterEnable().make();
    }

    private <T> Set<T> retrievePersistentHashSet(String name) {
        if (this.persistentCollectionNames.contains(name)) {
            return this.getMapdb().getHashSet(name);
        }
        return null;
    }

    private <K, V> Map<K, V> createPersistentHashMap(String name) {
        this.persistentCollectionNames.add(name);
        return this.getMapdb().createHashMap(name).counterEnable().make();
    }

    private <K, V> Map<K, V> retrievePersistentHashMap(String name) {
        if (this.persistentCollectionNames.contains(name)) {
            return this.getMapdb().getHashMap(name);
        }
        return null;
    }

    private <T> NavigableSet<T> createNavigableSet(String name, Comparator<T> comparator) {
        DB mapDb;
        this.persistentCollectionNames.add(name);
        DB dB = mapDb = this.getMapdb();
        dB.getClass();
        DB.BTreeSetMaker setMaker = new DB.BTreeSetMaker(dB, name);
        return setMaker.comparator(comparator).counterEnable().make();
    }

    private <T> NavigableSet<T> createNavigableSet(String name) {
        this.persistentCollectionNames.add(name);
        return this.getMapdb().createTreeSet(name).counterEnable().make();
    }

    private <T> NavigableSet<T> retrievePersistentNavigableSet(String name) {
        if (this.persistentCollectionNames.contains(name)) {
            return this.getMapdb().getTreeSet(name);
        }
        return null;
    }

    private <T> List<T> createPersistentList(String name) {
        this.persistentCollectionNames.add(name);
        BTreeMap backingMap = this.getMapdb().createTreeMap(name).counterEnable().make();
        return new PersistentList(backingMap);
    }

    private <T> List<T> retrievePersistentList(String name) {
        if (this.persistentCollectionNames.contains(name)) {
            BTreeMap backingMap = this.getMapdb().getTreeMap(name);
            return new PersistentList(backingMap);
        }
        return null;
    }

    @Override
    public <T> List<T> getList(String name) {
        SortAreaList list;
        if (this.collections.containsKey(name)) {
            list = (SortAreaList)this.collections.get(name);
        } else {
            list = new SortAreaList(name, this.inMemoryCardinality);
            this.collections.put(name, list);
        }
        return list;
    }

    @Override
    public <T> Set<T> getHashSet(String name) {
        SortAreaHashSet set;
        if (this.collections.containsKey(name)) {
            set = (SortAreaHashSet)this.collections.get(name);
        } else {
            set = new SortAreaHashSet(name, this.inMemoryCardinality);
            this.collections.put(name, set);
        }
        return set;
    }

    @Override
    public <T> NavigableSet<T> getNavigableSet(String name) {
        SortAreaNavigableSet set;
        if (this.collections.containsKey(name)) {
            set = (SortAreaNavigableSet)this.collections.get(name);
        } else {
            set = new SortAreaNavigableSet(name, this.inMemoryCardinality);
            this.collections.put(name, set);
        }
        return set;
    }

    @Override
    public <T> NavigableSet<T> getNavigableSet(String name, Comparator<T> comparator) {
        SortAreaNavigableSet<T> set;
        if (this.collections.containsKey(name)) {
            set = (SortAreaNavigableSet<T>)this.collections.get(name);
        } else {
            set = new SortAreaNavigableSet<T>(name, comparator, this.inMemoryCardinality);
            this.collections.put(name, set);
        }
        return set;
    }

    @Override
    public <K, V> Map<K, V> getHashMap(String name) {
        SortAreaHashMap map;
        if (this.collections.containsKey(name)) {
            map = (SortAreaHashMap)this.collections.get(name);
        } else {
            map = new SortAreaHashMap(name, this.inMemoryCardinality);
            this.collections.put(name, map);
        }
        return map;
    }

    @Override
    public void dropCollection(String name) {
        this.collections.remove(name);
        this.persistentCollectionNames.remove(name);
        if (this.persistentCollectionNames.isEmpty()) {
            this.indexManager.close();
            this.indexManager.open();
        }
    }

    public void setInMemoryCardinality(int inMemoryCardinality) {
        this.inMemoryCardinality = inMemoryCardinality;
    }

    private static final class PersistentList<T>
    extends AbstractList<T> {
        private final Map<Integer, T> backingMap;
        private int size;

        public PersistentList(Map<Integer, T> backingMap) {
            this.backingMap = backingMap;
            this.size = backingMap.size();
        }

        @Override
        public void clear() {
            this.backingMap.clear();
        }

        @Override
        public boolean add(T element) {
            this.backingMap.put(this.size, element);
            ++this.size;
            return true;
        }

        @Override
        public T get(int index) {
            return this.backingMap.get(index);
        }

        @Override
        public Iterator<T> iterator() {
            return this.backingMap.values().iterator();
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private final class SortAreaHashMap<K, V>
    extends AbstractMap<K, V> {
        private String name;
        private int persistentSizeThreshold;
        private Map<K, V> map;
        private boolean persistent;

        public SortAreaHashMap(String name, int persistentSizeThreshold) {
            this.name = name;
            this.persistentSizeThreshold = persistentSizeThreshold;
            if (QuerySortAreaImpl.this.persistentCollectionNames.contains(name)) {
                this.map = QuerySortAreaImpl.this.retrievePersistentHashMap(name);
                this.persistent = true;
            } else {
                this.map = Maps.newHashMap();
                this.persistent = false;
            }
        }

        @Override
        public V put(K key, V value) {
            V oldValue = this.map.put(key, value);
            if (oldValue == null && !this.persistent && this.map.size() >= this.persistentSizeThreshold) {
                Map persistentMap = QuerySortAreaImpl.this.createPersistentHashMap(this.name);
                persistentMap.putAll(this.map);
                this.map = persistentMap;
                this.persistent = true;
            }
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.map.putAll(m);
            if (!this.persistent && this.map.size() >= this.persistentSizeThreshold) {
                Map persistentMap = QuerySortAreaImpl.this.createPersistentHashMap(this.name);
                persistentMap.putAll(this.map);
                this.map = persistentMap;
                this.persistent = true;
            }
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public void clear() {
            if (this.persistent) {
                QuerySortAreaImpl.this.dropCollection(this.name);
                this.map = Maps.newHashMap();
                this.persistent = false;
            } else {
                this.map.clear();
            }
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }
    }

    private final class SortAreaNavigableSet<T>
    extends AbstractSet<T>
    implements NavigableSet<T> {
        private String name;
        private int persistentSizeThreshold;
        private NavigableSet<T> set;
        private boolean persistent;
        private Comparator<T> comparator;

        public SortAreaNavigableSet(String name, int persistentSizeThreshold) {
            this.name = name;
            this.persistentSizeThreshold = persistentSizeThreshold;
            if (QuerySortAreaImpl.this.persistentCollectionNames.contains(name)) {
                this.set = QuerySortAreaImpl.this.retrievePersistentNavigableSet(name);
                this.persistent = true;
            } else {
                this.set = new TreeSet<T>();
                this.persistent = false;
            }
        }

        public SortAreaNavigableSet(String name, Comparator<T> comparator, int persistentSizeThreshold) {
            this.name = name;
            this.comparator = comparator;
            this.persistentSizeThreshold = persistentSizeThreshold;
            if (QuerySortAreaImpl.this.persistentCollectionNames.contains(name)) {
                this.set = QuerySortAreaImpl.this.retrievePersistentNavigableSet(name);
                this.persistent = true;
            } else {
                this.set = new TreeSet<T>(comparator);
                this.persistent = false;
            }
        }

        @Override
        public Comparator<? super T> comparator() {
            return this.set.comparator();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object element) {
            return this.set.contains(element);
        }

        @Override
        public boolean add(T e) {
            boolean added = this.set.add(e);
            if (added && !this.persistent && this.set.size() >= this.persistentSizeThreshold) {
                NavigableSet persistentSet = this.comparator == null ? QuerySortAreaImpl.this.createNavigableSet(this.name) : QuerySortAreaImpl.this.createNavigableSet(this.name, this.comparator);
                persistentSet.addAll(this.set);
                this.set = persistentSet;
                this.persistent = true;
            }
            return added;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean added = this.set.addAll(c);
            if (added && !this.persistent && this.set.size() >= this.persistentSizeThreshold) {
                NavigableSet persistentSet = this.comparator == null ? QuerySortAreaImpl.this.createNavigableSet(this.name) : QuerySortAreaImpl.this.createNavigableSet(this.name, this.comparator);
                persistentSet.addAll(this.set);
                this.set = persistentSet;
                this.persistent = true;
            }
            return added;
        }

        @Override
        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        @Override
        public void clear() {
            if (this.persistent) {
                QuerySortAreaImpl.this.dropCollection(this.name);
                this.set = this.comparator == null ? new TreeSet<T>() : new TreeSet<T>(this.comparator);
                this.persistent = false;
            } else {
                this.set.clear();
            }
        }

        @Override
        public T first() {
            return (T)this.set.first();
        }

        @Override
        public T last() {
            return (T)this.set.last();
        }

        @Override
        public T lower(T e) {
            return this.set.lower(e);
        }

        @Override
        public T floor(T e) {
            return this.set.floor(e);
        }

        @Override
        public T ceiling(T e) {
            return this.set.ceiling(e);
        }

        @Override
        public T higher(T e) {
            return this.set.higher(e);
        }

        @Override
        public T pollFirst() {
            return this.set.pollFirst();
        }

        @Override
        public T pollLast() {
            return this.set.pollLast();
        }

        @Override
        public NavigableSet<T> descendingSet() {
            return this.set.descendingSet();
        }

        @Override
        public Iterator<T> descendingIterator() {
            return this.set.descendingIterator();
        }

        @Override
        public NavigableSet<T> subSet(T fromElement, boolean fromInclusive, T toElement, boolean toInclusive) {
            return this.set.subSet(fromElement, fromInclusive, toElement, toInclusive);
        }

        @Override
        public NavigableSet<T> headSet(T toElement, boolean inclusive) {
            return this.set.headSet(toElement, inclusive);
        }

        @Override
        public NavigableSet<T> tailSet(T fromElement, boolean inclusive) {
            return this.set.tailSet(fromElement, inclusive);
        }

        @Override
        public SortedSet<T> subSet(T fromElement, T toElement) {
            return this.set.subSet(fromElement, toElement);
        }

        @Override
        public SortedSet<T> headSet(T toElement) {
            return this.set.headSet(toElement);
        }

        @Override
        public SortedSet<T> tailSet(T fromElement) {
            return this.set.tailSet(fromElement);
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public int size() {
            return this.set.size();
        }
    }

    private final class SortAreaHashSet<T>
    extends AbstractSet<T> {
        private String name;
        private int persistentSizeThreshold;
        private Set<T> set;
        private boolean persistent;

        public SortAreaHashSet(String name, int persistentSizeThreshold) {
            this.name = name;
            this.persistentSizeThreshold = persistentSizeThreshold;
            if (QuerySortAreaImpl.this.persistentCollectionNames.contains(name)) {
                this.set = QuerySortAreaImpl.this.retrievePersistentHashSet(name);
                this.persistent = true;
            } else {
                this.set = Sets.newHashSet();
                this.persistent = false;
            }
        }

        @Override
        public boolean add(T element) {
            boolean added = this.set.add(element);
            if (added && !this.persistent && this.set.size() >= this.persistentSizeThreshold) {
                Set persistentSet = QuerySortAreaImpl.this.createPersistentHashSet(this.name);
                persistentSet.addAll(this.set);
                this.set = persistentSet;
                this.persistent = true;
            }
            return added;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean added = this.set.addAll(c);
            if (added && !this.persistent && this.set.size() >= this.persistentSizeThreshold) {
                Set persistentSet = QuerySortAreaImpl.this.createPersistentHashSet(this.name);
                persistentSet.addAll(this.set);
                this.set = persistentSet;
                this.persistent = true;
            }
            return added;
        }

        @Override
        public boolean remove(Object element) {
            return this.set.remove(element);
        }

        @Override
        public boolean contains(Object element) {
            return this.set.contains(element);
        }

        @Override
        public void clear() {
            if (this.persistent) {
                QuerySortAreaImpl.this.dropCollection(this.name);
                this.set = Sets.newHashSet();
                this.persistent = false;
            } else {
                this.set.clear();
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public int size() {
            return this.set.size();
        }
    }

    private final class SortAreaList<T>
    extends AbstractList<T> {
        private String name;
        private int inMemoryCardinality;
        private List<T> list;
        private boolean persistent;

        public SortAreaList(String name, int inMemoryCardinality) {
            this.name = name;
            this.inMemoryCardinality = inMemoryCardinality;
            if (QuerySortAreaImpl.this.persistentCollectionNames.contains(name)) {
                this.list = QuerySortAreaImpl.this.retrievePersistentList(name);
                this.persistent = true;
            } else {
                this.list = Lists.newArrayList();
                this.persistent = false;
            }
        }

        @Override
        public boolean add(T element) {
            boolean added = this.list.add(element);
            if (added && !this.persistent && this.list.size() >= this.inMemoryCardinality) {
                List persistentList = QuerySortAreaImpl.this.createPersistentList(this.name);
                persistentList.addAll(this.list);
                this.list = persistentList;
                this.persistent = true;
            }
            return added;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            boolean added = this.list.addAll(c);
            if (added && !this.persistent && this.list.size() >= this.inMemoryCardinality) {
                List persistentList = QuerySortAreaImpl.this.createPersistentList(this.name);
                persistentList.addAll(this.list);
                this.list = persistentList;
                this.persistent = true;
            }
            return added;
        }

        @Override
        public T set(int index, T element) {
            return this.list.set(index, element);
        }

        @Override
        public T get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public void clear() {
            if (this.persistent) {
                QuerySortAreaImpl.this.dropCollection(this.name);
                this.list = Lists.newArrayList();
                this.persistent = false;
            } else {
                this.list.clear();
            }
        }

        @Override
        public boolean contains(Object element) {
            return this.list.contains(element);
        }

        @Override
        public int indexOf(Object element) {
            return this.list.indexOf(element);
        }

        @Override
        public int lastIndexOf(Object element) {
            return this.list.lastIndexOf(element);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public T remove(int index) {
            return this.list.remove(index);
        }

        @Override
        public boolean remove(Object element) {
            return this.list.remove(element);
        }
    }
}

