/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.ods.IStoreMember;
import com.neeve.ods.OdsObject;
import com.neeve.ods.impl.StoreCommitCompletionStatus;
import com.neeve.util.UtlLinkedLongMap;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

final class StoreReplicatorOutboundCommitQueue
extends OdsObject {
    private final UtlLinkedLongMap<StoreCommitCompletionStatus> completionsMap = new UtlLinkedLongMap();
    private final UtlList completionsList = UtlList.create();
    private final AtomicBoolean guard = new AtomicBoolean(false);
    private long nextCommitSno;
    private long lastRemovedCommitSno;

    StoreReplicatorOutboundCommitQueue() {
        super(null);
        this.setNextCommitSno(1L);
    }

    final void removeUnprotected(long sno) {
        StoreCommitCompletionStatus status = (StoreCommitCompletionStatus)this.completionsMap.get(sno);
        if (status != null) {
            this.completionsMap.remove(sno);
            if (!status.isLinked()) {
                throw new InternalError("completion status object in completions map but not in list!");
            }
            status.unlink();
        }
        this.lastRemovedCommitSno = sno;
    }

    final void acquireReadLock() {
        while (!this.guard.compareAndSet(false, true)) {
        }
    }

    final void releaseReadLock() {
        this.guard.set(false);
    }

    final void acquireWriteLock() {
        while (!this.guard.compareAndSet(false, true)) {
        }
    }

    final void releaseWriteLock() {
        this.guard.set(false);
    }

    final void setNextCommitSno(long sno) {
        this.acquireWriteLock();
        try {
            this.nextCommitSno = sno;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    final long getNextCommitSno() {
        this.acquireReadLock();
        try {
            long l = this.nextCommitSno;
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    final long getLastRemovedCommitSno() {
        this.acquireReadLock();
        try {
            long l = this.lastRemovedCommitSno;
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long put(StoreCommitCompletionStatus status) {
        this.acquireWriteLock();
        try {
            long currentCommitSno = this.nextCommitSno++;
            if (status != null) {
                this.completionsMap.put(currentCommitSno, (Object)status.setCommitSequenceNumber(currentCommitSno));
                this.completionsList.append((UtlListElement)status);
            }
            long l = currentCommitSno;
            return l;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void put(long commitSno, StoreCommitCompletionStatus status) {
        this.acquireWriteLock();
        try {
            if (status != null) {
                this.completionsMap.put(commitSno, (Object)status.setCommitSequenceNumber(commitSno));
                this.completionsList.append((UtlListElement)status);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final StoreCommitCompletionStatus get(long sno) {
        this.acquireReadLock();
        try {
            StoreCommitCompletionStatus storeCommitCompletionStatus = (StoreCommitCompletionStatus)this.completionsMap.get(sno);
            return storeCommitCompletionStatus;
        }
        finally {
            this.releaseReadLock();
        }
    }

    final void remove(long sno) {
        this.acquireWriteLock();
        try {
            this.removeUnprotected(sno);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    final int size() {
        this.acquireReadLock();
        try {
            int n = this.completionsMap.size();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<StoreCommitCompletionStatus> setStatusAndRemoveCompleted(IStoreMember member, Exception e) {
        this.acquireWriteLock();
        try {
            LinkedHashSet<StoreCommitCompletionStatus> completed = new LinkedHashSet<StoreCommitCompletionStatus>();
            for (StoreCommitCompletionStatus status = (StoreCommitCompletionStatus)this.completionsList.first(); status != null; status = (StoreCommitCompletionStatus)status.next()) {
                if (!status.isMemberAdded(member)) continue;
                status.setReplicationStatus(member, e);
                if (!status.isComplete()) continue;
                completed.add(status);
            }
            Iterator iterator = completed.iterator();
            while (iterator.hasNext()) {
                this.removeUnprotected(((StoreCommitCompletionStatus)iterator.next()).getCommitSequenceNumber());
            }
            LinkedHashSet<StoreCommitCompletionStatus> linkedHashSet = completed;
            return linkedHashSet;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<StoreCommitCompletionStatus> completeAndClear(Exception e) {
        this.acquireWriteLock();
        try {
            LinkedHashSet<StoreCommitCompletionStatus> completed = new LinkedHashSet<StoreCommitCompletionStatus>();
            for (StoreCommitCompletionStatus status = (StoreCommitCompletionStatus)this.completionsList.first(); status != null; status = (StoreCommitCompletionStatus)status.next()) {
                completed.add(status.complete(e));
            }
            this.completionsMap.clear();
            this.completionsList.clear();
            LinkedHashSet<StoreCommitCompletionStatus> linkedHashSet = completed;
            return linkedHashSet;
        }
        finally {
            this.releaseWriteLock();
        }
    }
}

