/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization.rumi.quark;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.IXStringFactory;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XIntIterator;
import com.neeve.lang.XIntSequence;
import com.neeve.lang.XIterator;
import com.neeve.lang.XString;
import com.neeve.lang.XStringDeserializer;
import com.neeve.memory.MemoryStats;
import com.neeve.perf.serialization.rumi.quark.BooleanType;
import com.neeve.perf.serialization.rumi.quark.Code;
import com.neeve.perf.serialization.rumi.quark.Engine;
import com.neeve.perf.serialization.rumi.quark.FuelFigure;
import com.neeve.perf.serialization.rumi.quark.ICarData;
import com.neeve.perf.serialization.rumi.quark.MessageFactory;
import com.neeve.perf.serialization.rumi.quark.OptionalExtras;
import com.neeve.perf.serialization.rumi.quark.PerformanceFigure;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.quark.IQuarkChildSerializationCompletionCallback;
import com.neeve.query.impl.index.IdxMappable;
import com.neeve.rog.IRogFieldReflector;
import com.neeve.rog.impl.RogNonTransactionalField;
import com.neeve.sma.MessageReflector;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReflection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="quark", compatLevel="5.0.0", admVersion="nvx-rumi-adm v4.0 (build 595)", date="11/17/25 1:32 AM", buildInfo="nvx-rumi-perf-models-4.0-SNAPSHOT (Rumi ADM Maven Plugin)")
@AdmFactoryInfo(factoryClass=MessageFactory.class, vfid=-1, ofid=-1, typeId=105)
@JsonPropertyOrder(value={"timestamp", "someNumbers", "extras", "engine", "fuelFigure", "performanceFigure", "manufacturer", "model"})
public final class CarData
implements ICarData,
MessageReflector,
IdxMappable,
UtlPool.Item<CarData>,
AdmRuntime.BufferSizer {
    private static final RogNonTransactionalField<CarData, Integer> _serialNumberReflector = new RogNonTransactionalField<CarData, Integer>("serialNumber", CarData.class, "serialNumber", Integer.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<SerialNumberDeserializer> _fieldDeserializer = new ThreadLocal();

        private final SerialNumberDeserializer getFieldDeserializer() {
            SerialNumberDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new SerialNumberDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasSerialNumber();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                SerialNumberDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final int getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getSerialNumber();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, Integer value) {
            if (value == null) {
                node.clearSerialNumber();
            } else {
                node.setSerialNumber(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final Integer getValue(CarData node) {
            return this.resolveFieldValue(node) ? Integer.valueOf(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append((long)this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<CarData, Short> _modelYearReflector = new RogNonTransactionalField<CarData, Short>("modelYear", CarData.class, "modelYear", Short.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<ModelYearDeserializer> _fieldDeserializer = new ThreadLocal();

        private final ModelYearDeserializer getFieldDeserializer() {
            ModelYearDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new ModelYearDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasModelYear();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                ModelYearDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final short getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getModelYear();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, Short value) {
            if (value == null) {
                node.clearModelYear();
            } else {
                node.setModelYear(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final Short getValue(CarData node) {
            return this.resolveFieldValue(node) ? Short.valueOf(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append((long)this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<CarData, BooleanType> _availableReflector = new RogNonTransactionalField<CarData, BooleanType>("available", CarData.class, "available", BooleanType.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<AvailableDeserializer> _fieldDeserializer = new ThreadLocal();

        private final AvailableDeserializer getFieldDeserializer() {
            AvailableDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new AvailableDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasAvailable();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                AvailableDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final BooleanType getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getAvailable();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, BooleanType value) {
            if (value == null) {
                node.clearAvailable();
            } else {
                node.setAvailable(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final BooleanType getValue(CarData node) {
            return this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append((CharSequence)this.getResolvedFieldValue(node).name());
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<CarData, Code> _codeReflector = new RogNonTransactionalField<CarData, Code>("code", CarData.class, "code", Code.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<CodeDeserializer> _fieldDeserializer = new ThreadLocal();

        private final CodeDeserializer getFieldDeserializer() {
            CodeDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new CodeDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasCode();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                CodeDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final Code getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getCode();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, Code value) {
            if (value == null) {
                node.clearCode();
            } else {
                node.setCode(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final Code getValue(CarData node) {
            return this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append((CharSequence)this.getResolvedFieldValue(node).name());
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<CarData, String> _vehicleCodeReflector = new RogNonTransactionalField<CarData, String>("vehicleCode", CarData.class, "vehicleCode", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<VehicleCodeDeserializer> _fieldDeserializer = new ThreadLocal();

        private final VehicleCodeDeserializer getFieldDeserializer() {
            VehicleCodeDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new VehicleCodeDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasVehicleCode();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                VehicleCodeDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getVehicleCodeUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, String value) {
            if (value == null) {
                node.clearVehicleCode();
            } else {
                node.setVehicleCode(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(CarData node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<CarData, Date> _manufactureDateReflector = new RogNonTransactionalField<CarData, Date>("manufactureDate", CarData.class, "manufactureDate", Date.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<ManufactureDateDeserializer> _fieldDeserializer = new ThreadLocal();

        private final ManufactureDateDeserializer getFieldDeserializer() {
            ManufactureDateDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new ManufactureDateDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasManufactureDate();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                ManufactureDateDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final long getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getManufactureDateAsTimestamp();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, Date value) {
            if (value == null) {
                node.clearManufactureDate();
            } else {
                node.setManufactureDate(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final Date getValue(CarData node) {
            return this.resolveFieldValue(node) ? new Date(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<CarData, Long> _timestampReflector = new RogNonTransactionalField<CarData, Long>("timestamp", CarData.class, "timestamp", Long.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<TimestampDeserializer> _fieldDeserializer = new ThreadLocal();

        private final TimestampDeserializer getFieldDeserializer() {
            TimestampDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new TimestampDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasTimestamp();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                TimestampDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final long getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getTimestamp();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, Long value) {
            if (value == null) {
                node.clearTimestamp();
            } else {
                node.setTimestamp(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final Long getValue(CarData node) {
            return this.resolveFieldValue(node) ? Long.valueOf(this.getResolvedFieldValue(node)) : null;
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<CarData, Engine> _engineReflector = new RogNonTransactionalField<CarData, Engine>("engine", CarData.class, "engine", Engine.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<EngineDeserializer> _fieldDeserializer = new ThreadLocal();

        private final EngineDeserializer getFieldDeserializer() {
            EngineDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new EngineDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasEngine();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                EngineDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final Engine getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getEngine();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, Engine value) {
            if (value == null) {
                node.clearEngine();
            } else {
                node.setEngine(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final Engine getValue(CarData node) {
            return this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
        }

        public final boolean appendValueTo(CarData node, XString target) {
            throw new UnsupportedOperationException();
        }
    };
    private static final RogNonTransactionalField<CarData, String> _manufacturerReflector = new RogNonTransactionalField<CarData, String>("manufacturer", CarData.class, "manufacturer", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<ManufacturerDeserializer> _fieldDeserializer = new ThreadLocal();

        private final ManufacturerDeserializer getFieldDeserializer() {
            ManufacturerDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new ManufacturerDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasManufacturer();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                ManufacturerDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getManufacturerUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, String value) {
            if (value == null) {
                node.clearManufacturer();
            } else {
                node.setManufacturer(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(CarData node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final RogNonTransactionalField<CarData, String> _modelReflector = new RogNonTransactionalField<CarData, String>("model", CarData.class, "model", String.class, null){
        private static final long serialVersionUID = 1L;
        private final ThreadLocal<ModelDeserializer> _fieldDeserializer = new ThreadLocal();

        private final ModelDeserializer getFieldDeserializer() {
            ModelDeserializer fieldDeserializer = this._fieldDeserializer.get();
            if (fieldDeserializer == null) {
                fieldDeserializer = new ModelDeserializer();
                this._fieldDeserializer.set(fieldDeserializer);
            }
            return fieldDeserializer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean resolveFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.hasModel();
            }
            Deserializer entityDeserializer = node.deserializer(true);
            try {
                ModelDeserializer fieldDeserializer = this.getFieldDeserializer();
                fieldDeserializer.run(entityDeserializer);
                boolean bl = fieldDeserializer.wasSet();
                return bl;
            }
            finally {
                node.disposeDeserializer();
            }
        }

        private final XString getResolvedFieldValue(CarData node) {
            if (node.hasPojo()) {
                return node.getModelUnsafe();
            }
            return this.getFieldDeserializer()._value;
        }

        public final void setValue(CarData node, String value) {
            if (value == null) {
                node.clearModel();
            } else {
                node.setModel(value);
            }
        }

        public final boolean hasValue(CarData node) {
            return this.resolveFieldValue(node);
        }

        public final String getValue(CarData node) {
            XString val = this.resolveFieldValue(node) ? this.getResolvedFieldValue(node) : null;
            return val == null ? null : val.getValue();
        }

        public final boolean appendValueTo(CarData node, XString target) {
            if (this.resolveFieldValue(node)) {
                target.append(this.getResolvedFieldValue(node));
                return true;
            }
            return false;
        }
    };
    private static final HashMap<String, IRogFieldReflector<CarData, ?>> _fieldReflectors = new HashMap(10);
    private static final boolean _conserveMemory;
    private static final boolean _freeBackingStorageOnClear;
    private static final MemoryStats _memstats;
    private static final CarDataPoolFactory _carDataFactory;
    private static final CarDataPojoPoolFactory _carDataPojoFactory;
    private static final CarDataSerializerPoolFactory _carDataSerializerFactory;
    private static final CarDataDeserializerPoolFactory _carDataDeserializerFactory;
    static final UtlPool<CarData> _entityPool;
    static final UtlPool<Pojo> _entityPojoPool;
    static final UtlPool<Serializer> _entitySerializerPool;
    static final UtlPool<Deserializer> _entityDeserializerPool;
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<CarData> _pool;
    private long _serializedBuffer;
    private int _serializedBufferLength;
    private int _serializedBufferCapacity;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final CarData[] EMPTY_ARRAY;

    CarData() {
    }

    public static CarData create() {
        CarData entity = (CarData)_entityPool.get(null);
        _memstats.onEntityAllocated(CarData.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final long serializedBuffer(int len) {
        long oldBuffer = this._serializedBuffer;
        int oldCapacity = this._serializedBufferCapacity;
        int newCapacity = Math.max(len, 3);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newCapacity, (boolean)false);
        if (newCapacity > oldCapacity) {
            if (oldBuffer != 0L) {
                _memstats.onEntityDataDisposed(CarData.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memstats.onEntityDataAllocated(CarData.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
            this._serializedBufferCapacity = newCapacity;
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != 0L;
    }

    @JsonIgnore
    public final long getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @JsonIgnore
    public final int getSerializedBufferCapacity() {
        return this._serializedBufferCapacity;
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferCapacity) {
            return addr;
        }
        int newLength = capacity <= this._serializedBufferCapacity ? capacity : Math.max(capacity, this._serializedBufferCapacity * 2);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newLength, (boolean)false);
        this._serializedBufferCapacity = newLength;
        return this._serializedBuffer;
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo(boolean onlyPojos) {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (onlyPojos) {
            this._pojo.setOnlyPojos();
        } else {
            this._pojo.clearOnlyPojos();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        if (onlyPojos) {
            this.conserveMemory(AdmRuntime.DataStoragePolicy.OnlyPojo);
        }
        return this._pojo;
    }

    public final Pojo pojo() {
        return this.pojo(false);
    }

    public final void disposeSerializedBuffer(boolean gcDisposed) {
        if (this.hasSerializedBuffer()) {
            IOBuffer.freeMemoryBlock((long)this._serializedBuffer, (int)this._serializedBufferCapacity);
            _memstats.onEntityDataDisposed(CarData.class, MemoryStats.EntityType.EmbeddedEntity, this._serializedBufferCapacity, !gcDisposed);
            this._serializedBuffer = 0L;
            this._serializedBufferLength = 0;
            this._serializedBufferCapacity = 0;
        }
    }

    public final void disposeSerializedBuffer() {
        this.disposeSerializedBuffer(false);
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory(AdmRuntime.DataStoragePolicy policy) {
        switch (policy) {
            case OnlySerialized: {
                this.sync();
                this.disposeSerializer();
                this.disposeDeserializer();
                this.disposePojo(false);
                break;
            }
            case OnlyPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) {
                    this.pojo(false);
                }
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
            case SerializedOrPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) break;
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
        }
    }

    public final void clear(boolean disposeMembers, boolean freeBackingStorage) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this._pojo.clear(freeBackingStorage);
                this.disposePojo(false);
            } else {
                this._pojo.reset(freeBackingStorage);
            }
        }
        if (freeBackingStorage || disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear(boolean disposeMembers) {
        this.clear(disposeMembers, _freeBackingStorageOnClear);
    }

    public final void clear() {
        this.clear(_conserveMemory, _freeBackingStorageOnClear);
    }

    public final void reset(boolean disposeMembers, boolean freeBackingStorage) {
        this.clear(disposeMembers, freeBackingStorage);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset(boolean disposeMembers) {
        this.reset(disposeMembers, _conserveMemory);
    }

    public final void reset() {
        this.reset(_conserveMemory, _conserveMemory);
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            MessageFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (this.hasDirtyPojo()) {
            this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
            this._pojo.clearDirty();
        } else if (!this.hasSerializedBuffer()) {
            this.serializedBuffer(0);
        }
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (byte[])array, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (ByteBuffer)buffer, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)buffer.getNativeAddress(), (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(257);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)addr, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final CarData deserializeFromRawJson(String json) {
        try {
            MessageFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final CarData deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final CarData deserializeFrom(CarData val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final CarData wrap(IOBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer.getNativeAddress();
        this._serializedBufferLength = len;
        return this;
    }

    public final CarData deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final CarData deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(len), (int)0, (byte[])array, (int)offset, (int)len);
        }
        return this;
    }

    public final CarData deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final CarData deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(this._serializedBufferLength), (int)0, (ByteBuffer)buffer, (int)buffer.position(), (int)this._serializedBufferLength);
        }
        return this;
    }

    public final CarData deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            IOBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        }
        return this;
    }

    public final CarData deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset, len);
    }

    public final CarData deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final CarData deserializeFrom(PktPacket packet) {
        try {
            IOElasticBuffer buffer = packet.getBody().getBuffer();
            CarData carData = this.deserializeFrom(buffer, 0, buffer.getLength());
            return carData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final CarData deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        IOBuffer.copy((long)addr, (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        return this;
    }

    public final CarData deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(CarData copy) {
        copy.clear();
        this.sync();
        if (this.hasSerializedBuffer()) {
            copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
    }

    public final CarData copy() {
        CarData copy = CarData.create();
        this.copyInto(copy);
        return copy;
    }

    public boolean needsSync() {
        return false;
    }

    public final boolean fieldExists(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return _fieldReflectors.containsKey(name) || UtlReflection.hasPath((Object)message, (String)name);
    }

    public final boolean isFieldReflectable(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (_fieldReflectors.containsKey(name)) {
            return true;
        }
        Class c = UtlReflection.getUnwrappedReturnType(message.getClass(), (String)name);
        if (c == null || c.isArray()) {
            return false;
        }
        if (c.isEnum() || c.isPrimitive()) {
            return true;
        }
        return c == Date.class || c == Currency.class || c == String.class || XString.class.isAssignableFrom(c);
    }

    public final String getFieldValueAsString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsString(message, name.split("\\."));
    }

    public final String getFieldValueAsString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : String.valueOf(object);
        }
        IRogFieldReflector<CarData, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return val.toString();
            }
            return null;
        }
        return null;
    }

    public final XString getFieldValueAsRawString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsRawString(message, name.split("\\."));
    }

    public final XString getFieldValueAsRawString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : XString.create((String)object.toString());
        }
        IRogFieldReflector<CarData, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return XString.create((String)val.toString());
            }
            return null;
        }
        return null;
    }

    public final boolean appendFieldValueTo(Object message, String name, XString target) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.appendFieldValueTo(message, name.split("\\."), target);
    }

    public final boolean appendFieldValueTo(Object node, String[] pathComponents, XString target) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            if (object == null) {
                return false;
            }
            target.append((CharSequence)object.toString());
            return true;
        }
        IRogFieldReflector<CarData, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            return reflector.appendValueTo((Object)this, target);
        }
        return false;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    @Override
    @JsonProperty(value="serialNumber")
    public final void setSerialNumber(int val) {
        this.pojo().setSerialNumber(val);
    }

    @Override
    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final int getSerialNumber() {
        return this.pojo().getSerialNumber();
    }

    @Override
    @JsonIgnore
    public final Integer getSerialNumberAsObject() {
        return this.getSerialNumber();
    }

    @Override
    public final boolean hasSerialNumber() {
        return this.pojo().hasBlock2();
    }

    @Override
    public final void clearSerialNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonProperty(value="modelYear")
    public final void setModelYear(short val) {
        this.pojo().setModelYear(val);
    }

    @Override
    @JsonProperty(value="modelYear")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final short getModelYear() {
        return this.pojo().getModelYear();
    }

    @Override
    @JsonIgnore
    public final Short getModelYearAsObject() {
        return this.getModelYear();
    }

    @Override
    public final boolean hasModelYear() {
        return this.pojo().hasBlock2();
    }

    @Override
    public final void clearModelYear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonProperty(value="available")
    public final void setAvailable(BooleanType val) {
        this.pojo().setAvailable(val);
    }

    @Override
    @JsonProperty(value="available")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final BooleanType getAvailable() {
        return this.pojo().getAvailable();
    }

    @Override
    public final boolean hasAvailable() {
        return this.pojo().hasBlock2();
    }

    @Override
    public final void clearAvailable() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonProperty(value="code")
    public final void setCode(Code val) {
        this.pojo().setCode(val);
    }

    @Override
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Code getCode() {
        return this.pojo().getCode();
    }

    @Override
    public final boolean hasCode() {
        return this.pojo().hasBlock2();
    }

    @Override
    public final void clearCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonProperty(value="vehicleCode")
    public final void setVehicleCode(String val) {
        this.pojo().setVehicleCodeFrom(val);
    }

    @Override
    @JsonProperty(value="vehicleCode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getVehicleCode() {
        return this.pojo()._usrVehicleCode.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendVehicleCode(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setVehicleCode(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setVehicleCodeFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setVehicleCodeFrom(long val) {
        this.pojo().setVehicleCodeFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getVehicleCodeTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getVehicleCodeTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setVehicleCodeFrom(XString val) {
        this.pojo().setVehicleCodeFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getVehicleCodeTo(XString val) {
        this.pojo().getVehicleCodeTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getVehicleCodeUnsafe() {
        XString val = XString.create();
        this.pojo().getVehicleCodeTo(val);
        return val;
    }

    @Override
    public final boolean hasVehicleCode() {
        return this.pojo().hasBlock2();
    }

    @Override
    public final void clearVehicleCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    @JsonProperty(value="manufactureDate")
    public final void setManufactureDate(Date val) {
        this.pojo().setManufactureDate(val != null ? val.getTime() : 0L);
    }

    @Override
    @JsonProperty(value="manufactureDate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Date getManufactureDate() {
        long val = this.pojo().getManufactureDate();
        return val == 0L ? null : new Date(val);
    }

    @Override
    @JsonIgnore
    public final void setManufactureDateAsTimestamp(long val) {
        this.pojo().setManufactureDate(val);
    }

    @Override
    @JsonIgnore
    public final long getManufactureDateAsTimestamp() {
        return this.pojo().getManufactureDate();
    }

    @Override
    @JsonIgnore
    public final Long getManufactureDateAsTimestampObject() {
        return this.getManufactureDateAsTimestamp();
    }

    @Override
    @JsonIgnore
    public final void setManufactureDateAsInstant(Instant val) {
        this.setManufactureDateAsTimestamp(val != null ? val.toEpochMilli() : 0L);
    }

    @Override
    @JsonIgnore
    public final Instant getManufactureDateAsInstant() {
        if (!this.hasManufactureDate()) {
            return null;
        }
        long val = this.getManufactureDateAsTimestamp();
        return val > 0L ? Instant.ofEpochMilli(val) : null;
    }

    @Override
    public final boolean hasManufactureDate() {
        return this.pojo().hasBlock2();
    }

    @Override
    public final void clearManufactureDate() {
        throw new UnsupportedOperationException();
    }

    public static final int getTimestampFieldId() {
        return 1;
    }

    @Override
    @JsonProperty(value="timestamp")
    public final void setTimestamp(long val) {
        this.pojo().setTimestamp(val);
    }

    @Override
    @JsonIgnore
    public final long getTimestamp() {
        return this.pojo().getTimestamp();
    }

    @Override
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Long getTimestampAsObject() {
        if (!this.hasTimestamp()) {
            return null;
        }
        return this.getTimestamp();
    }

    @Override
    public final boolean hasTimestamp() {
        return this.pojo().hasTimestamp();
    }

    @Override
    public final void clearTimestamp() {
        this.pojo().clearTimestamp();
    }

    public static final int getSomeNumbersFieldId() {
        return 3;
    }

    @Override
    @JsonProperty(value="someNumbers")
    public final void setSomeNumbers(int[] val) {
        this.pojo().setSomeNumbersFrom(val, 0, val == null ? 0 : val.length);
    }

    @Override
    @JsonIgnore
    public final void setSomeNumbersFrom(XIntIterator val) {
        this.pojo().setSomeNumbersFrom(val);
    }

    @Override
    @JsonIgnore
    public final void addSomeNumbers(int val) {
        this.pojo().addToSomeNumbers(val);
    }

    @Override
    @JsonIgnore
    public final int getSomeNumbersCount() {
        return this.pojo().getSomeNumbersCount();
    }

    @Override
    @JsonIgnore
    public final int getSomeNumbersAt(int index) {
        return this.pojo().getSomeNumbersAt(index);
    }

    @Override
    @JsonProperty(value="someNumbers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final int[] getSomeNumbers() {
        int count = this.pojo().getSomeNumbersCount();
        if (count > 0) {
            int[] val = new int[count];
            this.pojo().getSomeNumbersTo(val, 0);
            return val;
        }
        return null;
    }

    @Override
    public final int[] getSomeNumbersEmptyIfNull() {
        int[] val = this.getSomeNumbers();
        return val != null ? val : AdmRuntime.EMPTY_INT_ARRAY;
    }

    @Override
    @JsonIgnore
    public final XIntIterator getSomeNumbersIterator() {
        return this.pojo().getSomeNumbersIterator();
    }

    @Override
    public final void clearSomeNumbers() {
        this.pojo().clearSomeNumbers();
    }

    public static final int getExtrasFieldId() {
        return 4;
    }

    @Override
    @JsonProperty(value="extras")
    public final void setExtras(OptionalExtras[] val) {
        this.pojo().setExtrasFrom(val, 0, val == null ? 0 : val.length);
    }

    @Override
    @JsonIgnore
    public final void setExtrasFrom(XIterator<OptionalExtras> val) {
        this.pojo().setExtrasFrom(val);
    }

    @Override
    @JsonProperty(value="extras")
    public final void addExtras(OptionalExtras val) {
        this.pojo().addToExtras(val);
    }

    @Override
    @Deprecated
    @JsonIgnore
    public final void setExtrasList(List<OptionalExtras> val) {
        this.clearExtras();
        if (val != null && val.size() > 0) {
            for (int i = 0; i < val.size(); ++i) {
                this.pojo().addToExtras(val.get(i));
            }
        }
    }

    @Override
    @JsonIgnore
    public final int getExtrasCount() {
        return this.pojo().getExtrasCount();
    }

    @Override
    @JsonIgnore
    public final OptionalExtras getExtrasAt(int index) {
        return this.pojo().getExtrasAt(index);
    }

    @Override
    @JsonProperty(value="extras")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final OptionalExtras[] getExtras() {
        int count = this.pojo().getExtrasCount();
        if (count > 0) {
            OptionalExtras[] val = new OptionalExtras[count];
            this.pojo().getExtrasTo(val, 0);
            return val;
        }
        return null;
    }

    @Override
    public final OptionalExtras[] getExtrasEmptyIfNull() {
        OptionalExtras[] val = this.getExtras();
        return val != null ? val : OptionalExtras.EMPTY_ARRAY;
    }

    @Override
    @JsonIgnore
    public final XIndexedList<OptionalExtras> getExtrasList() {
        XIndexedList rc = new XIndexedList();
        XIterator<OptionalExtras> it = this.pojo().getExtrasIterator();
        while (it.hasNext()) {
            rc.add(it.next());
        }
        return rc;
    }

    @Override
    @JsonIgnore
    public final XIterator<OptionalExtras> getExtrasIterator() {
        return this.pojo().getExtrasIterator();
    }

    @Override
    public final void clearExtras() {
        this.pojo().clearExtras();
    }

    public static final int getEngineFieldId() {
        return 5;
    }

    @Override
    @JsonProperty(value="engine")
    public final void setEngine(Engine val) {
        this.pojo().setEngine(val);
    }

    @Override
    public final void lendEngine(Engine val) {
        this.pojo().lendEngine(val);
    }

    @Override
    @JsonProperty(value="engine")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Engine getEngine() {
        return this.pojo().getEngine();
    }

    @Override
    @JsonIgnore
    public final void getEngineTo(Engine to) {
        this.pojo().getEngineTo(to);
    }

    @Override
    public final Engine takeEngine() {
        return this.pojo().takeEngine();
    }

    @Override
    public final boolean hasEngine() {
        return this.pojo().hasEngine();
    }

    @Override
    public final void clearEngine() {
        this.pojo().clearEngine();
    }

    public static final int getFuelFigureFieldId() {
        return 6;
    }

    @Override
    @JsonProperty(value="fuelFigure")
    public final void setFuelFigure(FuelFigure[] val) {
        this.pojo().clearFuelFigure();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToFuelFigure(val[i]);
            }
        }
    }

    @Override
    public final void lendFuelFigure(FuelFigure[] val) {
        this.pojo().clearFuelFigure();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().lendToFuelFigure(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setFuelFigureFrom(XIterator<FuelFigure> val) {
        this.pojo().clearFuelFigure();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                FuelFigure v = (FuelFigure)val.next();
                if (v == null) continue;
                this.pojo().addToFuelFigure(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void lendFuelFigureFrom(XIterator<FuelFigure> val) {
        this.pojo().clearFuelFigure();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                FuelFigure v = (FuelFigure)val.next();
                if (v == null) continue;
                this.pojo().lendToFuelFigure(v);
            }
        }
    }

    @Override
    @JsonProperty(value="fuelFigure")
    public final void addFuelFigure(FuelFigure val) {
        this.pojo().addToFuelFigure(val);
    }

    @Override
    @JsonProperty(value="fuelFigure")
    public final void lendFuelFigure(FuelFigure val) {
        this.pojo().lendToFuelFigure(val);
    }

    @Override
    @JsonProperty(value="fuelFigure")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final FuelFigure[] getFuelFigure() {
        int count = this.pojo().getFuelFigureCount();
        if (count > 0) {
            FuelFigure[] val = new FuelFigure[count];
            XIterator<FuelFigure> iterator = this.pojo().getFuelFigureIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (FuelFigure)iterator.next();
            }
            return val;
        }
        return null;
    }

    @Override
    public final FuelFigure[] getFuelFigureEmptyIfNull() {
        FuelFigure[] val = this.getFuelFigure();
        return val != null ? val : FuelFigure.EMPTY_ARRAY;
    }

    @Override
    public final int getFuelFigureCount() {
        return this.pojo().getFuelFigureCount();
    }

    @Override
    public final FuelFigure getFuelFigureAt(int index) {
        return this.pojo().getFuelFigureAt(index);
    }

    @Override
    public final XIterator<FuelFigure> getFuelFigureIterator() {
        return this.pojo().getFuelFigureIterator();
    }

    @Override
    public final FuelFigure[] takeFuelFigure() {
        int count = this.pojo().getFuelFigureCount();
        if (count > 0) {
            FuelFigure[] val = new FuelFigure[count];
            XIterator<FuelFigure> iterator = this.pojo().getFuelFigureIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (FuelFigure)iterator.next();
                val[i].acquire();
            }
            return val;
        }
        return null;
    }

    @Override
    public final void clearFuelFigure() {
        this.pojo().clearFuelFigure();
    }

    public static final int getPerformanceFigureFieldId() {
        return 7;
    }

    @Override
    @JsonProperty(value="performanceFigure")
    public final void setPerformanceFigure(PerformanceFigure[] val) {
        this.pojo().clearPerformanceFigure();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToPerformanceFigure(val[i]);
            }
        }
    }

    @Override
    public final void lendPerformanceFigure(PerformanceFigure[] val) {
        this.pojo().clearPerformanceFigure();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().lendToPerformanceFigure(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setPerformanceFigureFrom(XIterator<PerformanceFigure> val) {
        this.pojo().clearPerformanceFigure();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                PerformanceFigure v = (PerformanceFigure)val.next();
                if (v == null) continue;
                this.pojo().addToPerformanceFigure(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void lendPerformanceFigureFrom(XIterator<PerformanceFigure> val) {
        this.pojo().clearPerformanceFigure();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                PerformanceFigure v = (PerformanceFigure)val.next();
                if (v == null) continue;
                this.pojo().lendToPerformanceFigure(v);
            }
        }
    }

    @Override
    @JsonProperty(value="performanceFigure")
    public final void addPerformanceFigure(PerformanceFigure val) {
        this.pojo().addToPerformanceFigure(val);
    }

    @Override
    @JsonProperty(value="performanceFigure")
    public final void lendPerformanceFigure(PerformanceFigure val) {
        this.pojo().lendToPerformanceFigure(val);
    }

    @Override
    @JsonProperty(value="performanceFigure")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final PerformanceFigure[] getPerformanceFigure() {
        int count = this.pojo().getPerformanceFigureCount();
        if (count > 0) {
            PerformanceFigure[] val = new PerformanceFigure[count];
            XIterator<PerformanceFigure> iterator = this.pojo().getPerformanceFigureIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (PerformanceFigure)iterator.next();
            }
            return val;
        }
        return null;
    }

    @Override
    public final PerformanceFigure[] getPerformanceFigureEmptyIfNull() {
        PerformanceFigure[] val = this.getPerformanceFigure();
        return val != null ? val : PerformanceFigure.EMPTY_ARRAY;
    }

    @Override
    public final int getPerformanceFigureCount() {
        return this.pojo().getPerformanceFigureCount();
    }

    @Override
    public final PerformanceFigure getPerformanceFigureAt(int index) {
        return this.pojo().getPerformanceFigureAt(index);
    }

    @Override
    public final XIterator<PerformanceFigure> getPerformanceFigureIterator() {
        return this.pojo().getPerformanceFigureIterator();
    }

    @Override
    public final PerformanceFigure[] takePerformanceFigure() {
        int count = this.pojo().getPerformanceFigureCount();
        if (count > 0) {
            PerformanceFigure[] val = new PerformanceFigure[count];
            XIterator<PerformanceFigure> iterator = this.pojo().getPerformanceFigureIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (PerformanceFigure)iterator.next();
                val[i].acquire();
            }
            return val;
        }
        return null;
    }

    @Override
    public final void clearPerformanceFigure() {
        this.pojo().clearPerformanceFigure();
    }

    public static final int getManufacturerFieldId() {
        return 8;
    }

    @Override
    @JsonProperty(value="manufacturer")
    public final void setManufacturer(String val) {
        this.pojo().setManufacturerFrom(val);
    }

    @Override
    @JsonProperty(value="manufacturer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getManufacturer() {
        if (!this.hasManufacturer()) {
            return null;
        }
        return this.pojo()._usrManufacturer.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendManufacturer(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setManufacturer(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setManufacturerFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setManufacturerFrom(long val) {
        this.pojo().setManufacturerFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getManufacturerTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getManufacturerTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setManufacturerFrom(XString val) {
        this.pojo().setManufacturerFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getManufacturerTo(XString val) {
        this.pojo().getManufacturerTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getManufacturerUnsafe() {
        return this.pojo().getManufacturer();
    }

    @Override
    public final boolean hasManufacturer() {
        return this.pojo().hasManufacturer();
    }

    @Override
    public final void clearManufacturer() {
        this.pojo().clearManufacturer();
    }

    public static final int getModelFieldId() {
        return 9;
    }

    @Override
    @JsonProperty(value="model")
    public final void setModel(String val) {
        this.pojo().setModelFrom(val);
    }

    @Override
    @JsonProperty(value="model")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getModel() {
        if (!this.hasModel()) {
            return null;
        }
        return this.pojo()._usrModel.getAsString();
    }

    @Override
    @JsonIgnore
    public final void lendModel(XString val) {
        if (val == null || !val.hasValue() || val.isNull()) {
            this.setModel(null);
            return;
        }
        if (!val.isImmutable()) {
            throw new IllegalArgumentException("value is mutable");
        }
        this.pojo().setModelFrom(val);
    }

    @Override
    @JsonIgnore
    public final void setModelFrom(long val) {
        this.pojo().setModelFrom(val);
    }

    @Override
    @JsonIgnore
    public final <T extends XString> T getModelTo(IXStringFactory<T> factory) {
        XString to = factory.create(false);
        this.pojo().getModelTo(to);
        return (T)to;
    }

    @Override
    @JsonIgnore
    public final void setModelFrom(XString val) {
        this.pojo().setModelFrom(val);
    }

    @Override
    @JsonIgnore
    public final void getModelTo(XString val) {
        this.pojo().getModelTo(val);
    }

    @Override
    @JsonIgnore
    public final XString getModelUnsafe() {
        return this.pojo().getModel();
    }

    @Override
    public final boolean hasModel() {
        return this.pojo().hasModel();
    }

    @Override
    public final void clearModel() {
        this.pojo().clearModel();
    }

    public static final <T> IRogFieldReflector<CarData, T> getFieldReflector(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return CarData.getFieldReflector(name.split("\\."));
    }

    public static final <T> IRogFieldReflector<CarData, T> getFieldReflector(String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            throw new IllegalArgumentException("fetching of reflectable field accessors for nested fields is currently not supported");
        }
        return _fieldReflectors.get(pathComponents[0]);
    }

    public final Object getQueryFieldValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IRogFieldReflector<CarData, ?> reflector = _fieldReflectors.get(name);
        if (reflector != null) {
            return reflector.getValue((Object)this);
        }
        return null;
    }

    public final CarData init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final CarData setPool(UtlPool<CarData> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<CarData> getPool() {
        return this._pool;
    }

    public final CarData acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose(boolean freeBackingStorage) {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            if (freeBackingStorage) {
                this.clear(true);
            }
            this._pool.put((UtlPool.Item)this);
            _memstats.onEntityDisposed(CarData.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final void dispose() {
        this.dispose(false);
    }

    public final Object clone() {
        int[] cloner_someNumbers;
        CarData clonee = CarData.create();
        if (this.hasTimestamp()) {
            clonee.setTimestamp(this.getTimestamp());
        }
        if ((cloner_someNumbers = this.getSomeNumbers()) != null) {
            clonee.setSomeNumbers((int[])cloner_someNumbers.clone());
        } else {
            clonee.clearSomeNumbers();
        }
        OptionalExtras[] cloner_extras = this.getExtras();
        if (cloner_extras != null) {
            OptionalExtras[] clonee_extras = new OptionalExtras[cloner_extras.length];
            for (int i = 0; i < cloner_extras.length; ++i) {
                clonee_extras[i] = cloner_extras[i];
            }
            clonee.setExtras(clonee_extras);
        } else {
            clonee.setExtras(null);
        }
        Engine cloner_engine = this.getEngine();
        if (cloner_engine != null) {
            clonee.setEngine((Engine)cloner_engine.clone());
        } else {
            clonee.setEngine(null);
        }
        FuelFigure[] cloner_fuelFigure = this.getFuelFigure();
        if (cloner_fuelFigure != null) {
            FuelFigure[] clonee_fuelFigure = new FuelFigure[cloner_fuelFigure.length];
            for (int i = 0; i < cloner_fuelFigure.length; ++i) {
                clonee_fuelFigure[i] = (FuelFigure)cloner_fuelFigure[i].clone();
            }
            clonee.setFuelFigure(clonee_fuelFigure);
        } else {
            clonee.setFuelFigure(null);
        }
        PerformanceFigure[] cloner_performanceFigure = this.getPerformanceFigure();
        if (cloner_performanceFigure != null) {
            PerformanceFigure[] clonee_performanceFigure = new PerformanceFigure[cloner_performanceFigure.length];
            for (int i = 0; i < cloner_performanceFigure.length; ++i) {
                clonee_performanceFigure[i] = (PerformanceFigure)cloner_performanceFigure[i].clone();
            }
            clonee.setPerformanceFigure(clonee_performanceFigure);
        } else {
            clonee.setPerformanceFigure(null);
        }
        if (this.hasManufacturer()) {
            clonee.setManufacturer(this.getManufacturer());
        }
        if (this.hasModel()) {
            clonee.setModel(this.getModel());
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        if (this.hasTimestamp()) {
            builder.append(0 == c++ ? "" : ",").append("Timestamp=").append(this.getTimestamp());
        }
        builder.append(0 == c++ ? "" : ",").append("SomeNumbers=").append(Arrays.toString(this.getSomeNumbers()));
        builder.append(0 == c++ ? "" : ",").append("Extras=").append(Arrays.toString((Object[])this.getExtras()));
        if (this.hasEngine()) {
            builder.append(0 == c++ ? "" : ",").append("Engine=").append(this.getEngine());
        }
        builder.append(0 == c++ ? "" : ",").append("FuelFigure=").append(Arrays.toString(this.getFuelFigure()));
        builder.append(0 == c++ ? "" : ",").append("PerformanceFigure=").append(Arrays.toString(this.getPerformanceFigure()));
        if (this.hasManufacturer()) {
            builder.append(0 == c++ ? "" : ",").append("Manufacturer=").append(this.getManufacturer());
        }
        if (this.hasModel()) {
            builder.append(0 == c++ ? "" : ",").append("Model=").append(this.getModel());
        }
        builder.append("}");
        return builder.toString();
    }

    static {
        _fieldReflectors.put("Timestamp", (IRogFieldReflector<CarData, ?>)_timestampReflector);
        _fieldReflectors.put("timestamp", (IRogFieldReflector<CarData, ?>)_timestampReflector);
        _fieldReflectors.put("Engine", (IRogFieldReflector<CarData, ?>)_engineReflector);
        _fieldReflectors.put("engine", (IRogFieldReflector<CarData, ?>)_engineReflector);
        _fieldReflectors.put("Manufacturer", (IRogFieldReflector<CarData, ?>)_manufacturerReflector);
        _fieldReflectors.put("manufacturer", (IRogFieldReflector<CarData, ?>)_manufacturerReflector);
        _fieldReflectors.put("Model", (IRogFieldReflector<CarData, ?>)_modelReflector);
        _fieldReflectors.put("model", (IRogFieldReflector<CarData, ?>)_modelReflector);
        _conserveMemory = Config.conserveMemory();
        _freeBackingStorageOnClear = Config.getValue((String)("nv.tuning.memory." + CarData.class.getName() + ".freeBackingStorageOnClear"), (boolean)Config.getValue((String)"nv.tuning.memory.freeBackingStorageOnClear", (boolean)_conserveMemory));
        _memstats = MemoryStats.getInstance();
        _carDataFactory = new CarDataPoolFactory();
        _carDataPojoFactory = new CarDataPojoPoolFactory();
        _carDataSerializerFactory = new CarDataSerializerPoolFactory();
        _carDataDeserializerFactory = new CarDataDeserializerPoolFactory();
        _entityPool = UtlPool.create((String)"quark.entity", (String)"CarDataQuarkEntity.1.105", (UtlPool.Factory)_carDataFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(CarData.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new CarDataPoolEvictedItemReceiver());
        _entityPojoPool = UtlPool.create((String)"quark.entity.pojo", (String)"CarDataQuarkEntityPojo.1.105", (UtlPool.Factory)_carDataPojoFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new CarDataPojoPoolEvictedItemReceiver());
        _entitySerializerPool = UtlPool.create((String)"quark.entity.serializer", (String)"CarDataQuarkEntitySerializer.1.105", (UtlPool.Factory)_carDataSerializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new CarDataSerializerPoolEvictedItemReceiver());
        _entityDeserializerPool = UtlPool.create((String)"quark.entity.deserializer", (String)"CarDataQuarkEntityDeserializer.1.105", (UtlPool.Factory)_carDataDeserializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new CarDataDeserializerPoolEvictedItemReceiver());
        EMPTY_ARRAY = new CarData[0];
    }

    private static final class ModelDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private ModelDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleModel(XStringDeserializer val) {
            val.getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class ManufacturerDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private ManufacturerDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleManufacturer(XStringDeserializer val) {
            val.getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class EngineDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final Engine _value = Engine.create();
        private Deserializer _deserializer;
        private byte _flags;

        private EngineDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleEngine(Engine.Deserializer val) {
            this._value.deserializeFrom(val);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class TimestampDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private long _value;
        private Deserializer _deserializer;
        private byte _flags;

        private TimestampDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleTimestamp(long val) {
            this._value = val;
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class ManufactureDateDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private long _value;
        private Deserializer _deserializer;
        private byte _flags;

        private ManufactureDateDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleBlock2(Block2Deserializer val) {
            this._value = val.getManufactureDate();
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class VehicleCodeDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private final XString _value = XString.create();
        private Deserializer _deserializer;
        private byte _flags;

        private VehicleCodeDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleBlock2(Block2Deserializer val) {
            val.getVehicleCode().getTo(this._value);
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class CodeDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private Code _value;
        private Deserializer _deserializer;
        private byte _flags;

        private CodeDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleBlock2(Block2Deserializer val) {
            this._value = val.getCode();
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class AvailableDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private BooleanType _value;
        private Deserializer _deserializer;
        private byte _flags;

        private AvailableDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleBlock2(Block2Deserializer val) {
            this._value = val.getAvailable();
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class ModelYearDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private short _value;
        private Deserializer _deserializer;
        private byte _flags;

        private ModelYearDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleBlock2(Block2Deserializer val) {
            this._value = val.getModelYear();
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    private static final class SerialNumberDeserializer
    extends Deserializer.AbstractCallbackImpl {
        private static final byte FLG_WASRUN = 1;
        private static final byte FLG_WASSET = 2;
        private int _value;
        private Deserializer _deserializer;
        private byte _flags;

        private SerialNumberDeserializer() {
        }

        private final void setWasRun() {
            this._flags = (byte)(this._flags | 1);
        }

        private final void setWasSet() {
            this._flags = (byte)(this._flags | 2);
        }

        final void run(Deserializer deserializer) {
            this._flags = 0;
            this._deserializer = deserializer;
            this._deserializer.run(this);
            this.setWasRun();
        }

        final boolean wasRun() {
            return (this._flags & 1) != 0;
        }

        final boolean wasSet() {
            return (this._flags & 2) != 0;
        }

        @Override
        public final void handleBlock2(Block2Deserializer val) {
            this._value = val.getSerialNumber();
            this.setWasSet();
            this._deserializer.stop();
        }
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final byte FLG_ONLY_POJOS = 8;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private int _serializedLength;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private int _usrSerialNumber;
        private short _usrModelYear;
        private BooleanType _usrAvailable;
        private Code _usrCode;
        private final XString _usrVehicleCode = XString.create();
        private long _usrManufactureDate;
        private long _usrTimestamp;
        private final XIntSequence _someNumbersDeserializer = XIntSequence.create();
        private IOBuffer _usrSomeNumbersSerialized;
        private int _usrSomeNumbersSerializedLen;
        private final ExtrasDeserializer _extrasDeserializer = ExtrasDeserializer.create();
        private IOBuffer _usrExtrasSerialized;
        private int _usrExtrasSerializedLen;
        private Engine _usrEngine;
        private final XIndexedList<FuelFigure> _usrFuelFigure = new XIndexedList(256);
        private final XIndexedList<PerformanceFigure> _usrPerformanceFigure = new XIndexedList(256);
        private XString _usrManufacturer = XString.create();
        private XString _usrModel = XString.create();

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memstats.onEntityPojoAllocated(CarData.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final boolean hasBlock2() {
            return (this._fieldBitmask[0] & 2L) != 0L;
        }

        public final void clearBlock2() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasBlock2()) {
                return;
            }
            this._usrSerialNumber = 0;
            this._usrModelYear = 0;
            this._usrAvailable = null;
            this._usrCode = null;
            this._usrVehicleCode.clear(false);
            this._usrManufactureDate = 0L;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFDL;
            this._dirty = true;
            this._serializedLength -= 34;
        }

        public final int getSerialNumber() {
            return this._usrSerialNumber;
        }

        public final void setSerialNumber(int val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._usrSerialNumber = val;
            this._dirty = true;
        }

        public final short getModelYear() {
            return this._usrModelYear;
        }

        public final void setModelYear(short val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._usrModelYear = val;
            this._dirty = true;
        }

        public final BooleanType getAvailable() {
            return this._usrAvailable;
        }

        public final void setAvailable(BooleanType val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearAvailable();
                return;
            }
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._usrAvailable = val;
            this._dirty = true;
        }

        private final void clearAvailable() {
            if (!this.hasBlock2()) {
                return;
            }
            this._usrAvailable = null;
        }

        public final Code getCode() {
            return this._usrCode;
        }

        public final void setCode(Code val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearCode();
                return;
            }
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._usrCode = val;
            this._dirty = true;
        }

        private final void clearCode() {
            if (!this.hasBlock2()) {
                return;
            }
            this._usrCode = null;
        }

        public final XString getVehicleCode() {
            return this._usrVehicleCode.isNull() ? null : this._usrVehicleCode;
        }

        public final void getVehicleCodeTo(XString val) {
            this._usrVehicleCode.getTo(val);
        }

        public final void setVehicleCodeFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearVehicleCode();
                return;
            }
            if (val.length() != 6) {
                throw new IllegalStateException("length must be 6");
            }
            this._usrVehicleCode.setFrom(val);
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._dirty = true;
        }

        public final void setVehicleCodeFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearVehicleCode();
                return;
            }
            if (val.length() != 6) {
                throw new IllegalStateException("length must be 6");
            }
            this._usrVehicleCode.setFrom(val);
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._dirty = true;
        }

        public final void setVehicleCodeFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (XString.stringSize((long)val) != 6) {
                throw new IllegalStateException("length must be 6");
            }
            this._usrVehicleCode.setFrom(val);
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._dirty = true;
        }

        public final void setVehicleCodeFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearVehicleCode();
                return;
            }
            if (len != 6) {
                throw new IllegalStateException("length must be 6");
            }
            this._usrVehicleCode.setFrom(val);
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._dirty = true;
        }

        public final void setVehicleCodeFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearVehicleCode();
                return;
            }
            if (val.serializedLength() != 6) {
                throw new IllegalStateException("length must be 6");
            }
            val.getTo(this._usrVehicleCode);
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._dirty = true;
        }

        private final void clearVehicleCode() {
            if (!this.hasBlock2()) {
                return;
            }
            this._usrVehicleCode.clear(false);
        }

        public final long getManufactureDate() {
            return this._usrManufactureDate;
        }

        public final void setManufactureDate(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasBlock2()) {
                this._fieldBitmask[0] = this._fieldBitmask[0] | 2L;
                this._serializedLength += 34;
            }
            this._usrManufactureDate = val;
            this._dirty = true;
        }

        public final boolean hasTimestamp() {
            return (this._fieldBitmask[0] & 1L) != 0L;
        }

        public final long getTimestamp() {
            return this._usrTimestamp;
        }

        public final void setTimestamp(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasTimestamp()) {
                this._serializedLength += 10;
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 1L;
            this._usrTimestamp = val;
            this._dirty = true;
        }

        public final void clearTimestamp() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasTimestamp()) {
                return;
            }
            this._usrTimestamp = 0L;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFFFEL;
            this._dirty = true;
            this._serializedLength -= 10;
        }

        public final int getSomeNumbersCount() {
            return this._usrSomeNumbersSerializedLen / 4;
        }

        public final int getSomeNumbersAt(int index) {
            int nelem = this.getSomeNumbersCount();
            if (index < 0 || index > nelem - 1) {
                throw new IllegalArgumentException("index out of bounds");
            }
            return XIntSequence.getAt((IOBuffer)this._usrSomeNumbersSerialized, (int)index);
        }

        public final XIntSequence getSomeNumbersDeserializer() {
            if (this._usrSomeNumbersSerialized != null) {
                this._someNumbersDeserializer.wrap(this._usrSomeNumbersSerialized, 0, this._usrSomeNumbersSerializedLen);
            } else {
                this._someNumbersDeserializer.wrap(0L, 0, 0);
            }
            return this._someNumbersDeserializer;
        }

        public final XIntIterator getSomeNumbersIterator() {
            if (this._usrSomeNumbersSerialized != null) {
                this._someNumbersDeserializer.wrap(this._usrSomeNumbersSerialized, 0, this._usrSomeNumbersSerializedLen);
            } else {
                this._someNumbersDeserializer.wrap(0L, 0, 0);
            }
            return this._someNumbersDeserializer.iterator();
        }

        public final int getSomeNumbersTo(int[] val, int offset) {
            int nelem = this.getSomeNumbersCount();
            if (nelem > val.length - offset) {
                throw new IllegalArgumentException("array too small");
            }
            if (this._usrSomeNumbersSerialized != null) {
                this._usrSomeNumbersSerialized.getTo(0, val, offset, nelem);
            }
            return nelem;
        }

        public final void addToSomeNumbers(int val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            this._usrSomeNumbersSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrSomeNumbersSerialized, (int)(this._usrSomeNumbersSerializedLen + 4), (boolean)true);
            IOBuffer.putInt((long)this._usrSomeNumbersSerialized.getNativeAddress(), (int)this._usrSomeNumbersSerializedLen, (int)val);
            this._serializedLength += this._usrSomeNumbersSerializedLen > 0 ? 4 : 10;
            this._usrSomeNumbersSerializedLen += 4;
            this._dirty = true;
        }

        public final void addToSomeNumbersFrom(XIntSequence sequence) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (sequence == null) {
                return;
            }
            this._usrSomeNumbersSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrSomeNumbersSerialized, (int)(this._usrSomeNumbersSerializedLen + sequence.serializedLength()), (boolean)true);
            int len = sequence.getTo(this._usrSomeNumbersSerialized, this._usrSomeNumbersSerializedLen);
            this._serializedLength += this._usrSomeNumbersSerializedLen > 0 ? len : len + 6;
            this._usrSomeNumbersSerializedLen += len;
            this._dirty = true;
        }

        public final void setSomeNumbersFrom(XIntSequence sequence) {
            this.clearSomeNumbers();
            this.addToSomeNumbersFrom(sequence);
        }

        public final void addToSomeNumbersFrom(XIntIterator iterator) {
            if (iterator == null) {
                return;
            }
            if (iterator instanceof XIntSequence) {
                this.addToSomeNumbersFrom((XIntSequence)iterator);
            } else {
                iterator.toFirst();
                while (iterator.hasNext()) {
                    this.addToSomeNumbers(iterator.next());
                }
            }
        }

        public final void setSomeNumbersFrom(XIntIterator iterator) {
            this.clearSomeNumbers();
            this.addToSomeNumbersFrom(iterator);
        }

        public final void addToSomeNumbersFrom(int[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.length == 0) {
                return;
            }
            int nbytes = len * 4;
            this._usrSomeNumbersSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrSomeNumbersSerialized, (int)(this._usrSomeNumbersSerializedLen + nbytes), (boolean)true);
            this._usrSomeNumbersSerialized.putFrom(this._usrSomeNumbersSerializedLen, val, offset, len);
            this._serializedLength += this._usrSomeNumbersSerializedLen > 0 ? nbytes : 6 + nbytes;
            this._usrSomeNumbersSerializedLen += nbytes;
            this._dirty = true;
        }

        public final void setSomeNumbersFrom(int[] val, int offset, int len) {
            this.clearSomeNumbers();
            this.addToSomeNumbersFrom(val, offset, len);
        }

        public final void clearSomeNumbers(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrSomeNumbersSerializedLen == 0) {
                return;
            }
            this._serializedLength -= this._usrSomeNumbersSerializedLen + 6;
            this._usrSomeNumbersSerializedLen = 0;
            if (freeBackingStorage && this._usrSomeNumbersSerialized != null) {
                this._usrSomeNumbersSerialized.dispose();
                this._usrSomeNumbersSerialized = null;
            }
            this._dirty = true;
        }

        public final void clearSomeNumbers() {
            this.clearSomeNumbers(false);
        }

        public final int getExtrasCount() {
            return this._usrExtrasSerializedLen / 4;
        }

        public final OptionalExtras getExtrasAt(int index) {
            int nelem = this.getExtrasCount();
            if (index < 0 || index > nelem - 1) {
                throw new IllegalArgumentException("index out of bounds");
            }
            return OptionalExtras.fromValue(XIntSequence.getAt((IOBuffer)this._usrExtrasSerialized, (int)index));
        }

        public final ExtrasDeserializer getExtrasDeserializer() {
            if (this._usrExtrasSerialized != null) {
                this._extrasDeserializer.wrap(this._usrExtrasSerialized, 0, this._usrExtrasSerializedLen);
            } else {
                this._extrasDeserializer.wrap(0L, 0, 0);
            }
            return this._extrasDeserializer;
        }

        public final XIterator<OptionalExtras> getExtrasIterator() {
            if (this._usrExtrasSerialized != null) {
                this._extrasDeserializer.wrap(this._usrExtrasSerialized, 0, this._usrExtrasSerializedLen);
            } else {
                this._extrasDeserializer.wrap(0L, 0, 0);
            }
            return this._extrasDeserializer.iterator();
        }

        public final int getExtrasTo(OptionalExtras[] val, int offset) {
            int nelem = this.getExtrasCount();
            if (nelem > val.length - offset) {
                throw new IllegalArgumentException("array too small");
            }
            XIterator<OptionalExtras> iterator = this.getExtrasIterator();
            for (int i = 0; i < nelem; ++i) {
                val[offset + i] = (OptionalExtras)((Object)iterator.next());
            }
            return nelem;
        }

        public final void addToExtras(OptionalExtras val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            this._usrExtrasSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrExtrasSerialized, (int)(this._usrExtrasSerializedLen + 4), (boolean)true);
            IOBuffer.putInt((long)this._usrExtrasSerialized.getNativeAddress(), (int)this._usrExtrasSerializedLen, (int)val.val);
            this._dirty = true;
            this._serializedLength += this._usrExtrasSerializedLen > 0 ? 4 : 10;
            this._usrExtrasSerializedLen += 4;
        }

        public final void addToExtrasFrom(ExtrasDeserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            this._usrExtrasSerialized = IOBuffer.ensureCapacity((IOBuffer)this._usrExtrasSerialized, (int)(this._usrExtrasSerializedLen + deserializer.serializedLength()), (boolean)true);
            int len = deserializer.getTo(this._usrExtrasSerialized, this._usrExtrasSerializedLen);
            this._serializedLength += this._usrExtrasSerializedLen > 0 ? len : len + 6;
            this._usrExtrasSerializedLen += len;
            this._dirty = true;
        }

        public final void setExtrasFrom(ExtrasDeserializer deserializer) {
            this.clearExtras();
            this.addToExtrasFrom(deserializer);
        }

        public final void addToExtrasFrom(XIterator<OptionalExtras> iterator) {
            if (iterator == null) {
                return;
            }
            if (iterator instanceof ExtrasDeserializer) {
                this.addToExtrasFrom((ExtrasDeserializer)iterator);
            } else {
                iterator.toFirst();
                while (iterator.hasNext()) {
                    OptionalExtras val = (OptionalExtras)((Object)iterator.next());
                    if (val == null) continue;
                    this.addToExtras(val);
                }
            }
        }

        public final void setExtrasFrom(XIterator<OptionalExtras> iterator) {
            this.clearExtras();
            this.addToExtrasFrom(iterator);
        }

        public final void addToExtrasFrom(OptionalExtras[] val, int offset, int len) {
            if (val == null) {
                return;
            }
            for (int i = 0; i < len; ++i) {
                OptionalExtras v = val[offset + i];
                if (v == null) continue;
                this.addToExtras(v);
            }
        }

        public final void setExtrasFrom(OptionalExtras[] val, int offset, int len) {
            this.clearExtras();
            this.addToExtrasFrom(val, offset, len);
        }

        public final void clearExtras(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrExtrasSerializedLen == 0) {
                return;
            }
            this._serializedLength -= this._usrExtrasSerializedLen + 6;
            this._usrExtrasSerializedLen = 0;
            if (freeBackingStorage && this._usrExtrasSerialized != null) {
                this._usrExtrasSerialized.dispose();
                this._usrExtrasSerialized = null;
            }
            this._dirty = true;
        }

        public final void clearExtras() {
            this.clearExtras(false);
        }

        public final boolean hasEngine() {
            return (this._fieldBitmask[0] & 0x200L) != 0L;
        }

        public final Engine getEngine() {
            return this.hasEngine() ? this._usrEngine : null;
        }

        public final void getEngineTo(Engine to) {
            to.clear();
            if (!this.hasEngine()) {
                return;
            }
            this._usrEngine.sync();
            to.deserializeFrom(this._usrEngine.getSerializedBuffer(), 0, this._usrEngine.getSerializedBufferLength());
            if (this.isOnlyPojos()) {
                this._usrEngine.pojo(true);
            }
        }

        public final Engine takeEngine() {
            if (this._usrEngine != null) {
                this._usrEngine.acquire();
            }
            return this._usrEngine;
        }

        public final void setEngine(Engine val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrEngine == val) {
                return;
            }
            if (val == null) {
                this.clearEngine();
                return;
            }
            if (this._usrEngine != null) {
                this._usrEngine.clear();
            }
            this._usrEngine = val;
            if (this.isOnlyPojos()) {
                this._usrEngine.pojo(true);
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x200L;
            this._dirty = true;
        }

        public final void setEngineFrom(Engine.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                this.clearEngine();
                return;
            }
            if (this._usrEngine != null) {
                this._usrEngine.clear();
            }
            this._usrEngine = Engine.create();
            if (deserializer.getSerializedLength() > 0) {
                this._usrEngine.deserializeFrom(deserializer);
            }
            if (this.isOnlyPojos()) {
                this._usrEngine.pojo(true);
            }
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x200L;
            this._dirty = true;
        }

        public final void lendEngine(Engine val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (this._usrEngine == val) {
                return;
            }
            if (val == null) {
                this.clearEngine();
                return;
            }
            if (this._usrEngine != null) {
                this._usrEngine.clear();
            }
            val.acquire();
            this._usrEngine = val;
            this._fieldBitmask[0] = this._fieldBitmask[0] | 0x200L;
            this._dirty = true;
        }

        public final void clearEngine(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasEngine()) {
                return;
            }
            this._usrEngine.dispose(freeBackingStorage);
            this._usrEngine = null;
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFFDFFL;
            this._dirty = true;
        }

        public final void clearEngine() {
            this.clearEngine(false);
        }

        public final int getFuelFigureCount() {
            return this._usrFuelFigure.size();
        }

        public final FuelFigure getFuelFigureAt(int index) {
            if (index < 0 || index >= this.getFuelFigureCount()) {
                throw new IllegalArgumentException("index out of range");
            }
            return (FuelFigure)this._usrFuelFigure.get(index);
        }

        public final XIterator<FuelFigure> getFuelFigureIterator() {
            return this._usrFuelFigure.reusableIterator();
        }

        public final void addToFuelFigure(FuelFigure val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrFuelFigure.add((Object)val);
            this._dirty = true;
        }

        public final void addToFuelFigureFrom(FuelFigure.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            FuelFigure val = FuelFigure.create();
            if (deserializer.getSerializedLength() > 0) {
                val.deserializeFrom(deserializer);
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrFuelFigure.add((Object)val);
            this._dirty = true;
        }

        public final void lendToFuelFigure(FuelFigure val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            val.acquire();
            this._usrFuelFigure.add((Object)val);
            this._dirty = true;
        }

        public final void clearFuelFigure(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int size = this._usrFuelFigure.size();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((FuelFigure)this._usrFuelFigure.get(i)).dispose(freeBackingStorage);
            }
            this._usrFuelFigure.clear();
            this._dirty = true;
        }

        public final void clearFuelFigure() {
            this.clearFuelFigure(false);
        }

        public final int getPerformanceFigureCount() {
            return this._usrPerformanceFigure.size();
        }

        public final PerformanceFigure getPerformanceFigureAt(int index) {
            if (index < 0 || index >= this.getPerformanceFigureCount()) {
                throw new IllegalArgumentException("index out of range");
            }
            return (PerformanceFigure)this._usrPerformanceFigure.get(index);
        }

        public final XIterator<PerformanceFigure> getPerformanceFigureIterator() {
            return this._usrPerformanceFigure.reusableIterator();
        }

        public final void addToPerformanceFigure(PerformanceFigure val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrPerformanceFigure.add((Object)val);
            this._dirty = true;
        }

        public final void addToPerformanceFigureFrom(PerformanceFigure.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            PerformanceFigure val = PerformanceFigure.create();
            if (deserializer.getSerializedLength() > 0) {
                val.deserializeFrom(deserializer);
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrPerformanceFigure.add((Object)val);
            this._dirty = true;
        }

        public final void lendToPerformanceFigure(PerformanceFigure val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            val.acquire();
            this._usrPerformanceFigure.add((Object)val);
            this._dirty = true;
        }

        public final void clearPerformanceFigure(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int size = this._usrPerformanceFigure.size();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((PerformanceFigure)this._usrPerformanceFigure.get(i)).dispose(freeBackingStorage);
            }
            this._usrPerformanceFigure.clear();
            this._dirty = true;
        }

        public final void clearPerformanceFigure() {
            this.clearPerformanceFigure(false);
        }

        public final boolean hasManufacturer() {
            return (this._fieldBitmask[0] & 0x1000L) != 0L;
        }

        public final XString getManufacturer() {
            if (!this.hasManufacturer() || this._usrManufacturer.isNull()) {
                return null;
            }
            return this._usrManufacturer;
        }

        public final void getManufacturerTo(XString val) {
            if (!this.hasManufacturer() || this._usrManufacturer.isNull()) {
                val.clear();
                return;
            }
            this._usrManufacturer.getTo(val);
        }

        public final void setManufacturerFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearManufacturer();
                return;
            }
            int nbytes1 = this._usrManufacturer.serializedLength();
            this._usrManufacturer.setFrom(val);
            int nbytes2 = this._usrManufacturer.serializedLength();
            if (this.hasManufacturer()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x1000L;
            }
            this._dirty = true;
        }

        public final void setManufacturerFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearManufacturer();
                return;
            }
            int nbytes1 = this._usrManufacturer.serializedLength();
            this._usrManufacturer.setFrom(val);
            int nbytes2 = this._usrManufacturer.serializedLength();
            if (this.hasManufacturer()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x1000L;
            }
            this._dirty = true;
        }

        public final void setManufacturerFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int nbytes1 = this._usrManufacturer.serializedLength();
            this._usrManufacturer.setFrom(val);
            int nbytes2 = this._usrManufacturer.serializedLength();
            if (this.hasManufacturer()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x1000L;
            }
            this._dirty = true;
        }

        public final void setManufacturerFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearManufacturer();
                return;
            }
            int nbytes1 = this._usrManufacturer.serializedLength();
            this._usrManufacturer.setFrom(val, offset, len);
            int nbytes2 = this._usrManufacturer.serializedLength();
            if (this.hasManufacturer()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x1000L;
            }
            this._dirty = true;
        }

        public final void setManufacturerFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearManufacturer();
                return;
            }
            int nbytes1 = this._usrManufacturer.serializedLength();
            this._usrManufacturer.setFrom(val);
            int nbytes2 = this._usrManufacturer.serializedLength();
            if (this.hasManufacturer()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x1000L;
            }
            this._dirty = true;
        }

        public final void setManufacturerFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearManufacturer();
                return;
            }
            int nbytes1 = this._usrManufacturer.serializedLength();
            val.getTo(this._usrManufacturer);
            int nbytes2 = this._usrManufacturer.serializedLength();
            if (this.hasManufacturer()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x1000L;
            }
            this._dirty = true;
        }

        public final void clearManufacturer(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasManufacturer()) {
                return;
            }
            this._serializedLength -= this._usrManufacturer.serializedLength() + 6;
            this._usrManufacturer.clear(freeBackingStorage);
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFEFFFL;
            this._dirty = true;
        }

        public final void clearManufacturer() {
            this.clearManufacturer(false);
        }

        public final boolean hasModel() {
            return (this._fieldBitmask[0] & 0x2000L) != 0L;
        }

        public final XString getModel() {
            if (!this.hasModel() || this._usrModel.isNull()) {
                return null;
            }
            return this._usrModel;
        }

        public final void getModelTo(XString val) {
            if (!this.hasModel() || this._usrModel.isNull()) {
                val.clear();
                return;
            }
            this._usrModel.getTo(val);
        }

        public final void setModelFrom(String val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearModel();
                return;
            }
            int nbytes1 = this._usrModel.serializedLength();
            this._usrModel.setFrom(val);
            int nbytes2 = this._usrModel.serializedLength();
            if (this.hasModel()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x2000L;
            }
            this._dirty = true;
        }

        public final void setModelFrom(CharSequence val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearModel();
                return;
            }
            int nbytes1 = this._usrModel.serializedLength();
            this._usrModel.setFrom(val);
            int nbytes2 = this._usrModel.serializedLength();
            if (this.hasModel()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x2000L;
            }
            this._dirty = true;
        }

        public final void setModelFrom(long val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int nbytes1 = this._usrModel.serializedLength();
            this._usrModel.setFrom(val);
            int nbytes2 = this._usrModel.serializedLength();
            if (this.hasModel()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x2000L;
            }
            this._dirty = true;
        }

        public final void setModelFrom(byte[] val, int offset, int len) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearModel();
                return;
            }
            int nbytes1 = this._usrModel.serializedLength();
            this._usrModel.setFrom(val, offset, len);
            int nbytes2 = this._usrModel.serializedLength();
            if (this.hasModel()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x2000L;
            }
            this._dirty = true;
        }

        public final void setModelFrom(XString val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null || val.isNull()) {
                this.clearModel();
                return;
            }
            int nbytes1 = this._usrModel.serializedLength();
            this._usrModel.setFrom(val);
            int nbytes2 = this._usrModel.serializedLength();
            if (this.hasModel()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x2000L;
            }
            this._dirty = true;
        }

        public final void setModelFrom(XStringDeserializer val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                this.clearModel();
                return;
            }
            int nbytes1 = this._usrModel.serializedLength();
            val.getTo(this._usrModel);
            int nbytes2 = this._usrModel.serializedLength();
            if (this.hasModel()) {
                this._serializedLength += nbytes2 - nbytes1;
            } else {
                this._serializedLength += nbytes2 + 6;
                this._fieldBitmask[0] = this._fieldBitmask[0] | 0x2000L;
            }
            this._dirty = true;
        }

        public final void clearModel(boolean freeBackingStorage) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (!this.hasModel()) {
                return;
            }
            this._serializedLength -= this._usrModel.serializedLength() + 6;
            this._usrModel.clear(freeBackingStorage);
            this._fieldBitmask[0] = this._fieldBitmask[0] & 0xFFFFFFFFFFFFDFFFL;
            this._dirty = true;
        }

        public final void clearModel() {
            this.clearModel(false);
        }

        public final void clear(boolean freeBackingStorage) {
            this._readonly = false;
            this.clearBlock2();
            this._usrTimestamp = 0L;
            if (freeBackingStorage) {
                this.clearSomeNumbers(true);
            } else {
                this._usrSomeNumbersSerializedLen = 0;
            }
            if (freeBackingStorage) {
                this.clearExtras(true);
            } else {
                this._usrExtrasSerializedLen = 0;
            }
            this.clearEngine(freeBackingStorage);
            this.clearFuelFigure(freeBackingStorage);
            this.clearPerformanceFigure(freeBackingStorage);
            if (freeBackingStorage) {
                this.clearManufacturer(true);
            }
            if (freeBackingStorage) {
                this.clearModel(true);
            }
            this._fieldBitmask[0] = 0L;
            this._serializedLength = 0;
            this._dirty = true;
        }

        public final void clear() {
            this.clear(_freeBackingStorageOnClear);
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final Pojo setOnlyPojos() {
            this._flags = (byte)(this._flags | 8);
            return this;
        }

        private final boolean isOnlyPojos() {
            return (this._flags & 8) != 0;
        }

        private final Pojo clearOnlyPojos() {
            this._flags = (byte)(this._flags & 0xFFFFFFF7);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = this._serializedLength;
            if (this.hasEngine()) {
                len += this._usrEngine.hasDirtyPojo() ? 6 + this._usrEngine.pojo().getSerializedLength() : 6 + this._usrEngine.getSerializedBufferLength();
            }
            XIterator<FuelFigure> fuelFigureIterator = this.getFuelFigureIterator();
            while (fuelFigureIterator.hasNext()) {
                FuelFigure val = (FuelFigure)fuelFigureIterator.next();
                len += val.hasDirtyPojo() ? 6 + val.pojo().getSerializedLength() : 6 + val.getSerializedBufferLength();
            }
            XIterator<PerformanceFigure> performanceFigureIterator = this.getPerformanceFigureIterator();
            while (performanceFigureIterator.hasNext()) {
                PerformanceFigure val = (PerformanceFigure)performanceFigureIterator.next();
                len += val.hasDirtyPojo() ? 6 + val.pojo().getSerializedLength() : 6 + val.getSerializedBufferLength();
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            if (this.hasBlock2()) {
                Block2Serializer block2Serializer = serializer.block2();
                block2Serializer.serialNumber(this._usrSerialNumber);
                block2Serializer.modelYear(this._usrModelYear);
                block2Serializer.available(this._usrAvailable);
                block2Serializer.code(this._usrCode);
                block2Serializer.vehicleCode(this._usrVehicleCode);
                block2Serializer.manufactureDate(this._usrManufactureDate);
            }
            if (this.hasTimestamp()) {
                serializer.timestamp(this._usrTimestamp);
            }
            if (this._usrSomeNumbersSerializedLen > 0) {
                serializer.someNumbers(this._usrSomeNumbersSerialized, 0, this._usrSomeNumbersSerializedLen);
            }
            if (this._usrExtrasSerializedLen > 0) {
                serializer.extras(this._usrExtrasSerialized, 0, this._usrExtrasSerializedLen);
            }
            if (this.hasEngine()) {
                if (this._usrEngine.hasDirtyPojo()) {
                    this._usrEngine.pojo().serialize(serializer.engine());
                } else {
                    serializer.engine(this._usrEngine.getSerializedBuffer(), 0, this._usrEngine.getSerializedBufferLength());
                }
            }
            XIterator<FuelFigure> fuelFigureIterator = this.getFuelFigureIterator();
            while (fuelFigureIterator.hasNext()) {
                FuelFigure val = (FuelFigure)fuelFigureIterator.next();
                if (val.hasDirtyPojo()) {
                    val.pojo().serialize(serializer.fuelFigure());
                    continue;
                }
                serializer.fuelFigure(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
            }
            XIterator<PerformanceFigure> performanceFigureIterator = this.getPerformanceFigureIterator();
            while (performanceFigureIterator.hasNext()) {
                PerformanceFigure val = (PerformanceFigure)performanceFigureIterator.next();
                if (val.hasDirtyPojo()) {
                    val.pojo().serialize(serializer.performanceFigure());
                    continue;
                }
                serializer.performanceFigure(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
            }
            if (this.hasManufacturer()) {
                serializer.manufacturer(this._usrManufacturer);
            }
            if (this.hasModel()) {
                serializer.model(this._usrModel);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset(boolean freeBackingStorage) {
            this.clear(freeBackingStorage);
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo reset() {
            return this.reset(_conserveMemory);
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityPojoDisposed(CarData.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleBlock2(Block2Deserializer val) {
                Pojo.this.setSerialNumber(val.getSerialNumber());
                Pojo.this.setModelYear(val.getModelYear());
                Pojo.this.setAvailable(val.getAvailable());
                Pojo.this.setCode(val.getCode());
                XStringDeserializer s = val.getVehicleCode();
                if (s.iterator().next() != '\u0000') {
                    Pojo.this.setVehicleCodeFrom(s);
                }
                Pojo.this.setManufactureDate(val.getManufactureDate());
            }

            @Override
            public final void handleTimestamp(long val) {
                Pojo.this.setTimestamp(val);
            }

            @Override
            public final void handleSomeNumbers(XIntSequence val) {
                Pojo.this.setSomeNumbersFrom(val);
            }

            @Override
            public final void handleExtras(ExtrasDeserializer val) {
                Pojo.this.setExtrasFrom(val);
            }

            @Override
            public final void handleEngine(Engine.Deserializer val) {
                Pojo.this.setEngineFrom(val);
            }

            @Override
            public final void handleFuelFigure(FuelFigure.Deserializer val) {
                Pojo.this.addToFuelFigureFrom(val);
            }

            @Override
            public final void handlePerformanceFigure(PerformanceFigure.Deserializer val) {
                Pojo.this.addToPerformanceFigureFrom(val);
            }

            @Override
            public final void handleManufacturer(XStringDeserializer val) {
                Pojo.this.setManufacturerFrom(val);
            }

            @Override
            public final void handleModel(XStringDeserializer val) {
                Pojo.this.setModelFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final Block2Deserializer _block2Deserializer = Block2Deserializer.create();
        private final XIntSequence _intArrayDeserializer = XIntSequence.create();
        private final ExtrasDeserializer _extrasDeserializer = ExtrasDeserializer.create();
        private final Engine.Deserializer _engineDeserializer = Engine.Deserializer.create(true);
        private final FuelFigure.Deserializer _fuelFigureDeserializer = FuelFigure.Deserializer.create(true);
        private final PerformanceFigure.Deserializer _performanceFigureDeserializer = PerformanceFigure.Deserializer.create(true);
        private final XStringDeserializer _stringDeserializer = XStringDeserializer.create();
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private long _addr;
        private int _offset;
        private int _len;
        private boolean _stopped;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memstats.onEntityDeserializerAllocated(CarData.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(IOBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            this._stopped = false;
            block18: for (int pos = this._offset; !this._stopped && pos < lim; pos += 2 + flen) {
                switch ((IOBuffer.getShort((long)addr, (int)pos) & 0xFFFF) >>> 3) {
                    case 2: {
                        flen = 28;
                        cb.handleBlock2(this._block2Deserializer.init(addr, pos + 6));
                        flen += 4;
                        continue block18;
                    }
                    case 1: {
                        flen = 8;
                        cb.handleTimestamp(IOBuffer.getLong((long)addr, (int)(pos + 2)));
                        continue block18;
                    }
                    case 3: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleSomeNumbers(this._intArrayDeserializer.wrap(addr, pos + 6, flen));
                        flen += 4;
                        continue block18;
                    }
                    case 4: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleExtras(this._extrasDeserializer.wrap(addr, pos + 6, flen));
                        flen += 4;
                        continue block18;
                    }
                    case 5: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleEngine(this._engineDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block18;
                    }
                    case 6: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleFuelFigure(this._fuelFigureDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block18;
                    }
                    case 7: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handlePerformanceFigure(this._performanceFigureDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block18;
                    }
                    case 8: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleManufacturer(this._stringDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block18;
                    }
                    case 9: {
                        flen = IOBuffer.getInt((long)addr, (int)(pos + 2));
                        cb.handleModel(this._stringDeserializer.init(addr, pos + 6, flen));
                        flen += 4;
                        continue block18;
                    }
                    default: {
                        switch (IOBuffer.getShort((long)addr, (int)pos) & 3) {
                            case 0: {
                                flen = 4 + IOBuffer.getInt((long)addr, (int)(pos + 2));
                                continue block18;
                            }
                            case 1: {
                                flen = 1;
                                continue block18;
                            }
                            case 2: {
                                flen = 2;
                                continue block18;
                            }
                            case 3: {
                                flen = 4;
                                continue block18;
                            }
                            case 4: {
                                flen = 8;
                                continue block18;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + ((IOBuffer.getShort((long)addr, (int)pos) & 0xFFFF) >>> 3));
                    }
                }
            }
        }

        public final void stop() {
            this._stopped = true;
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityDeserializerDisposed(CarData.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static abstract class AbstractCallbackImpl
        implements Callback {
            @Override
            public void handleBlock2(Block2Deserializer val) {
            }

            @Override
            public void handleTimestamp(long val) {
            }

            @Override
            public void handleSomeNumbers(XIntSequence val) {
            }

            @Override
            public void handleExtras(ExtrasDeserializer val) {
            }

            @Override
            public void handleEngine(Engine.Deserializer val) {
            }

            @Override
            public void handleFuelFigure(FuelFigure.Deserializer val) {
            }

            @Override
            public void handlePerformanceFigure(PerformanceFigure.Deserializer val) {
            }

            @Override
            public void handleManufacturer(XStringDeserializer val) {
            }

            @Override
            public void handleModel(XStringDeserializer val) {
            }
        }

        public static interface Callback {
            public void handleBlock2(Block2Deserializer var1);

            public void handleTimestamp(long var1);

            public void handleSomeNumbers(XIntSequence var1);

            public void handleExtras(ExtrasDeserializer var1);

            public void handleEngine(Engine.Deserializer var1);

            public void handleFuelFigure(FuelFigure.Deserializer var1);

            public void handlePerformanceFigure(PerformanceFigure.Deserializer var1);

            public void handleManufacturer(XStringDeserializer var1);

            public void handleModel(XStringDeserializer var1);
        }
    }

    public static final class ExtrasDeserializer
    implements XIterator<OptionalExtras> {
        private long _addr;
        private int _offset;
        private int _nelem;
        private int _index;

        private ExtrasDeserializer() {
        }

        public static final ExtrasDeserializer create() {
            return new ExtrasDeserializer();
        }

        public final boolean hasNext() {
            return this._index < this._nelem;
        }

        public final OptionalExtras next() {
            int val;
            if (this._index == this._nelem) {
                throw new NoSuchElementException("no more elements");
            }
            return OptionalExtras.hasValue(val = IOBuffer.getInt((long)this._addr, (int)(this._offset + this._index++ * 4))) ? OptionalExtras.fromValue(val) : null;
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public XIterator<OptionalExtras> toFirst() {
            this._index = 0;
            return this;
        }

        public final ExtrasDeserializer wrap(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._nelem = len / 4;
            this._index = 0;
            return this;
        }

        public final ExtrasDeserializer wrap(IOBuffer buffer, int offset, int len) {
            return this.wrap(buffer.getNativeAddress(), offset, len);
        }

        public final int numElements() {
            return this._nelem;
        }

        public final int serializedLength() {
            return this._nelem * 4;
        }

        public final int getTo(OptionalExtras[] val, int offset) {
            XIterator<OptionalExtras> iterator = this.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                val[offset + i++] = (OptionalExtras)((Object)iterator.next());
            }
            return this.serializedLength();
        }

        public final int getTo(long addr, int offset) {
            int serializedLength = this.serializedLength();
            IOBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)serializedLength);
            return serializedLength;
        }

        public final int getTo(IOBuffer val, int offset) {
            val.putFrom(offset, this._addr, this._offset, this.serializedLength());
            return this.serializedLength();
        }

        public final XIterator<OptionalExtras> iterator() {
            return this.toFirst();
        }
    }

    public static final class Block2Deserializer {
        private final XStringDeserializer _stringDeserializer = XStringDeserializer.create();
        private long _addr;
        private int _offset;

        private Block2Deserializer() {
        }

        public static final Block2Deserializer create() {
            return new Block2Deserializer();
        }

        public final Block2Deserializer init(long addr, int offset) {
            this._addr = addr;
            this._offset = offset;
            return this;
        }

        public final Block2Deserializer init(IOBuffer buffer, int offset) {
            return this.init(buffer.getNativeAddress(), offset);
        }

        public final int serializedLength() {
            return 28;
        }

        public final int getTo(long addr, int offset) {
            IOBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)28);
            return 28;
        }

        public final int getTo(IOBuffer val, int offset) {
            val.putFrom(offset, this._addr, this._offset, 28);
            return 28;
        }

        public final int getSerialNumber() {
            return IOBuffer.getInt((long)this._addr, (int)(this._offset + 0));
        }

        public final short getModelYear() {
            return IOBuffer.getShort((long)this._addr, (int)(this._offset + 4));
        }

        public final BooleanType getAvailable() {
            int val = IOBuffer.getInt((long)this._addr, (int)(this._offset + 6));
            return val >= 0 && BooleanType.hasValue(val) ? BooleanType.fromValue(val) : null;
        }

        public final Code getCode() {
            int val = IOBuffer.getInt((long)this._addr, (int)(this._offset + 10));
            return val >= 0 && Code.hasValue(val) ? Code.fromValue(val) : null;
        }

        public final XStringDeserializer getVehicleCode() {
            return this._stringDeserializer.init(this._addr, this._offset + 14, 6);
        }

        public final long getManufactureDate() {
            return IOBuffer.getLong((long)this._addr, (int)(this._offset + 20));
        }

        public final void dispose() {
        }
    }

    public static final class Serializer
    implements IQuarkChildSerializationCompletionCallback,
    UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private final Block2Serializer _block2Serializer = Block2Serializer.create();
        private final Engine.Serializer _engineSerializer = Engine.Serializer.create();
        private final FuelFigure.Serializer _fuelFigureSerializer = FuelFigure.Serializer.create();
        private final PerformanceFigure.Serializer _performanceFigureSerializer = PerformanceFigure.Serializer.create();
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private CarData _entity;
        private IQuarkChildSerializationCompletionCallback _parent;
        private int _mark;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memstats.onEntitySerializerAllocated(CarData.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        public final Serializer init(long addr, int len, IQuarkChildSerializationCompletionCallback parent) {
            this._entity = null;
            this._parent = parent;
            this._mark = -1;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(IOBuffer buffer, int len, IQuarkChildSerializationCompletionCallback parent) {
            return this.init(buffer.getNativeAddress(), len, parent);
        }

        public final Serializer init(IOBuffer buffer, IQuarkChildSerializationCompletionCallback parent) {
            return this.init(buffer.getNativeAddress(), 0, parent);
        }

        final Serializer init(CarData entity) {
            this.init(entity.getSerializedBuffer(), 0, null);
            this._entity = entity;
            return this;
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(IOBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Block2Serializer block2() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + 28);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)16);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)28);
            this._len += 32;
            return this._block2Serializer.init(this._addr, this._len - 28);
        }

        public final Serializer timestamp(long val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 10);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)12);
            this._len += 2;
            IOBuffer.putLong((long)this._addr, (int)this._len, (long)val);
            this._len += 8;
            return this;
        }

        public final Serializer someNumbers(int[] val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + 4 * val.length);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)(4 * val.length));
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (int[])val, (int)0, (int)val.length);
            this._len += 4 * val.length;
            return this;
        }

        public final Serializer someNumbers(XIntIterator val) {
            if (val instanceof XIntSequence) {
                return this.someNumbers((XIntSequence)val);
            }
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            int serializedLengthPos = this._len;
            this._len += 4;
            while (val.hasNext()) {
                if (this.hasSizer()) {
                    this.ensureCapacity(this._len + 4);
                }
                IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.next());
                this._len += 4;
            }
            IOBuffer.putInt((long)this._addr, (int)serializedLengthPos, (int)(this._len - (serializedLengthPos + 4)));
            return this;
        }

        public final Serializer someNumbers(XIntSequence val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer someNumbers(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)24);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer extras(OptionalExtras[] val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + 4 * val.length);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)32);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)(4 * val.length));
            this._len += 4;
            for (int i = 0; i < val.length; ++i) {
                IOBuffer.putInt((long)this._addr, (int)this._len, (int)val[i].val);
                this._len += 4;
            }
            return this;
        }

        public final Serializer extras(ExtrasDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)32);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer extras(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)32);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Engine.Serializer engine() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)40);
            this._len += 2;
            this._mark = this._len;
            this._len += 4;
            if (this.hasSizer()) {
                this._engineSerializer.setSizer(this);
            }
            return this._engineSerializer.init(this._addr, this._len, (IQuarkChildSerializationCompletionCallback)this);
        }

        public final Serializer engine(Engine.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.getSerializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)40);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer engine(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)40);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer engine(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (addr == 0L && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)40);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            if (addr != 0L) {
                IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            }
            this._len += len;
            return this;
        }

        public final FuelFigure.Serializer fuelFigure() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            this._mark = this._len;
            this._len += 4;
            if (this.hasSizer()) {
                this._fuelFigureSerializer.setSizer(this);
            }
            return this._fuelFigureSerializer.init(this._addr, this._len, (IQuarkChildSerializationCompletionCallback)this);
        }

        public final Serializer fuelFigure(FuelFigure.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.getSerializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer fuelFigure(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer fuelFigure(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (addr == 0L && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)48);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            if (addr != 0L) {
                IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            }
            this._len += len;
            return this;
        }

        public final PerformanceFigure.Serializer performanceFigure() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)56);
            this._len += 2;
            this._mark = this._len;
            this._len += 4;
            if (this.hasSizer()) {
                this._performanceFigureSerializer.setSizer(this);
            }
            return this._performanceFigureSerializer.init(this._addr, this._len, (IQuarkChildSerializationCompletionCallback)this);
        }

        public final Serializer performanceFigure(PerformanceFigure.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.getSerializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)56);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer performanceFigure(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)56);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer performanceFigure(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (addr == 0L && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)56);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            if (addr != 0L) {
                IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            }
            this._len += len;
            return this;
        }

        public final Serializer manufacturer(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.length());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)64);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.length());
            this._len += 4;
            IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            this._len += val.length();
            return this;
        }

        public final Serializer manufacturer(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)64);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer manufacturer(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)64);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer manufacturer(byte[] val) {
            return this.manufacturer(val, 0, val.length);
        }

        public final Serializer manufacturer(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)64);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer manufacturer(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)64);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final Serializer model(String val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.length());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)72);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.length());
            this._len += 4;
            IOBuffer.putASCIICharSequence((long)this._addr, (int)this._len, (CharSequence)val);
            this._len += val.length();
            return this;
        }

        public final Serializer model(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null || val.isNull()) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)72);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer model(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)72);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            IOBuffer.putFrom((long)this._addr, (int)this._len, (byte[])val, (int)offset, (int)len);
            this._len += len;
            return this;
        }

        public final Serializer model(byte[] val) {
            return this.model(val, 0, val.length);
        }

        public final Serializer model(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + val.serializedLength());
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)72);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)val.serializedLength());
            this._len += 4;
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer model(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this._mark >= 0) {
                throw new IllegalStateException("child object serialization in progress");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + 6 + len);
            }
            IOBuffer.putShort((long)this._addr, (int)this._len, (short)72);
            this._len += 2;
            IOBuffer.putInt((long)this._addr, (int)this._len, (int)len);
            this._len += 4;
            val.getTo(offset, this._addr, this._len, len);
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            if (this._parent != null) {
                this._parent.childSerializeComplete(this._len);
                this._parent = null;
            }
            this._mark = -1;
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntitySerializerDisposed(CarData.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final void childSerializeComplete(int len) {
            if (this._mark < 0) {
                throw new IllegalStateException("child object serialization in not in progress");
            }
            IOBuffer.putInt((long)this._addr, (int)this._mark, (int)(len - this._len));
            this._len = len;
            this._mark = -1;
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    public static final class Block2Serializer {
        private long _addr;
        private int _offset;

        private Block2Serializer() {
        }

        public static final Block2Serializer create() {
            return new Block2Serializer();
        }

        final Block2Serializer init(long addr, int offset) {
            this._addr = addr;
            this._offset = offset;
            return this;
        }

        public final Block2Serializer init(IOBuffer buffer, int offset) {
            return this.init(buffer.getNativeAddress(), offset);
        }

        public final Block2Serializer init(IOBuffer buffer) {
            return this.init(buffer, 0);
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final void putFrom(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            buffer.getTo(offset, this._addr, this._offset, 28);
        }

        public final Block2Serializer serialNumber(int val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.putInt((long)this._addr, (int)(this._offset + 0), (int)val);
            return this;
        }

        public final Block2Serializer modelYear(short val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.putShort((long)this._addr, (int)(this._offset + 4), (short)val);
            return this;
        }

        public final Block2Serializer available(BooleanType val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.putInt((long)this._addr, (int)(this._offset + 6), (int)(val != null ? val.val : -1));
            return this;
        }

        public final Block2Serializer code(Code val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.putInt((long)this._addr, (int)(this._offset + 10), (int)(val != null ? val.val : -1));
            return this;
        }

        public final Block2Serializer vehicleCode(XString val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val.isNull()) {
                return this;
            }
            if (val.length() != 6) {
                throw new IllegalStateException("length must be 6");
            }
            val.getTo(this._addr, this._offset + 14);
            return this;
        }

        public final Block2Serializer vehicleCode(byte[] val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (len != 6) {
                throw new IllegalStateException("length must be 6");
            }
            IOBuffer.putFrom((long)this._addr, (int)(this._offset + 14), (byte[])val, (int)offset, (int)len);
            return this;
        }

        public final Block2Serializer vehicleCode(byte[] val) {
            return this.vehicleCode(val, 0, val.length);
        }

        public final Block2Serializer vehicleCode(XStringDeserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val.serializedLength() != 6) {
                throw new IllegalStateException("length must be 6");
            }
            val.getTo(this._addr, this._offset + 14);
            return this;
        }

        public final Block2Serializer vehicleCode(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (len != 6) {
                throw new IllegalStateException("length must be 6");
            }
            val.getTo(offset, this._addr, this._offset + 14, len);
            return this;
        }

        public final Block2Serializer manufactureDate(long val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.putLong((long)this._addr, (int)(this._offset + 20), (long)val);
            return this;
        }

        public final Block2Serializer manufactureDate(Date val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.putLong((long)this._addr, (int)(this._offset + 20), (long)(val != null ? val.getTime() : -1L));
            return this;
        }

        public final void dispose() {
        }
    }

    private static final class CarDataDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private CarDataDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memstats.onEntityDeserializerLeaked(CarData.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class CarDataDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private CarDataDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class CarDataSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private CarDataSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memstats.onEntitySerializerLeaked(CarData.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class CarDataSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private CarDataSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class CarDataPojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private CarDataPojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            evictedItem.clear(true);
            _memstats.onEntityPojoLeaked(CarData.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class CarDataPojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private CarDataPojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class CarDataPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<CarData> {
        private CarDataPoolEvictedItemReceiver() {
        }

        public final void process(CarData evictedItem) {
            evictedItem.clear(false, true);
            _memstats.onEntityLeaked(CarData.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class CarDataPoolFactory
    implements UtlPool.Factory<CarData> {
        private CarDataPoolFactory() {
        }

        public final CarData createItem(Object object) {
            return new CarData();
        }

        public final CarData[] createItemArray(int size) {
            return new CarData[size];
        }
    }

    static final class CarDataPoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        CarDataPoolFactoryItemCreateArgument() {
        }

        CarDataPoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }
}

