/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.client.link.ClientLinkManager;
import com.neeve.client.link.EClientLinkNotManagedException;
import com.neeve.tools.interactive.commands.Command;
import java.util.Iterator;
import java.util.Set;

public final class Dependents
extends Command {
    private final ClientLinkManager linkManager;

    public Dependents(ClientLinkManager linkManager) {
        this.linkManager = linkManager;
    }

    private void processDependents(String name) {
        try {
            Set<String> dependents = this.linkManager.getDependents(name, false);
            if (dependents.size() > 0) {
                System.out.println("");
                Iterator<String> iterator = dependents.iterator();
                while (iterator.hasNext()) {
                    System.out.println("  " + iterator.next());
                }
            } else {
                System.out.printf("<No dependents>\n", new Object[0]);
            }
            System.out.printf("\n", new Object[0]);
        }
        catch (EClientLinkNotManagedException e) {
            System.out.println("Invalid link ['" + name + "'].");
        }
    }

    public final void run(String[] args) {
        if (args.length != 1) {
            System.out.println("Syntax error: dependents <name>");
        } else {
            this.processDependents(args[0]);
        }
    }

    public final void help() {
        System.out.println("dependents <name>");
        System.out.println("  List dependents of a link maintained by the link manager.");
    }

    public final String[] keywords() {
        return new String[]{"dependents"};
    }
}

