/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import cern.colt.function.ObjectProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.ObjectArrayList;
import com.neeve.aep.AepEngine;
import com.neeve.config.Config;
import com.neeve.daemon.config.IDmnConfigDescriptor;
import com.neeve.daemon.controller.DmnController;
import com.neeve.daemon.thread.DmnThreadManager;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.lang.XCollection;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCopyableNode;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogMessageLogger;
import com.neeve.rog.log.RogMessageLog;
import com.neeve.server.app.ISrvAppServerStopper;
import com.neeve.server.app.ISrvAppWatcher;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.SrvAppManager;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvControllerAdminApp;
import com.neeve.server.controller.SrvControllerAdminClient;
import com.neeve.server.controller.SrvControllerConfig;
import com.neeve.server.controller.SrvControllerDirectHeartbeatGenerator;
import com.neeve.server.controller.SrvControllerHeartbeatGenerator;
import com.neeve.server.controller.SrvControllerIndirectHeartbeatGenerator;
import com.neeve.server.link.SrvLinkInboundManager;
import com.neeve.server.mon.SrvMonAdminClientStats;
import com.neeve.server.mon.SrvMonAppBusBindingInfo;
import com.neeve.server.mon.SrvMonAppBusBindingState;
import com.neeve.server.mon.SrvMonAppBusChannelInfo;
import com.neeve.server.mon.SrvMonAppClientInfo;
import com.neeve.server.mon.SrvMonAppFlowInfo;
import com.neeve.server.mon.SrvMonAppHAPolicy;
import com.neeve.server.mon.SrvMonAppInfo;
import com.neeve.server.mon.SrvMonAppMessageLoggerStats;
import com.neeve.server.mon.SrvMonAppRole;
import com.neeve.server.mon.SrvMonAppState;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonHeartbeatFactory;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.SrvMonIntHistogram;
import com.neeve.server.mon.SrvMonIntSeries;
import com.neeve.server.mon.SrvMonLongHistogram;
import com.neeve.server.mon.SrvMonLongSeries;
import com.neeve.server.mon.SrvMonPoolStats;
import com.neeve.server.mon.SrvMonSysStats;
import com.neeve.server.mon.cnc.ISrvMonTrace;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsRequest;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsResponse;
import com.neeve.server.mon.cnc.SrvMonGetTraceHistoryRequest;
import com.neeve.server.mon.cnc.SrvMonGetTraceHistoryResponse;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonListCommandsRequest;
import com.neeve.server.mon.cnc.SrvMonReturnType;
import com.neeve.server.mon.cnc.SrvMonStartAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStartTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonStartTraceWatchResponse;
import com.neeve.server.mon.cnc.SrvMonStopAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStopTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonStopTraceWatchResponse;
import com.neeve.server.mon.cnc.SrvMonTrace;
import com.neeve.server.mon.cnc.SrvMonTraceLevel;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.cnc.SrvMonXvmInfoRequest;
import com.neeve.server.mon.cnc.SrvMonXvmInfoResponse;
import com.neeve.server.mon.common.ISrvMonEvent;
import com.neeve.server.mon.common.SrvMonXvmHeader;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingCreatedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDestroyedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpenFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpenedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpeningMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingStateChangeMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelUpMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppClientConnectMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppClientDisconnectMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineActiveMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStartedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStoppedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppFlowCreateMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppLoadedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStateChangeMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppUnloadedMessage;
import com.neeve.server.mon.util.SrvMonHeartbeatTracer;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.server.thread.SrvThreadManager;
import com.neeve.stats.IStats;
import com.neeve.trace.TraceHistoryHandler;
import com.neeve.trace.TraceLoggerFactory;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlNet;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlPoolRegistry;
import com.neeve.util.UtlProc;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.HdrHistogram.IntCountsHistogram;

public final class SrvController
extends DmnController
implements ISrvAppServerStopper {
    private final String DISCOVERY_CACHE_SERVER_ENTITY_TYPE = "Server";
    private final String DISCOVERY_CACHE_APP_ENTITY_TYPE = "Application";
    private static final Map<SrvConfigDescriptor, SrvController> controllers;
    private static final String HOSTNAME_NOT_AVAILABLE_STR = "???";
    private static final XString HOSTNAME_NOT_AVAILABLE;
    private static final String ADDRESS_NOT_AVAILABLE_STR = "";
    private static final XString ADDRESS_NOT_AVAILABLE;
    private final TraceWatcher traceWatcher;
    private final SrvThreadManager threadManager;
    private final SrvAppManager appManager;
    private final SrvLinkInboundManager linkInboundManager;
    private final Set<SrvControllerAdminClient> traceWatchers;
    private final Set<SrvControllerAdminClient> appWatchers;
    private final XLinkedHashMap<String, SrvMonAppInfo> appsInfo;
    private final IDiscoveryCache discoveryCache;
    private final Tracer packetTracer;
    private final SrvControllerHeartbeatGenerator heartbeatGenerator;
    private final RogMessageLog heartbeatLog;
    private final Tracer heartbeatTracer;
    private final SrvMonHeartbeatTracer heartbeatTracerFormatter;
    private final boolean smaTraceEnabled;
    private final boolean smaHeartbeatsEnabled;
    private final Tracer commandTracer;
    private final PoolWatcher poolWatcher;
    private final XString hostname;
    private final XString address;
    private final XString systemName;
    private final XString systemVersion;
    private final SrvMonXvmHeader xvmMessageHeader = SrvMonXvmHeader.create();
    private List<UtlAddressDescriptor> advertisementDescriptorSet;
    private ObjectArrayList pools;
    private Object bootstrapConfigurer;
    private volatile long loadTime;
    private ExecutorService commandExecutorService;
    private volatile SrvControllerAdminApp adminApp;
    private long traceRecordSequenceNumber = 0L;
    final SrvConfigDescriptor configDescriptor;

    private SrvController(SrvConfigDescriptor configDescriptor) {
        super(SrvControllerConfig.getConfig());
        this.traceWatcher = new TraceWatcher(configDescriptor.getMaxTraceHistory());
        if (configDescriptor.getAdmin().getSma().isEnabled()) {
            this.smaTraceEnabled = configDescriptor.getAdmin().getSma().getTraceChannel().isEnabled();
            this.smaHeartbeatsEnabled = configDescriptor.getAdmin().getSma().getHeartbeatChannel().isEnabled();
        } else {
            this.smaTraceEnabled = false;
            this.smaHeartbeatsEnabled = false;
        }
        this.tracer.log(configDescriptor.toString(), Tracer.Level.CONFIG);
        this.configDescriptor = configDescriptor;
        this.threadManager = SrvThreadManager.create(configDescriptor.getName());
        this.appManager = SrvAppManager.create(this.configDescriptor, this.threadManager, new AppWatcher(), this);
        this.linkInboundManager = SrvLinkInboundManager.create(this.configDescriptor, this.threadManager, this.appManager);
        this.traceWatchers = new HashSet<SrvControllerAdminClient>();
        this.appWatchers = new HashSet<SrvControllerAdminClient>();
        this.appsInfo = new XLinkedHashMap();
        String discoveryDescriptor = configDescriptor.getDiscoveryDescriptor();
        try {
            if (discoveryDescriptor == null) {
                this.discoveryCache = DiscoveryCacheFactory.getInstance().createCache(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR);
                this.tracer.log("Opened server discovery cache (default): '" + UtlAddressDescriptor.parse((String)DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR, null).toPasswordSanitizedFullString() + "'", Tracer.Level.INFO);
            } else {
                this.discoveryCache = DiscoveryCacheFactory.getInstance().createCache(discoveryDescriptor);
                this.tracer.log("Opened server discovery cache (configured): '" + UtlAddressDescriptor.parse((String)discoveryDescriptor, null).toPasswordSanitizedFullString() + "'", Tracer.Level.INFO);
            }
        }
        catch (EDiscoveryException e) {
            throw new RuntimeException("Unable to open server discovery cache '" + UtlAddressDescriptor.parse((String)discoveryDescriptor, null).toPasswordSanitizedFullString() + "'", e);
        }
        this.hostname = XString.create((String)UtlNet.getLocalHostNameForDisplay((String)HOSTNAME_NOT_AVAILABLE_STR));
        this.address = XString.create((String)UtlNet.getLocalHostAddressForDisplay((String)ADDRESS_NOT_AVAILABLE_STR));
        this.systemName = configDescriptor.getSystemName() != null ? XString.create((String)configDescriptor.getSystemName()) : null;
        this.systemVersion = configDescriptor.getSystemVersion() != null ? XString.create((String)configDescriptor.getSystemVersion()) : null;
        this.xvmMessageHeader.setXvmHeartbeatVersion(4);
        this.xvmMessageHeader.setXvmName(configDescriptor.getName());
        this.xvmMessageHeader.setSystemNameFrom(this.systemName);
        this.xvmMessageHeader.setSystemVersionFrom(this.systemVersion);
        this.xvmMessageHeader.sync();
        this.xvmMessageHeader.setAsReadOnly();
        this.packetTracer = Tracer.get((String)"nv.packet");
        Config.getRepository();
        if (configDescriptor.getHeartbeats().isEnabled()) {
            this.tracer.log("Heartbeats will be sent by this server every " + configDescriptor.getHeartbeats().getInterval() + " seconds using hostname " + this.hostname.getValue(), Tracer.Level.INFO);
            try {
                Properties props = (Properties)configDescriptor.getHeartbeatLoggingProperties().clone();
                if (UtlProps.getValue((Properties)props, (String)"enabled", (boolean)false)) {
                    StoreObjectFactoryRegistry.getInstance().registerIfNoConflict(SrvMonHeartbeatFactory.class.getName());
                    if (UtlProps.getValue((Properties)props, (String)"initialLogLength", null) == null) {
                        props.setProperty("initialLogLength", "0");
                    }
                    if (UtlProps.getValue((Properties)props, (String)"storeRoot", null) == null) {
                        props.setProperty("storeRoot", Config.getDataDirectory() + "/server-hearbeats/");
                    }
                    props.setProperty("autoRepair", "true");
                    this.heartbeatLog = RogMessageLog.create((String)(configDescriptor.getName() + "-heartbeats"), (Properties)props);
                    this.heartbeatLog.setErrorHandler(new IRogMessageLogger.ErrorHandler(){

                        public void onError(Throwable cause) {
                            SrvController.this.tracer.log("Error in hearbeat logger: " + UtlThrowable.prepareStackTrace((Throwable)cause) + " ... closing", Tracer.Level.SEVERE);
                            SrvController.this.closeHeartbeatLog();
                        }
                    });
                } else {
                    this.heartbeatLog = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error opening heartbeat log: " + e.getMessage(), e);
            }
            SrvMonHeartbeatTracer srvMonHeartbeatTracer = this.heartbeatTracerFormatter = configDescriptor.getHeartbeatTracing().isEnabled() ? new SrvMonHeartbeatTracer() : null;
            if (this.heartbeatTracerFormatter != null) {
                SrvConfigDescriptor.HeartbeatTracing tracingConfig = configDescriptor.getHeartbeatTracing();
                this.heartbeatTracerFormatter.setTraceAdminClientStats(tracingConfig.isTraceAdminClientStats());
                this.heartbeatTracerFormatter.setTraceAppStats(tracingConfig.isTraceAppStats());
                this.heartbeatTracerFormatter.setTracePoolStats(tracingConfig.isTracePoolStats());
                this.heartbeatTracerFormatter.setTraceSysStats(tracingConfig.isTraceSysStats());
                this.heartbeatTracerFormatter.setTraceThreadStats(tracingConfig.isTraceThreadStats());
                this.heartbeatTracerFormatter.setTraceUserStats(tracingConfig.isTraceUserStats());
                this.heartbeatTracer = Tracer.get((String)"nv.server.heartbeat");
            } else {
                this.heartbeatTracer = null;
            }
            this.heartbeatGenerator = Config.getValue((String)"nv.server.heartbeats.useLegacyGenerator", (boolean)false) ? new SrvControllerIndirectHeartbeatGenerator(this) : new SrvControllerDirectHeartbeatGenerator(this);
        } else {
            this.heartbeatLog = null;
            this.heartbeatTracerFormatter = null;
            this.heartbeatTracer = null;
            this.heartbeatGenerator = null;
        }
        this.commandTracer = Tracer.get((String)"nv.server.commmand");
        this.poolWatcher = new PoolWatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SrvController getInstance(SrvConfigDescriptor configDescriptor) {
        SrvController controller;
        Map<SrvConfigDescriptor, SrvController> map = controllers;
        synchronized (map) {
            controller = controllers.get(configDescriptor);
            if (controller == null) {
                controller = new SrvController(configDescriptor);
                controllers.put(configDescriptor, controller);
            }
        }
        return controller;
    }

    private final void openHeartbeatLog() throws Exception {
        if (this.heartbeatLog != null) {
            this.tracer.log("Opening heartbeat log...", Tracer.Level.INFO);
            this.heartbeatLog.open();
        }
    }

    private final void closeHeartbeatLog() {
        if (this.heartbeatLog != null && this.heartbeatLog.isOpen()) {
            try {
                this.tracer.log("Closing heartbeat log...", Tracer.Level.INFO);
                this.heartbeatLog.flush(true);
                this.heartbeatLog.close();
            }
            catch (Throwable thrown) {
                this.tracer.log("Error closing heartbeat log: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            }
        }
    }

    private final <T extends ISrvMonTrace> T populateTraceRecord(LogRecord record, T admTraceRecord) {
        admTraceRecord.setProcessId(UtlProc.getPid());
        if (!this.address.equals((Object)ADDRESS_NOT_AVAILABLE)) {
            admTraceRecord.setHostAddressFrom(this.address);
        }
        if (!this.hostname.equals((Object)HOSTNAME_NOT_AVAILABLE)) {
            admTraceRecord.setHostNameFrom(this.hostname);
        }
        admTraceRecord.setXvmName(this.configDescriptor.getName());
        admTraceRecord.setTrace(record.getMessage());
        admTraceRecord.setTimestamp(record.getMillis());
        admTraceRecord.setThreadId(record.getThreadID());
        admTraceRecord.setTracerName(record.getLoggerName());
        Level level = record.getLevel();
        if (level == Level.OFF) {
            admTraceRecord.setLevel(SrvMonTraceLevel.OFF);
        } else if (level == Level.SEVERE) {
            admTraceRecord.setLevel(SrvMonTraceLevel.SEVERE);
        } else if (level == Level.WARNING) {
            admTraceRecord.setLevel(SrvMonTraceLevel.WARNING);
        } else if (level == Level.INFO) {
            admTraceRecord.setLevel(SrvMonTraceLevel.INFO);
        } else if (level == Level.CONFIG) {
            admTraceRecord.setLevel(SrvMonTraceLevel.CONFIG);
        } else if (level == Level.FINE) {
            admTraceRecord.setLevel(SrvMonTraceLevel.FINE);
        } else if (level == Level.FINER) {
            admTraceRecord.setLevel(SrvMonTraceLevel.FINER);
        } else if (level == Level.FINEST) {
            admTraceRecord.setLevel(SrvMonTraceLevel.FINEST);
        } else if (level == Level.ALL) {
            admTraceRecord.setLevel(SrvMonTraceLevel.ALL);
        } else {
            admTraceRecord.setLevel(SrvMonTraceLevel.UNKNOWN);
        }
        return admTraceRecord;
    }

    private final SrvMonAppInfo createMonApp(SrvAppLoader loader) {
        SrvMonAppInfo appInfo = SrvMonAppInfo.create();
        appInfo.setName(loader.getAppName());
        appInfo.setVersion(loader.getAppVersion());
        appInfo.setJarVersionString(loader.getAppJarVersion());
        appInfo.setState(SrvMonAppState.Loaded);
        return appInfo;
    }

    final Tracer tracer() {
        return this.tracer;
    }

    final Tracer getPacketTracer() {
        return this.packetTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onTrace(LogRecord record) {
        if (this.traceWatchers != null) {
            SrvMonTraceRecord traceRecord;
            Set<SrvControllerAdminClient> set = this.traceWatchers;
            synchronized (set) {
                SrvControllerAdminApp adminApp = this.adminApp;
                if (this.smaTraceEnabled && adminApp != null || !this.traceWatchers.isEmpty()) {
                    traceRecord = this.populateTraceRecord(record, SrvMonTraceRecord.create());
                    traceRecord.setTraceSeqNo(this.traceRecordSequenceNumber++);
                    traceRecord.lendXvmHeader(this.xvmMessageHeader);
                } else {
                    traceRecord = null;
                }
                for (SrvControllerAdminClient client : this.traceWatchers) {
                    client.publishTraceRecord(traceRecord.copy());
                }
            }
            if (this.smaTraceEnabled && this.adminApp != null) {
                this.adminApp.publishTraceRecord(traceRecord);
            } else if (traceRecord != null) {
                traceRecord.dispose();
            }
        }
    }

    final SrvMonXvmHeader getXvmMessageHeader() {
        return this.xvmMessageHeader;
    }

    final Map<String, SrvMonAppInfo> getAppsInfo() {
        return this.appsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onPoolAdded(UtlPool<?> pool) {
        ObjectArrayList objectArrayList = this.pools;
        synchronized (objectArrayList) {
            this.pools.add(pool);
        }
        if (this.heartbeatGenerator != null) {
            this.heartbeatGenerator.onPoolAdded(pool);
        }
        if (this.tracer.debug) {
            this.tracer.log("[POOL ACTIVATE] {type='" + pool.type() + "', name='" + pool.name() + "'}", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onPoolRemoved(UtlPool<?> pool) {
        ObjectArrayList objectArrayList = this.pools;
        synchronized (objectArrayList) {
            this.pools.delete(pool, false);
        }
        if (this.heartbeatGenerator != null) {
            this.heartbeatGenerator.onPoolRemoved(pool);
        }
        if (this.tracer.debug) {
            this.tracer.log("[POOL DEACTIVATE] {type='" + pool.type() + "', name='" + pool.name() + "'}", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppLoaded(SrvAppLoader loader) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = this.createMonApp(loader);
            appInfo.setLoadedTimeAsTimestamp(System.currentTimeMillis());
            this.appsInfo.put((Object)loader.getAppName(), (Object)appInfo);
            SrvMonAppLoadedMessage message = SrvMonAppLoadedMessage.create();
            message.setAppInfo(appInfo.copy());
            message.setEventTimestampAsTimestamp(appInfo.getLoadedTimeAsTimestamp());
            message.setEventSource("xvm");
            this.dispatchLifecycleEvent(message);
        }
    }

    final void onAppInitialized(SrvAppLoader loader, long timestamp) {
        if (this.heartbeatGenerator != null) {
            this.heartbeatGenerator.onAppInitialized(loader);
        }
        this.onAppStateChange(loader.getAppName(), timestamp, SrvMonAppState.Initialized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppStateChange(String appName, long timestamp, SrvMonAppState newState) {
        SrvAppLoader loader;
        if (newState == SrvMonAppState.Active) {
            if (this.advertisementDescriptorSet.size() > 0) {
                this.discoveryCache.add("Application", appName, this.advertisementDescriptorSet);
            }
        } else if (newState == SrvMonAppState.Stopped) {
            if (this.adminApp != null && "admin".equalsIgnoreCase(appName)) {
                this.adminApp = null;
            }
            if (!this.discoveryCache.closed()) {
                this.discoveryCache.remove("Application", appName);
            }
        }
        SrvMonAppRole role = null;
        SrvMonAppHAPolicy haPolicy = null;
        if (this.appManager.isStarted() && (loader = this.appManager.getAppLoader(appName)) != null) {
            role = SrvMonAppRole.Standalone;
            AepEngine engine = loader.getAppEngine();
            if (engine != null) {
                IStoreBinding binding = engine.getStore();
                if (binding != null && binding.getState() != IStoreBinding.State.Closed) {
                    try {
                        switch (binding.getRole()) {
                            case Backup: {
                                role = SrvMonAppRole.Backup;
                                break;
                            }
                            case Primary: {
                                role = SrvMonAppRole.Primary;
                                break;
                            }
                        }
                    }
                    catch (Throwable thrown) {
                        this.tracer.log("Error fetching app store binding state: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
                    }
                }
                if (this.adminApp == null && "admin".equalsIgnoreCase(loader.getAppName()) && newState == SrvMonAppState.Started) {
                    this.adminApp = (SrvControllerAdminApp)((Object)loader.getAppMain());
                }
                switch (loader.getAppEngine().getHAPolicy()) {
                    case EventSourcing: {
                        haPolicy = SrvMonAppHAPolicy.EventSourcing;
                        break;
                    }
                    case StateReplication: {
                        haPolicy = SrvMonAppHAPolicy.StateReplication;
                        break;
                    }
                }
            }
        }
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            appInfo.setState(newState);
            appInfo.setRole(role);
            appInfo.setHAPolicy(haPolicy);
            SrvMonAppStateChangeMessage message = SrvMonAppStateChangeMessage.create();
            message.setEventSource(appInfo.getName());
            message.setEventTimestampAsTimestamp(timestamp);
            message.setAppState(appInfo.getState());
            this.dispatchLifecycleEvent(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppBusBindingCreated(SrvMonAppBusBindingCreatedMessage message) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)message.getEventSource());
            SrvMonAppBusBindingInfo busBindingInfo = (SrvMonAppBusBindingInfo)message.getBusBindingInfo().clone();
            if (SrvMonUtil.addMonAppBusBindingInfo(appInfo, busBindingInfo)) {
                this.dispatchLifecycleEvent(message.copy());
            } else {
                this.tracer.log("App '" + message.getEventSource() + "' has exceeded the monitoring storage quota for bus bindings. Some app bus bindings will not be reported in a app watcher monitoring stream.", Tracer.Level.WARNING);
                busBindingInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppBusBindingStateChange(String appName, String busBindingName, SrvMonAppBusBindingState newState) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            if (SrvMonUtil.updateMonAppBusBindingState(appInfo, busBindingName, newState)) {
                SrvMonAppBusBindingStateChangeMessage message = SrvMonAppBusBindingStateChangeMessage.create();
                message.setEventSource(appName);
                message.setBusBindingName(busBindingName);
                message.setBusBindingState(newState);
                this.dispatchLifecycleEvent(message);
            } else {
                this.tracer.log("New state ('" + (Object)((Object)newState) + "') reported for binding to bus '" + busBindingName + "' in app '" + appName + "' but no bus with that name exists for that app!", Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppBusBindingDestroyed(SrvMonAppBusBindingDestroyedMessage message) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)message.getEventSource());
            if (SrvMonUtil.removeMonAppBusBindingInfo(appInfo, message.getBusBindingName())) {
                this.dispatchLifecycleEvent(message.copy());
            } else {
                this.tracer.log("Binding to bus '" + message.getBusBindingName() + "' in app '" + message.getEventSource() + "' was reported as destroyed but no bus with that name exists for that app!", Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppChannelUp(SrvMonAppChannelUpMessage message) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)message.getEventSource());
            SrvMonAppBusChannelInfo busChannelInfo = SrvMonUtil.createMonAppBusChannelInfo(message.getChannelName(), message.getIsJoined());
            if (SrvMonUtil.addMonAppBusChannelInfo(appInfo, message.getBusBindingName(), busChannelInfo)) {
                this.dispatchLifecycleEvent(message.copy());
            } else {
                this.tracer.log("App '" + message.getChannelName() + "' has exceeded the monitoring storage quota for channels in bus '" + message.getBusBindingName() + "'. Some app channels will not be reported in a app watcher monitoring stream.", Tracer.Level.WARNING);
                busChannelInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppChannelDown(SrvMonAppChannelDownMessage message) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)message.getEventSource());
            if (appInfo != null) {
                if (SrvMonUtil.removeMonAppBusChannelInfo(appInfo, message.getBusBindingName(), message.getChannelName())) {
                    this.dispatchLifecycleEvent(message.copy());
                } else {
                    this.tracer.log("Received a channel closed event for a non-existent channel (app=" + message.getEventSource() + ", bus=" + message.getBusBindingName() + ", channel=" + message.getChannelName() + ")!", Tracer.Level.WARNING);
                }
            } else {
                this.tracer.log("Received a closed channel event for a non-existent app '" + message.getEventSource() + "'!", Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppClientConnected(String appName, String clientName) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            SrvMonAppClientInfo clientInfo = SrvMonUtil.createMonAppClientInfo(clientName);
            if (SrvMonUtil.addMonAppClientInfo(appInfo, clientInfo)) {
                SrvMonAppClientConnectMessage message = SrvMonAppClientConnectMessage.create();
                message.setEventSource(appName);
                message.lendClientInfo(clientInfo);
                this.dispatchLifecycleEvent(message);
            } else {
                this.tracer.log("App '" + appName + "' has exceeded the monitoring storage quota for clients. Some app clients will not be reported in a app watcher monitoring stream.", Tracer.Level.WARNING);
                clientInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppClientDisconnected(String appName, String clientName) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            if (SrvMonUtil.removeMonAppClientInfo(appInfo, clientName)) {
                SrvMonAppClientDisconnectMessage message = SrvMonAppClientDisconnectMessage.create();
                message.setEventSource(appName);
                message.setClientName(clientName);
                this.dispatchLifecycleEvent(message);
            } else {
                this.tracer.log("Received a disconnected client event for a non-existent client (app=" + appInfo.getName() + ", client=" + clientName + ")!", Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppFlowCreated(String appName, long timestamp, int flowid) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            SrvMonAppFlowInfo flowInfo = SrvMonUtil.createMonAppFlowInfo(flowid);
            if (SrvMonUtil.addMonAppFlowInfo(appInfo, flowInfo)) {
                SrvMonAppFlowCreateMessage message = SrvMonAppFlowCreateMessage.create();
                message.setEventSource(appName);
                message.setEventTimestampAsTimestamp(timestamp);
                message.lendFlowInfo(flowInfo);
                this.dispatchLifecycleEvent(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppUnloaded(String appName, long timestamp) {
        this.onAppStateChange(appName, timestamp, SrvMonAppState.Unloaded);
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.remove((Object)appName);
            if (appInfo != null) {
                SrvMonAppUnloadedMessage message = SrvMonAppUnloadedMessage.create();
                message.setEventSource(appName);
                message.setEventTimestampAsTimestamp(timestamp);
                this.dispatchLifecycleEvent(message);
            }
            if (this.heartbeatGenerator != null) {
                this.heartbeatGenerator.onAppUnloaded(appName);
            }
            if (this.adminApp != null && "admin".equalsIgnoreCase(appName)) {
                this.adminApp = null;
            }
        }
    }

    final void onClientConnect(SrvControllerAdminApp.AdminClientContext client) {
        if (this.heartbeatGenerator != null) {
            this.heartbeatGenerator.onAdminClientConnected(client);
        }
    }

    final void onSrvMonListCommandsRequest(SrvControllerAdminApp.AdminClientContext client, SrvMonListCommandsRequest command) throws Exception {
        client.sendResponse(command, this.appManager.issueGetCommands(command));
    }

    final void onSrvMonXvmInfoRequest(SrvControllerAdminApp.AdminClientContext client, SrvMonXvmInfoRequest command) {
        SrvMonXvmInfoResponse response = SrvMonXvmInfoResponse.create();
        response.lendXvmHeader(this.xvmMessageHeader);
        response.setSystemNameFrom(this.systemName);
        response.setSystemVersionFrom(this.systemVersion);
        response.setXvmAdminVersion("5");
        client.sendResponse(command, response);
    }

    final void onSrvMonStartTraceWatchRequest(SrvControllerAdminClient client, SrvMonStartTraceWatchRequest command) {
        this.onTraceWatchStart(client);
        client.sendResponse(command, SrvMonStartTraceWatchResponse.create());
    }

    final void onSrvMonStopTraceWatchRequest(SrvControllerAdminClient client, SrvMonStopTraceWatchRequest command) {
        this.onTraceWatchStop(client);
        client.sendResponse(command, SrvMonStopTraceWatchResponse.create());
    }

    final void onSrvMonStartAppWatchCommand(SrvControllerAdminClient client, SrvMonStartAppWatchCommand command) {
        this.onAppWatchStart(client);
    }

    final void onSrvMonStopAppWatchCommand(SrvControllerAdminClient client, SrvMonStopAppWatchCommand command) {
        this.onAppWatchStop(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSrvMonGetLoadedAppsRequest(SrvControllerAdminApp.AdminClientContext client, SrvMonGetLoadedAppsRequest command) {
        SrvMonGetLoadedAppsResponse response = SrvMonGetLoadedAppsResponse.create();
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            for (SrvMonAppInfo appInfo : this.appsInfo.values()) {
                response.addLoadedApps(appInfo.copy());
            }
            client.sendResponse(command, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSrvMonGetTraceHistoryRequest(SrvControllerAdminApp.AdminClientContext client, SrvMonGetTraceHistoryRequest command) {
        SrvMonGetTraceHistoryResponse response = SrvMonGetTraceHistoryResponse.create();
        Object object = this.traceWatcher.history().getHistoryLock();
        synchronized (object) {
            for (LogRecord record : this.traceWatcher.history()) {
                response.addTraceRecords(this.populateTraceRecord(record, SrvMonTrace.create()));
            }
            response.setTraceSeqNo(this.traceRecordSequenceNumber);
            client.sendResponse(command, response);
        }
    }

    final void onSrvMonInvokeCommandRequest(final SrvControllerAdminApp.AdminClientContext client, final SrvMonInvokeCommandRequest invokeRequest) throws Exception {
        String appName;
        if (this.tracer.isEnabled(Tracer.Level.VERBOSE)) {
            this.tracer.log("Invoking admin command '" + invokeRequest.getCommandName() + "' [target=" + invokeRequest.getTarget() + ", args=" + Arrays.asList(invokeRequest.getParametersEmptyIfNull()) + "]", Tracer.Level.VERBOSE);
        }
        if ((appName = invokeRequest.getTarget()) == null) {
            throw new Exception("appName must be set for invoke command request");
        }
        final String commandName = invokeRequest.getCommandName();
        if (commandName == null) {
            throw new Exception("command must be set for invoke command request");
        }
        if ("server".equals(appName)) {
            appName = "admin";
        }
        final String[] parameters = invokeRequest.getParametersEmptyIfNull();
        if (appName.equals("admin")) {
            if (commandName.compareToIgnoreCase("app_ping") == 0) {
                if (parameters.length == 1) {
                    boolean loaded = this.appManager.isAppLoaded(parameters[0]);
                    SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
                    response.setReturnType(SrvMonReturnType.BOOLEAN);
                    response.setBooleanReturnValue(loaded);
                    client.sendResponse(invokeRequest, response);
                    return;
                }
                throw new Exception("command syntax error: app_ping <appName>");
            }
            if (commandName.compareToIgnoreCase("get_admin_compat_level") == 0) {
                SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
                this.appManager.issueAppCommandUnsafe("admin", commandName, parameters, response);
                client.sendResponse(invokeRequest, response);
                return;
            }
        }
        if (this.commandTracer.isEnabled(Tracer.Level.INFO)) {
            this.commandTracer.log("Admin Client '" + client.getClientName(invokeRequest) + "' is invoking '" + invokeRequest.getCommandName() + "' on '" + invokeRequest.getTarget() + "' with parameters " + Arrays.asList(invokeRequest.getParametersEmptyIfNull()), Tracer.Level.INFO);
        }
        if (this.commandExecutorService != null) {
            final String fixedAppName = appName;
            final PktPacket requestPacket = (PktPacket)invokeRequest.getAttachment();
            if (requestPacket != null) {
                requestPacket.acquire();
            }
            invokeRequest.acquire();
            this.commandExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
                    try {
                        SrvController.this.appManager.issueAppCommandUnsafe(fixedAppName, commandName, parameters, response);
                        client.sendResponse(invokeRequest, response);
                    }
                    catch (Exception e) {
                        client.sendErrorResponse(invokeRequest, e);
                    }
                    finally {
                        invokeRequest.dispose();
                        if (requestPacket != null) {
                            requestPacket.dispose();
                        }
                    }
                }
            });
        } else {
            SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
            try {
                this.appManager.issueAppCommandUnsafe(appName, commandName, parameters, response);
                client.sendResponse(invokeRequest, response);
            }
            catch (Exception e) {
                client.sendErrorResponse(invokeRequest, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onTraceWatchStart(SrvControllerAdminClient client) {
        this.tracer.log("Client '" + client.getName() + "' has started a trace watch", Tracer.Level.INFO);
        SrvControllerAdminClient srvControllerAdminClient = client;
        synchronized (srvControllerAdminClient) {
            Object object = this.traceWatcher.history().getHistoryLock();
            synchronized (object) {
                Set<SrvControllerAdminClient> set = this.traceWatchers;
                synchronized (set) {
                    this.traceWatchers.add(client);
                }
                for (LogRecord record : this.traceWatcher.history()) {
                    SrvMonTraceRecord traceRecord = this.populateTraceRecord(record, SrvMonTraceRecord.create());
                    traceRecord.lendXvmHeader(this.getXvmMessageHeader());
                    client.publishTraceRecord(traceRecord);
                }
                client.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onTraceWatchStop(SrvControllerAdminClient client) {
        this.tracer.log("Client '" + client.getName() + "' has stopped a trace watch", Tracer.Level.INFO);
        Set<SrvControllerAdminClient> set = this.traceWatchers;
        synchronized (set) {
            this.traceWatchers.remove(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppWatchStart(SrvControllerAdminClient client) {
        this.tracer.log("Client '" + client.getName() + "' has started a app watch", Tracer.Level.INFO);
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            Set<SrvControllerAdminClient> set = this.appWatchers;
            synchronized (set) {
                this.appWatchers.add(client);
                for (SrvMonAppInfo appInfo : this.appsInfo.values()) {
                    SrvMonAppLoadedMessage message = SrvMonAppLoadedMessage.create();
                    message.lendXvmHeader(this.xvmMessageHeader);
                    message.setEventSource("xvm");
                    message.setEventTimestampAsTimestamp(appInfo.getLoadedTimeAsTimestamp());
                    message.setAppInfo(appInfo.copy());
                    client.publishEvent(message, false, false);
                }
                client.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppWatchStop(SrvControllerAdminClient client) {
        this.tracer.log("Client '" + client.getName() + "' has stopped a app watch", Tracer.Level.INFO);
        Set<SrvControllerAdminClient> set = this.appWatchers;
        synchronized (set) {
            this.appWatchers.remove(client);
        }
    }

    final void onClientDisconnect(SrvControllerAdminApp.AdminClientContext client) {
        if (client instanceof SrvControllerAdminClient) {
            this.onTraceWatchStop((SrvControllerAdminClient)client);
            this.onAppWatchStop((SrvControllerAdminClient)client);
        }
        if (this.heartbeatGenerator != null) {
            this.heartbeatGenerator.onAdminClientDisconnected(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <MessageType extends IRogMessage & IRogCopyableNode<? extends IRogMessage>> void dispatchLifecycleEvent(MessageType message) {
        ((ISrvMonEvent)message).lendXvmHeader(this.xvmMessageHeader);
        Set<SrvControllerAdminClient> set = this.appWatchers;
        synchronized (set) {
            for (SrvControllerAdminClient client : this.appWatchers) {
                client.publishEvent((IRogMessage)((IRogCopyableNode<? extends IRogMessage>)message).copy(), true, false);
            }
        }
        SrvControllerAdminApp adminApp = this.adminApp;
        if (adminApp != null) {
            adminApp.publishEvent(message);
        } else {
            message.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SrvMonHeartbeatMessage prepareHeartbeat(long statsCollectionStartWallTime, long statsCollectionStartTime, long statsCollectionEndTime, SrvMonSysStats sysStats, XIndexedList<SrvMonPoolStats> poolStats, XIndexedList<SrvMonAdminClientStats> adminClientStats, XIndexedList<SrvMonAppStats> appsStats, SrvMonAppMessageLoggerStats heartbeatLoggerStats) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            XIterator appsInfoIt = this.appsInfo.reuseableValueIterator();
            while (appsInfoIt.hasNext()) {
                ((SrvMonAppInfo)appsInfoIt.next()).acquire();
            }
            SrvMonHeartbeatMessage message = SrvMonUtil.prepareMonHeartbeatMessage(statsCollectionStartWallTime, statsCollectionStartTime, statsCollectionStartTime, this.getConfigDescriptor().getName(), sysStats, poolStats, adminClientStats, (XCollection<SrvMonAppInfo>)this.appsInfo.values(), appsStats);
            message.setHeartbeatLoggerStats(heartbeatLoggerStats);
            message.setSystemNameFrom(this.systemName);
            message.setSystemVersionFrom(this.systemVersion);
            message.lendXvmHeader(this.xvmMessageHeader);
            message.setLoadedTimeAsTimestamp(this.loadTime);
            message.setServerHostNameFrom(this.hostname);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void completeHeartbeat(long statsCollectionStartWallTime, long statsCollectionStartTime, long statsCollectionEndTime, SrvMonHeartbeatMessage.Serializer heartbeatMessageSerializer) {
        heartbeatMessageSerializer.xvmHeader(this.xvmMessageHeader).collectionStartWallTime(statsCollectionStartWallTime).collectionStartTime(statsCollectionStartTime).collectionEndTime(statsCollectionEndTime).serverName(this.getConfigDescriptor().getName()).serverHostName(this.hostname).serverPid(UtlProc.getPid()).loadedTime(this.loadTime).systemName(this.systemName).systemVersion(this.systemVersion);
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            XIterator appsInfoIterator = this.appsInfo.reuseableValueIterator();
            while (appsInfoIterator.hasNext()) {
                heartbeatMessageSerializer.appsInfo((SrvMonAppInfo)appsInfoIterator.next());
            }
        }
        heartbeatMessageSerializer.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processHeartbeat(SrvMonHeartbeatMessage message) {
        block27: {
            try {
                StringBuilder sb;
                SrvControllerAdminApp adminApp;
                Set<SrvControllerAdminClient> set = this.appWatchers;
                synchronized (set) {
                    for (SrvControllerAdminClient client : this.appWatchers) {
                        try {
                            client.publishHeartbeat(message.copy());
                        }
                        catch (Throwable e) {
                            StringBuilder sb2 = new StringBuilder();
                            sb2.append("Heartbeat message enque to watching client faulted with error [" + e.toString() + "].\n");
                            sb2.append("Stack trace:\n");
                            sb2.append(UtlThrowable.prepareStackTrace((Throwable)e));
                            this.tracer.log(sb2.toString(), Tracer.Level.WARNING);
                        }
                    }
                }
                if (this.smaHeartbeatsEnabled && (adminApp = this.adminApp) != null) {
                    SrvMonHeartbeatMessage toPublish = message.copy();
                    try {
                        adminApp.publishHeartbeat(toPublish);
                    }
                    catch (Exception e) {
                        sb = new StringBuilder();
                        sb.append("Heartbeat message publish over SMA faulted with error [" + e.toString() + "].\n");
                        sb.append("Stack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                }
                if (this.heartbeatTracerFormatter != null) {
                    StringBuilder sb3 = new StringBuilder();
                    try {
                        this.heartbeatTracerFormatter.printStats(message, sb3);
                        this.heartbeatTracer.log(sb3.toString(), Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        this.heartbeatTracer.log("Error in heartbeat tracer: " + UtlThrowable.prepareStackTrace((Throwable)e) + " ... closing", Tracer.Level.SEVERE);
                    }
                }
                if (this.heartbeatLog != null && this.heartbeatLog.isOpen()) {
                    SrvMonHeartbeatMessage toLog = message.copy();
                    try {
                        this.heartbeatLog.log((IRogMessage)toLog, false, true);
                        this.heartbeatLog.flush(false);
                        toLog.dispose();
                    }
                    catch (Exception e) {
                        this.tracer.log("Error in hearbeat logger: " + UtlThrowable.prepareStackTrace((Throwable)e) + " ... closing", Tracer.Level.SEVERE);
                        this.closeHeartbeatLog();
                    }
                }
                if (!this.appManager.isStarted()) break block27;
                set = this.appsInfo;
                synchronized (set) {
                    XIterator appsInfos = this.appsInfo.reuseableValueIterator();
                    while (appsInfos.hasNext()) {
                        try {
                            SrvMonAppInfo appInfo = (SrvMonAppInfo)appsInfos.next();
                            switch (appInfo.getState()) {
                                case Active: 
                                case Loaded: 
                                case Started: {
                                    this.appManager.dispatchEventToApp(appInfo.getName(), message);
                                    break;
                                }
                            }
                        }
                        catch (Throwable e) {
                            sb = new StringBuilder();
                            sb.append("Heartbeat message dispatch faulted with error [" + e.toString() + "].\n");
                            sb.append("Stack trace:\n");
                            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                            this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                        }
                    }
                }
            }
            finally {
                message.dispose();
            }
        }
    }

    public final void setBootstrapConfigurer(Object configurer) {
        this.bootstrapConfigurer = configurer;
    }

    public final Object getBootstrapConfigurer() {
        return this.bootstrapConfigurer;
    }

    public final boolean isHeartbeatLogConfigured() {
        return this.heartbeatLog != null;
    }

    public final boolean isHeartbeatLogOpen() {
        return this.isHeartbeatLogConfigured() && this.heartbeatLog.isOpen();
    }

    public final IRogMessageLogger.Stats getHeartbeatLogStats() {
        if (!this.isHeartbeatLogConfigured()) {
            throw new IllegalStateException("heartbeat logging is not configured");
        }
        return this.heartbeatLog.getStats();
    }

    public final SrvAppManager getAppManager() {
        return this.appManager;
    }

    @Override
    protected final IDmnConfigDescriptor getConfigDescriptor() {
        return this.configDescriptor;
    }

    @Override
    protected final DmnThreadManager getThreadManager() {
        return this.threadManager;
    }

    @Override
    protected final void doInit() throws Exception {
        if (this.heartbeatGenerator != null) {
            this.openHeartbeatLog();
        }
    }

    @Override
    protected final void doStart() throws Exception {
        if (Config.getValue((String)"nv.server.backgroundcommandinvocation", (boolean)true)) {
            this.commandExecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "X-Server-CommandExecutor");
                    thread.setDaemon(false);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable throwable) {
                            SrvController.this.tracer.log("Uncaught exception in command executor thread: " + UtlThrowable.prepareStackTrace((Throwable)throwable), Tracer.Level.WARNING);
                        }
                    });
                    return thread;
                }
            });
        }
        this.tracer.log("Starting the pool watch...", Tracer.Level.INFO);
        this.pools = UtlPoolRegistry.getInstance().getValues((UtlPoolRegistry.EventHandler)this.poolWatcher);
        this.pools.forEach(new ObjectProcedure(){

            public final boolean apply(Object element) {
                UtlPool pool = (UtlPool)element;
                if (((SrvController)SrvController.this).tracer.debug) {
                    SrvController.this.tracer.log("[POOL ACTIVATE*] {type='" + pool.type() + "', name='" + pool.name() + "'}", Tracer.Level.DEBUG);
                }
                if (SrvController.this.heartbeatGenerator != null) {
                    SrvController.this.heartbeatGenerator.onPoolAdded(pool);
                }
                return true;
            }
        });
        this.tracer.log("Starting the link manager...", Tracer.Level.INFO);
        this.advertisementDescriptorSet = this.linkInboundManager.start();
        this.tracer.log("Starting server advertisements...", Tracer.Level.INFO);
        this.tracer.log("...advertisement descriptor set", Tracer.Level.INFO);
        if (this.advertisementDescriptorSet.size() > 0) {
            for (UtlAddressDescriptor descriptor : this.advertisementDescriptorSet) {
                this.tracer.log("......" + descriptor.toString(), Tracer.Level.INFO);
            }
            this.discoveryCache.add("Server", this.configDescriptor.getName(), this.advertisementDescriptorSet);
        } else {
            this.tracer.log("...empty.", Tracer.Level.INFO);
        }
        if (this.heartbeatGenerator != null) {
            this.tracer.log("Starting the heartbeat generator...", Tracer.Level.INFO);
            this.heartbeatGenerator.start();
        }
        this.tracer.log("Starting the application manager...", Tracer.Level.INFO);
        this.appManager.start();
        this.loadTime = System.currentTimeMillis();
        if (this.systemName == null) {
            this.tracer.log("Server (NAME=" + this.configDescriptor.getName() + ") startup complete.", Tracer.Level.INFO);
        } else {
            this.tracer.log("Server (NAME=" + this.configDescriptor.getName() + ", SYSTEM=" + this.systemName.getValue() + (this.systemVersion != null ? " v" + this.systemVersion.getValue() : ADDRESS_NOT_AVAILABLE_STR) + ") startup complete.", Tracer.Level.INFO);
        }
    }

    @Override
    protected final void doStop() {
        if (this.heartbeatGenerator != null) {
            this.tracer.log("Stopping the statistics runner...", Tracer.Level.INFO);
            this.heartbeatGenerator.shutdown();
        }
        this.tracer.log("Stopping the link manager...", Tracer.Level.INFO);
        this.linkInboundManager.stop();
        if (this.commandExecutorService != null) {
            this.tracer.log("Stopping the command executor thread...", Tracer.Level.INFO);
            try {
                this.commandExecutorService.shutdown();
                if (!this.commandExecutorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.commandExecutorService.shutdownNow();
                    if (!this.commandExecutorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                        this.tracer.log("Timed out waiting for the command executor thread to terminate", Tracer.Level.WARNING);
                    }
                }
            }
            catch (InterruptedException e) {
                this.tracer.log("Interrupted while waiting for the command executor thread to terminate", Tracer.Level.WARNING);
                Thread.currentThread().interrupt();
            }
        }
        this.tracer.log("Stopping the application manager...", Tracer.Level.INFO);
        this.appManager.stop();
        this.tracer.log("Stopping server advertisements...", Tracer.Level.INFO);
        if (this.advertisementDescriptorSet.size() > 0) {
            this.discoveryCache.remove("Server", this.configDescriptor.getName());
        }
        this.tracer.log("Stopping the pool watch...", Tracer.Level.INFO);
        UtlPoolRegistry.getInstance().removeHandler((UtlPoolRegistry.EventHandler)this.poolWatcher);
    }

    @Override
    protected final void doClose() throws Exception {
        if (this.heartbeatGenerator != null) {
            this.closeHeartbeatLog();
        }
        if (this.discoveryCache != null) {
            this.tracer.log("Closing server discovery cache...", Tracer.Level.INFO);
            this.discoveryCache.close();
        }
        if (this.systemName == null) {
            this.tracer.log("Server (NAME=" + this.configDescriptor.getName() + ") shutdown complete.", Tracer.Level.INFO);
        } else {
            this.tracer.log("Server (NAME=" + this.configDescriptor.getName() + ", SYSTEM=" + this.systemName.getValue() + (this.systemVersion != null ? " v" + this.systemVersion.getValue() : ADDRESS_NOT_AVAILABLE_STR) + ") shutdown complete.", Tracer.Level.INFO);
        }
    }

    void doRestart() throws Exception {
        super.restart();
    }

    void doKill() throws Exception {
        super.kill();
    }

    static {
        HOSTNAME_NOT_AVAILABLE = XString.create((String)HOSTNAME_NOT_AVAILABLE_STR);
        ADDRESS_NOT_AVAILABLE = XString.create((String)ADDRESS_NOT_AVAILABLE_STR);
        controllers = new HashMap<SrvConfigDescriptor, SrvController>();
    }

    private final class AppWatcher
    implements ISrvAppWatcher {
        private AppWatcher() {
        }

        @Override
        public final void onAppLoaded(SrvAppLoader loader) {
            SrvController.this.onAppLoaded(loader);
        }

        @Override
        public final void onAppInitialized(SrvAppLoader loader, long timestamp) {
            SrvController.this.onAppInitialized(loader, timestamp);
        }

        @Override
        public final void onAppStarted(SrvMonAppEngineStartedMessage message) {
            SrvController.this.onAppStateChange(message.getEventSource(), message.getEventTimestampAsTimestamp(), SrvMonAppState.Started);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppActive(SrvMonAppEngineActiveMessage message) {
            SrvController.this.onAppStateChange(message.getEventSource(), message.getEventTimestampAsTimestamp(), SrvMonAppState.Active);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingCreated(SrvMonAppBusBindingCreatedMessage message) {
            SrvController.this.onAppBusBindingCreated(message);
        }

        @Override
        public final void onAppBusBindingOpening(SrvMonAppBusBindingOpeningMessage message) {
            SrvController.this.onAppBusBindingStateChange(message.getEventSource(), message.getBusBindingName(), SrvMonAppBusBindingState.Opening);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingOpened(SrvMonAppBusBindingOpenedMessage message) {
            SrvController.this.onAppBusBindingStateChange(message.getEventSource(), message.getBusBindingName(), SrvMonAppBusBindingState.Opened);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingOpenFailed(SrvMonAppBusBindingOpenFailedMessage message) {
            SrvController.this.onAppBusBindingStateChange(message.getEventSource(), message.getBusBindingName(), SrvMonAppBusBindingState.Failed);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingFailed(SrvMonAppBusBindingDownMessage message) {
            SrvController.this.onAppBusBindingStateChange(message.getEventSource(), message.getBusBindingName(), SrvMonAppBusBindingState.Failed);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingDestroyed(SrvMonAppBusBindingDestroyedMessage message) {
            SrvController.this.onAppBusBindingDestroyed(message);
        }

        @Override
        public final void onAppChannelUp(SrvMonAppChannelUpMessage message) {
            SrvController.this.onAppChannelUp(message);
        }

        @Override
        public final void onAppChannelDown(SrvMonAppChannelDownMessage message) {
            SrvController.this.onAppChannelDown(message);
        }

        @Override
        public final void onAppFlowCreated(String appName, long timestamp, int flowid) {
            SrvController.this.onAppFlowCreated(appName, timestamp, flowid);
        }

        @Override
        public final void onAppClientConnected(String appName, String clientName) {
            SrvController.this.onAppClientConnected(appName, clientName);
        }

        @Override
        public final void onAppClientDisconnected(String appName, String clientName) {
            SrvController.this.onAppClientDisconnected(appName, clientName);
        }

        @Override
        public final void onAppStopped(SrvMonAppEngineStoppedMessage message) {
            SrvController.this.onAppStateChange(message.getEventSource(), message.getEventTimestampAsTimestamp(), SrvMonAppState.Stopped);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppUnloaded(String appName, long timestamp) {
            SrvController.this.onAppUnloaded(appName, timestamp);
        }

        @Override
        public <E extends IRogMessage & IRogCopyableNode<? extends IRogMessage>> void onAppMonEvent(String appName, E monEvent) {
            if (appName != "admin") {
                SrvController.this.dispatchLifecycleEvent((IRogMessage)((IRogCopyableNode<? extends IRogMessage>)monEvent).copy());
            }
        }
    }

    private final class TraceWatcher
    extends Handler {
        private final TraceHistoryHandler history;
        private volatile boolean inTraceWatcher;

        TraceWatcher(int maxHistory) {
            this.history = TraceHistoryHandler.create((Handler)this, (int)maxHistory);
            TraceLoggerFactory.getInstance().registerWatcher((Handler)this.history);
        }

        final TraceHistoryHandler history() {
            return this.history;
        }

        @Override
        public final void publish(LogRecord record) {
            if (!this.inTraceWatcher) {
                this.inTraceWatcher = true;
                this.inTraceWatcher = false;
            }
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }
    }

    private final class PoolWatcher
    implements UtlPoolRegistry.EventHandler {
        private PoolWatcher() {
        }

        public final void onPoolAdded(UtlPool<?> pool) {
            SrvController.this.onPoolAdded(pool);
        }

        public final void onPoolRemoved(UtlPool<?> pool) {
            SrvController.this.onPoolRemoved(pool);
        }
    }

    public static final class LongHistogramComputer {
        public final IntCountsHistogram histogram;
        public int sampleSize = 0;
        public long maxValue = 0L;
        public long minValue = Long.MAX_VALUE;
        public double mean = 0.0;
        public int samplesOverMax = 0;
        public int samplesUnderMin = 0;

        public LongHistogramComputer() {
            this.histogram = new IntCountsHistogram(Long.MAX_VALUE, 3);
        }

        public void addValue(long value) {
            ++this.sampleSize;
            this.minValue = Math.min(this.minValue, value);
            this.maxValue = Math.max(this.maxValue, value);
            this.mean = this.sampleSize == 1 ? (double)value : this.mean * (double)(this.sampleSize - 1) / (double)this.sampleSize + (double)value / (double)this.sampleSize;
            if (value > this.histogram.getHighestTrackableValue()) {
                value = this.histogram.getHighestTrackableValue();
                ++this.samplesOverMax;
            }
            if (value < 0L) {
                value = 0L;
                ++this.samplesUnderMin;
            }
            this.histogram.recordValue(value);
        }

        public final void reset() {
            if (this.sampleSize == 0) {
                return;
            }
            this.sampleSize = 0;
            this.mean = 0.0;
            this.samplesOverMax = 0;
            this.samplesUnderMin = 0;
            this.maxValue = 0L;
            this.minValue = Long.MAX_VALUE;
            this.histogram.reset();
        }

        public SrvMonLongHistogram computeHistogramData(boolean nullIfNoSamples) {
            if (nullIfNoSamples && this.sampleSize == 0) {
                return null;
            }
            SrvMonLongHistogram data = SrvMonLongHistogram.create();
            SrvMonLongHistogram.Serializer dataSerializer = data.serializer();
            dataSerializer.sampleSize(this.sampleSize);
            if (this.sampleSize > 0) {
                dataSerializer.samplesOverMax(this.samplesOverMax).samplesUnderMin(this.samplesUnderMin).mean((long)this.mean).maximum(this.maxValue).minimum(this.minValue).median(this.histogram.getValueAtPercentile(50.0)).pct75(this.histogram.getValueAtPercentile(75.0)).pct90(this.histogram.getValueAtPercentile(90.0)).pct99(this.histogram.getValueAtPercentile(99.0)).pct999(this.histogram.getValueAtPercentile(99.9)).pct9999(this.histogram.getValueAtPercentile(99.99));
            }
            dataSerializer.done();
            return data;
        }
    }

    public static final class LongSeriesCollector
    implements IStats.Series.Collector {
        final IStats.Series series;
        final LongHistogramComputer runningCollector;
        final DoubleArrayList tempArray;
        final boolean collectRaw;
        long skippedSeqNos = 0L;
        long lastSeqNo = 0L;
        LongHistogramComputer intervalCollector;
        SrvMonLongSeries timings;

        public LongSeriesCollector(IStats.Series series, DoubleArrayList tempArray, boolean collectRaw) {
            this.series = series;
            this.tempArray = tempArray;
            this.collectRaw = collectRaw;
            this.runningCollector = new LongHistogramComputer();
        }

        public final void reset() {
            this.runningCollector.reset();
            this.lastSeqNo = 0L;
            this.skippedSeqNos = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SrvMonLongSeries collect(LongHistogramComputer intervalCollector) {
            if (this.series.sequenceNumber() < this.lastSeqNo) {
                this.reset();
            }
            intervalCollector.reset();
            this.intervalCollector = intervalCollector;
            this.timings = this.timings;
            long prevLastSeqNo = this.lastSeqNo;
            long seqNo = this.series.get((IStats.Series.Collector)this, this.tempArray, this.lastSeqNo + 1L);
            long skipped = 0L;
            if (seqNo > 0L) {
                skipped = seqNo - (prevLastSeqNo + 1L);
                this.skippedSeqNos += skipped;
            }
            SrvMonLongSeries timings = SrvMonLongSeries.create();
            SrvMonLongSeries.Serializer timingsSerializer = timings.serializer();
            timingsSerializer.lastSequenceNumber(this.lastSeqNo).numDataPoints((int)(this.lastSeqNo - prevLastSeqNo - skipped)).skippedDatapoints(this.skippedSeqNos);
            SrvMonLongHistogram histogram = intervalCollector.computeHistogramData(true);
            try {
                timingsSerializer.intervalStats(histogram);
            }
            finally {
                if (histogram != null) {
                    histogram.dispose();
                }
            }
            histogram = this.runningCollector.computeHistogramData(false);
            try {
                timingsSerializer.runningStats(histogram);
            }
            finally {
                if (histogram != null) {
                    histogram.dispose();
                }
            }
            timingsSerializer.done();
            this.timings = null;
            this.intervalCollector = null;
            return timings;
        }

        public void report(double[] values, int offset, int length) {
        }

        public void add(long sequenceNumber, double value) {
            this.runningCollector.addValue((long)value);
            this.intervalCollector.addValue((long)value);
            if (this.collectRaw) {
                this.timings.addDataPoints((long)value);
            }
            this.lastSeqNo = sequenceNumber;
        }
    }

    public static final class IntHistogramComputer {
        public final IntCountsHistogram histogram;
        public int sampleSize = 0;
        public int maxValue = 0;
        public int minValue = Integer.MAX_VALUE;
        public float mean = 0.0f;
        public int samplesOverMax = 0;
        public int samplesUnderMin = 0;

        public IntHistogramComputer() {
            this.histogram = new IntCountsHistogram(Integer.MAX_VALUE, 3);
        }

        public void addValue(int value) {
            ++this.sampleSize;
            this.minValue = Math.min(this.minValue, value);
            this.maxValue = Math.max(this.maxValue, value);
            this.mean = this.sampleSize == 1 ? (float)value : this.mean * (float)(this.sampleSize - 1) / (float)this.sampleSize + (float)value / (float)this.sampleSize;
            if ((long)value > this.histogram.getHighestTrackableValue()) {
                value = (int)this.histogram.getHighestTrackableValue();
                ++this.samplesOverMax;
            }
            if (value < 0) {
                value = 0;
                ++this.samplesUnderMin;
            }
            this.histogram.recordValue((long)value);
        }

        public final void reset() {
            if (this.sampleSize == 0) {
                return;
            }
            this.sampleSize = 0;
            this.mean = 0.0f;
            this.samplesOverMax = 0;
            this.samplesUnderMin = 0;
            this.maxValue = 0;
            this.minValue = Integer.MAX_VALUE;
            this.histogram.reset();
        }

        public SrvMonIntHistogram computeHistogramData(boolean nullIfNoSamples) {
            if (nullIfNoSamples && this.sampleSize == 0) {
                return null;
            }
            SrvMonIntHistogram data = SrvMonIntHistogram.create();
            SrvMonIntHistogram.Serializer dataSerializer = data.serializer();
            dataSerializer.sampleSize(this.sampleSize);
            if (this.sampleSize > 0) {
                dataSerializer.samplesOverMax(this.samplesOverMax).samplesUnderMin(this.samplesUnderMin).mean((int)this.mean).maximum(this.maxValue).minimum(this.minValue).median((int)this.histogram.getValueAtPercentile(50.0)).pct75((int)this.histogram.getValueAtPercentile(75.0)).pct90((int)this.histogram.getValueAtPercentile(90.0)).pct99((int)this.histogram.getValueAtPercentile(99.0)).pct999((int)this.histogram.getValueAtPercentile(99.9)).pct9999((int)this.histogram.getValueAtPercentile(99.99));
            }
            dataSerializer.done();
            return data;
        }
    }

    public static final class IntSeriesCollector
    implements IStats.Series.Collector {
        final IStats.Series series;
        final IntHistogramComputer runningCollector;
        final DoubleArrayList tempArray;
        final boolean collectRaw;
        long skippedSeqNos = 0L;
        long lastSeqNo = 0L;
        IntHistogramComputer intervalCollector;
        SrvMonIntSeries timings;

        public IntSeriesCollector(IStats.Series series, DoubleArrayList tempArray, boolean collectRaw) {
            this.series = series;
            this.tempArray = tempArray;
            this.collectRaw = collectRaw;
            this.runningCollector = new IntHistogramComputer();
        }

        public final void reset() {
            this.runningCollector.reset();
            this.lastSeqNo = 0L;
            this.skippedSeqNos = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SrvMonIntSeries collect(IntHistogramComputer intervalCollector) {
            if (this.series.sequenceNumber() < this.lastSeqNo) {
                this.reset();
            }
            intervalCollector.reset();
            this.intervalCollector = intervalCollector;
            this.timings = this.timings;
            long prevLastSeqNo = this.lastSeqNo;
            long seqNo = this.series.get((IStats.Series.Collector)this, this.tempArray, this.lastSeqNo + 1L);
            long skipped = 0L;
            if (seqNo > 0L) {
                skipped = seqNo - (prevLastSeqNo + 1L);
                this.skippedSeqNos += skipped;
            }
            SrvMonIntSeries timings = SrvMonIntSeries.create();
            SrvMonIntSeries.Serializer timingsSerializer = timings.serializer();
            timingsSerializer.lastSequenceNumber(this.lastSeqNo).numDataPoints((int)(this.lastSeqNo - prevLastSeqNo - skipped)).skippedDatapoints(this.skippedSeqNos);
            SrvMonIntHistogram histogram = intervalCollector.computeHistogramData(true);
            try {
                timingsSerializer.intervalStats(histogram);
            }
            finally {
                if (histogram != null) {
                    histogram.dispose();
                }
            }
            histogram = this.runningCollector.computeHistogramData(false);
            try {
                timingsSerializer.runningStats(histogram);
            }
            finally {
                if (histogram != null) {
                    histogram.dispose();
                }
            }
            timingsSerializer.done();
            this.timings = null;
            this.intervalCollector = null;
            return timings;
        }

        public void report(double[] values, int offset, int length) {
        }

        public void add(long sequenceNumber, double value) {
            this.runningCollector.addValue((int)value);
            this.intervalCollector.addValue((int)value);
            if (this.collectRaw) {
                this.timings.addDataPoints((int)value);
            }
            this.lastSeqNo = sequenceNumber;
        }
    }
}

