/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.deploy;

import com.neeve.config.Config;
import com.neeve.deploy.Host;
import com.neeve.deploy.HostCollection;
import com.neeve.deploy.Server;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxActionExecutor;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.link.ILnkContainerRunCompletionChecker;
import com.neeve.link.LnkRegistry;
import com.neeve.link.LnkSTRRunnableContainer;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class Model
extends LnkSTRRunnableContainer {
    private final String applicationName;
    private final WorkerThread thread;
    private final DelayedActionEventHandler delayedActionEventHandler;
    private final EmxActionExecutor<Object, Object> actionExecutor;
    private final StopAction stopAction;
    private final HostCollection hostCollection;
    private final Tracer tracer;
    private final String tracePrefix;
    private final Properties serverConnectionProperties = new Properties();
    private int serverCommandTimeout;
    private int serverConnectHandshakeTimeout;
    private int serverConnectRetryInterval;
    private volatile State state;

    public Model(String applicationName, Tracer tracer) throws Exception {
        this(applicationName, DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR, tracer);
    }

    public Model(String applicationName, String discoveryDescriptor, Tracer tracer) throws Exception {
        super(null, "X-" + applicationName + "-Deploy-ModelWorker", null, 0);
        this.applicationName = applicationName;
        this.tracer = tracer;
        this.tracePrefix = "[Model] ";
        try {
            this.setReader(EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, this.getName(), IEmxDispatcher.Params.create((boolean)false, (boolean)true)));
        }
        catch (EEmxException e) {
            throw new RuntimeException("Failed to create worker dispatcher [" + e.toString() + "]");
        }
        this.thread = new WorkerThread(new ThreadStartCoordinator());
        this.delayedActionEventHandler = new DelayedActionEventHandler();
        this.actionExecutor = new EmxActionExecutor();
        this.stopAction = new StopAction();
        this.setServerCommandTimeout(30000);
        this.setServerConnectHandshakeTimeout(15000);
        this.setServerConnectRetryInterval(1000);
        Config.getPropertiesTo((Properties)this.serverConnectionProperties);
        this.hostCollection = new HostCollection(this, discoveryDescriptor, tracer);
        this.state = State.Init;
        if (tracer.debug) {
            tracer.log(this.tracePrefix + " Created model worker '" + this.getName() + "'...", Tracer.Level.DEBUG);
        }
    }

    private final IllegalStateException prepareStateValidationErrorException() {
        switch (this.state) {
            case Init: {
                return new IllegalStateException("worker has not been opened");
            }
            case Open: {
                return new IllegalStateException("worker is open");
            }
            case Closed: {
                return new IllegalStateException("worker is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    final void scheduleAction(IEmxAction action, Object data) throws Exception {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Scheduling action '" + action.getClass().getSimpleName() + "' for immediate execution...", Tracer.Level.DEBUG);
        }
        this.actionExecutor.invoke(this.getReader(), action, data, 0);
    }

    final void scheduleAction(IEmxAction action, Object data, int delay) throws Exception {
        if (delay <= 0) {
            this.scheduleAction(action, data);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Scheduling action '" + action.getClass().getSimpleName() + "' for delayed execution (delay=" + delay + "ms)...", Tracer.Level.DEBUG);
            }
            IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.delayedActionEventHandler, delay);
            event.setAttachment((Object)new DelayedActionEventData(action, data));
            this.getReader().schedAlarmEv(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Opening model...", Tracer.Level.DEBUG);
        }
        if (this.state == State.Init) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Starting worker thread...", Tracer.Level.DEBUG);
            }
            this.thread.start();
            ThreadStartCoordinator threadStartCoordinator = this.thread.coordinator;
            synchronized (threadStartCoordinator) {
                while (!this.thread.coordinator.isStarted) {
                    try {
                        this.thread.coordinator.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " Worker thread started.", Tracer.Level.DEBUG);
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
        this.hostCollection.open();
        this.state = State.Open;
    }

    public final HostCollection getHostCollection() {
        return this.hostCollection;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final void setServerCommandTimeout(int timeout) {
        this.serverCommandTimeout = timeout;
        this.serverConnectionProperties.put("nv.server.admin.commandtimeout", String.valueOf(timeout));
    }

    public final int getServerCommandTimeout() {
        return this.serverCommandTimeout;
    }

    public final void setServerConnectHandshakeTimeout(int timeout) {
        this.serverConnectHandshakeTimeout = timeout;
        this.serverConnectionProperties.put("nv.server.admin.connecthandshaketimeout", String.valueOf(timeout));
    }

    public final int getServerConnectHandshakeTimeout() {
        return this.serverConnectHandshakeTimeout;
    }

    public final void setServerConnectRetryInterval(int interval) {
        this.serverConnectRetryInterval = interval;
    }

    public final int getServerConnectRetryInterval() {
        return this.serverConnectRetryInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerConnectionProperties(Properties serverConnectionProperties) {
        Properties properties = this.serverConnectionProperties;
        synchronized (properties) {
            this.serverConnectionProperties.clear();
            this.serverConnectionProperties.putAll((Map<?, ?>)serverConnectionProperties);
        }
    }

    public final Properties getServerConnectionProperties() {
        return this.serverConnectionProperties;
    }

    public final Server getServer(String serverName) {
        Host host;
        Server server = null;
        Iterator<Host> iterator = this.getHostCollection().getHosts().iterator();
        while (iterator.hasNext() && (server = (host = iterator.next()).getServer(serverName)) == null) {
        }
        return server;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void close() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " Closing model...", Tracer.Level.DEBUG);
        }
        if (this.state != State.Closed) {
            try {
                if (this.state != State.Open) return;
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " Shutting down the worker thread...", Tracer.Level.DEBUG);
                }
                try {
                    this.actionExecutor.invoke(this.getReader(), (IEmxAction)this.stopAction, null, 1);
                    if (Thread.currentThread() == this.getReader().getOwner()) return;
                    while (true) {
                        try {
                            this.thread.join();
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    throw new InternalError("Failure encountered while shutting down model worker thread [" + e.toString() + "]...");
                }
            }
            finally {
                LnkRegistry.getInstance().removeContainer(this.getName());
                this.state = State.Closed;
            }
        } else {
            if (!this.tracer.debug) return;
            this.tracer.log(this.tracePrefix + " Already closed.", Tracer.Level.DEBUG);
        }
    }

    private final class StopAction
    implements IEmxAction<Object, Object> {
        private StopAction() {
        }

        public final Object execute(IEmxDispatcher dispatcher, Object object) throws Exception {
            ((WorkerThread)Model.this.getReader().getOwner()).shutdown();
            Model.this.hostCollection.close();
            return null;
        }
    }

    private final class DelayedActionEventHandler
    implements IEmxEventHandler {
        private DelayedActionEventHandler() {
        }

        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            DelayedActionEventData eventData = (DelayedActionEventData)event.getAttachment();
            try {
                Model.this.scheduleAction(eventData.action, eventData.data);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unhandled fault during scheduled action execution [" + e.toString() + "]\n");
                sb.append("Stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                Model.this.tracer.log(Model.this.tracePrefix + " " + sb.toString(), Tracer.Level.SEVERE);
            }
            return false;
        }
    }

    private final class DelayedActionEventData {
        final IEmxAction<?, ?> action;
        final Object data;

        DelayedActionEventData(IEmxAction<?, ?> action, Object data) {
            this.action = action;
            this.data = data;
        }
    }

    private final class WorkerThread
    extends Thread
    implements ILnkContainerRunCompletionChecker {
        final ThreadStartCoordinator coordinator;
        private boolean stopped;

        WorkerThread(ThreadStartCoordinator coordinator) {
            this.coordinator = coordinator;
            this.setName(Model.this.getReader().getName());
            this.setDaemon(true);
        }

        private final void shutdown() {
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                Model.this.getReader().setOwner();
                ThreadStartCoordinator threadStartCoordinator = this.coordinator;
                synchronized (threadStartCoordinator) {
                    this.coordinator.isStarted = true;
                    this.coordinator.notify();
                }
                Model.this.run(-1, this);
                if (((Model)Model.this).tracer.debug) {
                    Model.this.tracer.log(Model.this.tracePrefix + " Worker thread done.", Tracer.Level.DEBUG);
                }
                if (((Model)Model.this).tracer.debug) {
                    Model.this.tracer.log(Model.this.tracePrefix + " Closing worker dispatcher...", Tracer.Level.DEBUG);
                }
                try {
                    Model.this.getReader().close(true);
                }
                catch (Exception e) {
                    Model.this.tracer.log(Model.this.tracePrefix + " Failed to close worker dispatcher [" + e.toString() + "].", Tracer.Level.WARNING);
                }
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Unhandled fault during thread execution [" + e.toString() + "]\n");
                sb.append("Stack trace:\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                Model.this.tracer.log(Model.this.tracePrefix + " " + sb.toString(), Tracer.Level.SEVERE);
            }
        }

        public final boolean isDone() {
            return this.stopped;
        }

        public final Object getCompletion() throws Exception {
            return null;
        }
    }

    private final class ThreadStartCoordinator {
        boolean isStarted = false;

        private ThreadStartCoordinator() {
        }
    }

    private static enum State {
        Init,
        Open,
        Closed;

    }
}

