/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.daemon.thread;

import cern.colt.function.ObjectProcedure;
import cern.colt.list.ObjectArrayList;
import com.neeve.daemon.thread.DmnThread;
import com.neeve.daemon.thread.DmnThreadObject;
import com.neeve.daemon.thread.EDmnThreadException;
import com.neeve.daemon.thread.EDmnThreadInvalidStateException;
import com.neeve.daemon.thread.EDmnThreadInvalidThreadingModeException;
import com.neeve.daemon.thread.EDmnThreadMaxThreadsReachedException;
import com.neeve.daemon.thread.EDmnThreadUnmanagedThreadException;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import java.util.HashSet;
import java.util.Iterator;

public final class DmnThreadPool
extends DmnThreadObject {
    private final String name;
    private int maxOnDemandThreads;
    private DmnThread main;
    private ObjectArrayList ioThreads;
    private HashSet<DmnThread> odThreads;
    private volatile State state;
    private int currentOnDemandThreadCreateIndex;

    DmnThreadPool(String name, RootConfig.ObjectConfig config) {
        super(config);
        this.name = name;
        this.state = State.Uninitialized;
    }

    final void init(int numIOThreads, long[] ioThreadCpuAffinityMasks, int maxOnDemandThreads) throws Exception {
        if (this.state == State.Uninitialized) {
            this.ioThreads = new ObjectArrayList(numIOThreads);
            this.main = new DmnThread("X-Server-" + this.name + "-Main", Thread.currentThread(), this.tracer);
            this.ioThreads.add((Object)this.main);
            this.main.setCPUAffinityMask(ioThreadCpuAffinityMasks[0]);
            this.main.getDispatcher().forceSchedNwReadyEvAsCritical();
            if (this.getThreaded()) {
                for (int i = 1; i < numIOThreads; ++i) {
                    DmnThread thread = new DmnThread("X-Server-" + this.name + "-IOThread-" + i, null, this.tracer);
                    thread.setCPUAffinityMask(ioThreadCpuAffinityMasks[i]);
                    thread.getDispatcher().forceSchedNwReadyEvAsCritical();
                    this.ioThreads.add((Object)thread);
                }
            } else if (numIOThreads > 1) {
                this.tracer.log("Thread pool initialized with numThreads > 1 (=" + numIOThreads + ") but daemon is operating in single threaded mode. Initializing with numThreads=1", Tracer.Level.WARNING);
            }
            this.maxOnDemandThreads = maxOnDemandThreads;
            this.odThreads = new HashSet();
            if (this.getThreaded() && this.ioThreads.size() > 1) {
                this.ioThreads.forEach(new ObjectProcedure(){

                    public final boolean apply(Object element) {
                        DmnThread thread = (DmnThread)element;
                        if (thread != DmnThreadPool.this.main) {
                            thread.start();
                        }
                        return true;
                    }
                });
            }
        } else {
            throw new EDmnThreadInvalidStateException();
        }
        this.state = State.Initialized;
    }

    final void start() {
        if (this.state == State.Initialized) {
            if (Thread.currentThread() != this.main.getDispatcher().getOwner()) {
                throw new InternalError("Start must be invoked by the main thread");
            }
            if (this.getThreaded() && this.ioThreads.size() > 1) {
                this.ioThreads.forEach(new ObjectProcedure(){

                    public final boolean apply(Object element) {
                        DmnThread thread = (DmnThread)element;
                        if (thread != DmnThreadPool.this.main) {
                            thread.go();
                        }
                        return true;
                    }
                });
            }
            Iterator<DmnThread> iterator = this.odThreads.iterator();
            while (iterator.hasNext()) {
                iterator.next().go();
            }
        } else {
            throw new EDmnThreadInvalidStateException();
        }
        this.state = State.Started;
        this.main.go();
        this.main.run();
    }

    final void stop() {
        if (this.state == State.Initialized || this.state == State.Started) {
            if (this.main != null) {
                if (Thread.currentThread() != this.main.getDispatcher().getOwner()) {
                    throw new InternalError("Stop must be invoked by the main thread");
                }
                Iterator<DmnThread> iterator = this.odThreads.iterator();
                while (iterator.hasNext()) {
                    iterator.next().stop();
                    iterator.remove();
                }
                if (this.getThreaded() && this.ioThreads.size() > 1) {
                    this.ioThreads.forEach(new ObjectProcedure(){

                        public final boolean apply(Object element) {
                            DmnThread thread = (DmnThread)element;
                            if (thread != DmnThreadPool.this.main) {
                                thread.stop();
                            }
                            return true;
                        }
                    });
                }
                this.main.stop();
            }
        } else {
            throw new EDmnThreadInvalidStateException();
        }
    }

    public final boolean isIOThread() {
        return !this.ioThreads.forEach(new ObjectProcedure(){

            public final boolean apply(Object element) {
                return !((DmnThread)element).isCurrentThread();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOnDemandThread() {
        HashSet<DmnThread> hashSet = this.odThreads;
        synchronized (hashSet) {
            Iterator<DmnThread> iterator = this.odThreads.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isCurrentThread()) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isManagedThread() {
        return this.isIOThread() || this.isOnDemandThread();
    }

    public final DmnThread getMainThread() {
        return this.main;
    }

    public final int getIOThreadCount() {
        return this.ioThreads.size();
    }

    public final DmnThread getIOThread(int num) {
        return (DmnThread)this.ioThreads.get(num);
    }

    public final DmnThread createThread() throws EDmnThreadInvalidStateException, EDmnThreadInvalidThreadingModeException, EDmnThreadMaxThreadsReachedException, EDmnThreadException {
        if (this.state == State.Initialized || this.state == State.Started) {
            if (this.getThreaded()) {
                HashSet<DmnThread> hashSet = this.odThreads;
                synchronized (hashSet) {
                    if (this.maxOnDemandThreads < 0 || this.odThreads.size() < this.maxOnDemandThreads) {
                        try {
                            DmnThread thread = new DmnThread("ODThread-" + ++this.currentOnDemandThreadCreateIndex, null, this.tracer);
                            this.odThreads.add(thread);
                            thread.start();
                            if (this.state == State.Started) {
                                thread.go();
                            }
                            return thread;
                        }
                        catch (Exception e) {
                            throw new EDmnThreadException(e);
                        }
                    }
                    throw new EDmnThreadMaxThreadsReachedException();
                }
            }
            throw new EDmnThreadInvalidThreadingModeException();
        }
        throw new EDmnThreadInvalidStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void destroyThread(DmnThread thread) throws EDmnThreadInvalidStateException, EDmnThreadInvalidThreadingModeException, EDmnThreadUnmanagedThreadException {
        if (this.state != State.Started) throw new EDmnThreadInvalidStateException();
        if (!this.getThreaded()) throw new EDmnThreadInvalidThreadingModeException();
        HashSet<DmnThread> hashSet = this.odThreads;
        synchronized (hashSet) {
            if (!this.odThreads.contains(thread)) {
                throw new EDmnThreadUnmanagedThreadException();
            }
            this.odThreads.remove(thread);
            thread.stop();
            return;
        }
    }

    private static enum State {
        Uninitialized,
        Initialized,
        Started,
        Stopped;

    }
}

