/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.daemon;

import com.neeve.ci.ProductInfo;
import com.neeve.config.Config;
import com.neeve.daemon.controller.DmnController;
import com.neeve.daemon.controller.IDmnControllerEventHandler;
import com.neeve.daemon.controller.IDmnControllerLauncher;
import com.neeve.util.UtlNet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Date;
import java.util.Properties;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public abstract class DmnMain {
    private final MainThread mainThread;
    private boolean managedByWrapper;
    protected final DmnController controller;

    protected DmnMain(DmnController controller) {
        this.controller = controller;
        this.controller.setEventHandler(new ControllerEventHandler());
        this.controller.setLauncher(new ControllerLauncher());
        this.mainThread = new MainThread();
    }

    private static final void printInstallRoot() {
        File verDir = new File(Config.getRootDirectory() + "/ver");
        if (verDir.exists()) {
            System.out.println("   [Install Root=" + Config.getRootDirectory() + "]");
        } else {
            System.out.println("   [Root Directory=" + Config.getRootDirectory() + "]");
        }
    }

    private static final void printComponentVersions(ProductInfo info) {
        try {
            File verDir = new File(Config.getRootDirectory() + "/ver");
            if (verDir.exists()) {
                System.out.println("   Installed Components");
                File[] files = verDir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].getName().endsWith(".display")) continue;
                    BufferedReader s = new BufferedReader(new FileReader(files[i]));
                    System.out.println("     " + s.readLine());
                }
            } else if (info != null) {
                System.out.println("   " + info.getComponentVersionString() + " (embedded)");
            } else {
                System.out.println("   Installed Components");
                System.out.println("     <Installed component version information is not available>");
            }
        }
        catch (Exception e) {
            System.out.println("     <*** Error in obtaining product versions [" + e.toString() + "] ***>");
        }
    }

    private static final void printJREInfo() {
        Properties props = System.getProperties();
        System.out.println("   System Information");
        System.out.println("     User Name        = " + props.getProperty("user.name"));
        System.out.println("     Host Name        = " + UtlNet.getLocalHostNameForDisplay((String)"Unknown"));
        System.out.println("     Host Address     = " + UtlNet.getLocalHostAddressForDisplay((String)"Unknown"));
        System.out.println("     OS Name          = " + props.getProperty("os.name"));
        System.out.println("     OS Arch          = " + props.getProperty("os.arch"));
        System.out.println("     OS Version       = " + props.getProperty("os.version"));
        System.out.println("     JRE Spec Name    = " + props.getProperty("java.specification.name"));
        System.out.println("     JRE Spec Version = " + props.getProperty("java.specification.version"));
        System.out.println("     JRE Spec Vendor  = " + props.getProperty("java.specification.vendor"));
        System.out.println("     JRE Version      = " + props.getProperty("java.version"));
        System.out.println("     JRE Vendor       = " + props.getProperty("java.vendor"));
        System.out.println("     JRE Home         = " + props.getProperty("java.home"));
        System.out.println("     JVM Spec Name    = " + props.getProperty("java.vm.specification.name"));
        System.out.println("     JVM Spec Version = " + props.getProperty("java.vm.specification.version"));
        System.out.println("     JVM Spec Vendor  = " + props.getProperty("java.vm.specification.vendor"));
        System.out.println("     JVM Impl Name    = " + props.getProperty("java.vm.name"));
        System.out.println("     JVM Impl Version = " + props.getProperty("java.vm.version"));
        System.out.println("     JVM Impl Vendor  = " + props.getProperty("java.vm.vendor"));
    }

    protected static final void printCommonDaemonBanner() {
        DmnMain.printCommonDaemonBanner(null);
    }

    protected static final void printCommonDaemonBanner(ProductInfo info) {
        DmnMain.printInstallRoot();
        System.out.println("");
        DmnMain.printComponentVersions(info);
        System.out.println("");
        DmnMain.printJREInfo();
        System.out.println("");
        System.out.println("   [" + new Date() + "]");
    }

    private final void onInitBegin() {
    }

    private final void onInitEnd(Throwable e) {
    }

    private final void onStartBegin() {
    }

    private final void onStartEnd(Throwable e) {
    }

    private final Integer onStart(String[] args) {
        if (this.managedByWrapper) {
            this.mainThread.start();
        } else {
            this.mainThread.run();
        }
        return null;
    }

    private final int onStop(int exitCode) {
        if (this.managedByWrapper) {
            this.controller.stop();
            new Thread(){

                @Override
                public final void run() {
                    while (true) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }.start();
            return exitCode;
        }
        throw new UnsupportedOperationException("'stop' is not supported in unmanaged run mode");
    }

    private final void onKill() {
        if (this.managedByWrapper) {
            WrapperManager.stopImmediate((int)1);
        } else {
            System.exit(-1);
        }
    }

    private final void onRestart() {
        if (!this.managedByWrapper) {
            throw new UnsupportedOperationException("'restart' is not supported in unmanaged run mode");
        }
        WrapperManager.restartAndReturn();
    }

    protected final void entryPoint(boolean managedByWrapper, String[] args) throws Exception {
        this.managedByWrapper = managedByWrapper;
        if (this.managedByWrapper) {
            WrapperManager.start((WrapperListener)new WrapperEventHandler(), (String[])args);
        } else {
            this.onStart(args);
            System.exit(0);
        }
    }

    private final class MainThread
    extends Thread {
        private MainThread() {
        }

        @Override
        public final void run() {
            DmnMain.this.controller.start();
        }
    }

    private final class ControllerLauncher
    implements IDmnControllerLauncher {
        private ControllerLauncher() {
        }

        @Override
        public void executeVMRestart() throws Exception {
            DmnMain.this.onRestart();
        }

        @Override
        public void executeVMKill() throws Exception {
            DmnMain.this.onKill();
        }
    }

    private final class ControllerEventHandler
    implements IDmnControllerEventHandler {
        private ControllerEventHandler() {
        }

        @Override
        public final void onEvent(int type, Object data) {
            switch (type) {
                case 1: {
                    DmnMain.this.onInitBegin();
                    break;
                }
                case 2: {
                    DmnMain.this.onInitEnd((Throwable)data);
                    break;
                }
                case 3: {
                    DmnMain.this.onStartBegin();
                    break;
                }
                case 4: {
                    DmnMain.this.onStartEnd((Throwable)data);
                }
            }
        }
    }

    private final class WrapperEventHandler
    implements WrapperListener {
        private WrapperEventHandler() {
        }

        public final Integer start(String[] args) {
            return DmnMain.this.onStart(args);
        }

        public final int stop(int exitCode) {
            return DmnMain.this.onStop(exitCode);
        }

        public final void controlEvent(int event) {
            if (!(WrapperManager.isControlledByNativeWrapper() || event != 200 && event != 201 && event != 203)) {
                WrapperManager.stop((int)0);
            }
        }
    }
}

