/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.asm;

import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmXMLParser;
import com.neeve.adm.EAdmException;
import com.neeve.asm.AsmDocumentation;
import com.neeve.asm.AsmModel;
import com.neeve.asm.AsmObject;
import com.neeve.asm.AsmOperation;
import com.neeve.asm.EAsmException;
import com.neeve.build.codegen.CgCodeSource;
import com.neeve.build.codegen.CgExtendedDOMBuilder;
import com.neeve.build.codegen.CgResourceChangeTracker;
import com.neeve.build.codegen.ECgException;
import com.neeve.util.UtlFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class AsmXMLParser
extends AsmObject {
    private final File modelFile;
    private final File modelsDir;
    private final Document doc;
    private final Element messagesElement;
    private final NodeList operationElements;

    private AsmXMLParser(File modelFile, File modelsDir, CgResourceChangeTracker parseContext) throws Exception {
        URL modelUrl;
        this.modelFile = modelFile;
        this.modelsDir = modelsDir;
        try {
            modelUrl = modelFile.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new EAsmException("Error opening model: " + modelFile + " " + ex.getMessage(), ex);
        }
        try {
            this.doc = CgExtendedDOMBuilder.readXML((URL)modelUrl, (String)"/x-asml.xsd", (PrintStream)System.out, (CgResourceChangeTracker)parseContext);
        }
        catch (ECgException ex) {
            if (ex.getCodeSource() != null) {
                throw new EAsmException(ex.getMessage(), (Throwable)ex, ex.getCodeSource());
            }
            if (ex.getAggregatedErrors() != null) {
                throw new EAsmException(ex.getMessage(), (Throwable)ex, ex.getAggregatedErrors());
            }
            throw new RuntimeException(ex.getMessage(), ex);
        }
        NodeList messagesElements = this.doc.getElementsByTagName("messages");
        this.messagesElement = (Element)messagesElements.item(0);
        this.operationElements = this.doc.getElementsByTagName("operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final File resolveModelFile(AsmXMLParser parser, File thisModelFile, File modelsDir, String referencedModelFilename, String referencingElementName) throws IOException {
        if (referencedModelFilename == null || referencedModelFilename.trim().length() == 0) {
            throw new IllegalArgumentException("referenced model file name (in the '" + referencingElementName + "' element) cannot be null or empty");
        }
        File file = new File(referencedModelFilename);
        if (file.isAbsolute()) {
            return file;
        }
        if (modelsDir != null && (file = new File(modelsDir + File.separator + referencedModelFilename)).exists()) {
            return file;
        }
        if (thisModelFile != null && (file = new File(thisModelFile.getParentFile().getCanonicalPath() + File.separator + referencedModelFilename).getCanonicalFile()).exists()) {
            return file;
        }
        URL url = ((Object)((Object)parser)).getClass().getResource("/" + referencedModelFilename);
        if (url != null) {
            InputStream is = url.openStream();
            try {
                File file2 = UtlFile.copyToTempFile((InputStream)is);
                return file2;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        throw new FileNotFoundException("model file '" + referencedModelFilename + " could not be located");
    }

    private final AsmDocumentation parseElementDocumentation(Element element, String modelType) throws EAdmException {
        NodeList documentation;
        Node briefDoc = element.getAttributes().getNamedItem("doc");
        String brief = null;
        if (briefDoc != null) {
            brief = briefDoc.getNodeValue();
        }
        if ((documentation = element.getElementsByTagName("documentation")).getLength() > 0 && documentation.item(0).getParentNode() == element) {
            AsmDocumentation doc = new AsmDocumentation(modelType);
            doc.setBrief(brief);
            Element docElement = (Element)documentation.item(0);
            if (docElement.hasAttribute("brief")) {
                doc.setBrief(docElement.getAttribute("brief"));
            }
            if (docElement.getChildNodes().getLength() > 0) {
                Text text = (Text)docElement.getChildNodes().item(0);
                doc.setFull(text.getWholeText());
            }
            doc.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)docElement));
            return doc;
        }
        if (brief != null) {
            AsmDocumentation doc = new AsmDocumentation(modelType);
            doc.setBrief(briefDoc.getTextContent());
            doc.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)element));
            return doc;
        }
        return null;
    }

    private final void parseOperations(AsmModel model) throws Exception {
        HashSet<String> operationNames = new HashSet<String>();
        HashSet<String> inMessageNames = new HashSet<String>();
        for (int i = 0; i < this.operationElements.getLength(); ++i) {
            Element operationElement = (Element)this.operationElements.item(i);
            String name = operationElement.getAttributes().getNamedItem("name").getNodeValue();
            if (operationNames.contains(name)) {
                throw new EAsmException("duplicate operation name '" + name + "'", CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            operationNames.add(name);
            String inMessageName = operationElement.getAttributes().getNamedItem("inMessage").getNodeValue();
            if (inMessageNames.contains(inMessageName)) {
                throw new EAsmException("duplicate operation inbound message '" + inMessageName + "'", CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            inMessageNames.add(inMessageName);
            List<AdmMessage> resolvedInMessages = model.resolveMessage(inMessageName);
            if (resolvedInMessages == null || resolvedInMessages.size() == 0) {
                throw new EAsmException("failed to resolve operation inbound message '" + inMessageName + "'", CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            if (resolvedInMessages.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("ambiguous operation inbound message '" + inMessageName + "'").append("\n");
                for (AdmMessage message : resolvedInMessages) {
                    sb.append("...").append(message.getFullName());
                }
                throw new EAsmException(sb.toString(), CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            String outMessageName = operationElement.getAttributes().getNamedItem("outMessage").getNodeValue();
            List<AdmMessage> resolvedOutMessages = model.resolveMessage(outMessageName);
            if (resolvedOutMessages == null || resolvedOutMessages.size() == 0) {
                throw new EAsmException("failed to resolve operation outbound message '" + outMessageName + "'", CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            if (resolvedOutMessages.size() > 1) {
                StringBuilder sb = new StringBuilder();
                sb.append("ambiguous operation outbound message '" + outMessageName + "'").append("\n");
                for (AdmMessage message : resolvedOutMessages) {
                    sb.append("...").append(message.getFullName());
                }
                throw new EAsmException(sb.toString(), CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            }
            String restPath = operationElement.getAttributes().getNamedItem("RESTPath") != null ? operationElement.getAttributes().getNamedItem("RESTPath").getNodeValue() : null;
            String restMethod = operationElement.getAttributes().getNamedItem("RESTMethod") != null ? operationElement.getAttributes().getNamedItem("RESTMethod").getNodeValue() : "POST";
            AsmDocumentation documentation = this.parseElementDocumentation(operationElement, "Operation");
            AsmOperation operation = new AsmOperation(name, resolvedInMessages.get(0), resolvedOutMessages != null ? resolvedOutMessages.get(0) : null, restPath, AsmOperation.RestMethod.valueOf(restMethod), documentation);
            operation.setCodeSource(CgExtendedDOMBuilder.getCodeSource((Node)operationElement));
            model.addOperation(operation);
        }
    }

    @Deprecated
    public static final AsmModel parse(File modelFile, File modelsDir, String namespace) throws EAsmException {
        return AsmXMLParser.parse(modelFile, modelsDir, namespace, null);
    }

    public static final AsmModel parse(File modelFile, File modelsDir, String namespace, CgResourceChangeTracker parseContext) throws EAsmException {
        if (modelFile == null) {
            throw new IllegalArgumentException("model file cannot be null");
        }
        try {
            URL modelUrl;
            AsmXMLParser parser = new AsmXMLParser(modelFile, modelsDir, parseContext);
            Node nameAttr = parser.doc.getElementsByTagName("model").item(0).getAttributes().getNamedItem("name");
            Node nsAttr = parser.doc.getElementsByTagName("model").item(0).getAttributes().getNamedItem("namespace");
            Node msgsInAttr = parser.messagesElement.getAttributes().getNamedItem("modelFile");
            AdmModel messagesModel = AdmXMLParser.parse((File)AsmXMLParser.resolveModelFile(parser, modelFile, modelsDir, msgsInAttr.getNodeValue(), "messages"), (File)modelsDir, null);
            String resolvedNamespace = namespace != null ? namespace : nsAttr.getNodeValue();
            AsmModel model = new AsmModel(nameAttr.getNodeValue(), resolvedNamespace, messagesModel);
            model.setDocumentation(parser.parseElementDocumentation((Element)parser.doc.getElementsByTagName("model").item(0), "Model"));
            try {
                modelUrl = modelFile.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new EAsmException("Error opening model: " + modelFile + " " + ex.getMessage(), ex);
            }
            model.setCodeSource(new CgCodeSource(modelUrl, 1, 1));
            parser.parseOperations(model);
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof EAsmException) {
                throw (EAsmException)((Object)e);
            }
            throw new EAsmException(e);
        }
    }

    public static final AsmModel parse(File modelFile) throws EAsmException {
        return AsmXMLParser.parse(modelFile, null, null);
    }
}

