/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmField;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmModelImport;
import com.neeve.adm.AdmObject;
import com.neeve.util.UtlMisc;
import java.util.LinkedList;

public class AdmFieldLookup
extends AdmObject {
    private AdmField field;
    private final LinkedList<AdmModelImport> importPath = new LinkedList();

    public AdmFieldLookup() {
    }

    public AdmFieldLookup(AdmField field) {
        this.field = field;
    }

    private String importPathToString() {
        StringBuilder sb = new StringBuilder();
        for (AdmModelImport modelImport : this.importPath) {
            sb.append(UtlMisc.coalesce((Object)modelImport.getCodeSource(), (Object)"Source unknown"));
            sb.append("\n");
        }
        return sb.toString();
    }

    public final AdmField getField() {
        return this.field;
    }

    public final void setField(AdmField field) {
        this.field = field;
    }

    public final LinkedList<AdmModelImport> getImportPath() {
        return this.importPath;
    }

    public final AdmField deriveField(AdmModel model, String name, short id) {
        if (this.field == null) {
            throw new RuntimeException("Can't import field based on empty lookup");
        }
        AdmField retVal = new AdmField(model, this.field.getModel(), this.importPath, name, id, this.field.getType());
        return retVal;
    }

    public final String toString() {
        return this.importPathToString();
    }
}

