/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.engine.driver.local;

import com.neeve.event.IEventAcknowledger;
import com.neeve.event.IEventHandler;
import com.neeve.io.IOBuffer;
import com.neeve.io.IONativePacket;
import com.neeve.perf.aep.engine.LatencyRecorder;
import com.neeve.perf.aep.engine.driver.local.LocalMessageChannel;
import com.neeve.perf.aep.engine.messages.FinalMessage;
import com.neeve.perf.aep.engine.messages.Latencies;
import com.neeve.perf.aep.engine.messages.LatencyType;
import com.neeve.perf.aep.engine.messages.Throughput;
import com.neeve.perf.serialization.Driver;
import com.neeve.perf.serialization.Provider;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.stats.StatsLatencyWriter;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlTime;
import java.text.DecimalFormat;

public final class LocalMessageBusBinding
extends MessageBusBindingBase
implements Runnable {
    private final int _sender = this.hashCode();
    private final DecimalFormat _dfmt = new DecimalFormat("#,###");
    private final MessageAcknowledger _acknowledger = new MessageAcknowledger();
    private final StatsLatencyWriter.Stats _stats = new StatsLatencyWriter.Stats();
    private Provider<?> _provider;
    private long _serializedMessage;
    private int _serializedMessageLength;
    private String _encoding;
    private int _count;
    private int _warmupTime;
    private int _rate;
    private boolean _emptyMessage;
    private String _injectorCPUAffinityMask;
    private boolean _promptToStart;
    private long _start;
    private boolean _warmupCompleted;
    private int _warmupCount;
    private int _postWarmupCount;
    private long _postWarmupStart;
    private int _postWarmupRate;
    private int _numReceived;
    private volatile boolean _warmupDone;
    private volatile boolean _done;

    LocalMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws Exception {
        super(null, userName, descriptor, eventHandler);
    }

    private final IONativePacket prepareSerializedDataMessage(IONativePacket packet) {
        packet.init(this._serializedMessage, 0, this._serializedMessageLength);
        return packet;
    }

    private final void receiveData(IONativePacket packet, MessageChannel channel, boolean isChannelGuaranteed) {
        long now = UtlTime.now();
        this.onMessage(channel, this.wrap(packet, this._provider.vfid(), this._provider.otype(), this._provider.encoding(), this._sender, 0, 0L, 0L, null, null, null, 0L, 0L, now, now), (IEventAcknowledger)(isChannelGuaranteed ? this._acknowledger : null));
    }

    private final IONativePacket prepareSerializedFinalMessage(IONativePacket packet) {
        FinalMessage message = FinalMessage.create();
        Throughput throughput = Throughput.create();
        throughput.setPostWarmup(this._postWarmupRate);
        message.setThroughput(throughput);
        Latencies latencies = Latencies.create();
        LatencyType w2w = LatencyType.create();
        w2w.setMean(this._stats.avgo);
        w2w.setPct50(this._stats.pct50);
        w2w.setPct99(this._stats.pct99);
        latencies.setW2w(w2w);
        message.setLatencies(latencies);
        this._serializedMessageLength = message.serializeTo(this._serializedMessage, 0);
        packet.init(this._serializedMessage, 0, this._serializedMessageLength);
        return packet;
    }

    private final void receiveFinal(IONativePacket packet, MessageChannel channel, boolean isChannelGuaranteed) {
        long now = UtlTime.now();
        this.onMessage(channel, this.wrap(packet, (short)-3, (short)1, 4, this._sender, 0, 0L, 0L, null, null, null, 0L, 0L, now, now), (IEventAcknowledger)(isChannelGuaranteed ? this._acknowledger : null));
    }

    final void send(LocalMessageChannel source, MessageView view) throws SmaException {
        try {
            long preWireTs = UtlTime.now();
            view.setPostWireSendTs(preWireTs);
            view.setPreWireTs(preWireTs);
            LatencyRecorder.recordW2w(view.getPreWireTs() - view.getPostWireTs());
            ++this._numReceived;
            if (this._numReceived == this._warmupCount) {
                this._warmupDone = true;
            }
            if (this._numReceived == this._count) {
                long stop = UtlTime.now();
                LatencyRecorder.stop(this._count - this._postWarmupCount, this._stats);
                this._postWarmupRate = (int)((long)this._postWarmupCount * 1000000000L / (stop - this._postWarmupStart));
                System.out.println("Processed " + this._dfmt.format(this._postWarmupCount) + " messages @ " + this._dfmt.format(this._postWarmupRate) + " msgs/sec post warmup.");
                System.out.println("Run complete (run rumi-reporter on latencies.*.bin to calculate latency stats)");
                this._done = true;
            }
            if (source.getQos() == MessageChannel.Qos.Guaranteed) {
                source.onStable(view);
            }
        }
        catch (Throwable e) {
            throw new SmaException(e);
        }
    }

    protected final void doOpen() throws SmaException {
        this._provider = Driver.getProvider((String)this.descriptor.getProviderConfig().getProperty("encoding", "protobuf.serial"));
        this._count = Integer.parseInt(this.descriptor.getProviderConfig().getProperty("count", "10000000"));
        this._warmupTime = Integer.parseInt(this.descriptor.getProviderConfig().getProperty("warmup_time", "2"));
        this._rate = Integer.parseInt(this.descriptor.getProviderConfig().getProperty("rate", "100000"));
        this._warmupCount = this._rate * this._warmupTime;
        this._emptyMessage = Boolean.parseBoolean(this.descriptor.getProviderConfig().getProperty("empty_message", "false"));
        this._injectorCPUAffinityMask = this.descriptor.getProviderConfig().getProperty("injector_cpu_affinity_mask", null);
        if (this._injectorCPUAffinityMask != null && this._injectorCPUAffinityMask.equalsIgnoreCase("null")) {
            this._injectorCPUAffinityMask = null;
        }
        this._promptToStart = Boolean.parseBoolean(this.descriptor.getProviderConfig().getProperty("prompt_to_start", "false"));
        this._serializedMessage = IOBuffer.allocateMemoryBlock((long)1024L, (boolean)false);
        this._serializedMessageLength = ((IRogMessage)this._provider.create(!this._emptyMessage)).serializeTo(this._serializedMessage, 0);
        LatencyRecorder.noWrite(Boolean.parseBoolean(this.descriptor.getProviderConfig().getProperty("lw_nowrite", "false")));
        LatencyRecorder.printIntervalStats(Boolean.parseBoolean(this.descriptor.getProviderConfig().getProperty("lw_print_interval_stats", "false")));
    }

    protected final MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        return new LocalMessageChannel(descriptor, this);
    }

    protected final void doStart() throws SmaException {
        new Thread(this).start();
    }

    protected final void doFlush() throws SmaException {
    }

    protected final boolean doCanFail() {
        return true;
    }

    protected final boolean doAcksRequireFlush() {
        return false;
    }

    protected final void doClose() throws SmaException {
    }

    @Override
    public final void run() {
        try {
            LocalMessageChannel clientChannel;
            System.out.println("Driver Parameters {");
            System.out.println("...Encoding=" + this._provider.name());
            System.out.println("...Count=" + this._count);
            System.out.println("...Warmup Time=" + this._warmupTime);
            System.out.println("...Rate=" + this._rate);
            System.out.println("...EmptyMessage=" + this._emptyMessage);
            System.out.println("...Affinity=" + this._injectorCPUAffinityMask);
            if (this._injectorCPUAffinityMask != null) {
                UtlThread.setCPUAffinityMask((String)this._injectorCPUAffinityMask);
            }
            if (this._promptToStart) {
                System.out.println("Please start the backup and press any key to continue...");
                System.in.read();
            }
            boolean isClientChannelGuaranteed = (clientChannel = (LocalMessageChannel)this.getMessageChannel("client")).getQos() == MessageChannel.Qos.Guaranteed;
            LocalMessageChannel controlChannel = (LocalMessageChannel)this.getMessageChannel("control");
            boolean isControlChannelGuaranteed = controlChannel.getQos() == MessageChannel.Qos.Guaranteed;
            int i = 0;
            IONativePacket packet = new IONativePacket();
            this._start = UtlTime.now();
            long nanosPerMsg = this._rate > 0 ? 1000000000L / (long)this._rate : 0L;
            long next = this._start + nanosPerMsg;
            LatencyRecorder.start(this._rate, this._count);
            while (i < this._count) {
                long current = UtlTime.now();
                if (current < next) continue;
                this.receiveData(this.prepareSerializedDataMessage(packet), (MessageChannel)clientChannel, isClientChannelGuaranteed);
                next += nanosPerMsg;
                ++i;
                if (this._warmupCompleted) {
                    ++this._postWarmupCount;
                    continue;
                }
                if (i != this._warmupCount) continue;
                while (!this._warmupDone) {
                }
                this._postWarmupStart = UtlTime.now();
                this._warmupCompleted = true;
            }
            while (!this._done) {
            }
            this.receiveFinal(this.prepareSerializedFinalMessage(packet), (MessageChannel)controlChannel, isControlChannelGuaranteed);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private final class MessageAcknowledger
    extends MessageBusBindingBase.Acknowledger<MessageAcknowledger> {
        MessageAcknowledger() {
            super((MessageBusBindingBase)LocalMessageBusBinding.this);
        }

        protected final void doAck() {
        }

        protected final void doReset() {
        }
    }
}

