/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkFactory;
import com.neeve.link.LnkSynchronousConnector;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.tools.interactive.commands.Join;
import com.neeve.tools.interactive.commands.Links;

public final class Connect
extends Command {
    private final LnkContainer container;
    private final Links links;
    private final Join join;

    public Connect(LnkContainer container, Links links, Join join) {
        this.container = container;
        this.links = links;
        this.join = join;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processConnect(String descriptor, int timeout) {
        System.out.println("Establishing link [descriptor='" + descriptor + "'] (timeout=" + timeout + ")...");
        ILnkClientEndpoint cep = null;
        ILnkPeerEndpoint pep = null;
        try {
            cep = LnkFactory.getInstance().createClientEndpoint(this.container.touch(descriptor), null);
            pep = LnkSynchronousConnector.create().run(cep, timeout);
            this.join.run(new String[]{pep.getName()});
            System.out.println("Successfully established link [name='" + pep.getName() + "'].");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("Failure [" + e.toString() + "].");
        }
        finally {
            if (pep == null && cep != null) {
                try {
                    cep.close();
                }
                catch (Exception e) {
                    System.out.println("Failed to close link client endpoint [" + e.toString() + "]");
                }
            }
        }
        return false;
    }

    public final void run(String[] args) {
        if (args.length != 2) {
            System.out.println("Syntax error: connect <descriptor> <timeout>");
        } else if (this.processConnect(args[0], Integer.parseInt(args[1]))) {
            this.links.run(new String[0]);
        }
    }

    public final void help() {
        System.out.println("connect <descriptor> <timeout>");
        System.out.println("  Establish a link connection using a link descriptor.");
    }

    public final String[] keywords() {
        return new String[]{"connect"};
    }
}

