/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoByteField;
import com.neeve.sto.StoField;
import java.nio.ByteBuffer;

public final class StoBooleanField
extends StoField {
    private boolean val;

    private StoBooleanField(String name) {
        super(StoField.Type.BOOLEAN, name);
    }

    private StoBooleanField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        StoBooleanField.put(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoBooleanField.put(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferDetach() {
        if (!this.val) {
            this.val = StoBooleanField.get(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = false;
    }

    @Override
    protected final int getSerializedLength() {
        return 1;
    }

    @Override
    protected final String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        return this.getValue() == ((StoBooleanField)other).getValue();
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        ((StoBooleanField)clonee).setValue(this.getValue());
    }

    public static StoBooleanField create(String name) {
        return new StoBooleanField(name);
    }

    public static StoBooleanField create(ByteBuffer buffer, int bufferOffset) {
        return new StoBooleanField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 1;
    }

    public static void put(ByteBuffer buffer, int offset, boolean val) {
        StoByteField.put(buffer, offset, (byte)(val ? 1 : 0));
    }

    public static boolean get(ByteBuffer buffer, int offset) {
        return StoByteField.get(buffer, offset) > 0;
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        this.setValue(false);
    }

    public final void setValue(boolean val) {
        this.val = val;
        if (this.buffer != null) {
            StoBooleanField.put(this.buffer, this.bodyOffset, val);
        }
    }

    public final boolean getValue() {
        if (!this.val && this.buffer != null) {
            this.val = StoBooleanField.get(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

