/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.network;

import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.io.IOBuffer;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.network.LnkNwPeerEndpointStats;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktUtils;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlTime;

final class LnkNwPeerEndpointInputBuffer
extends UtlListElement {
    private final int id;
    private final Tracer tracer;
    private final String tracePrefix;
    private IOBuffer buffer;
    private final LnkNwPeerEndpointStats stats;
    private final int minBufferSize;
    private final int maxBufferSizeSoft;
    private final int maxBufferSizeHard;
    private final int maxReadSpinTime;
    private int readPos;
    private int meanReadSize;
    private final double meanReadSizeChangeLambda;
    private int meanPacketSize;
    private final double meanPacketSizeChangeLambda;
    private final boolean shouldShrink;
    private final double retainedOnShrinkage;
    private boolean stampInTs;

    LnkNwPeerEndpointInputBuffer(String name, int id, Tracer tracer, int minBufferSize, int maxBufferSizeSoft, int maxBufferSizeHard, int maxReadSpinTime, double meanReadSizeChangeLambda, double meanPacketSizeChangeLambda, boolean shouldShrink, int shrinkagePct, boolean stampInTs, LnkNwPeerEndpointStats stats) {
        this.id = id;
        this.tracer = tracer;
        this.tracePrefix = "[ibuf #" + id + "] ";
        this.stats = stats;
        this.minBufferSize = minBufferSize;
        this.maxBufferSizeSoft = maxBufferSizeSoft == 0 ? Integer.MAX_VALUE : maxBufferSizeSoft;
        this.maxBufferSizeHard = maxBufferSizeHard == 0 ? Integer.MAX_VALUE : maxBufferSizeHard;
        this.maxReadSpinTime = maxReadSpinTime;
        this.meanReadSize = 0;
        this.meanReadSizeChangeLambda = meanReadSizeChangeLambda;
        this.meanPacketSize = 0;
        this.meanPacketSizeChangeLambda = meanPacketSizeChangeLambda;
        this.shouldShrink = shouldShrink;
        this.stampInTs = stampInTs;
        this.retainedOnShrinkage = (double)(100 - shrinkagePct) / 100.0;
        this.buffer = this.allocateBuffer(minBufferSize);
        tracer.log("Network Link Endpoint Configuration (Input Buffer)...", Tracer.Level.CONFIG);
        tracer.log("....link=" + name, Tracer.Level.CONFIG);
        tracer.log("........id=" + this.id, Tracer.Level.CONFIG);
        tracer.log("........minBufferSize=" + this.minBufferSize, Tracer.Level.CONFIG);
        tracer.log("........maxBufferSize {soft=" + this.maxBufferSizeSoft + ", hard=" + this.maxBufferSizeHard + "}", Tracer.Level.CONFIG);
        tracer.log("........maxReadSpinTime=" + this.maxReadSpinTime, Tracer.Level.CONFIG);
        tracer.log("........meanReadSizeChangeLambda=" + this.meanReadSizeChangeLambda, Tracer.Level.CONFIG);
        tracer.log("........meanPacketSizeChangeLambda=" + this.meanPacketSizeChangeLambda, Tracer.Level.CONFIG);
        tracer.log("........shouldShrink=" + shouldShrink, Tracer.Level.CONFIG);
        tracer.log("........retainedOnShrinkage=" + (int)(this.retainedOnShrinkage * 100.0) + "%", Tracer.Level.CONFIG);
        tracer.log("........stampInTs=" + stampInTs, Tracer.Level.CONFIG);
    }

    final void enableIOTimestamps(boolean enabled) {
        this.stampInTs = enabled;
    }

    private final IOBuffer allocateBuffer(int size) {
        size = IOBuffer.slabSize((int)size);
        IOBuffer buffer = IOBuffer.create((int)size);
        this.stats.inputBufSize = size;
        ++this.stats.numInputBufAllocs;
        this.stats.numInputBufBytesAllocated += (long)size;
        return buffer;
    }

    private final int read(IOBuffer buffer, int readStartPos, IEmxNwLnkPeerEndpoint pep, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        int readPos = readStartPos;
        int totalBytesRead = 0;
        long startTime = 0L;
        while (buffer.getLength() > readPos) {
            long currentTime;
            int bytesRead = pep.read(buffer, readPos, waitCond);
            ++this.stats.numNetworkReads;
            readPos += bytesRead;
            totalBytesRead += bytesRead;
            if (bytesRead != 0) continue;
            if (totalBytesRead > 0) break;
            long l = currentTime = this.maxReadSpinTime > 0 ? UtlTime.now() : 0L;
            if (startTime == 0L) {
                startTime = currentTime;
            }
            if (currentTime - startTime < (long)this.maxReadSpinTime) continue;
            break;
        }
        return totalBytesRead;
    }

    private final int recalcBufferSize(int bytesRead, int numDeserialized, int remaining, int lastPacketSerializedSize, boolean fullBufferRead) {
        int bufferCapacity = this.buffer.getLength();
        int newSize = 0;
        if (lastPacketSerializedSize > bufferCapacity) {
            if (lastPacketSerializedSize > this.maxBufferSizeHard) {
                throw new RuntimeException("Inbound packet size is greater than the hard upper limit of the inbound buffer [packetSize=" + lastPacketSerializedSize + " maxBufferSize=" + this.maxBufferSizeHard + "]");
            }
            newSize = lastPacketSerializedSize;
            ++this.stats.numInputBufGrowths;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Insufficient space in buffer to accomodate packet. Expanding buffer (currentBufferSize=" + bufferCapacity + ", newBufferSize=" + newSize + ")...", Tracer.Level.DEBUG);
            }
        } else if (fullBufferRead && bufferCapacity < this.maxBufferSizeSoft) {
            newSize = Math.min(bufferCapacity + bytesRead, this.maxBufferSizeSoft);
            ++this.stats.numInputBufGrowths;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Sufficient space in buffer to accomodate packet but full buffer read. Expanding buffer...(currentBufferSize=" + bufferCapacity + ", newBufferSize=" + newSize + ").", Tracer.Level.DEBUG);
            }
        } else if ((this.shouldShrink || bufferCapacity > this.maxBufferSizeSoft) && numDeserialized > 0 && bufferCapacity > this.minBufferSize && (this.meanReadSize + remaining) * 2 < bufferCapacity && this.meanPacketSize * 2 < bufferCapacity && lastPacketSerializedSize * 2 < bufferCapacity) {
            newSize = Math.max(this.minBufferSize, (int)Math.ceil((double)bufferCapacity * this.retainedOnShrinkage));
            if (newSize == bufferCapacity) {
                newSize = 0;
            }
            ++this.stats.numInputBufShrinks;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Shrinking buffer...(currentBufferSize=" + bufferCapacity + ", newBufferSize=" + newSize + ")", Tracer.Level.DEBUG);
            }
        }
        return newSize;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int readDeserializeAndDispatch(IEmxNwLnkPeerEndpoint pep, IEmxDispatcher dispatcher, EmxNwLnkOpWaitCond waitCond, ILnkEventHandlerCore handler, Tracer packetTracer) throws Exception {
        int lastPacketSerializedSize;
        int numDeserialized;
        int pos;
        int remaining;
        int bytesRead;
        boolean fullBufferRead;
        block22: {
            long preReadTs;
            long l = preReadTs = this.stampInTs ? UtlTime.now() : 0L;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Reading from network [pos=" + this.readPos + " capacity=" + this.buffer.getLength() + " remaining=" + (this.buffer.getLength() - this.readPos) + "]...", Tracer.Level.DEBUG);
            }
            boolean bl = fullBufferRead = this.readPos + (bytesRead = this.read(this.buffer, this.readPos, pep, waitCond)) == this.buffer.getLength();
            if (this.stampInTs) {
                this.stats.r.add((double)(UtlTime.now() - preReadTs));
            }
            ++this.stats.numReads;
            this.stats.numBytesRead += (long)bytesRead;
            if (bytesRead > 0) {
                this.meanReadSize = this.meanReadSize == 0 ? bytesRead : (int)Math.ceil(this.meanReadSizeChangeLambda * (double)bytesRead + (1.0 - this.meanReadSizeChangeLambda) * (double)this.meanReadSize);
                this.stats.meanReadSize = this.meanReadSize;
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Read complete [bytesRead=" + bytesRead + "(" + this.meanReadSize + ") fullBufferRead=" + fullBufferRead + "]", Tracer.Level.DEBUG);
            }
            remaining = this.readPos + bytesRead;
            pos = 0;
            numDeserialized = 0;
            Exception failure = null;
            try {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Deserializing [pos=" + pos + " remaining=" + remaining + "]...", Tracer.Level.DEBUG);
                }
                while ((lastPacketSerializedSize = PktHeader.getSerializedPacketLength(this.buffer, pos, remaining)) > 0 && lastPacketSerializedSize <= remaining) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Serialized packet size in buffer is " + lastPacketSerializedSize + ".", Tracer.Level.DEBUG);
                    }
                    long ts = this.stampInTs ? UtlTime.now() : 0L;
                    PktPacket packet = PktFactory.getInstance().createPacket(PktHeader.getBodyType(this.buffer, pos));
                    packet.deserialize(this.buffer, pos, false);
                    ++numDeserialized;
                    ++this.stats.numPacketsRead;
                    this.meanPacketSize = this.meanPacketSize == 0 ? lastPacketSerializedSize : (int)Math.ceil(this.meanPacketSizeChangeLambda * (double)lastPacketSerializedSize + (1.0 - this.meanPacketSizeChangeLambda) * (double)this.meanPacketSize);
                    this.stats.meanPacketSize = this.meanPacketSize;
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Packet deserialized [packetSize=" + lastPacketSerializedSize + "(" + this.meanPacketSize + ")]", Tracer.Level.DEBUG);
                    }
                    if (packetTracer.debug) {
                        packetTracer.log("[PTRACE.NWL<-] " + (Object)((Object)packet.getHeader()), Tracer.Level.DEBUG);
                    }
                    pos += lastPacketSerializedSize;
                    remaining -= lastPacketSerializedSize;
                    if (handler != null) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Dispatching packet...", Tracer.Level.DEBUG);
                        }
                        handler.onEvent(dispatcher, 5, (Object)packet);
                    }
                    if (!this.tracer.debug) continue;
                    this.tracer.log(this.tracePrefix + "Deserializing [pos=" + pos + " remaining=" + remaining + "]...", Tracer.Level.DEBUG);
                }
                if (!this.tracer.debug) break block22;
            }
            catch (Exception e) {
                try {
                    PktUtils.dumpCorruptedSerializedPacket(this.tracePrefix + " Error deserializing packet from network link [" + e.getMessage() + "]", this.buffer.getBufferUnsafe(), pos, pos + remaining, e, this.tracer);
                    failure = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Deserialized " + numDeserialized + " packets (failure=" + failure + ")...", Tracer.Level.DEBUG);
                    }
                    throw throwable;
                }
            }
            this.tracer.log(this.tracePrefix + "Deserialized " + numDeserialized + " packets (failure=" + failure + ")...", Tracer.Level.DEBUG);
        }
        int newSize = this.recalcBufferSize(bytesRead, numDeserialized, remaining, lastPacketSerializedSize, fullBufferRead);
        IOBuffer newBuffer = null;
        if (newSize > 0) {
            newBuffer = this.allocateBuffer(newSize);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Allocated new buffer [oldSize=" + this.buffer.getLength() + " newSize=" + newSize + "(" + newBuffer.getLength() + ")]", Tracer.Level.DEBUG);
            }
        } else {
            newBuffer = this.buffer;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Continuing with existing buffer.", Tracer.Level.DEBUG);
            }
        }
        if (remaining > 0) {
            IOBuffer.copy((long)this.buffer.getNativeAddress(), (int)pos, (long)newBuffer.getNativeAddress(), (int)0, (int)remaining);
        }
        this.stats.numInputBufBytesCompacted += (long)remaining;
        if (this.buffer != newBuffer) {
            this.buffer.dispose();
        }
        this.buffer = newBuffer;
        this.readPos = remaining;
        return numDeserialized;
    }
}

