/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.ucx;

import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkClosedGracefullyException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwReadReadyEvent;
import com.neeve.emx.IEmxNwWriteReadyEvent;
import com.neeve.emx.ucx.EmxUcx;
import com.neeve.emx.ucx.EmxUcxObject;
import com.neeve.io.IOBuffer;
import com.neeve.trace.Tracer;

public final class EmxUcxNwLnkPeerEndpoint
extends EmxUcxObject
implements IEmxNwLnkPeerEndpoint {
    private final long ep;
    private boolean closed;
    private static final int MAX_BUFFERS_IN_VECTORED_WRITES = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EmxUcxNwLnkPeerEndpoint(long ep, boolean accepted) throws Exception {
        this.ep = ep;
        if (accepted) {
            this.readInternal(new IEmxNwLnkPeerEndpoint.IDataReceiver(){

                @Override
                public final void onData(long buffer, int offset, int length) {
                    if (((EmxUcxNwLnkPeerEndpoint)EmxUcxNwLnkPeerEndpoint.this).tracer.debug) {
                        EmxUcxNwLnkPeerEndpoint.this.tracer.log("Received " + length + " bytes in handshake", Tracer.Level.DEBUG);
                    }
                }
            });
        } else {
            IOBuffer buffer = IOBuffer.create((int)0);
            try {
                long written = this.writeInternal(buffer, 0, buffer.getCapacity());
                if (this.tracer.debug) {
                    this.tracer.log("Sent " + written + " bytes in handshake", Tracer.Level.DEBUG);
                }
            }
            finally {
                buffer.dispose();
            }
        }
    }

    private final void readInternal(IEmxNwLnkPeerEndpoint.IDataReceiver receiver) throws EEmxNwLnkOpFailedException {
        EmxUcx.registerDataReceiver(this.ep, receiver);
        try {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Reading...", Tracer.Level.DEBUG);
                }
                EmxUcx.recv(this.ep);
            }
            catch (Exception e) {
                if (this.tracer.fine) {
                    this.tracer.log("Read failed [" + e.toString() + "]", Tracer.Level.FINE);
                }
                throw new EEmxNwLnkOpFailedException(e);
            }
        }
        finally {
            EmxUcx.deregisterDataReceiver(this.ep);
        }
    }

    private final long writeInternal(IOBuffer buffer, int offset, int len) throws EEmxNwLnkOpFailedException {
        if (len <= 0) {
            return 0L;
        }
        try {
            if (this.tracer.debug) {
                this.tracer.log("Writing " + len + " bytes...", Tracer.Level.DEBUG);
            }
            EmxUcx.send(this.ep, buffer.getNativeAddress(), offset, len);
        }
        catch (Exception e) {
            if (this.tracer.fine) {
                this.tracer.log("Write failed [" + e.toString() + "]", Tracer.Level.FINE);
            }
            throw new EEmxNwLnkOpFailedException(e);
        }
        return len;
    }

    private final void closeInternal() {
        EmxUcx.destroyEndpoint(this.ep);
    }

    @Override
    public final boolean usingNativeIO() {
        return true;
    }

    @Override
    public final void configureBlocking(boolean blocking) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (!blocking) {
                throw new UnsupportedOperationException("non-blocking IO is not supported");
            }
        } else {
            throw new EEmxInvalidStateException("configureBlocking", "closed");
        }
    }

    @Override
    public final boolean isBlocking() throws EEmxInvalidStateException {
        if (!this.closed) {
            return true;
        }
        throw new EEmxInvalidStateException("isBlocking", "closed");
    }

    @Override
    public final boolean supportReadUsingDataReceiver() {
        return true;
    }

    @Override
    public final boolean performsDatagramTransfer() {
        return true;
    }

    @Override
    public final int read(IOBuffer buffer, int offset, int len, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkClosedGracefullyException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            throw new UnsupportedOperationException();
        }
        throw new EEmxInvalidStateException("read", "closed");
    }

    @Override
    public final int read(IOBuffer buffer, int offset, int len) throws EEmxInvalidStateException, EEmxNwLnkClosedGracefullyException, EEmxNwLnkOpFailedException {
        return this.read(buffer, offset, len, null);
    }

    @Override
    public final int read(IOBuffer buffer, int offset, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkClosedGracefullyException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            return this.read(buffer, offset, buffer.getLength() - offset, waitCond);
        }
        throw new EEmxInvalidStateException("read", "closed");
    }

    @Override
    public final int read(IOBuffer buffer, int offset) throws EEmxInvalidStateException, EEmxNwLnkClosedGracefullyException, EEmxNwLnkOpFailedException {
        return this.read(buffer, offset, buffer.getLength() - offset, null);
    }

    @Override
    public final void read(IEmxNwLnkPeerEndpoint.IDataReceiver receiver) throws EEmxInvalidStateException, EEmxNwLnkClosedGracefullyException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (receiver == null) {
                throw new IllegalArgumentException("receiver cannot be null");
            }
        } else {
            throw new EEmxInvalidStateException("read", "closed");
        }
        this.readInternal(receiver);
    }

    @Override
    public final IEmxNwReadReadyEvent getReadReadyEvent() {
        return null;
    }

    @Override
    public final long write(IOBuffer buffer, int offset, int len, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (waitCond != null) {
                throw new UnsupportedOperationException("non-blocking IO is not supported");
            }
            return this.writeInternal(buffer, offset, len);
        }
        throw new EEmxInvalidStateException("write", "closed");
    }

    @Override
    public final long write(IOBuffer buffer, int offset, int len) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        return this.write(buffer, offset, len, null);
    }

    @Override
    public final long write(IOBuffer[] buffers, int[] offsets, int[] lens, int count, EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (count > 16) {
                throw new IllegalArgumentException("number of buffers cannot exceed 16");
            }
            if (buffers == null) {
                throw new IllegalArgumentException("buffers cannot be null");
            }
            if (buffers.length < count) {
                throw new IllegalArgumentException("buffers length is less than count");
            }
            if (offsets == null) {
                throw new IllegalArgumentException("offsets cannot be null");
            }
            if (offsets.length < count) {
                throw new IllegalArgumentException("offsets length is less than count");
            }
            if (lens == null) {
                throw new IllegalArgumentException("lens cannot be null");
            }
            if (lens.length < count) {
                throw new IllegalArgumentException("lens length is less than count");
            }
            throw new UnsupportedOperationException();
        }
        throw new EEmxInvalidStateException("write", "closed");
    }

    @Override
    public final long write(IOBuffer[] buffers, int[] offsets, int[] lens, int count) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        return this.write(buffers, offsets, lens, count, null);
    }

    @Override
    public final IEmxNwWriteReadyEvent getWriteReadyEvent() {
        return null;
    }

    @Override
    public void close() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            if (this.tracer.fine) {
                this.tracer.log("Closing UCX network link peer endpoint...", Tracer.Level.FINE);
            }
            try {
                this.closeInternal();
            }
            catch (Exception e) {
                this.tracer.log("Failure in closing UCX network link peer endpoint [" + e.toString() + "].", Tracer.Level.WARNING);
            }
            finally {
                this.closed = true;
            }
        }
    }
}

