/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.util.concurrent.atomic.AtomicLong;

public final class UtlConcurrentRingBuffer<T> {
    private final T[] buffer;
    private final AtomicLong head;
    private final AtomicLong tail;
    private final AtomicLong numFulls;
    private volatile boolean waiting;

    private UtlConcurrentRingBuffer(int size, ItemFactory<T> factory) {
        this.buffer = factory.createItemArray(size);
        for (int i = 0; i < size; ++i) {
            this.buffer[i] = factory.createItem();
        }
        this.head = new AtomicLong(0L);
        this.tail = new AtomicLong(0L);
        this.numFulls = new AtomicLong(0L);
    }

    public static <T> UtlConcurrentRingBuffer<T> create(int size, ItemFactory<T> factory) {
        if (size <= 0) {
            throw new IllegalArgumentException("size must be > 0");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        return new UtlConcurrentRingBuffer<T>(size, factory);
    }

    public final boolean hasSpace() {
        return this.length() < this.buffer.length;
    }

    public final long head() {
        return this.head.get();
    }

    public final long tail() {
        return this.tail.get();
    }

    public final int size() {
        return this.buffer.length;
    }

    public final int length() {
        return (int)(this.head.get() - this.tail.get());
    }

    public final T get(long slot) {
        if (this.head.get() != slot && this.tail.get() != slot) {
            throw new IllegalArgumentException("slot must be value returned by nextWrite() or nextRead()");
        }
        return this.buffer[(int)(slot % (long)this.buffer.length)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long nextWrite() {
        while (!this.hasSpace()) {
            this.numFulls.incrementAndGet();
            this.waiting = true;
            try {
                UtlConcurrentRingBuffer utlConcurrentRingBuffer = this;
                synchronized (utlConcurrentRingBuffer) {
                    while (!this.hasSpace()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    continue;
                }
            }
            finally {
                this.waiting = false;
                continue;
            }
            break;
        }
        return this.head.get();
    }

    public final void write(long slot) {
        if (this.head.get() != slot) {
            throw new IllegalArgumentException("slow must be value returned by next()");
        }
        this.head.incrementAndGet();
    }

    public final long nextRead() {
        if (this.length() == 0) {
            return -1L;
        }
        return this.tail.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(long slot) {
        if (this.tail.get() != slot) {
            throw new IllegalArgumentException("slot must be value returned by nextRead()");
        }
        this.tail.incrementAndGet();
        if (this.waiting) {
            UtlConcurrentRingBuffer utlConcurrentRingBuffer = this;
            synchronized (utlConcurrentRingBuffer) {
                this.notify();
            }
        }
    }

    public final long numFulls() {
        return this.numFulls.get();
    }

    public static interface ItemFactory<T> {
        public T createItem();

        public T[] createItemArray(int var1);
    }
}

