/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config.impl;

import com.neeve.config.EConfigException;
import com.neeve.config.IConfigComplexEntity;
import com.neeve.config.IConfigComplexEntityContainer;
import com.neeve.config.IConfigContentNode;
import com.neeve.config.IConfigRepository;
import com.neeve.config.impl.ConfigEntityBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class ConfigComplexEntityBase
extends ConfigEntityBase
implements IConfigComplexEntity {
    protected final Map<String, Properties> propsets = new HashMap<String, Properties>();

    protected ConfigComplexEntityBase(IConfigRepository repository, String name, IConfigComplexEntityContainer container) {
        super(repository, name, container);
    }

    private final Properties getPropset(String setname, boolean create) {
        if (setname == null) {
            throw new IllegalArgumentException("property set name cannot be null");
        }
        Properties propset = this.propsets.get(setname);
        if (propset == null && create) {
            propset = new Properties();
            this.propsets.put(setname, propset);
        }
        return propset;
    }

    @Override
    public final IConfigComplexEntity setProperties(String setname, Properties props) {
        if (props == null) {
            this.getPropset(setname, true).clear();
        } else {
            this.getPropset(setname, true).putAll((Map<?, ?>)props);
        }
        this.setDirty(true);
        return this;
    }

    @Override
    public final Properties getProperties(String setname) {
        return this.getPropset(setname, false);
    }

    @Override
    public final IConfigComplexEntity setProperty(String setname, String propname, String propval) {
        if (propname == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        if (propval == null) {
            this.getPropset(setname, true).remove(propname);
        } else {
            this.getPropset(setname, true).setProperty(propname, propval);
        }
        this.setDirty(true);
        return this;
    }

    @Override
    public final String getProperty(String setname, String propname, String defval) {
        if (propname == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        Properties props = this.getPropset(setname, false);
        return props == null ? null : props.getProperty(propname, defval);
    }

    @Override
    public final Iterator<String> names() {
        return this.propsets.keySet().iterator();
    }

    @Override
    public final IConfigContentNode clear() {
        this.propsets.clear();
        this.setDirty(true);
        return this;
    }

    @Override
    public final void serialize(StringBuilder builder) {
        builder.append(this.propsets.size());
        for (String name : this.propsets.keySet()) {
            builder.append("%").append(name).append("(");
            UtlProps.serialize(this.propsets.get(name), builder);
            builder.append(")%");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deserialize(String str, boolean markAsDirty) throws EConfigException {
        if (this.tracer.debug) {
            this.tracer.log("Deserializing complex entity '" + this.getName() + "' from '" + str + "'...", Tracer.Level.DEBUG);
        }
        boolean dirty = this.isDirty();
        try {
            int propsetStartMarkerPos = str.indexOf(37, 0);
            int count = 0;
            if (propsetStartMarkerPos >= 0) {
                count = Integer.valueOf(str.substring(0, propsetStartMarkerPos));
            }
            if (this.tracer.debug) {
                this.tracer.log("Number of propsets=" + count, Tracer.Level.DEBUG);
            }
            int propsetEndMarkerPos = 0;
            for (int i = 0; i < count; ++i) {
                int propsetContentStartMarkerPos = str.indexOf(40, propsetStartMarkerPos);
                if (propsetContentStartMarkerPos < 0) {
                    throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
                }
                int propsetContentEndMarkerPos = str.indexOf(41, propsetContentStartMarkerPos);
                if (propsetContentEndMarkerPos < 0) {
                    throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
                }
                String name = str.substring(propsetStartMarkerPos + 1, propsetContentStartMarkerPos);
                if (this.tracer.debug) {
                    this.tracer.log("Found propset with name '" + name + "'", Tracer.Level.DEBUG);
                }
                this.setProperties(name, UtlProps.deserialize(str.substring(propsetContentStartMarkerPos + 1, propsetContentEndMarkerPos)));
                if (this.tracer.debug) {
                    this.tracer.log("Deserialized propset '" + name + "'" + this.getProperties(name) + "'.", Tracer.Level.DEBUG);
                }
                if ((propsetEndMarkerPos = str.indexOf(37, propsetStartMarkerPos + 1)) < 0) {
                    throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
                }
                propsetStartMarkerPos = str.indexOf(37, propsetEndMarkerPos + 1);
                if (i >= count - 1 || propsetStartMarkerPos >= 0) continue;
                throw new IllegalArgumentException("Supplied string is not a valid serialized repository");
            }
            this.setDirty(dirty || markAsDirty);
        }
        catch (Throwable throwable) {
            this.setDirty(dirty || markAsDirty);
            throw throwable;
        }
    }

    @Override
    public final String toString() {
        return "[ComplexEntity] <" + super.toString() + ">";
    }
}

