/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.serialization.rumi.quark.serial;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XIntIterator;
import com.neeve.lang.XIntSequence;
import com.neeve.lang.XIterator;
import com.neeve.lang.XStringDeserializer;
import com.neeve.perf.serialization.Provider;
import com.neeve.perf.serialization.rumi.quark.Acceleration;
import com.neeve.perf.serialization.rumi.quark.BooleanType;
import com.neeve.perf.serialization.rumi.quark.Car;
import com.neeve.perf.serialization.rumi.quark.Code;
import com.neeve.perf.serialization.rumi.quark.Engine;
import com.neeve.perf.serialization.rumi.quark.FuelFigure;
import com.neeve.perf.serialization.rumi.quark.OptionalExtras;
import com.neeve.perf.serialization.rumi.quark.PerformanceFigure;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlTime;
import java.io.UnsupportedEncodingException;

public class CarBenchmark
implements Provider<Car> {
    private static final byte[] MANUFACTURER;
    private static final byte[] MODEL;
    private static final byte[] ENG_MAN_CODE;
    private static final byte[] VEHICLE_CODE;
    private static final int[] SOME_NUMBERS;
    private static final OptionalExtras[] EXTRAS;
    private final Car.Serializer carSerializer = Car.Serializer.create();
    private final Car.Deserializer carDeserializer = Car.Deserializer.create();
    private final CarDeserializationCallback cb = new CarDeserializationCallback();
    private final IOBuffer encodeBuffer = IOBuffer.create((int)1024);
    private int encodedLength;
    private final IOBuffer decodeBuffer = IOBuffer.create((int)1024);
    private final int decodeLength = this.serializeTo(this.decodeBuffer);

    public static final int serializeTo(Car.Serializer carSerializer) {
        carSerializer.block2().code(Code.A).modelYear((short)2005).serialNumber(12345).available(BooleanType.T).vehicleCode(VEHICLE_CODE);
        carSerializer.someNumbers(SOME_NUMBERS).extras(EXTRAS);
        Engine.Serializer engineSerializer = carSerializer.engine();
        engineSerializer.block1().capacity((short)4200).numCylinders((byte)8).manufacturerCode(ENG_MAN_CODE);
        engineSerializer.done();
        FuelFigure.Serializer fuelFigureSerializer = carSerializer.fuelFigure();
        fuelFigureSerializer.block1().speed((short)30).mpg(35.9f);
        fuelFigureSerializer.done();
        fuelFigureSerializer = carSerializer.fuelFigure();
        fuelFigureSerializer.block1().speed((short)55).mpg(49.0f);
        fuelFigureSerializer.done();
        fuelFigureSerializer.block1().speed((short)75).mpg(40.0f);
        fuelFigureSerializer.done();
        PerformanceFigure.Serializer performanceFigureSerializer = carSerializer.performanceFigure().octaneRating((byte)95);
        Acceleration.Serializer accelerationSerializer = performanceFigureSerializer.acceleration();
        accelerationSerializer.block1().mph((short)30).seconds(4.0f);
        accelerationSerializer.done();
        accelerationSerializer = performanceFigureSerializer.acceleration();
        accelerationSerializer.block1().mph((short)60).seconds(7.5f);
        accelerationSerializer.done();
        accelerationSerializer = performanceFigureSerializer.acceleration();
        accelerationSerializer.block1().mph((short)100).seconds(12.2f);
        accelerationSerializer.done();
        performanceFigureSerializer.done();
        performanceFigureSerializer = carSerializer.performanceFigure().octaneRating((byte)99);
        accelerationSerializer = performanceFigureSerializer.acceleration();
        accelerationSerializer.block1().mph((short)30).seconds(3.8f);
        accelerationSerializer.done();
        accelerationSerializer = performanceFigureSerializer.acceleration();
        accelerationSerializer.block1().mph((short)60).seconds(7.1f);
        accelerationSerializer.done();
        accelerationSerializer = performanceFigureSerializer.acceleration();
        accelerationSerializer.block1().mph((short)100).seconds(11.8f);
        accelerationSerializer.done();
        performanceFigureSerializer.done();
        return carSerializer.manufacturer(MANUFACTURER).model(MODEL).done();
    }

    public static final int serializeTo(Car.Serializer carSerializer, IOBuffer buffer) {
        return CarBenchmark.serializeTo(carSerializer.init(buffer));
    }

    private final int serializeTo(IOBuffer buffer) {
        return CarBenchmark.serializeTo(this.carSerializer, buffer);
    }

    private final int serializeTo(Car car) {
        return CarBenchmark.serializeTo(car.serializer(1024).timestamp(UtlTime.now()));
    }

    private final void deserializeFrom(IOBuffer buffer, int len) {
        this.carDeserializer.init(buffer, 0, len).run((Car.Deserializer.Callback)this.cb);
    }

    private final void deserializeFrom(Car car) {
        car.deserializer().run((Car.Deserializer.Callback)this.cb);
    }

    @Override
    public String name() {
        return "rumi.quark.serial";
    }

    @Override
    public short vfid() {
        return -1;
    }

    @Override
    public short otype() {
        return 1;
    }

    @Override
    public int encoding() {
        return 6;
    }

    @Override
    public Car create(boolean encode) {
        Car car = Car.create();
        if (encode) {
            this.encode(car);
        }
        return car;
    }

    @Override
    public void prepareToEncode() {
    }

    @Override
    public void encode(Car car) {
        this.encodedLength = this.serializeTo(car);
    }

    @Override
    public void encode() {
        this.encodedLength = this.serializeTo(this.encodeBuffer);
    }

    @Override
    public int encodedLength() {
        return this.encodedLength;
    }

    @Override
    public void postEncode() {
    }

    @Override
    public void prepareToDecode() {
    }

    @Override
    public void decode(Car car) {
        this.deserializeFrom(car);
    }

    @Override
    public void decode() {
        this.deserializeFrom(this.decodeBuffer, this.decodeLength);
    }

    @Override
    public int decodedLength() {
        return this.decodeLength;
    }

    @Override
    public void postDecode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long dispose(MessageView view) {
        Car car = (Car)view;
        try {
            this.cb.ts = 0L;
            this.decode(car);
            long l = this.cb.ts;
            return l;
        }
        finally {
            car.dispose();
        }
    }

    static {
        try {
            MANUFACTURER = "MANUFACTURER".getBytes("UTF-8");
            MODEL = "MODEL".getBytes("UTF-8");
            ENG_MAN_CODE = "abc".getBytes("UTF-8");
            VEHICLE_CODE = "abcdef".getBytes("UTF-8");
            SOME_NUMBERS = new int[]{0, 1, 2, 3, 4};
            EXTRAS = new OptionalExtras[]{OptionalExtras.sportsPack, OptionalExtras.sunRoof};
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static final class AccelerationDeserializationCallback
    implements Acceleration.Deserializer.Callback {
        private AccelerationDeserializationCallback() {
        }

        public void handleBlock1(Acceleration.Block1Deserializer val) {
            val.getMph();
            val.getSeconds();
        }
    }

    private static final class PerformanceFigureDeserializationCallback
    implements PerformanceFigure.Deserializer.Callback {
        private final AccelerationDeserializationCallback accelerationDeserializationCallback = new AccelerationDeserializationCallback();

        private PerformanceFigureDeserializationCallback() {
        }

        public final void handleOctaneRating(byte val) {
        }

        public final void handleAcceleration(Acceleration.Deserializer val) {
            val.run((Acceleration.Deserializer.Callback)this.accelerationDeserializationCallback);
        }
    }

    private static final class FuelFigureDeserializationCallback
    implements FuelFigure.Deserializer.Callback {
        private final byte[] tempBuffer = new byte[128];

        private FuelFigureDeserializationCallback() {
        }

        public final void handleBlock1(FuelFigure.Block1Deserializer val) {
            val.getSpeed();
            val.getMpg();
        }
    }

    private static final class EngineDeserializationCallback
    implements Engine.Deserializer.Callback {
        private final byte[] tempBuffer = new byte[128];

        private EngineDeserializationCallback() {
        }

        public final void handleBlock1(Engine.Block1Deserializer val) {
            val.getCapacity();
            val.getNumCylinders();
            val.getManufacturerCode().getTo(this.tempBuffer, 0);
        }
    }

    public static final class CarDeserializationCallback
    implements Car.Deserializer.Callback {
        private final byte[] tempBuffer = new byte[128];
        private final int[] tempIntBuffer = new int[128];
        private final EngineDeserializationCallback engineDeserializationCallback = new EngineDeserializationCallback();
        private final FuelFigureDeserializationCallback fuelFigureDeserializationCallback = new FuelFigureDeserializationCallback();
        private final PerformanceFigureDeserializationCallback performanceFigureDeserializationCallback = new PerformanceFigureDeserializationCallback();
        long ts;

        public void handleTimestamp(long val) {
            this.ts = val;
        }

        public void handleBlock2(Car.Block2Deserializer val) {
            val.getSerialNumber();
            val.getModelYear();
            val.getAvailable();
            val.getCode();
            val.getVehicleCode().getTo(this.tempBuffer, 0);
        }

        public void handleSomeNumbers(XIntSequence val) {
            XIntIterator iterator = val.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }

        public void handleExtras(Car.ExtrasDeserializer val) {
            XIterator iterator = val.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }

        public void handleEngine(Engine.Deserializer val) {
            val.run((Engine.Deserializer.Callback)this.engineDeserializationCallback);
        }

        public void handlePerformanceFigure(PerformanceFigure.Deserializer val) {
            val.run((PerformanceFigure.Deserializer.Callback)this.performanceFigureDeserializationCallback);
        }

        public void handleFuelFigure(FuelFigure.Deserializer val) {
            val.run((FuelFigure.Deserializer.Callback)this.fuelFigureDeserializationCallback);
        }

        public void handleManufacturer(XStringDeserializer val) {
            val.getTo(this.tempBuffer, 0);
        }

        public void handleModel(XStringDeserializer val) {
            val.getTo(this.tempBuffer, 0);
        }
    }
}

