/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.kafka;

import com.neeve.kafka.KafkaMessageBusBinding;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;

public final class KafkaMessageChannel
extends MessageChannelBase {
    private final KafkaMessageBusBinding binding;
    private final XString sendTopicBuilder = XString.create();
    private String[] filters;

    protected KafkaMessageChannel(MessageChannelDescriptor descriptor, KafkaMessageBusBinding binding) throws SmaException {
        super(null, descriptor, (MessageBusBindingBase)binding);
        this.binding = binding;
    }

    private final void subscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String topic = this.normalizeTopic(filter == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + filter : filter));
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Subscribing to topic '" + topic + "' (" + (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed ? "guaranteed" : "best effort") + ")...", Tracer.Level.DEBUG);
        }
        this.binding.subscribe(this, topic);
    }

    private final void unsubscribe(String filter, boolean topicStartsWithChannel) throws SmaException {
        String topic = this.normalizeTopic(filter == null ? this.getName() : (topicStartsWithChannel ? this.getName() + "/" + filter : filter));
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Unsubscribing from topic '" + topic + "' (" + (this.descriptor.getChannelQos() == MessageChannel.Qos.Guaranteed ? "guaranteed" : "best effort") + ")...", Tracer.Level.DEBUG);
        }
        this.binding.unsubscribe(this, topic);
    }

    private final XString resolveSendTopic(XString keyOrFilter, boolean topicStartsWithChannel) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Constructing topic using [keyOrFilter=" + keyOrFilter + ", topicStartsWithChannel=" + topicStartsWithChannel + "]...", Tracer.Level.DEBUG);
        }
        if (keyOrFilter == null || keyOrFilter.length() == 0) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is null. using static topic", Tracer.Level.DEBUG);
            }
            return this.getNameAsRaw();
        }
        if (topicStartsWithChannel) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic starts with channel. preparing topic...", Tracer.Level.DEBUG);
            }
            this.sendTopicBuilder.clear();
            this.sendTopicBuilder.append((CharSequence)this.descriptor.getName()).append((CharSequence)"/").append(keyOrFilter);
            return this.sendTopicBuilder;
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "...keyOrFilter is not null and topic does not starts with channel. using keyOrFilter as topic...", Tracer.Level.DEBUG);
        }
        return keyOrFilter;
    }

    private final String prepareSendTopic(MessageView view) throws SmaException {
        XString key = view.getMessageKeyAsRaw();
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (key == null && !topicStartsWithChannel) {
            throw new SmaException("send performed with null key but binding configured to not prepend topic with channel");
        }
        return this.normalizeTopic(this.resolveSendTopic(key, topicStartsWithChannel).getValue());
    }

    private final void checkAndAddReceivedChannelNameToTransportHeaders(MessageTransportHeaders transportHeaders, MessageMetadata metadata) {
        if (transportHeaders != null && this.getId() == Short.MAX_VALUE && metadata != null) {
            XString receivedMessageChannel = metadata.getMessageChannelNameAsRaw();
            if (receivedMessageChannel == null || receivedMessageChannel.isNull() || receivedMessageChannel.length() == 0) {
                transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, metadata.getMessageChannelId());
            } else {
                transportHeaders.addHeader(MessageBusBinding.TRANSPORT_HEADER_RECEIVED_CHANNEL, receivedMessageChannel);
            }
        }
    }

    final void onMessage(byte[] message, MessageMetadata metadata, MessageTransportHeaders transportHeaders, String topic, KafkaMessageBusBinding.KafkaAcknowledger acknowledger, long postWireTs) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received message (metadata=" + metadata + ")", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(message)), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
        }
        MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.d1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)message);
        long preDeserializeTs = MessageLatencyManager.captureMsgLatencyStats ? UtlTime.now() : 0L;
        this.checkAndAddReceivedChannelNameToTransportHeaders(transportHeaders, metadata);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Dispatching...", Tracer.Level.DEBUG);
        }
        this.onMessage(message, transportHeaders, metadata != null ? (short)metadata.getMessageViewFactory() : (short)39, metadata != null ? metadata.getMessageViewType() : (short)1, metadata != null ? (int)metadata.getMessageEncodingType() : 6, metadata != null ? metadata.getMessageSender() : 0, metadata != null ? metadata.getMessageFlow() : 0, metadata != null ? metadata.getMessageSno() : 0L, metadata != null ? metadata.getRequestId() : 0L, metadata != null ? metadata.getRequestorIdAsRaw() : null, XString.create((String)topic), acknowledger, 0L, 0L, postWireTs, preDeserializeTs);
    }

    final void onAckNack(MessageView view, Exception status) {
        this.onMessageStability(view, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doSend(MessageView view, int flags) throws SmaException {
        MessageMetadata metadata;
        block13: {
            block12: {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Received request to send message...", Tracer.Level.DEBUG);
                }
                MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
                if (MessageLatencyManager.captureMsgLatencyStats) {
                    view.setPreSerializeTs(UtlTime.now());
                }
                if (this.binding.rawMode()) break block12;
                metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
                switch (this.binding.getMetadataVersion()) {
                    case 2: {
                        metadata.serializeV2((byte)view.getMessageEncodingType(), view.getVfid(), view.getMessageType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw());
                        break block13;
                    }
                    case 3: {
                        metadata.serializeV3((byte)view.getMessageEncodingType(), view.getVfid(), view.getMessageType(), view.getMessageSender(), view.getMessageFlow(), view.getMessageSequenceNumber(), this.wireInfo.getChannelId(), this.wireInfo.getChannelNameAsRaw(), view.getRequestId(), view.getRequestorIdAsRaw());
                        break block13;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported metadata version [" + this.binding.getMetadataVersion() + "]");
                    }
                }
            }
            metadata = null;
        }
        try {
            byte[] serializedMessage = view.serializeToByteArray();
            String topic = this.prepareSendTopic(view);
            if (MessageLatencyManager.captureMsgLatencyStats) {
                view.setPostSerializeTs(UtlTime.now());
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.s2, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Publishing message. Message is " + serializedMessage.length + " bytes, metadata is " + metadata + ", topic is '" + topic + "'", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... ...preSerialize=" + view.getPreSerializeTs(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... ...postSerialize=" + view.getPostSerializeTs(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + UtlBuffer.dump((ByteBuffer)ByteBuffer.wrap(serializedMessage)).toString(), Tracer.Level.DEBUG);
                this.tracer.log(this.tracePrefix + "--------------------------------------------------", Tracer.Level.DEBUG);
            }
            boolean bl = this.binding.send(this, view, metadata, serializedMessage, topic, this.descriptor.getChannelQos(), flags);
            return bl;
        }
        finally {
            if (metadata != null) {
                metadata.dispose();
            }
        }
    }

    private final String normalizeTopic(String destination) {
        return destination.replace('/', '.');
    }

    protected final void doJoin(String[] filters, int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(filters != null && filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("join performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (filters == null || filters.length == 0) {
            this.subscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : filters) {
                this.subscribe(filter, topicStartsWithChannel);
            }
        }
        this.filters = filters;
    }

    protected final void doLeave(int flags) throws SmaException {
        boolean topicStartsWithChannel = this.binding.topicStartsWithChannel();
        if (!(this.filters != null && this.filters.length != 0 || topicStartsWithChannel)) {
            throw new SmaException("leave performed with null filter but binding configured to not prepend subscription with channel");
        }
        if (this.filters == null || this.filters.length == 0) {
            this.unsubscribe(null, topicStartsWithChannel);
        } else {
            for (String filter : this.filters) {
                this.unsubscribe(filter, topicStartsWithChannel);
            }
        }
    }

    protected final void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing channel...", Tracer.Level.DEBUG);
        }
        this.binding.onChannelClose(this);
    }

    public final String getType() {
        return "kafka";
    }
}

