/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class UtlTailoringCore {
    protected static final String delimitedReplace(String string, PropertySource props, int start, String openString, String closeString, String defaultDelimiter, boolean preserveDefaults, LinkedHashMap<String, String> cycleDetection) throws TailoringException {
        SubstEvaluator substEvaluator = new SubstEvaluator(string, start, openString, closeString, defaultDelimiter, preserveDefaults);
        SubstEvaluator.Result result = substEvaluator.parseAndEvaluate(props);
        if (result.getBegin() == 0 && result.getEnd() == string.length()) {
            return result.getValue();
        }
        StringBuilder sb = new StringBuilder(result.getValue().length() + 1024);
        sb.append(string.substring(0, result.getBegin()));
        sb.append(result.getValue());
        sb.append(string.substring(result.getEnd()));
        return sb.toString();
    }

    protected static final String legacyDelimitedReplace(String string, PropertySource props, int start, String openString, String closeString, String defaultDelimiter, boolean preserveDefaults, LinkedHashMap<String, String> cycleDetection) throws TailoringException {
        int close;
        int open = string.indexOf(openString, start);
        int n = close = open == -1 ? -1 : string.indexOf(closeString, open + 1);
        if (open == -1 || close == -1) {
            return string;
        }
        String toReplace = null;
        int next = string.indexOf(openString, open + openString.length());
        if (next > -1) {
            String tailored = UtlTailoringCore.delimitedReplace(string, props, next, openString, closeString, defaultDelimiter, preserveDefaults, cycleDetection);
            if (tailored != string && (close = tailored.indexOf(closeString, open + openString.length())) == -1) {
                return tailored;
            }
            string = tailored;
        }
        toReplace = string.substring(open + openString.length(), close);
        String replacement = null;
        if (defaultDelimiter != null) {
            int lastDefaultDelimiter = -1;
            lastDefaultDelimiter = toReplace.lastIndexOf(defaultDelimiter);
            if (lastDefaultDelimiter > -1) {
                if (toReplace.length() > lastDefaultDelimiter + defaultDelimiter.length() && !preserveDefaults) {
                    replacement = toReplace.substring(lastDefaultDelimiter + defaultDelimiter.length());
                }
                toReplace = toReplace.substring(0, lastDefaultDelimiter);
            }
        }
        if (cycleDetection != null && cycleDetection.containsKey(toReplace)) {
            StringBuilder cycle = new StringBuilder();
            for (String r : cycleDetection.values()) {
                cycle.append(r).append("->");
            }
            cycle.append(string.substring(open, close + 1));
            throw new TailoringException("Substitution cycle detected: " + cycle);
        }
        if ((replacement = props.getValue(toReplace, replacement)) != null) {
            if (string.indexOf(openString, start) != -1) {
                if (cycleDetection == null) {
                    cycleDetection = new LinkedHashMap();
                }
                cycleDetection.put(toReplace, string.substring(open, close + 1));
                replacement = UtlTailoringCore.delimitedReplace(replacement, props, start, openString, closeString, defaultDelimiter, preserveDefaults, cycleDetection);
            }
            StringBuffer rc = new StringBuffer(string.length() + 1024);
            rc.append(string.substring(0, open));
            rc.append(replacement);
            rc.append(string.substring(close + closeString.length()));
            return rc.toString();
        }
        return string;
    }

    public static final String delimitedReplace(String string, PropertySource props, int start, String openString, String closeString, String defaultDelimiter, boolean preserveDefaults) throws TailoringException {
        return UtlTailoringCore.delimitedReplace(string, props, start, openString, closeString, defaultDelimiter, preserveDefaults, null);
    }

    protected static final class SubstEvaluator {
        private final String source;
        private final String openString;
        private final String closeString;
        private final String defaultDelimiter;
        private final boolean preserveDefaults;
        private final int offset;
        private final String[] idTerminators;
        private final String[] literalTerminators;
        Set<String> cycleDetector;

        public SubstEvaluator(String source, int offset, String openString, String closeString, String defaultDelimiter, boolean preserveDefaults) {
            this(source, offset, openString, closeString, defaultDelimiter, preserveDefaults, null);
        }

        public SubstEvaluator(String source, int offset, String openString, String closeString, String defaultDelimiter, boolean preserveDefaults, Set<String> cycleDetector) {
            this.source = source;
            this.offset = offset;
            this.openString = openString;
            this.closeString = closeString;
            this.defaultDelimiter = defaultDelimiter;
            this.preserveDefaults = preserveDefaults;
            this.cycleDetector = cycleDetector;
            this.idTerminators = new String[]{defaultDelimiter, closeString};
            this.literalTerminators = new String[]{closeString};
        }

        public Result parseAndEvaluate(PropertySource propertySource) throws TailoringException {
            State state = new State(this.offset, propertySource);
            String value = state.expr();
            return new Result(value, this.offset, state.offset);
        }

        private final class State {
            private final PropertySource propertySource;
            private int offset;

            public State(int offset, PropertySource propertySource) {
                this.offset = offset;
                this.propertySource = propertySource;
            }

            public String expr() throws TailoringException {
                return this.literalOrVarSeq(false);
            }

            public String var() throws Error, TailoringException {
                int begin = this.offset;
                this.expectOpenString();
                String key = this.idOrVarSeq();
                String defaultValue = this.defaultExpr();
                this.expectCloseString();
                String result = this.evaluate(key, defaultValue);
                if (result == null) {
                    result = SubstEvaluator.this.source.substring(begin, this.offset);
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String evaluate(String key, String defaultValue) throws TailoringException {
                this.pushKey(key);
                try {
                    String result = this.propertySource.getValue(key, null);
                    if (result == null) {
                        if (!SubstEvaluator.this.preserveDefaults) {
                            result = defaultValue;
                        } else if (defaultValue != null) {
                            int size = SubstEvaluator.this.openString.length() + key.length() + SubstEvaluator.this.defaultDelimiter.length() + SubstEvaluator.this.closeString.length();
                            StringBuilder sb = new StringBuilder(size);
                            sb.append(SubstEvaluator.this.openString).append(key).append(SubstEvaluator.this.defaultDelimiter).append(defaultValue).append(SubstEvaluator.this.closeString);
                            String string = sb.toString();
                            return string;
                        }
                    } else if (result != SubstEvaluator.this.source && result.contains(SubstEvaluator.this.openString)) {
                        result = this.expand(result);
                    }
                    String string = result;
                    return string;
                }
                finally {
                    this.popKey(key);
                }
            }

            private String expand(String result) throws TailoringException {
                SubstEvaluator parser = new SubstEvaluator(result, 0, SubstEvaluator.this.openString, SubstEvaluator.this.closeString, SubstEvaluator.this.defaultDelimiter, SubstEvaluator.this.preserveDefaults, SubstEvaluator.this.cycleDetector);
                return parser.parseAndEvaluate(this.propertySource).getValue();
            }

            private void expectOpenString() {
                if (this.eof()) {
                    throw new Error("Unexpected end of input", this.offset);
                }
                if (!this.consume(SubstEvaluator.this.openString)) {
                    throw new Error("Expected " + SubstEvaluator.this.openString, this.offset);
                }
            }

            private void expectCloseString() {
                if (this.eof()) {
                    throw new Error("Unexpected end of input", this.offset);
                }
                if (!this.consume(SubstEvaluator.this.closeString)) {
                    throw new Error("Expected " + SubstEvaluator.this.closeString, this.offset);
                }
            }

            private String defaultExpr() throws TailoringException {
                String defaultValue = this.consume(SubstEvaluator.this.defaultDelimiter) ? this.literalOrVarSeq(true) : null;
                return defaultValue;
            }

            private String idOrVarSeq() throws TailoringException {
                return this.rawOrVarSeq(SubstEvaluator.this.idTerminators);
            }

            private String literalOrVarSeq(boolean useTerminators) throws TailoringException {
                return this.rawOrVarSeq(useTerminators ? SubstEvaluator.this.literalTerminators : null);
            }

            private String rawOrVarSeq(String[] terminators) throws TailoringException {
                int begin = this.offset;
                StringBuilder sb = new StringBuilder();
                while (!this.eof() && !this.atTerminator(terminators)) {
                    if (this.peek(SubstEvaluator.this.openString)) {
                        if (this.offset > begin) {
                            sb.append(SubstEvaluator.this.source, begin, this.offset);
                            begin = this.offset;
                        }
                        try {
                            sb.append(this.var());
                        }
                        catch (Error error) {
                            sb.append(SubstEvaluator.this.source, begin, this.offset);
                        }
                        begin = this.offset;
                        continue;
                    }
                    ++this.offset;
                }
                if (begin == 0 && this.offset == SubstEvaluator.this.source.length()) {
                    return SubstEvaluator.this.source;
                }
                if (this.offset > begin) {
                    sb.append(SubstEvaluator.this.source, begin, this.offset);
                }
                return sb.toString();
            }

            private boolean atTerminator(String[] terminators) {
                if (terminators != null) {
                    for (int i = 0; i < terminators.length; ++i) {
                        if (!this.peek(terminators[i])) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean eof() {
                return this.offset >= SubstEvaluator.this.source.length();
            }

            private boolean consume(String s) {
                if (!this.peek(this.offset, s)) {
                    return false;
                }
                this.offset += s.length();
                return true;
            }

            private boolean peek(String s) {
                return this.peek(this.offset, s);
            }

            private boolean peek(int offset, String s) {
                if (s.length() > SubstEvaluator.this.source.length() - offset) {
                    return false;
                }
                for (int i = 0; i < s.length(); ++i) {
                    if (SubstEvaluator.this.source.charAt(offset + i) == s.charAt(i)) continue;
                    return false;
                }
                return true;
            }

            private void pushKey(String key) throws TailoringException {
                if (SubstEvaluator.this.cycleDetector == null) {
                    SubstEvaluator.this.cycleDetector = new LinkedHashSet<String>();
                }
                if (!SubstEvaluator.this.cycleDetector.add(key)) {
                    StringBuilder sb = new StringBuilder();
                    for (String visited : SubstEvaluator.this.cycleDetector) {
                        sb.append(SubstEvaluator.this.openString);
                        sb.append(visited);
                        sb.append(SubstEvaluator.this.closeString).append("->");
                    }
                    sb.append(SubstEvaluator.this.openString).append(key).append(SubstEvaluator.this.closeString);
                    throw new TailoringException("Substitution cycle detected: " + sb);
                }
            }

            private void popKey(String key) {
                SubstEvaluator.this.cycleDetector.remove(key);
            }
        }

        static final class Error
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public Error(String message, int offset) {
                super(message);
            }
        }

        static final class Result {
            private final String value;
            private final int begin;
            private final int end;

            public Result(String value, int begin, int end) {
                this.value = value;
                this.begin = begin;
                this.end = end;
            }

            public String getValue() {
                return this.value;
            }

            public int getBegin() {
                return this.begin;
            }

            public int getEnd() {
                return this.end;
            }
        }
    }

    public static final class TailoringException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TailoringException() {
        }

        public TailoringException(String message) {
            super(message);
        }
    }

    private static final class PropertiesPropSource
    implements PropertySource {
        Properties props;

        PropertiesPropSource(Properties props) {
            this.props = props;
        }

        @Override
        public String getValue(String key, String defaultValue) {
            return this.props.getProperty(key, defaultValue);
        }
    }

    public static interface PropertySource {
        public String getValue(String var1, String var2);
    }
}

