/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.trace;

import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class TraceHistoryHandler
extends Handler {
    private final LogRecord[] history;
    private final Handler handler;
    private final IteratorImpl iterator;
    private long head;
    private long tail;

    private TraceHistoryHandler(Handler handler, int maxRecords) {
        this.handler = handler;
        this.history = new LogRecord[maxRecords];
        this.tail = -1L;
        this.head = -1L;
        this.iterator = new IteratorImpl();
        this.setLevel(Level.FINEST);
    }

    public static TraceHistoryHandler create(Handler handler, int maxRecords) {
        if (maxRecords < 0) {
            throw new IllegalArgumentException("maxRecords must be >= 0");
        }
        return new TraceHistoryHandler(handler, maxRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void publish(LogRecord record) {
        if (!this.isLoggable(record)) return;
        LogRecord[] logRecordArray = this.history;
        synchronized (this.history) {
            if (!this.iterator.hasNext()) {
                if (this.head == -1L) {
                    this.tail = 0L;
                    this.head = 0L;
                    this.history[(int)0L] = record;
                } else {
                    this.history[(int)(++this.head % (long)this.history.length)] = record;
                    if ((int)(this.head - this.tail + 1L) == this.history.length) {
                        ++this.tail;
                    }
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.handler == null) return;
            this.handler.publish(record);
            return;
        }
    }

    @Override
    public final void flush() {
        if (this.handler != null) {
            this.handler.flush();
        }
    }

    @Override
    public final void close() {
        if (this.handler != null) {
            this.handler.close();
        }
    }

    public final Object getHistoryLock() {
        return this.history;
    }

    public final Iterator<LogRecord> iterator() {
        return this.iterator.init();
    }

    private final class IteratorImpl
    implements Iterator<LogRecord> {
        private long current;
        private long count;

        private IteratorImpl() {
        }

        final IteratorImpl init() {
            this.current = TraceHistoryHandler.this.tail;
            this.count = TraceHistoryHandler.this.tail >= 0L ? TraceHistoryHandler.this.head - TraceHistoryHandler.this.tail + 1L : 0L;
            return this;
        }

        @Override
        public final boolean hasNext() {
            return this.count > 0L;
        }

        @Override
        public final LogRecord next() {
            if (this.count > 0L) {
                LogRecord record = TraceHistoryHandler.this.history[(int)(this.current % (long)TraceHistoryHandler.this.history.length)];
                ++this.current;
                --this.count;
                return record;
            }
            return null;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

