/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.eaio.uuid.UUID;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingRoleChangedEvent;
import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreCommitCompletionStatus;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.IStoreMemberDownEvent;
import com.neeve.ods.IStoreMemberInitCompleteEvent;
import com.neeve.ods.IStoreMemberReplicationStatus;
import com.neeve.ods.IStoreMemberUpEvent;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreObjectAddedEvent;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.IStoreObjectRemovedEvent;
import com.neeve.ods.IStoreObjectUpdatedEvent;
import com.neeve.ods.StoreBinding;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.log.RogLog;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.util.UtlTime;
import jargs.gnu.CmdLineParser;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class OdsTool
implements IStoreEventHandler {
    private final int MAX_OBJECTS = 1024;
    private final IStoreBinding store;
    private final Set<IStoreMember> members = new LinkedHashSet<IStoreMember>();
    private final StoreObject[] objects;
    protected final InteractiveTool interactiveTool;

    protected OdsTool(String memberName, String storeName) throws Exception {
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory(new StoreObjectFactory());
        this.objects = new StoreObject[1024];
        StoreReplicatorDescriptor replicatorDescriptor = StoreReplicatorDescriptor.create(storeName);
        replicatorDescriptor.save();
        StorePersisterDescriptor persisterDescriptor = StorePersisterDescriptor.create(storeName, RogLog.class.getName());
        persisterDescriptor.setProperty("storeRoot", memberName);
        persisterDescriptor.save();
        StoreDescriptor storeDescriptor = StoreDescriptor.create(storeName);
        storeDescriptor.setReplicator(storeName);
        storeDescriptor.setPersister(storeName);
        this.store = StoreBinding.create(memberName, storeDescriptor, this, 0);
        this.store.open();
        this.members.add(this.store.getMember());
        this.interactiveTool = new InteractiveTool();
        this.interactiveTool.registerCommand((Command)new CreateObject());
        this.interactiveTool.registerCommand((Command)new SetObjectValue());
        this.interactiveTool.registerCommand((Command)new DeleteObject());
        this.interactiveTool.registerCommand((Command)new ListObjects());
        this.interactiveTool.registerCommand((Command)new Commit());
        this.interactiveTool.registerCommand((Command)new Rollback());
        this.interactiveTool.registerCommand((Command)new ListMembers());
        this.interactiveTool.registerCommand((Command)new Role());
        this.interactiveTool.registerCommand((Command)new Name());
        this.interactiveTool.registerCommand((Command)new Close());
    }

    private final void dumpCommitCompletionStatus(IStoreCommitCompletionEvent completionEvent) {
        IStoreCommitCompletionStatus completionStatus = completionEvent.getCompletionStatus();
        StringBuilder builder = new StringBuilder("\n******* Commit has completed *******");
        builder.append("\n*******...Replication Status Summary");
        builder.append("\n*******......SuccessCount=").append(completionStatus.getSuccessCount());
        builder.append("\n*******......FailureCount=").append(completionStatus.getFailedCount());
        builder.append("\n*******...Member Replication Status Detail");
        if (completionStatus.getReplicationStatus().size() > 0) {
            for (IStoreMemberReplicationStatus status : completionStatus.getReplicationStatus().values()) {
                builder.append("\n*******......'").append(status.getMember().getName()).append("'=").append(status.getStatus() == null ? "success" : status.getStatus().getMessage());
            }
        } else {
            builder.append("\n*******......<replicated to zero members>");
        }
        builder.append("\n");
        System.out.println(builder.toString());
    }

    protected final void run() throws Exception {
        Thread.currentThread().setName("OdsTool Main");
        this.interactiveTool.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(IStoreEvent event) {
        if (event instanceof IStoreMemberUpEvent) {
            Set<IStoreMember> set = this.members;
            synchronized (set) {
                IStoreMember member = ((IStoreMemberUpEvent)event).getMember();
                System.out.println("\n******* [Member '" + member.getName() + "' has joined the store] *******\n");
                this.members.add(member);
            }
        } else if (event instanceof IStoreMemberDownEvent) {
            Set<IStoreMember> set = this.members;
            synchronized (set) {
                IStoreMember member = ((IStoreMemberDownEvent)event).getMember();
                System.out.println("\n******* [Member '" + member.getName() + "' has left the store] *******\n");
                this.members.remove(member);
            }
        } else if (event instanceof IStoreMemberInitCompleteEvent) {
            IStoreMember member = ((IStoreMemberInitCompleteEvent)event).getMember();
            System.out.println("\n******* [Member '" + member.getName() + "' has been successfully initialized] *******\n");
        } else if (event instanceof IStoreCommitCompletionEvent) {
            this.dumpCommitCompletionStatus((IStoreCommitCompletionEvent)event);
        } else if (event instanceof IStoreObjectAddedEvent) {
            IStoreObject object = ((IStoreObjectAddedEvent)event).getObject();
            if (object instanceof StoreObject) {
                StoreObject storeObject = (StoreObject)object;
                System.out.println("\n******* [Object added at index '" + storeObject.getIndex() + "'] *******\n");
                this.objects[storeObject.getIndex()] = storeObject;
            } else {
                System.out.println("Object of unknown type added to store!");
            }
        } else if (event instanceof IStoreObjectUpdatedEvent) {
            IStoreObject object = ((IStoreObjectUpdatedEvent)event).getObject();
            if (object instanceof StoreObject) {
                StoreObject storeObject = (StoreObject)object;
                System.out.println("\n******* [Object updated at index '" + storeObject.getIndex() + "'] *******\n");
            } else {
                System.out.println("Object of unknown type added to store!");
            }
        } else if (event instanceof IStoreObjectRemovedEvent) {
            IStoreObject object = ((IStoreObjectRemovedEvent)event).getObject();
            if (object instanceof StoreObject) {
                StoreObject storeObject = (StoreObject)object;
                System.out.println("\n******* [Object removed from index '" + storeObject.getIndex() + "'] *******\n");
                this.objects[storeObject.getIndex()] = null;
            } else {
                System.out.println("Object of unknown type removed from store!");
            }
        } else if (event instanceof IStoreBindingRoleChangedEvent) {
            IStoreBinding.Role role = ((IStoreBindingRoleChangedEvent)event).getRole();
            System.out.println("\n******* [Role set to '" + (Object)((Object)role) + "'] *******\n");
        }
    }

    private static void printUsage() {
        System.err.println("Usage OdsTool [{-s, --store} name of store to bind to] ");
        System.err.println("              [{-m, --member} name of store member to use]");
        System.err.println("              [{-h, --help} print this help string]");
    }

    public static void main(String[] args) {
        block5: {
            try {
                CmdLineParser parser = new CmdLineParser();
                CmdLineParser.Option memberNameOption = parser.addStringOption('m', "member");
                CmdLineParser.Option storeNameOption = parser.addStringOption('s', "store");
                CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
                try {
                    parser.parse(args);
                    if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                        String memberName = (String)parser.getOptionValue(memberNameOption, (Object)String.valueOf(UtlTime.now()));
                        String storeName = (String)parser.getOptionValue(storeNameOption, (Object)"odstool");
                        new OdsTool(memberName, storeName).run();
                        break block5;
                    }
                    OdsTool.printUsage();
                }
                catch (CmdLineParser.OptionException e) {
                    System.err.println(e.getMessage());
                    OdsTool.printUsage();
                }
            }
            catch (Throwable e) {
                System.err.println("Unhandled fault [" + e.toString() + "]");
                e.printStackTrace();
            }
        }
    }

    public final class Close
    extends Command {
        public final void doClose() {
            System.out.println("Closing store...");
            try {
                OdsTool.this.store.close(0);
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: close");
            } else {
                this.doClose();
            }
        }

        public final void help() {
            System.out.println("close");
            System.out.println("  Close store.");
        }

        public final String[] keywords() {
            return new String[]{"close"};
        }
    }

    public final class Name
    extends Command {
        public final void doName() {
            try {
                System.out.println("...<" + OdsTool.this.store.getMember().getName() + ">");
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: name");
            } else {
                this.doName();
            }
        }

        public final void help() {
            System.out.println("name");
            System.out.println("  List store member name");
        }

        public final String[] keywords() {
            return new String[]{"name"};
        }
    }

    public final class Role
    extends Command {
        public final void doRole() {
            try {
                System.out.println("...<" + (Object)((Object)OdsTool.this.store.getRole()) + ">");
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: role");
            } else {
                this.doRole();
            }
        }

        public final void help() {
            System.out.println("role");
            System.out.println("  List store member role");
        }

        public final String[] keywords() {
            return new String[]{"role"};
        }
    }

    public final class ListMembers
    extends Command {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doList() {
            Set set = OdsTool.this.members;
            synchronized (set) {
                StringBuilder builder = new StringBuilder("...<");
                Iterator iterator = OdsTool.this.members.iterator();
                while (iterator.hasNext()) {
                    builder.append(((IStoreMember)iterator.next()).getName());
                    if (!iterator.hasNext()) continue;
                    builder.append(",");
                }
                builder.append(">");
                System.out.println(builder.toString());
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: members");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("members");
            System.out.println("  List store members");
        }

        public final String[] keywords() {
            return new String[]{"members"};
        }
    }

    public final class Rollback
    extends Command {
        public final void doRollback() {
            System.out.println("Rolling back changes...");
            try {
                OdsTool.this.store.rollback();
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: rollback");
            } else {
                this.doRollback();
            }
        }

        public final void help() {
            System.out.println("rollback");
            System.out.println("  Rollback changes made since last rollback");
        }

        public final String[] keywords() {
            return new String[]{"rollback"};
        }
    }

    public final class Commit
    extends Command {
        public final void doCommitSync() {
            System.out.println("Committing changes (synchronous)...");
            try {
                IStoreCommitCompletionEvent completionEvent = OdsTool.this.store.createCommitCompletionEvent().setNotify(true).setDispatch(false);
                OdsTool.this.store.commit(completionEvent).waitForCompletion();
                OdsTool.this.dumpCommitCompletionStatus(completionEvent);
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void doCommitAsync() {
            System.out.println("Committing changes (asynchronous)...");
            try {
                OdsTool.this.store.commit(null);
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void doCommitPipelined() {
            System.out.println("Committing changes (pipelined)...");
            try {
                OdsTool.this.store.commit(OdsTool.this.store.createCommitCompletionEvent().setNotify(false).setDispatch(true));
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void run(String[] args) {
            if (args.length > 1) {
                System.out.println("Syntax error: commit <sync|async|pipelined>");
            } else if (args.length == 0) {
                this.doCommitAsync();
            } else if (args[0].compareToIgnoreCase("sync") == 0) {
                this.doCommitSync();
            } else if (args[0].compareToIgnoreCase("async") == 0) {
                this.doCommitAsync();
            } else if (args[0].compareToIgnoreCase("pipelined") == 0) {
                this.doCommitPipelined();
            }
        }

        public final void help() {
            System.out.println("commit");
            System.out.println("  Commit changes made since last commit");
        }

        public final String[] keywords() {
            return new String[]{"commit"};
        }
    }

    public final class ListObjects
    extends Command {
        public final void doList() {
            int count = 0;
            System.out.println("Objects:");
            for (int i = 0; i < OdsTool.this.objects.length; ++i) {
                if (OdsTool.this.objects[i] == null) continue;
                ++count;
                System.out.println("..." + OdsTool.this.objects[i]);
            }
            if (count == 0) {
                System.out.println("...<none>");
            }
        }

        public final void run(String[] args) {
            if (args.length != 0) {
                System.out.println("Syntax error: objects");
            } else {
                this.doList();
            }
        }

        public final void help() {
            System.out.println("objects");
            System.out.println("  List store objects");
        }

        public final String[] keywords() {
            return new String[]{"objects"};
        }
    }

    public final class DeleteObject
    extends Command {
        public final void doDelete(int index) {
            System.out.println("Deleting object #" + index + "...");
            try {
                if (index >= 0 && index < OdsTool.this.objects.length) {
                    if (OdsTool.this.objects[index] == null) {
                        throw new Exception("object does not exist at that index");
                    }
                } else {
                    throw new Exception("index must be >=0 and < " + OdsTool.this.objects.length);
                }
                OdsTool.this.store.remove(OdsTool.this.objects[index].setValue(null));
                ((OdsTool)OdsTool.this).objects[index] = null;
                System.out.println("Success");
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: delete <index>");
            } else {
                this.doDelete(Integer.parseInt(args[0]));
            }
        }

        public final void help() {
            System.out.println("delete");
            System.out.println("  Delete an object");
        }

        public final String[] keywords() {
            return new String[]{"delete"};
        }
    }

    public final class SetObjectValue
    extends Command {
        public final void doSet(int index, String value) {
            System.out.println("Setting object #" + index + " value to '" + value + "'...");
            try {
                if (index >= 0 && index < OdsTool.this.objects.length) {
                    if (OdsTool.this.objects[index] == null) {
                        throw new Exception("no object");
                    }
                } else {
                    throw new Exception("index must be >=0 and < " + OdsTool.this.objects.length);
                }
                OdsTool.this.objects[index].setValue(value);
                System.out.println("Success");
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
                e.printStackTrace();
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: set <index> <value>");
            } else {
                this.doSet(Integer.parseInt(args[0]), args[1]);
            }
        }

        public final void help() {
            System.out.println("set");
            System.out.println("  Set the value of an object");
        }

        public final String[] keywords() {
            return new String[]{"set"};
        }
    }

    public final class CreateObject
    extends Command {
        public final void doCreate(int index, String value) {
            System.out.println("Creating object #" + index + " with value='" + value + "'...");
            try {
                if (index >= 0 && index < OdsTool.this.objects.length) {
                    if (OdsTool.this.objects[index] != null) {
                        throw new Exception("object already exists");
                    }
                } else {
                    throw new Exception("index must be >=0 and < " + OdsTool.this.objects.length);
                }
                StoreObject object = new StoreObject(index);
                OdsTool.this.store.put(object);
                StoreObject storeObject = object;
                ((OdsTool)OdsTool.this).objects[index] = storeObject;
                storeObject.setValue(value);
                System.out.println("Success");
            }
            catch (Exception e) {
                System.out.println("Failed [" + e.toString() + "]");
            }
        }

        public final void run(String[] args) {
            if (args.length != 2) {
                System.out.println("Syntax error: create <index> <value>");
            } else {
                this.doCreate(Integer.parseInt(args[0]), args[1]);
            }
        }

        public final void help() {
            System.out.println("create");
            System.out.println("  Create a new object");
        }

        public final String[] keywords() {
            return new String[]{"create"};
        }
    }

    private final class StoreObject
    extends RogNode {
        private final int fid_value;
        private int index;
        private String value;

        StoreObject(UUID id) {
            super((short)1, (short)0, (short)1, id, true);
            this.fid_value = super.getLastFid() + 2;
        }

        StoreObject(int index) {
            this(new UUID());
            this.setIndex(index);
        }

        public final byte[] serializeToByteArray() {
            throw new UnsupportedOperationException();
        }

        public final ByteBuffer serializeToByteBuffer() {
            throw new UnsupportedOperationException();
        }

        public final PktPacket serializeToPacket() {
            PktPacket packet = PktFactory.getInstance().createPacket(257);
            ((PktBodyData)packet.getBody()).setBufferLength(6 + (this.value == null ? 0 : this.value.length()));
            IOElasticBuffer buffer = packet.getBody().getBuffer();
            buffer.putInt(0, this.index);
            buffer.putShort(4, (short)buffer.putASCIICharSequence(6, (CharSequence)this.value));
            return packet;
        }

        public final String serializeToJson() {
            throw new UnsupportedOperationException();
        }

        public final StoreObject deserializeFromByteArray(byte[] array) {
            throw new UnsupportedOperationException();
        }

        public final StoreObject deserializeFromByteBuffer(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        public final StoreObject deserializeFromPacket(PktPacket packet) {
            IOElasticBuffer buffer = packet.getBody().getBuffer();
            this.index = buffer.getInt(0);
            short valueLen = buffer.getShort(4);
            if (valueLen > 0) {
                this.value = buffer.getString(6, (int)valueLen);
            }
            return this;
        }

        public final StoreObject deserializeFromJson(String json) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int getLastFid() {
            return this.fid_value;
        }

        final StoreObject setIndex(int val) {
            this.index = val;
            return this;
        }

        final int getIndex() {
            return this.index;
        }

        final StoreObject setValue(String val) {
            this.recordFieldUpdate(this.fid_value, this.getValue());
            this.value = val;
            return this;
        }

        final String getValue() {
            return this.value;
        }

        public final void sync() {
        }

        @Override
        public final IStoreObject.EncodingType getContentEncodingType() {
            return IStoreObject.EncodingType.Custom;
        }

        @Override
        public final PktPacket serialize() {
            return this.serializeToPacket();
        }

        @Override
        public final IStoreObject deserialize(PktPacket packet) {
            return this.deserializeFromPacket(packet);
        }

        @Override
        public final IStoreObject setFieldValue(long fid, Object val) {
            if (fid == (long)this.fid_value) {
                this.value = (String)val;
                if (this.getValue() == null) {
                    ((OdsTool)OdsTool.this).objects[this.getIndex()] = null;
                } else if (this.getValue() != null && OdsTool.this.objects[this.getIndex()] == null) {
                    ((OdsTool)OdsTool.this).objects[this.getIndex()] = this;
                }
            } else {
                super.setFieldValue(fid, val);
            }
            return this;
        }

        @Override
        public final String toString() {
            return "{" + this.getIndex() + ", " + this.getValue() + "}";
        }
    }

    private final class StoreObjectFactory
    implements IStoreObjectFactory {
        static final short OFID = 1;
        static final short ID_StoreObject = 1;

        private StoreObjectFactory() {
        }

        @Override
        public final short getOfid() {
            return 1;
        }

        @Override
        public final IStoreObject create(short type, UUID id, IStoreObject.EncodingType encodingType, PktPacket packet) {
            return new StoreObject(id);
        }
    }
}

