/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.neeve.config.Config;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.ods.OdsException;
import com.neeve.query.QueryException;
import com.neeve.query.index.IdxFieldResolver;
import com.neeve.rog.RogObject;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogQueryEngine;
import java.lang.reflect.Method;
import java.util.Properties;

public class RogLogFactory
extends RogObject {
    private static final IConfigRepository repo = Config.getRepository();
    private static Class<? extends RogLogQueryEngine> queryEngineImplClass;

    public static RogLogQueryEngine createQueryEngine() throws QueryException {
        try {
            if (queryEngineImplClass == null) {
                String clazz = "com.neeve.rog.impl.log.RogLogQueryEngineImpl";
                IConfigSimpleEntity entity = repo.getSimpleEntity("/ods/providers/roglog");
                if (entity != null) {
                    clazz = entity.getProperty("Class", "com.neeve.rog.impl.log.RogLogQueryEngineImpl");
                }
                queryEngineImplClass = Class.forName(clazz);
            }
            return queryEngineImplClass.newInstance();
        }
        catch (Exception e) {
            throw new QueryException("Error creating query engine", e);
        }
    }

    public static RogLog createLog(String name) throws OdsException {
        return RogLogFactory.createLog(name, null);
    }

    public static RogLog createLog(String name, Properties props) throws OdsException {
        return RogLog.create(name, props);
    }

    public static <REC> IdxFieldResolver<REC> createFieldResolver() {
        try {
            Class<?> clazz = Class.forName("com.neeve.rog.impl.log.RogLogQueryFieldResolver");
            Method instanceGetter = clazz.getDeclaredMethod("get", new Class[0]);
            IdxFieldResolver fieldResolver = (IdxFieldResolver)instanceGetter.invoke(null, new Object[0]);
            return fieldResolver;
        }
        catch (Exception e) {
            throw new QueryException("Could not create IdxFieldResolver", e);
        }
    }
}

