/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import com.neeve.event.Event;
import com.neeve.io.IOBuffer;
import com.neeve.ods.impl.StorePersisterCompactionCompletedEvent;
import com.neeve.ods.impl.StorePersisterCompactionErrorEvent;
import com.neeve.ods.impl.StorePersisterCompactionStartedEvent;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.rog.RogObject;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCompactingReader;
import com.neeve.rog.log.RogLogMetadata;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import com.neeve.util.UtlUnit;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public final class RogLogCompactor
extends RogObject {
    private static final Tracer tracer = Tracer.get((String)"nv.rog.compaction");
    private final RogLog log;
    private final Params params;
    private volatile State state;
    private Exception compactionCompletionStatus;
    private long logPosAtCompactStartTime;
    private long logSizeAtCompactStartTime;
    private long logFileSizeAtCompactStartTime;
    private int numEntriesWrittenDuringCompaction;
    private long numBytesWrittenDuringCompaction;
    private Runner runner;
    public static final String PROP_COMPACTION_THRESHOLD = "compaction.compactionThreshold";

    RogLogCompactor(RogLog log, Params params) {
        this.log = log;
        this.params = params;
        this.state = State.NotStarted;
        this.runner = new Runner(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setState(State state) {
        RogLogCompactor rogLogCompactor = this;
        synchronized (rogLogCompactor) {
            this.state = state;
            switch (this.state) {
                case Complete: 
                case Failed: 
                case InProgress: {
                    ((Object)((Object)this)).notifyAll();
                    break;
                }
            }
        }
    }

    final void start() {
        if (this.runner == null || !this.runner.isAlive()) {
            tracer.log("[Compactor] starting up.", Tracer.Level.INFO);
            this.runner = new Runner(this.log);
            this.runner.start();
        }
    }

    final void onPacketWrittenDuringCompaction(PktPacket packet) {
        ++this.numEntriesWrittenDuringCompaction;
        this.numBytesWrittenDuringCompaction += (long)((PktRecoveryLog.FilePosition)packet.getTag(4)).getSize();
    }

    public final State getState() {
        return this.state;
    }

    public final RogLogCompactor compact() {
        if (!this.log.isOpen()) {
            throw new IllegalStateException("log is not open");
        }
        switch (this.state) {
            case InProgress: 
            case Compacted: {
                throw new IllegalStateException("compaction in progress (state='" + (Object)((Object)this.state) + "')");
            }
        }
        tracer.log("[Compactor] Compacting log '" + this.log.getName() + "'...", Tracer.Level.INFO);
        this.logPosAtCompactStartTime = this.log.getNextWritePointer();
        this.logSizeAtCompactStartTime = this.log.getSize();
        this.logFileSizeAtCompactStartTime = this.log.getAllocatedSize();
        this.numEntriesWrittenDuringCompaction = 0;
        this.numBytesWrittenDuringCompaction = 0L;
        this.compactionCompletionStatus = null;
        this.start();
        this.setState(State.InProgress);
        return this;
    }

    public final boolean isCompactionInProgress() {
        switch (this.state) {
            case InProgress: 
            case Compacted: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForCompactionToComplete() throws Exception {
        RogLogCompactor rogLogCompactor = this;
        synchronized (rogLogCompactor) {
            if (this.state == State.NotStarted) {
                throw new IllegalStateException("compact not started");
            }
            while (this.state != State.Complete && this.state != State.Failed) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.state != State.Failed) continue;
                throw this.compactionCompletionStatus;
            }
        }
    }

    public final void stop() {
        if (this.runner != null) {
            this.runner.shutdown();
            while (true) {
                try {
                    this.runner.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static enum State {
        NotStarted,
        InProgress,
        Compacted,
        Complete,
        Failed;

    }

    public static final class Params {
        public static final String PROP_COMPACTION_THRESHOLD = "compactionThreshold";
        public static final String PROP_COMPACTION_THRESHOLD_DEFAULT = "0";
        public static final String PROP_COMPACT_ON_START = "compactOnStart";
        public static final boolean PROP_COMPACT_ON_START_DEFAULT = false;
        long compactionThreshold;
        boolean compactOnStart;

        private Params(Properties props) {
            this.compactionThreshold = (long)UtlUnit.parseBytes((String)UtlProps.getValue((Properties)props, (String)PROP_COMPACTION_THRESHOLD, (String)PROP_COMPACTION_THRESHOLD_DEFAULT), (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Megabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
            this.compactOnStart = UtlProps.getValue((Properties)props, (String)PROP_COMPACT_ON_START, (boolean)false);
        }

        public static Params create(Properties props) {
            String prefix = "compaction.";
            Properties compactorProps = new Properties();
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                String key = String.valueOf(prop.getKey());
                if (!key.startsWith("compaction.")) continue;
                compactorProps.put(key.substring("compaction.".length()), prop.getValue());
            }
            return new Params(compactorProps);
        }

        void dump(String prefix, StringBuilder sb) {
            sb.append(prefix).append("compactor {\n");
            sb.append(prefix).append("...").append(PROP_COMPACTION_THRESHOLD).append("=").append(this.compactionThreshold).append(" (").append(UtlUnit.readableBytesSize((long)this.compactionThreshold)).append(")\n");
            sb.append(prefix).append("...").append(PROP_COMPACT_ON_START).append("=").append(this.compactOnStart).append("\n");
            sb.append(prefix).append("}\n");
        }
    }

    private final class Runner
    extends Thread {
        private final CompactionReadHandler handler;
        private final RogLogCompactingReader reader;
        private final Writer writer;
        private final NumberFormat format;
        private volatile boolean closed;

        Runner(RogLog log) {
            super("X-RogLogCompactor-" + log.getName());
            this.handler = new CompactionReadHandler();
            this.reader = RogLogCompactingReader.create(log, this.handler, tracer);
            this.writer = new Writer();
            this.format = NumberFormat.getInstance();
            this.format.setMaximumFractionDigits(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean waitForCompactionToBeTriggered() {
            RogLogCompactor rogLogCompactor = RogLogCompactor.this;
            synchronized (rogLogCompactor) {
                while (true) {
                    if (this.closed || !RogLogCompactor.this.log.isOpen()) {
                        if (tracer.fine) {
                            tracer.log("[Compactor] Exiting run (closed)...", Tracer.Level.FINE);
                        }
                        return false;
                    }
                    if (RogLogCompactor.this.state == State.InProgress) break;
                    try {
                        if (tracer.fine) {
                            tracer.log("[Compactor] Waiting to compact (state=" + (Object)((Object)RogLogCompactor.this.state) + ")", Tracer.Level.FINE);
                        }
                        ((Object)((Object)RogLogCompactor.this)).wait();
                    }
                    catch (InterruptedException e) {}
                }
                return true;
            }
        }

        private final PktRecoveryLog createTargetLog(int logNumber, long startingPos, boolean close) {
            PktRecoveryLog sourceLog = RogLogCompactor.this.log.getPacketLog();
            PktRecoveryLog targetLog = PktRecoveryLog.create((String)sourceLog.getDirname(), (String)RogLogCompactor.this.log.logFilename(logNumber)).setOpenMode(PktRecoveryLog.FileOpenMode.rw).setInitialLength(sourceLog.getInitialLength()).setZeroOutInitial(sourceLog.isZeroOutInitial()).setPageSize(sourceLog.getPageSize()).setReadBufferSize(sourceLog.getReadBufferSize()).setWriteBufferSize(sourceLog.getWriteBufferSize()).setFlushUsingMappedMemory(sourceLog.isFlushUsingMappedMemory()).setFlushDirectFromPacket(sourceLog.isFlushDirectFromPacket());
            int flags = 0;
            if (sourceLog.supportsTailing()) {
                flags |= 0x80;
            }
            targetLog.open(flags | 0x100, startingPos);
            if (close) {
                targetLog.close();
            }
            return targetLog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void shutdown() {
            RogLogCompactor rogLogCompactor = RogLogCompactor.this;
            synchronized (rogLogCompactor) {
                this.closed = true;
                this.reader.close();
                ((Object)((Object)RogLogCompactor.this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            while (this.waitForCompactionToBeTriggered()) {
                RogLogMetadata metadata = RogLogCompactor.this.log.getMetadata();
                int liveLogNumber = metadata.getLiveLogNumber();
                if (tracer.debug) {
                    tracer.log("[Compactor] Starting compaction (log #" + liveLogNumber + "->#" + (liveLogNumber + 1) + ") [size: " + this.format.format(RogLogCompactor.this.logSizeAtCompactStartTime) + ", marker=" + this.format.format(RogLogCompactor.this.logPosAtCompactStartTime) + "] ...", Tracer.Level.DEBUG);
                } else {
                    tracer.log("[Compactor] Starting compaction (log #" + liveLogNumber + "->#" + (liveLogNumber + 1) + ") [size: " + UtlFile.readableFileSize((long)RogLogCompactor.this.logSizeAtCompactStartTime) + "] ...", Tracer.Level.INFO);
                }
                PktRecoveryLog compactedPacketLog = null;
                try {
                    RogLogCompactor.this.log.dispatchEvent((Event)StorePersisterCompactionStartedEvent.create(null, RogLogCompactor.this.log, RogLogCompactor.this.logSizeAtCompactStartTime, RogLogCompactor.this.logFileSizeAtCompactStartTime));
                    RogLogCompactor.this.log.backupLog(liveLogNumber + 1, true);
                    compactedPacketLog = this.createTargetLog(liveLogNumber + 1, -1L, true);
                    this.writer.open(RogLogCompactor.this.log.getPacketLog().getDirname(), RogLogCompactor.this.log.logFilename(liveLogNumber), RogLogCompactor.this.log.logFilename(liveLogNumber + 1));
                    try {
                        long newFileSize;
                        long newSize;
                        long ts = System.currentTimeMillis();
                        RogLogCompactingReader.RunCompletionReason completionReason = this.reader.run(liveLogNumber, RogLogCompactor.this.logPosAtCompactStartTime);
                        switch (completionReason) {
                            case EndOfFile: {
                                throw new Exception("end of file reached during compaction run");
                            }
                            case MaxFilePointerReached: {
                                break;
                            }
                            case Closed: {
                                throw new Exception("compactor was closed before run completed");
                            }
                            default: {
                                throw new IllegalStateException("Received unknown error from compaction reader [" + (Object)((Object)completionReason) + "]");
                            }
                        }
                        RogLogCompactor.this.setState(State.Compacted);
                        RogLogCompactor.this.log.getCompactionSynchronizer().lock();
                        try {
                            long uncompactCopyStart = UtlTime.now();
                            RogLogCompactor.this.log.doFlush(false);
                            if (this.closed) {
                                throw new Exception("compactor was closed before run completed");
                            }
                            long eofSize = RogLogCompactor.this.logSizeAtCompactStartTime - RogLogCompactor.this.logPosAtCompactStartTime;
                            long numUncompactedBytes = RogLogCompactor.this.numBytesWrittenDuringCompaction + eofSize;
                            if (tracer.debug) {
                                tracer.log("[Compactor] Copying " + this.format.format(numUncompactedBytes) + " uncompacted bytes (entryCount=" + this.format.format(RogLogCompactor.this.numEntriesWrittenDuringCompaction) + ", entryBytes=" + this.format.format(RogLogCompactor.this.numBytesWrittenDuringCompaction) + ")", Tracer.Level.DEBUG);
                            }
                            this.writer.copyUncompacted(RogLogCompactor.this.logPosAtCompactStartTime, numUncompactedBytes);
                            if (tracer.debug) {
                                tracer.log("[Compactor] Uncompacted copy complete", Tracer.Level.DEBUG);
                            }
                            if (tracer.debug) {
                                tracer.log("[Compactor] Copy complete. Reopening target log...", Tracer.Level.DEBUG);
                            }
                            long lastValidatedPosition = 9L + this.handler.writeStats().tbytes + RogLogCompactor.this.numBytesWrittenDuringCompaction;
                            compactedPacketLog = this.createTargetLog(liveLogNumber + 1, lastValidatedPosition, false);
                            if (tracer.debug) {
                                tracer.log("[Compactor] Switching live log...", Tracer.Level.DEBUG);
                            }
                            metadata.setLiveLogNumber(liveLogNumber + 1);
                            metadata.setLastValidatedPosition(compactedPacketLog.getNextWritePointer());
                            RogLogCompactor.this.log.setPacketLog(compactedPacketLog);
                            int uncompactCopyTime = (int)(UtlTime.now() - uncompactCopyStart);
                            long brate = numUncompactedBytes * 1000000000L / (long)uncompactCopyTime;
                            tracer.log("[Compaction Reader] COPY STATS (T) [time=" + UtlUnit.formatDuration((double)uncompactCopyTime, (TimeUnit)TimeUnit.NANOSECONDS) + ", brate=" + UtlUnit.readableBytesSize((long)brate) + ", bytes=" + UtlUnit.readableBytesSize((long)numUncompactedBytes) + "]", Tracer.Level.INFO);
                            tracer.log("[Compactor] Switched live log to '" + RogLogCompactor.this.log.logFilename(), Tracer.Level.INFO);
                            newSize = RogLogCompactor.this.log.getSize();
                            newFileSize = RogLogCompactor.this.log.getAllocatedSize();
                        }
                        finally {
                            RogLogCompactor.this.log.getCompactionSynchronizer().unlock();
                        }
                        long startEntryCount = this.reader.readStats().tcount();
                        long endEntryCount = this.handler.writeStats().tcount + (long)RogLogCompactor.this.numEntriesWrittenDuringCompaction;
                        if (tracer.debug) {
                            tracer.log("[Compactor] Compaction complete (log #" + liveLogNumber + "->#" + (liveLogNumber + 1) + ") [entries: " + this.format.format(startEntryCount) + "->" + this.format.format(endEntryCount) + ", size: " + this.format.format(RogLogCompactor.this.logSizeAtCompactStartTime) + "->" + this.format.format(newSize) + ", fileSize:" + this.format.format(RogLogCompactor.this.logFileSizeAtCompactStartTime) + "->" + this.format.format(newFileSize) + ")].", Tracer.Level.INFO);
                        } else {
                            tracer.log("[Compactor] Compaction complete (log #" + liveLogNumber + "->#" + (liveLogNumber + 1) + ") [entries: " + this.format.format(startEntryCount) + "->" + this.format.format(endEntryCount) + ", size: " + UtlUnit.readableBytesSize((long)RogLogCompactor.this.logSizeAtCompactStartTime) + "->" + UtlUnit.readableBytesSize((long)newSize) + ", fileSize:" + UtlUnit.readableBytesSize((long)RogLogCompactor.this.logFileSizeAtCompactStartTime) + "->" + UtlUnit.readableBytesSize((long)newFileSize) + ")].", Tracer.Level.INFO);
                        }
                        RogLogCompactor.this.setState(State.Complete);
                        RogLogCompactor.this.log.dispatchEvent((Event)StorePersisterCompactionCompletedEvent.create(null, RogLogCompactor.this.log, RogLogCompactor.this.logSizeAtCompactStartTime, RogLogCompactor.this.logFileSizeAtCompactStartTime, newSize, newFileSize));
                        RogLogCompactor.this.log.scavenge();
                    }
                    finally {
                        this.writer.close();
                    }
                }
                catch (Exception e) {
                    tracer.log("[Compactor] Error encountered in compaction " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                    RogLogCompactor.this.compactionCompletionStatus = e;
                    RogLogCompactor.this.setState(State.Failed);
                    RogLogCompactor.this.log.dispatchEvent((Event)StorePersisterCompactionErrorEvent.create(null, RogLogCompactor.this.log, RogLogCompactor.this.compactionCompletionStatus));
                }
                finally {
                    if (!tracer.verbose) continue;
                    tracer.log("[Compactor] Finished compaction run.", Tracer.Level.VERBOSE);
                }
            }
            tracer.log("[Compactor] Shutting down...", Tracer.Level.INFO);
        }

        private final class CompactionReadHandler
        implements RogLogCompactingReader.ReadHandler {
            private final WriteStats writeStats = new WriteStats();

            CompactionReadHandler() {
            }

            final WriteStats writeStats() {
                return this.writeStats;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void handleCompacted(RogLogCompactingReader.LogObjectTable objects) throws Exception {
                int numObjects = objects.size();
                long compactedSize = objects.getCumulativeObjectSerializedSize();
                long lastTransactionId = objects.getLastTransactionId();
                long lastStableTransactionId = objects.getLastStableTransactionId();
                if (tracer.debug) {
                    tracer.log("[Compactor] Received compacted set [objectCount=" + numObjects + ", compactedSize=" + compactedSize + ", lastTransactionId=" + lastTransactionId + ", lastStableTransactionId=" + lastStableTransactionId + "]...", Tracer.Level.DEBUG);
                }
                try {
                    long ts = System.currentTimeMillis();
                    long val = 0L;
                    UtlLinkedHashMap.FastIterator iterator = objects.fastIterator().toFirst();
                    while (iterator.hasNext()) {
                        val += (long)((RogLogCompactingReader.LogObject)iterator.next().getValue()).getLogEntry().getSize();
                    }
                    if (tracer.debug) {
                        tracer.log("[Compactor] [reportedCompactedSize=" + compactedSize + ", calcCompactedSize=" + val + ", time=" + (System.currentTimeMillis() - ts) + "]...", Tracer.Level.DEBUG);
                    }
                    this.writeStats.start();
                    Runner.this.writer.ensureSpaceForCompactedEntries(compactedSize);
                    iterator = objects.fastIterator().toFirst();
                    long previousTransactionId = 0L;
                    long previousStableTransactionId = 0L;
                    boolean inCommit = false;
                    while (iterator.hasNext()) {
                        boolean commitEnd;
                        long nextTransactionId;
                        long stableTransactionId;
                        long transactionId;
                        RogLogCompactingReader.LogObject nextLogObject;
                        RogLogCompactingReader.LogObject logObject = (RogLogCompactingReader.LogObject)iterator.next().getValue();
                        boolean commitStart = !inCommit;
                        inCommit = true;
                        if (iterator.hasNext()) {
                            nextLogObject = (RogLogCompactingReader.LogObject)iterator.next().getValue();
                            try {
                                transactionId = logObject.getTransactionId();
                                stableTransactionId = logObject.getStableTransactionId() >= previousTransactionId ? previousTransactionId : previousStableTransactionId;
                                nextTransactionId = iterator.hasNext() ? nextLogObject.getTransactionId() : lastTransactionId;
                                commitEnd = transactionId != nextTransactionId;
                            }
                            finally {
                                iterator.previous();
                            }
                        } else {
                            nextLogObject = null;
                            transactionId = lastTransactionId;
                            stableTransactionId = lastStableTransactionId >= previousTransactionId ? previousTransactionId : previousStableTransactionId;
                            nextTransactionId = 0L;
                            commitEnd = true;
                        }
                        long checkpointVersion = logObject.getCheckpointVersion();
                        try {
                            RogLogCompactingReader.LogEntry logEntry = logObject.getLogEntry();
                            Runner.this.writer.write(logEntry, transactionId, stableTransactionId, checkpointVersion, commitStart, commitEnd);
                            this.writeStats.updateCheckAndOutputStats(logEntry.getSize());
                            if (commitEnd) {
                                previousTransactionId = transactionId;
                                previousStableTransactionId = stableTransactionId;
                            }
                            inCommit = !commitEnd;
                        }
                        catch (Throwable throwable) {
                            if (commitEnd) {
                                previousTransactionId = transactionId;
                                previousStableTransactionId = stableTransactionId;
                            }
                            inCommit = !commitEnd;
                            logObject.dispose();
                            throw throwable;
                        }
                        logObject.dispose();
                    }
                    this.writeStats.outputStats(true, System.currentTimeMillis());
                }
                finally {
                    objects.clear();
                    objects.done();
                }
            }

            @Override
            public final void onWait() {
                throw new InternalError("should have never be invoked");
            }

            final class WriteStats {
                private final NumberFormat format = NumberFormat.getInstance();
                long start;
                long ts;
                long tcount;
                long tbytes;
                long dcount;
                long dbytes;

                WriteStats() {
                    this.format.setMaximumFractionDigits(0);
                }

                final void start() {
                    this.tcount = 0L;
                    this.tbytes = 0L;
                    this.dcount = 0L;
                    this.dbytes = 0L;
                    this.start = this.ts = UtlTime.now();
                }

                final void outputStats(boolean endOfRun, long ts) {
                    long brate;
                    long elapsed = endOfRun ? ts - this.start : ts - this.ts;
                    long prate = endOfRun ? this.tcount * 1000000000L / elapsed : this.dcount * 1000000000L / elapsed;
                    long l = brate = endOfRun ? this.tbytes * 1000000000L / elapsed : this.dbytes * 1000000000L / elapsed;
                    if (endOfRun) {
                        tracer.log("[Compaction Reader] WRITE STATS (T) [time=" + UtlUnit.formatDuration((double)elapsed, (TimeUnit)TimeUnit.NANOSECONDS) + ", prate=" + this.format.format(prate) + ", brate=" + UtlUnit.readableBytesSize((long)brate) + ", count=" + this.format.format(this.tcount) + ", bytes=" + UtlUnit.readableBytesSize((long)this.tbytes) + "]", Tracer.Level.INFO);
                    } else if (tracer.verbose) {
                        tracer.log("[Compaction Reader] WRITE STATS (D) [time=" + UtlUnit.formatDuration((double)elapsed, (TimeUnit)TimeUnit.NANOSECONDS) + ", prate=" + this.format.format(prate) + ", brate=" + UtlUnit.readableBytesSize((long)brate) + ", count=" + this.format.format(this.dcount) + ", bytes=" + UtlUnit.readableBytesSize((long)this.dbytes) + "]", Tracer.Level.VERBOSE);
                    }
                    this.dcount = 0L;
                    this.dbytes = 0L;
                    this.ts = UtlTime.now();
                }

                final void updateCheckAndOutputStats(int size) {
                    ++this.dcount;
                    ++this.tcount;
                    this.dbytes += (long)size;
                    this.tbytes += (long)size;
                    long ts = UtlTime.now();
                    if (ts - this.ts >= 5000000000L) {
                        this.outputStats(false, ts);
                    }
                }
            }
        }
    }

    private final class Writer {
        private final UncompactedFile uncompacted = new UncompactedFile();
        private final CompactedFile compacted = new CompactedFile();

        Writer() {
        }

        private final void map(MemoryMappedFile file, FileChannel.MapMode mode) throws IOException {
            if (file.buffer != null) {
                file.buffer.dispose();
            }
            long position = Math.max(9L, file.bufferFilePointer + (long)file.bufferPos);
            long bytesRemaining = file.raf.length() - position;
            int bytesToMap = (int)Math.min(Integer.MAX_VALUE, bytesRemaining);
            if (tracer.debug) {
                tracer.log("[Compactor] Mapped " + bytesToMap + " bytes at pos=" + position + " in '" + file.filename + "'", Tracer.Level.DEBUG);
            }
            file.bufferFilePointer = position;
            file.buffer = IOBuffer.wrap((ByteBuffer)file.channel.map(mode, file.bufferFilePointer, bytesToMap));
            file.bufferPos = 0;
        }

        final void open(String dirname, String uncompactedFilename, String compactedFilename) throws IOException {
            this.uncompacted.open(dirname, uncompactedFilename);
            this.compacted.open(dirname, compactedFilename);
        }

        final void ensureSpaceForCompactedEntries(long numBytes) throws IOException {
            if (tracer.debug) {
                tracer.log("[Compactor] Ensuring compacted file has space for " + numBytes + " bytes of compacted entries.", Tracer.Level.DEBUG);
            }
            this.compacted.raf.setLength(Math.max(this.compacted.raf.length(), 9L + numBytes));
        }

        final void ensureSpaceForUncompactedEntries(long numBytes) throws IOException {
            long bytesRemaining = this.compacted.raf.length() - (this.compacted.bufferFilePointer + (long)this.compacted.bufferPos);
            if (numBytes > bytesRemaining) {
                if (tracer.debug) {
                    tracer.log("[Compactor] Extending compacted file length by " + (numBytes - bytesRemaining) + " bytes.", Tracer.Level.DEBUG);
                }
                this.compacted.raf.setLength(this.compacted.raf.length() + (numBytes - bytesRemaining));
            }
        }

        final void write(RogLogCompactingReader.LogEntry logEntry, long transactionId, long stableTransactionId, long checkpointVersion, boolean commitStart, boolean commitEnd) throws Exception {
            int serializedLength = logEntry.getSize();
            if (serializedLength > this.compacted.remainingInBuffer()) {
                this.map(this.compacted, FileChannel.MapMode.READ_WRITE);
            }
            this.compacted.write(logEntry.getBuffer().getNativeAddress(), logEntry.getBufferPos(), serializedLength);
            long addr = this.compacted.buffer.getNativeAddress();
            int offset = this.compacted.bufferPos - serializedLength;
            int odsSubheaderOffset = PktHeader.getSubheaderOffset((long)addr, (int)offset, (int)7);
            if (odsSubheaderOffset < 0) {
                throw new InternalError("ODS subheader now found in serialized form of packet");
            }
            byte flags = 8;
            if (commitStart) {
                flags = (byte)(flags | 2);
            }
            if (commitEnd) {
                flags = (byte)(flags | 1);
            }
            PktSubheaderODS.setFlags((long)addr, (int)odsSubheaderOffset, (byte)flags);
            PktSubheaderODS.setTransactionId((long)addr, (int)odsSubheaderOffset, (long)transactionId);
            PktSubheaderODS.setStableTransactionId((long)addr, (int)odsSubheaderOffset, (long)stableTransactionId);
            PktSubheaderODS.setCheckpointVersion((long)addr, (int)odsSubheaderOffset, (long)checkpointVersion);
        }

        final void copyUncompacted(long startPos, long totalBytesToCopy) throws Exception {
            this.ensureSpaceForUncompactedEntries(totalBytesToCopy);
            this.uncompacted.bufferFilePointer = startPos;
            while (totalBytesToCopy > 0L) {
                this.map(this.uncompacted, FileChannel.MapMode.READ_ONLY);
                this.map(this.compacted, FileChannel.MapMode.READ_WRITE);
                int bytesToCopy = (int)Math.min(totalBytesToCopy, (long)this.uncompacted.buffer.getLength());
                if (tracer.debug) {
                    tracer.log("[Compactor] Copyng " + bytesToCopy + " uncompacted bytes.", Tracer.Level.DEBUG);
                }
                this.compacted.write(this.uncompacted.buffer.getNativeAddress(), this.uncompacted.bufferPos, bytesToCopy);
                this.uncompacted.bufferPos += bytesToCopy;
                totalBytesToCopy -= (long)bytesToCopy;
            }
        }

        final void close() {
            this.compacted.close();
            this.uncompacted.close();
        }

        private final class CompactedFile
        extends MemoryMappedFile {
            private CompactedFile() {
            }

            final void open(String dirname, String filename) throws IOException {
                super.open(dirname, filename, true);
            }
        }

        private final class UncompactedFile
        extends MemoryMappedFile {
            private UncompactedFile() {
            }

            final void open(String dirname, String filename) throws IOException {
                super.open(dirname, filename, false);
            }
        }

        private abstract class MemoryMappedFile {
            String filename;
            RandomAccessFile raf;
            FileChannel channel;
            IOBuffer buffer;
            long bufferFilePointer;
            int bufferPos;

            private MemoryMappedFile() {
            }

            protected void open(String dirname, String filename, boolean forWrite) throws IOException {
                this.filename = filename;
                this.raf = new RandomAccessFile(new File(dirname, filename), forWrite ? "rw" : "r");
                this.channel = this.raf.getChannel();
            }

            final int remainingInBuffer() {
                return this.buffer == null ? 0 : this.buffer.getLength() - this.bufferPos;
            }

            final void write(long src, int srcOffset, int len) {
                IOBuffer.copy((long)src, (int)srcOffset, (long)this.buffer.getNativeAddress(), (int)this.bufferPos, (int)len);
                this.bufferPos += len;
            }

            final void close() {
                try {
                    if (this.buffer != null) {
                        this.buffer.dispose();
                    }
                    if (this.raf != null) {
                        this.raf.close();
                    }
                }
                catch (Exception e) {
                    tracer.log("[Compactor] Error encountered while closing compaction file ('" + this.filename + "')" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                }
                finally {
                    this.raf = null;
                    this.channel = null;
                    this.buffer = null;
                    this.bufferFilePointer = 0L;
                    this.bufferPos = 0;
                }
            }
        }
    }
}

