/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log;

import cern.colt.list.ObjectArrayList;
import com.eaio.uuid.UUID;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XLinkedList;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.OdsException;
import com.neeve.pkt.EPktException;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.pkt.log.EPktLogCorruptException;
import com.neeve.pkt.log.PktRecoveryLog;
import com.neeve.rog.RogObject;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogCheckpointReaderParams;
import com.neeve.rog.log.RogLogReader;
import com.neeve.stats.IStats;
import com.neeve.stats.StatsFactory;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class RogLogCompactionReader
extends RogObject {
    private final Tracer tracer;
    private final RogLogCheckpointReaderParams params;
    private final RogLog log;
    private final ReadHandler handler;
    private final CompactionBuffer compactionBuffer;
    private final StableCheckpointData stableCheckpointData = new StableCheckpointData();
    private final XLinkedHashMap<UUID, CompactionReaderEntry> checkpointEntries = new XLinkedHashMap();
    private XLinkedList<Checkpoint> unstablizedCheckpoints = new XLinkedList();
    private XLinkedList<Checkpoint> stabilizedCheckpoints = new XLinkedList();
    private final UtlPool<CompactionReaderEntry> entryPool;
    private final UtlPool<Checkpoint> checkpointPool;
    private int logNumber;
    private PktRecoveryLog.Reader checkpointFinderLogReader;
    private long numReadByFinderLogReader = 0L;
    private PktRecoveryLog.Reader checkpointProcessorLogReader;
    private long numReadByProcessorLogReader = 0L;
    private long maxStableTransactionId = -1L;
    private volatile boolean running = false;
    private volatile boolean closed = false;

    private RogLogCompactionReader(RogLog log, ReadHandler handler, Tracer tracer, RogLogCheckpointReaderParams params) {
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler cannot be null");
        }
        this.tracer = tracer;
        this.params = params;
        this.compactionBuffer = params.offheapBuffering ? new CompactionBuffer() : null;
        this.entryPool = UtlPool.create((String)"rog.log.compactentry", (String)log.getName(), (UtlPool.Factory)new UtlPool.Factory<CompactionReaderEntry>(){

            public CompactionReaderEntry createItem(Object object) {
                return new CompactionReaderEntry();
            }

            public CompactionReaderEntry[] createItemArray(int size) {
                return new CompactionReaderEntry[size];
            }
        }, (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.checkpointPool = UtlPool.create((String)"rog.log.checkpoint", (String)log.getName(), (UtlPool.Factory)new UtlPool.Factory<Checkpoint>(){

            public Checkpoint createItem(Object object) {
                return new Checkpoint();
            }

            public Checkpoint[] createItemArray(int size) {
                return new Checkpoint[size];
            }
        }, (UtlPool.Params)UtlPool.Params.create().setThreaded(false));
        this.log = log;
        this.handler = handler;
        if (tracer.debug) {
            StringBuilder sb = new StringBuilder();
            params.dump(sb, "...");
            tracer.log("[Compaction Reader] Created:\n" + sb, Tracer.Level.DEBUG);
        }
    }

    private static void throwPktCorruptionError(String message, PktPacket logPacket) throws EPktLogCorruptException {
        StringBuilder sb = new StringBuilder();
        sb.append(message).append(", Pkt Dump:\n");
        IOElasticBuffer headerBuffer = logPacket.getHeader().getBuffer();
        IOElasticBuffer bodyBuffer = logPacket.getBody().getBuffer();
        sb.append(headerBuffer != null ? headerBuffer.dump("  Header Buffer: ", 0, headerBuffer.getLength()) : " no header buffer!").append("\n  ");
        sb.append(headerBuffer != null ? bodyBuffer.dump("  Body Buffer: ", 0, bodyBuffer.getLength()) : " no body buffer!");
        sb.append("  [ body type: ").append(logPacket.getBody().getClass().getSimpleName()).append("]\n  ");
        sb.append("  Packet: " + logPacket.toString()).append("\n");
        PktRecoveryLog.FilePosition fp = (PktRecoveryLog.FilePosition)logPacket.getTag(4);
        sb.append("  FP: ").append(fp != null ? Long.valueOf(fp.getPosition()) : "???");
        sb.append(", SZ: ").append(fp != null ? Integer.valueOf(fp.getSize()) : "???");
        throw new EPktLogCorruptException(sb.toString());
    }

    private static long getPktFilePosition(PktPacket packet) throws EPktLogCorruptException {
        PktRecoveryLog.FilePosition fp = (PktRecoveryLog.FilePosition)packet.getTag(4);
        if (fp == null) {
            RogLogCompactionReader.throwPktCorruptionError("Missing file position", packet);
        }
        return ((PktRecoveryLog.FilePosition)packet.getTag(4)).getPosition();
    }

    private static int getPktFileSize(PktPacket packet) throws EPktLogCorruptException {
        PktRecoveryLog.FilePosition fp = (PktRecoveryLog.FilePosition)packet.getTag(4);
        if (fp == null) {
            RogLogCompactionReader.throwPktCorruptionError("Missing file position for packet", packet);
        }
        return ((PktRecoveryLog.FilePosition)packet.getTag(4)).getSize();
    }

    private static PktSubheaderODS getPktOdsHeader(PktPacket packet) throws EPktLogCorruptException {
        PktSubheaderODS odsHeader = packet.getHeader().getODSSubheader();
        if (odsHeader == null) {
            RogLogCompactionReader.throwPktCorruptionError("Logged packet is missing ODS subheader", packet);
        }
        return odsHeader;
    }

    private static RogLogReader.Entry.Type getPktEntryType(PktPacket packet) throws EPktLogCorruptException, OdsException {
        PktSubheaderODS ods = packet.getHeader().getODSSubheader();
        if (ods == null) {
            RogLogCompactionReader.throwPktCorruptionError("Packet does not have a valid ODS subheader", packet);
        }
        switch (ods.getCommitEntryType()) {
            case 1: {
                return RogLogReader.Entry.Type.Put;
            }
            case 2: {
                return RogLogReader.Entry.Type.Update;
            }
            case 3: {
                return RogLogReader.Entry.Type.Remove;
            }
            case 4: {
                return RogLogReader.Entry.Type.Send;
            }
            case 5: {
                return RogLogReader.Entry.Type.Message;
            }
        }
        throw new OdsException("PktPacket has unsupported commit entry type (type='" + ods.getCommitEntryType() + "')");
    }

    static final RogLogCompactionReader create(RogLog log, ReadHandler handler, Tracer tracer, RogLogCheckpointReaderParams params) {
        return new RogLogCompactionReader(log, handler, tracer, params);
    }

    private final RunCompletionReason getNextStableCheckpoint(long maxFilePointer, StableCheckpointData data) throws Exception {
        boolean waitEventDispatched = false;
        block0: while (!this.closed) {
            if (!this.stabilizedCheckpoints.isEmpty()) {
                Checkpoint checkpoint = (Checkpoint)this.stabilizedCheckpoints.removeFirst();
                if (this.tracer.debug) {
                    this.tracer.log("[Compaction Reader] returning stablized checkpoint [stabilized=" + this.stabilizedCheckpoints.size() + ", unstabilized=" + this.unstablizedCheckpoints.size() + " chkpnt=" + checkpoint + "]", Tracer.Level.DEBUG);
                }
                data.checkpointVersion = checkpoint.checkpointVersion;
                data.entryCount = checkpoint.entryCount;
                data.byteCount = checkpoint.byteCount;
                checkpoint.dispose();
                return null;
            }
            PktPacket logPacket = this.checkpointFinderLogReader.next();
            if (logPacket != null) {
                ++this.numReadByFinderLogReader;
                if (RogLogCompactionReader.getPktFilePosition(logPacket) >= maxFilePointer) {
                    logPacket.dispose();
                    return RunCompletionReason.MaxFilePointerReached;
                }
                PktSubheaderODS odsHeader = RogLogCompactionReader.getPktOdsHeader(logPacket);
                long entryCheckpointVersion = odsHeader.getCheckpointVersion();
                if (entryCheckpointVersion <= 0L) {
                    return RunCompletionReason.LogNotCheckpointed;
                }
                Checkpoint workingCheckpoint = !this.unstablizedCheckpoints.isEmpty() ? (Checkpoint)this.unstablizedCheckpoints.getLast() : null;
                long transactionId = odsHeader.getTransactionId();
                long stableTransactionId = odsHeader.getStableTransactionId();
                if (stableTransactionId < this.maxStableTransactionId) {
                    this.tracer.log("[Compaction Reader] encountered an of order stable transaction id at file position " + RogLogCompactionReader.getPktFilePosition(logPacket) + " (" + stableTransactionId + "<" + this.maxStableTransactionId + ")  [checkpoint=" + workingCheckpoint + "] packet = " + logPacket, Tracer.Level.WARNING);
                }
                this.maxStableTransactionId = Math.max(this.maxStableTransactionId, stableTransactionId);
                if (workingCheckpoint != null && entryCheckpointVersion == workingCheckpoint.checkpointVersion) {
                    if (workingCheckpoint.lastTransactionId > odsHeader.getTransactionId()) {
                        this.tracer.log("[Compaction Reader] encountered an of order transaction id at file position " + RogLogCompactionReader.getPktFilePosition(logPacket) + " (" + workingCheckpoint.lastTransactionId + ">" + transactionId + ")  [checkpoint=" + workingCheckpoint + "] packet = " + logPacket, Tracer.Level.WARNING);
                    }
                } else {
                    if (workingCheckpoint != null) {
                        if (entryCheckpointVersion < workingCheckpoint.checkpointVersion) {
                            this.tracer.log("[Compaction Reader] encountered an of order checkpoint version at file position " + RogLogCompactionReader.getPktFilePosition(logPacket) + " (" + workingCheckpoint.checkpointVersion + ">" + entryCheckpointVersion + ")  [checkpoint=" + workingCheckpoint + "] packet = " + logPacket, Tracer.Level.WARNING);
                        }
                        workingCheckpoint.complete = true;
                        if (this.tracer.debug) {
                            this.tracer.log("[Compaction Reader] completed " + workingCheckpoint + "]", Tracer.Level.DEBUG);
                        }
                    }
                    workingCheckpoint = (Checkpoint)this.checkpointPool.get(null);
                    workingCheckpoint.checkpointVersion = entryCheckpointVersion;
                    this.unstablizedCheckpoints.add((Object)workingCheckpoint);
                }
                workingCheckpoint.lastTransactionId = Math.max(odsHeader.getTransactionId(), workingCheckpoint.lastTransactionId);
                ++workingCheckpoint.entryCount;
                workingCheckpoint.byteCount += (long)RogLogCompactionReader.getPktFileSize(logPacket);
                logPacket.dispose();
                while (!this.unstablizedCheckpoints.isEmpty()) {
                    Checkpoint cp = (Checkpoint)this.unstablizedCheckpoints.getFirst();
                    if (!cp.complete || cp.lastTransactionId > this.maxStableTransactionId) continue block0;
                    this.stabilizedCheckpoints.add(this.unstablizedCheckpoints.removeFirst());
                }
                continue;
            }
            if (this.closed) break;
            if (this.logNumber < this.log.getMetadata().getLiveLogNumber()) {
                return RunCompletionReason.EndOfFile;
            }
            if (maxFilePointer < Long.MAX_VALUE) {
                return RunCompletionReason.MaxFilePointerReached;
            }
            if (!waitEventDispatched) {
                this.handler.onWait();
                waitEventDispatched = true;
            }
            Thread.sleep(100L);
        }
        return RunCompletionReason.Closed;
    }

    private final void closeCheckpointFinderLogReader() {
        if (this.checkpointFinderLogReader != null) {
            try {
                this.checkpointFinderLogReader.close();
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to shut down checkpoint finder log reader [").append(e.toString()).append("]\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
            finally {
                this.checkpointFinderLogReader = null;
            }
        }
    }

    private final void closeCheckpointProcessorLogReader() {
        if (this.checkpointProcessorLogReader != null) {
            try {
                this.checkpointProcessorLogReader.close();
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to shut down checkpoint processor log reader [").append(e.toString()).append("]\n");
                sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                this.tracer.log(sb.toString(), Tracer.Level.WARNING);
            }
            finally {
                this.checkpointProcessorLogReader = null;
            }
        }
    }

    final void releaseReaderFiles() {
        if (!this.running) {
            this.closeCheckpointProcessorLogReader();
            this.closeCheckpointFinderLogReader();
        }
    }

    /*
     * Exception decompiling
     */
    public final RunCompletionReason run(int logNumber, long maxFilePointer) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[MONITOR], 2[TRYBLOCK]], but top level block is 24[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final RunCompletionReason run() throws Exception {
        return this.run(this.log.getMetadata().getLiveLogNumber(), Long.MAX_VALUE);
    }

    public final PktPacket next() throws Exception {
        if (this.checkpointProcessorLogReader != null) {
            return this.checkpointProcessorLogReader.next();
        }
        throw new IllegalStateException("run was not invoked or reader is closed");
    }

    public final void close() {
        this.closed = true;
        if (!this.running) {
            this.closeCheckpointProcessorLogReader();
            this.entryPool.close();
            this.checkpointPool.close();
            if (this.compactionBuffer != null) {
                this.compactionBuffer.close();
            }
        }
    }

    static /* synthetic */ int access$800(RogLogCompactionReader x0) {
        return x0.logNumber;
    }

    static /* synthetic */ PktRecoveryLog.Reader access$1200(RogLogCompactionReader x0) {
        return x0.checkpointFinderLogReader;
    }

    public class CompactionBuffer {
        final XLinkedList<IOBuffer> usedBuffers = new XLinkedList();
        final StringBuilder statsOuput = new StringBuilder();
        final IStats.Latencies readLatencies;
        final IStats.Latencies writeLatencies;
        final Comparator<CompactionReaderEntry> filePositionComparator;
        private ObjectArrayList logOrderedList;

        public CompactionBuffer() {
            this.readLatencies = ((RogLogCompactionReader)RogLogCompactionReader.this).tracer.verbose ? StatsFactory.createLatencyStat((String)"read ", (int)131072) : null;
            this.writeLatencies = ((RogLogCompactionReader)RogLogCompactionReader.this).tracer.verbose ? StatsFactory.createLatencyStat((String)"write", (int)131072) : null;
            this.filePositionComparator = new Comparator<CompactionReaderEntry>(){

                @Override
                public int compare(CompactionReaderEntry o1, CompactionReaderEntry o2) {
                    long diff = o1.filePosition - o2.filePosition;
                    if (diff < 0L) {
                        return -1;
                    }
                    if (diff > 0L) {
                        return 1;
                    }
                    return 0;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private final void bufferCompactedEntries(XLinkedHashMap<UUID, CompactionReaderEntry> checkpointEntries) throws Exception {
            if (RogLogCompactionReader.access$700((RogLogCompactionReader)RogLogCompactionReader.this).offHeapBufferingLoadStrategy == RogLogCheckpointReaderParams.OffheapBufferingLoadStrategy.Disabled) {
                if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                    RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] Skipping object prebuffering (strategy=" + (Object)RogLogCompactionReader.access$700((RogLogCompactionReader)RogLogCompactionReader.this).offHeapBufferingLoadStrategy + ")", Tracer.Level.VERBOSE);
                }
                return;
            }
            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] Buffering compacted entries into to sequential off heap memory using " + (Object)RogLogCompactionReader.access$700((RogLogCompactionReader)RogLogCompactionReader.this).offHeapBufferingLoadStrategy, Tracer.Level.VERBOSE);
            }
            start = System.currentTimeMillis();
            serializedCount = 0L;
            serializedSize = 0L;
            if (this.logOrderedList == null) {
                this.logOrderedList = new ObjectArrayList(checkpointEntries.size());
            }
            this.logOrderedList.setSize(checkpointEntries.size());
            c = 0;
            entries = checkpointEntries.reuseableValueIterator();
            while (entries.hasNext()) {
                this.logOrderedList.setQuick(c++, entries.next());
            }
            this.logOrderedList.quickSortFromTo(0, this.logOrderedList.size() - 1, this.filePositionComparator);
            elapsed = System.currentTimeMillis() - start;
            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose || elapsed > 10000L) {
                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] Sorted conflated entries in " + UtlUnit.formatDuration((double)(System.currentTimeMillis() - start), (TimeUnit)TimeUnit.MILLISECONDS), Tracer.Level.INFO);
            }
            buffer = null;
            lastReport = System.currentTimeMillis();
            lastSize = 0L;
            this.statsOuput.setLength(0);
            block7 : switch (3.$SwitchMap$com$neeve$rog$log$RogLogCheckpointReaderParams$OffheapBufferingLoadStrategy[RogLogCompactionReader.access$700((RogLogCompactionReader)RogLogCompactionReader.this).offHeapBufferingLoadStrategy.ordinal()]) {
                case 1: {
                    raf = new RandomAccessFile(new File(RogLogCompactionReader.access$500(RogLogCompactionReader.this).getLogFile().getParentFile(), RogLogCompactionReader.access$500(RogLogCompactionReader.this).logFilename(RogLogCompactionReader.access$800(RogLogCompactionReader.this))), "r");
                    fileChannel = raf.getChannel();
                    mapMode = FileChannel.MapMode.READ_ONLY;
                    lastEntry = (CompactionReaderEntry)this.logOrderedList.get(this.logOrderedList.size() - 1);
                    lastEntryEnd = lastEntry.getFilePosition() + (long)lastEntry.getSizeOnDisk();
                    fileBuffer = null;
                    fileBufferOffset = 0L;
                    for (i = 0; i < this.logOrderedList.size(); ++i) {
                        compactionEntry = (CompactionReaderEntry)this.logOrderedList.get(i);
                        if (CompactionReaderEntry.access$900(compactionEntry) != null) {
                            this.logOrderedList.setQuick(i, null);
                            continue;
                        }
                        rs = System.nanoTime();
                        if (fileBuffer == null || compactionEntry.filePosition + (long)compactionEntry.sizeOnDisk > fileBufferOffset + (long)fileBuffer.limit()) {
                            lengthToMap = (int)Math.min((long)RogLogCompactionReader.access$700((RogLogCompactionReader)RogLogCompactionReader.this).memMappedReadBufferMaxSize, lastEntryEnd - compactionEntry.filePosition);
                            if (lengthToMap < compactionEntry.sizeOnDisk) {
                                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] Exceeding memMappedReadBufferMaxSize limit to accomodate large log entry (size=" + compactionEntry.sizeOnDisk + ")", Tracer.Level.WARNING);
                                lengthToMap = compactionEntry.sizeOnDisk;
                            }
                            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] Mapping log file at " + compactionEntry.filePosition + " with length=" + lengthToMap, Tracer.Level.VERBOSE);
                            }
                            this.releaseMappedBuffer((MappedByteBuffer)fileBuffer);
                            fileBuffer = null;
                            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).debug) {
                                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] released previously mapped portion", Tracer.Level.DEBUG);
                            }
                            fileBuffer = fileChannel.map(mapMode, compactionEntry.filePosition, lengthToMap);
                            if (RogLogCompactionReader.access$700((RogLogCompactionReader)RogLogCompactionReader.this).memMappedReadBufferLoad) {
                                if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                                    RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] loading mapped file portion", Tracer.Level.VERBOSE);
                                }
                                fileBuffer.load();
                                if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                                    RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] loaded mapped file portion", Tracer.Level.VERBOSE);
                                }
                            }
                            fileBufferOffset = compactionEntry.filePosition;
                        }
                        mappedBufferOffset = (int)(compactionEntry.filePosition - fileBufferOffset);
                        fileBuffer.position(mappedBufferOffset);
                        if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                            this.readLatencies.add((double)(System.nanoTime() - rs));
                        }
                        if (buffer == null || buffer.remaining() < compactionEntry.sizeOnDisk) {
                            buffer = this.newBuffer(compactionEntry.sizeOnDisk);
                        }
                        ws = System.nanoTime();
                        CompactionReaderEntry.access$1002(compactionEntry, buffer.position());
                        CompactionReaderEntry.access$1102(compactionEntry, (ByteBuffer)buffer);
                        try {
                            fileBuffer.limit(mappedBufferOffset + compactionEntry.sizeOnDisk);
                        }
                        catch (IllegalArgumentException e) {
                            RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("Error buffering entries: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                            throw e;
                        }
                        buffer.put((ByteBuffer)fileBuffer);
                        fileBuffer.limit(fileBuffer.capacity());
                        if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                            this.writeLatencies.add((double)(System.nanoTime() - ws));
                        }
                        serializedSize += (long)compactionEntry.sizeOnDisk;
                        if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose && ++serializedCount % 100000L == 0L) {
                            now = System.currentTimeMillis();
                            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] ...Serialized " + serializedCount + " from log position " + compactionEntry.filePosition + " into buffer position " + CompactionReaderEntry.access$1000(compactionEntry) + " in " + UtlUnit.formatDuration((double)(now - lastReport), (TimeUnit)TimeUnit.MILLISECONDS) + " [size=" + serializedSize + " (" + UtlUnit.readableBytesSize((long)(serializedSize - lastSize)) + ")]", Tracer.Level.VERBOSE);
                            }
                            this.readLatencies.compute();
                            this.readLatencies.get(this.statsOuput, DecimalFormat.getNumberInstance());
                            this.writeLatencies.compute();
                            this.writeLatencies.get(this.statsOuput, DecimalFormat.getNumberInstance());
                            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] ...Latencies:\n" + this.statsOuput, Tracer.Level.VERBOSE);
                            }
                            this.statsOuput.setLength(0);
                            lastSize = serializedSize;
                            lastReport = now;
                        }
                        this.logOrderedList.setQuick(i, null);
                    }
                    try {
                        this.releaseMappedBuffer((MappedByteBuffer)fileBuffer);
                        break;
                    }
                    finally {
                        raf.close();
                    }
                    catch (Throwable t) {
                        try {
                            RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("Error buffering entries: " + UtlThrowable.prepareStackTrace((Throwable)t), Tracer.Level.SEVERE);
                            throw new RuntimeException("Error buffering entries: [" + t.getMessage() + "]", t);
                        }
                        catch (Throwable var36_41) {
                            try {
                                this.releaseMappedBuffer((MappedByteBuffer)fileBuffer);
                            }
                            finally {
                                raf.close();
                            }
                            throw var36_41;
                        }
                    }
                }
                case 2: {
                    RogLogCompactionReader.access$1200(RogLogCompactionReader.this).seek(((CompactionReaderEntry)this.logOrderedList.get((int)0)).filePosition);
                    for (i = 0; i < this.logOrderedList.size(); ++i) {
                        compactionEntry = (CompactionReaderEntry)this.logOrderedList.getQuick(i);
                        if (CompactionReaderEntry.access$900(compactionEntry) != null) {
                            this.logOrderedList.setQuick(i, null);
                            continue;
                        }
                        rs = System.nanoTime();
                        packet = null;
                        while (true) {
                            if ((packet = RogLogCompactionReader.access$1200(RogLogCompactionReader.this).next()) == null) {
                                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] EOF reached without finding entry to compact ... aborting brebuffer", Tracer.Level.WARNING);
                                break block7;
                            }
                            fp = RogLogCompactionReader.access$100(packet);
                            if (fp == compactionEntry.filePosition) ** GOTO lbl144
                            if (fp >= compactionEntry.filePosition) break;
                            packet.dispose();
                        }
                        RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] File pointer exceeds entry to compact ... aborting brebuffer", Tracer.Level.WARNING);
                        packet.dispose();
                        break block7;
lbl144:
                        // 1 sources

                        if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                            this.readLatencies.add((double)(System.nanoTime() - rs));
                        }
                        if (buffer == null || buffer.remaining() < compactionEntry.sizeOnDisk) {
                            buffer = this.newBuffer(compactionEntry.sizeOnDisk);
                        }
                        ws = System.nanoTime();
                        CompactionReaderEntry.access$1002(compactionEntry, buffer.position());
                        CompactionReaderEntry.access$1102(compactionEntry, (ByteBuffer)buffer);
                        len = packet.serialize((ByteBuffer)buffer);
                        buffer.position(buffer.position() + len + 1);
                        if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                            this.writeLatencies.add((double)(System.nanoTime() - ws));
                        }
                        serializedSize += (long)len;
                        packet.dispose();
                        if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose && ++serializedCount % 100000L == 0L) {
                            now = System.currentTimeMillis();
                            RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] ...Serialized " + serializedCount + " from log position " + compactionEntry.filePosition + " into buffer position " + CompactionReaderEntry.access$1000(compactionEntry) + " in " + UtlUnit.formatDuration((double)(now - lastReport), (TimeUnit)TimeUnit.MILLISECONDS) + " [size=" + serializedSize + " (" + UtlUnit.readableBytesSize((long)(serializedSize - lastSize)) + ")]", Tracer.Level.VERBOSE);
                            this.readLatencies.compute();
                            this.readLatencies.get(this.statsOuput, DecimalFormat.getNumberInstance());
                            this.writeLatencies.compute();
                            this.writeLatencies.get(this.statsOuput, DecimalFormat.getNumberInstance());
                            RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] ...Latencies:\n" + this.statsOuput, Tracer.Level.VERBOSE);
                            this.statsOuput.setLength(0);
                            lastSize = serializedSize;
                            lastReport = now;
                        }
                        this.logOrderedList.setQuick(i, null);
                    }
                    break;
                }
                case 3: {
                    raf = new RandomAccessFile(new File(RogLogCompactionReader.access$500(RogLogCompactionReader.this).getLogFile().getParentFile(), RogLogCompactionReader.access$500(RogLogCompactionReader.this).logFilename(RogLogCompactionReader.access$800(RogLogCompactionReader.this))), "r");
                    readBuffer = IOBuffer.create((int)4096);
                    try {
                        for (i = 0; i < this.logOrderedList.size(); ++i) {
                            compactionEntry = (CompactionReaderEntry)this.logOrderedList.getQuick(i);
                            if (CompactionReaderEntry.access$900(compactionEntry) != null) {
                                this.logOrderedList.setQuick(i, null);
                                continue;
                            }
                            rs = System.nanoTime();
                            if (readBuffer.getCapacity() < compactionEntry.sizeOnDisk) {
                                readBuffer.dispose();
                                readBuffer = IOBuffer.create((int)compactionEntry.sizeOnDisk);
                            }
                            bytes = readBuffer.getBufferUnsafe().array();
                            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                                this.readLatencies.add((double)(System.nanoTime() - rs));
                            }
                            raf.seek(compactionEntry.getFilePosition());
                            for (bytesRead = 0; bytesRead < compactionEntry.sizeOnDisk; bytesRead += raf.read(bytes, bytesRead, compactionEntry.sizeOnDisk - bytesRead)) {
                            }
                            if (buffer == null || buffer.remaining() < compactionEntry.sizeOnDisk) {
                                buffer = this.newBuffer(compactionEntry.sizeOnDisk);
                            }
                            ws = System.nanoTime();
                            CompactionReaderEntry.access$1002(compactionEntry, buffer.position());
                            CompactionReaderEntry.access$1102(compactionEntry, (ByteBuffer)buffer);
                            buffer.put(bytes, 0, compactionEntry.sizeOnDisk);
                            serializedSize += (long)compactionEntry.sizeOnDisk;
                            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                                this.writeLatencies.add((double)(System.nanoTime() - ws));
                            }
                            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose && ++serializedCount % 100000L == 0L) {
                                now = System.currentTimeMillis();
                                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] ...Serialized " + serializedCount + " from log position " + compactionEntry.filePosition + " into buffer position " + CompactionReaderEntry.access$1000(compactionEntry) + " in " + UtlUnit.formatDuration((double)(now - lastReport), (TimeUnit)TimeUnit.MILLISECONDS) + " [size=" + serializedSize + " (" + UtlUnit.readableBytesSize((long)(serializedSize - lastSize)) + ")]", Tracer.Level.VERBOSE);
                                this.readLatencies.compute();
                                this.readLatencies.get(this.statsOuput, DecimalFormat.getNumberInstance());
                                this.writeLatencies.compute();
                                this.writeLatencies.get(this.statsOuput, DecimalFormat.getNumberInstance());
                                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] ...Latencies:\n" + this.statsOuput, Tracer.Level.VERBOSE);
                                this.statsOuput.setLength(0);
                                lastSize = serializedSize;
                                lastReport = now;
                            }
                            this.logOrderedList.setQuick(i, null);
                        }
                        break;
                    }
                    catch (Throwable t) {
                        RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("Error buffering entries: " + UtlThrowable.prepareStackTrace((Throwable)t), Tracer.Level.SEVERE);
                        throw new RuntimeException("Error buffering entries: [" + t.getMessage() + "]", t);
                    }
                    finally {
                        raf.close();
                        if (readBuffer != null) {
                            readBuffer.dispose();
                        }
                    }
                }
            }
            if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).fine) {
                elapsed = Math.max(1L, System.currentTimeMillis() - start);
                RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] Done conflating entries to sequential off heap buffer [" + UtlUnit.readableBytesSize((long)serializedSize) + " in " + UtlUnit.formatDuration((double)elapsed, (TimeUnit)TimeUnit.MILLISECONDS) + " (" + UtlUnit.readableBytesSize((long)(serializedSize * 1000L / elapsed)) + "/sec)]", Tracer.Level.FINE);
                if (RogLogCompactionReader.access$600((RogLogCompactionReader)RogLogCompactionReader.this).verbose) {
                    this.readLatencies.compute();
                    this.readLatencies.get(this.statsOuput, DecimalFormat.getNumberInstance());
                    this.writeLatencies.compute();
                    this.writeLatencies.get(this.statsOuput, DecimalFormat.getNumberInstance());
                    RogLogCompactionReader.access$600(RogLogCompactionReader.this).log("[Compaction Reader] ...Latencies:\n" + this.statsOuput, Tracer.Level.VERBOSE);
                }
            }
        }

        private final void releaseMappedBuffer(MappedByteBuffer mappedFileBuffer) {
            if (mappedFileBuffer != null) {
                try {
                    UtlBuffer.releaseBuffer((ByteBuffer)mappedFileBuffer);
                }
                catch (RuntimeException e) {
                    throw new EPktException("compactor log file unmap failure [" + e.toString() + "]");
                }
            }
        }

        private ByteBuffer newBuffer(int minSize) {
            if (((RogLogCompactionReader)RogLogCompactionReader.this).tracer.debug) {
                RogLogCompactionReader.this.tracer.log("[Compaction Reader] Serializing to buffer (" + (this.usedBuffers.size() + 1) + ")", Tracer.Level.DEBUG);
            }
            IOBuffer iobuf = IOBuffer.create((int)Math.max(minSize, ((RogLogCompactionReader)RogLogCompactionReader.this).params.offHeapBufferingMaxPageSize));
            this.usedBuffers.add((Object)iobuf);
            return iobuf.getBufferUnsafe();
        }

        public void releaseBuffers() {
            XIterator buffers = this.usedBuffers.reusableIterator();
            while (buffers.hasNext()) {
                IOBuffer buffer = (IOBuffer)buffers.next();
                if (buffer.getPool() != null) {
                    buffer.dispose();
                } else {
                    UtlBuffer.releaseBuffer((ByteBuffer)buffer.getBufferUnsafe());
                }
                buffers.remove();
            }
        }

        public void close() {
            this.releaseBuffers();
        }

        static /* synthetic */ void access$1600(CompactionBuffer x0, XLinkedHashMap x1) throws Exception {
            x0.bufferCompactedEntries((XLinkedHashMap<UUID, CompactionReaderEntry>)x1);
        }
    }

    public class CompactionReaderEntry
    implements UtlPool.Item<CompactionReaderEntry> {
        private UtlPool<CompactionReaderEntry> pool;
        private PktPacket packet;
        private ByteBuffer packetBuffer;
        private int bufferPosition;
        final UUID id = new UUID(0L, 0L);
        long filePosition;
        int sizeOnDisk;
        ReadHandler.ChangeType type;

        CompactionReaderEntry() {
        }

        private CompactionReaderEntry update(PktPacket logPacket) throws OdsException {
            PktSubheaderODS odsHeader = RogLogCompactionReader.getPktOdsHeader(logPacket);
            this.releasePacket();
            this.packet = logPacket;
            UUID objectId = odsHeader.getObjectId();
            if (objectId != null) {
                this.id.clockSeqAndNode = objectId.clockSeqAndNode;
                this.id.time = objectId.time;
            }
            this.filePosition = RogLogCompactionReader.getPktFilePosition(logPacket);
            this.sizeOnDisk = RogLogCompactionReader.getPktFileSize(logPacket);
            switch (RogLogCompactionReader.getPktEntryType(logPacket)) {
                case Message: 
                case Send: {
                    this.type = ReadHandler.ChangeType.Send;
                    break;
                }
                case Put: {
                    this.type = ReadHandler.ChangeType.Put;
                    break;
                }
                case Remove: {
                    this.type = ReadHandler.ChangeType.Remove;
                    break;
                }
                case Update: {
                    this.type = ReadHandler.ChangeType.Update;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown log entry type " + (Object)((Object)RogLogCompactionReader.getPktEntryType(logPacket)));
                }
            }
            return this;
        }

        public final int getSizeOnDisk() {
            return this.sizeOnDisk;
        }

        public final PktPacket getPacket() {
            if (this.packet != null) {
                this.packet.acquire();
                return this.packet;
            }
            if (this.packetBuffer != null) {
                return PktFactory.getInstance().createPacket(this.packetBuffer, this.bufferPosition, this.packetBuffer.capacity() - this.bufferPosition);
            }
            try {
                return RogLogCompactionReader.this.checkpointProcessorLogReader.readAt(this.filePosition);
            }
            catch (IOException e) {
                throw new RuntimeException("Error fetching log entry '" + this.id + "' at position: " + this.filePosition + "[" + e.getMessage() + "]", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final IStoreObject getObject() {
            RogLogReader.Entry logEntry = this.getLogEntry();
            try {
                IStoreObject object = logEntry.getObject();
                if (object != null) {
                    object.acquire();
                }
                IStoreObject iStoreObject = object;
                return iStoreObject;
            }
            finally {
                logEntry.dispose();
            }
        }

        public final RogLogReader.Entry getLogEntry() {
            try {
                return RogLogReader.Entry.create(RogLogCompactionReader.this.log, this.getPacket(), this.filePosition, this.sizeOnDisk);
            }
            catch (OdsException e) {
                throw new RuntimeException("Error fetching log entry '" + this.id + "' at position: " + this.filePosition + "[" + e.getMessage() + "]", e);
            }
        }

        public UUID getId() {
            return this.id;
        }

        public long getFilePosition() {
            return this.filePosition;
        }

        public final ReadHandler.ChangeType getEntryType() {
            return this.type;
        }

        public void dispose() {
            this.releasePacket();
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            } else {
                this.init();
            }
        }

        public void releasePacket() {
            if (this.packet != null) {
                this.packet.dispose();
                this.packet = null;
            }
        }

        public CompactionReaderEntry init() {
            this.releasePacket();
            this.packetBuffer = null;
            this.id.clockSeqAndNode = 0L;
            this.id.time = 0L;
            return this;
        }

        public CompactionReaderEntry setPool(UtlPool<CompactionReaderEntry> pool) {
            this.pool = pool;
            return this;
        }

        public UtlPool<CompactionReaderEntry> getPool() {
            return this.pool;
        }

        static /* synthetic */ PktPacket access$900(CompactionReaderEntry x0) {
            return x0.packet;
        }

        static /* synthetic */ int access$1002(CompactionReaderEntry x0, int x1) {
            x0.bufferPosition = x1;
            return x0.bufferPosition;
        }

        static /* synthetic */ ByteBuffer access$1102(CompactionReaderEntry x0, ByteBuffer x1) {
            x0.packetBuffer = x1;
            return x0.packetBuffer;
        }

        static /* synthetic */ int access$1000(CompactionReaderEntry x0) {
            return x0.bufferPosition;
        }

        static /* synthetic */ CompactionReaderEntry access$1500(CompactionReaderEntry x0, PktPacket x1) throws OdsException {
            return x0.update(x1);
        }
    }

    public static enum RunCompletionReason {
        LogNotCheckpointed,
        EndOfFile,
        MaxFilePointerReached,
        Closed;

    }

    public static interface ReadHandler {
        public boolean onCheckpointStart(long var1);

        public void handleConflatedChanges(XLinkedHashMap<UUID, CompactionReaderEntry> var1);

        public void handleChange(ChangeType var1, List<CompactionReaderEntry> var2);

        public void onCheckpointComplete(long var1, int var3, int var4);

        public void onWait();

        public static enum ChangeType {
            Put,
            Update,
            Remove,
            Send,
            Noop;

        }
    }

    private final class Checkpoint
    implements UtlPool.Item<Checkpoint> {
        UtlPool<Checkpoint> pool;
        long checkpointVersion;
        public boolean complete;
        long lastTransactionId;
        int entryCount;
        long byteCount;

        private Checkpoint() {
        }

        public Checkpoint init() {
            this.checkpointVersion = -1L;
            this.lastTransactionId = -1L;
            this.complete = false;
            this.entryCount = 0;
            this.byteCount = 0L;
            return this;
        }

        public void dispose() {
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }

        public Checkpoint setPool(UtlPool<Checkpoint> pool) {
            this.pool = pool;
            return this;
        }

        public UtlPool<Checkpoint> getPool() {
            return this.pool;
        }

        public String toString() {
            return "Checkpoint#" + this.checkpointVersion + " [lastTransactionId=" + this.lastTransactionId + ", entries=" + this.entryCount + ", complete=" + this.complete + "]";
        }
    }

    private final class StableCheckpointData {
        long checkpointVersion;
        int entryCount;
        long byteCount;

        private StableCheckpointData() {
        }

        public final void reset() {
            this.checkpointVersion = 0L;
            this.entryCount = 0;
            this.byteCount = 0L;
        }
    }
}

