/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.AggregateNode;
import com.akiban.sql.parser.AndNode;
import com.akiban.sql.parser.BetweenOperatorNode;
import com.akiban.sql.parser.BinaryRelationalOperatorNode;
import com.akiban.sql.parser.CastNode;
import com.akiban.sql.parser.CharConstantNode;
import com.akiban.sql.parser.ColumnReference;
import com.akiban.sql.parser.CreateIndexNode;
import com.akiban.sql.parser.CursorNode;
import com.akiban.sql.parser.FromList;
import com.akiban.sql.parser.FromTable;
import com.akiban.sql.parser.GroupByColumn;
import com.akiban.sql.parser.GroupByList;
import com.akiban.sql.parser.InListOperatorNode;
import com.akiban.sql.parser.IndexColumn;
import com.akiban.sql.parser.IndexColumnList;
import com.akiban.sql.parser.LikeEscapeOperatorNode;
import com.akiban.sql.parser.NotNode;
import com.akiban.sql.parser.NumericConstantNode;
import com.akiban.sql.parser.OrNode;
import com.akiban.sql.parser.OrderByColumn;
import com.akiban.sql.parser.OrderByList;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumn;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.ResultSetNode;
import com.akiban.sql.parser.RowConstructorNode;
import com.akiban.sql.parser.SQLParser;
import com.akiban.sql.parser.SelectNode;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.UnaryComparisonOperatorNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.ValueNodeList;
import com.akiban.sql.types.DataTypeDescriptor;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.neeve.query.QueryException;
import com.neeve.query.QueryParseException;
import com.neeve.query.impl.QueryValidator;
import com.neeve.query.impl.util.UtlQueryRegex;
import com.neeve.util.UtlText;
import com.neeve.util.UtlTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class QueryParser {
    private static final String ABSOLUTE_PATH_TOKEN = "nvxroot";
    private static final Set<String> pseudoColumns = Sets.newHashSet((Object[])new String[]{"x_repository_name"});
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";
    private static final String ESCAPED_SINGLE_QUOTE = "''";
    public static final String NVX_RECORD = "nvx:record";
    public static final Column SELECT_ALL = new Column(null, "*");
    private SQLParser parser = new SQLParser();
    private QueryValidator validator = new QueryValidator();

    private static String qualify(String tableName, String columnName) {
        return Strings.isNullOrEmpty((String)tableName) ? columnName : tableName + "." + columnName;
    }

    public Condition getHaving(Result parseResult) {
        SelectNode select = parseResult.getSelect();
        ValueNode having = select.getHavingClause();
        return having == null ? null : this.getCondition(parseResult, having);
    }

    public List<Column> getGroupBy(Result parseResult) {
        SelectNode select = parseResult.getSelect();
        ArrayList columns = Lists.newArrayList();
        GroupByList groupByList = select.getGroupByList();
        if (groupByList != null) {
            int numColumns = groupByList.size();
            for (int i = 0; i < numColumns; ++i) {
                GroupByColumn groupByColumn = (GroupByColumn)groupByList.get(i);
                Column column = this.getColumn(parseResult, (QueryTreeNode)groupByColumn);
                columns.add(column);
            }
        }
        return columns;
    }

    public List<Column> getOrderBy(Result parseResult) {
        CursorNode cursor;
        OrderByList orderByList;
        StatementNode statement = parseResult.getStatement();
        ArrayList orderByColumns = Lists.newArrayList();
        if (statement instanceof CursorNode && (orderByList = (cursor = (CursorNode)statement).getOrderByList()) != null) {
            int size = orderByList.size();
            for (int i = 0; i < size; ++i) {
                Column column = this.getColumn(parseResult, orderByList.get(i));
                orderByColumns.add(column);
            }
        }
        return orderByColumns;
    }

    public Range<Integer> getLimitRange(Result parseResult) {
        CursorNode cursor = (CursorNode)parseResult.getStatement();
        Integer offset = (Integer)this.getConstant(cursor.getOffsetClause());
        Integer fetchSize = (Integer)this.getConstant(cursor.getFetchFirstClause());
        if (offset == null) {
            if (fetchSize == null) {
                return null;
            }
            return Range.upTo((Comparable)fetchSize, (BoundType)BoundType.CLOSED);
        }
        if (fetchSize == null) {
            return Range.downTo((Comparable)offset, (BoundType)BoundType.OPEN);
        }
        return Range.openClosed((Comparable)offset, (Comparable)Integer.valueOf(offset + fetchSize));
    }

    private String preprocessToken(String token) {
        String result = token;
        if (result.startsWith("/")) {
            result = ABSOLUTE_PATH_TOKEN + result.substring(1);
        }
        result = result.replace("/", "_");
        if ((result = result.replace("$", "_")).contains(".")) {
            int firstPeriodIndex = result.indexOf(".");
            String className = result.substring(0, firstPeriodIndex);
            String beanPath = result.substring(firstPeriodIndex + 1);
            beanPath = beanPath.replace(".", "_");
            result = className + "." + beanPath;
        }
        return result;
    }

    private String preprocessStatement(String originalSql) {
        String sql = UtlQueryRegex.preprocessRegexLikeOperator(originalSql);
        StringBuilder b = new StringBuilder();
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        int openDoubleQuote = sql.indexOf(DOUBLE_QUOTE);
        int openSingleQuote = sql.indexOf(SINGLE_QUOTE);
        if (openDoubleQuote >= 0 && openSingleQuote >= 0) {
            if (openDoubleQuote < openSingleQuote) {
                inDoubleQuote = true;
            } else {
                inSingleQuote = true;
            }
        } else {
            inDoubleQuote = openDoubleQuote >= 0;
            boolean bl = inSingleQuote = openSingleQuote >= 0;
        }
        if (inDoubleQuote) {
            int closeDoubleQuote = sql.indexOf(DOUBLE_QUOTE, openDoubleQuote + 1);
            if (closeDoubleQuote == -1) {
                throw new QueryParseException("Open quote found without corresponding close quote", openDoubleQuote);
            }
            if (openDoubleQuote > 0) {
                String beforeQuoted = sql.substring(0, openDoubleQuote);
                String preprocessedBefore = this.preprocessStatement(beforeQuoted);
                b.append(preprocessedBefore);
                b.append(" ");
            }
            b.append(sql.substring(openDoubleQuote, closeDoubleQuote + 1));
            if (closeDoubleQuote < sql.length() - 1) {
                b.append(" ");
                String afterQuoted = sql.substring(closeDoubleQuote + 1);
                String preprocessedAfter = this.preprocessStatement(afterQuoted);
                b.append(preprocessedAfter);
            }
        } else if (inSingleQuote) {
            int nextSingleQuote = sql.indexOf(SINGLE_QUOTE, openSingleQuote + 1);
            if (nextSingleQuote == -1) {
                throw new QueryParseException("Open single quote found without corresponding close quote", openSingleQuote);
            }
            int escapedSingleQuote = sql.indexOf(ESCAPED_SINGLE_QUOTE, openSingleQuote + 1);
            while (escapedSingleQuote == nextSingleQuote) {
                nextSingleQuote = sql.indexOf(SINGLE_QUOTE, escapedSingleQuote + 2);
                if (nextSingleQuote == -1) {
                    throw new QueryParseException("Open single quote found without corresponding close quote", openSingleQuote);
                }
                escapedSingleQuote = sql.indexOf(ESCAPED_SINGLE_QUOTE, openSingleQuote + 2);
            }
            int closeSingleQuote = nextSingleQuote;
            if (openSingleQuote > 0) {
                String beforeQuoted = sql.substring(0, openSingleQuote);
                String preprocessedBefore = this.preprocessStatement(beforeQuoted);
                b.append(preprocessedBefore);
                b.append(" ");
            }
            b.append(sql.substring(openSingleQuote, closeSingleQuote + 1));
            if (closeSingleQuote < sql.length() - 1) {
                b.append(" ");
                String afterQuoted = sql.substring(closeSingleQuote + 1);
                String preprocessedAfter = this.preprocessStatement(afterQuoted);
                b.append(preprocessedAfter);
            }
        } else {
            boolean firstToken = true;
            for (String xpqlToken : UtlQueryRegex.tokens(sql)) {
                if (firstToken) {
                    firstToken = false;
                } else {
                    b.append(" ");
                }
                String sqlToken = this.preprocessToken(xpqlToken);
                b.append(sqlToken);
            }
        }
        return b.toString();
    }

    private String postprocessTable(String tableName) {
        if (tableName == null) {
            return null;
        }
        String result = tableName;
        result = result.replace("__", ".");
        result = result.replace("_", ".");
        return result;
    }

    private String postprocessColumn(String columnName) {
        String lower = columnName.toLowerCase();
        if (pseudoColumns.contains(lower)) {
            return lower;
        }
        return columnName.replace("_", ".");
    }

    private String postProcessFrom(String from) {
        if (Strings.isNullOrEmpty((String)from)) {
            return "";
        }
        if (from.startsWith(ABSOLUTE_PATH_TOKEN)) {
            from = "/" + from.substring(ABSOLUTE_PATH_TOKEN.length());
        }
        return from.replace("_", "/");
    }

    public boolean isDDL(String sql) {
        return UtlText.startsWithIgnoreCase((String)sql, (String)"create") || UtlText.startsWithIgnoreCase((String)sql, (String)"drop");
    }

    public Column parseColumn(String columnDef) throws QueryParseException {
        if (columnDef == null) {
            throw new QueryParseException("Column definition can't be null", 0);
        }
        if (columnDef.trim().length() == 0) {
            throw new QueryParseException("Column definition can't be empty", 0);
        }
        int dot = columnDef.indexOf(46);
        if (dot == 0) {
            throw new QueryParseException("Column definition can't start with '.'", dot);
        }
        if (dot == columnDef.length() - 1) {
            throw new QueryParseException("Column definition can't end with '.'", dot);
        }
        if (dot == -1) {
            return new Column(columnDef.replace("/", "."), null);
        }
        return new Column(columnDef.substring(0, dot).replace("/", "."), columnDef.substring(dot + 1));
    }

    public StatementNode parseDDL(String sql) throws QueryParseException {
        try {
            if (UtlText.startsWithIgnoreCase((String)sql, (String)"create")) {
                String preprocessed = this.preprocessCreateIndex(sql);
                StatementNode stmt = this.parser.parseStatement(preprocessed);
                return this.postprocessCreateIndex(stmt, preprocessed);
            }
            if (UtlText.startsWithIgnoreCase((String)sql, (String)"drop")) {
                return this.parser.parseStatement(sql);
            }
            throw new QueryParseException("Provided SQL is not DDL: " + sql, 0);
        }
        catch (StandardException e) {
            throw new QueryParseException(e.getMessage(), 0);
        }
    }

    private String preprocessCreateIndex(String ddl) {
        int openPos = ddl.indexOf("(");
        if (openPos == -1) {
            throw new QueryParseException("index column not found", 0);
        }
        int closePos = ddl.indexOf(")", openPos);
        String preprocessed = ddl.substring(0, openPos + 1);
        String columns = ddl.substring(openPos + 1, closePos);
        String[] columnArray = columns.split(",");
        boolean firstColumn = true;
        for (String column : columnArray) {
            if (!firstColumn) {
                preprocessed = preprocessed + ",";
            } else {
                firstColumn = false;
            }
            preprocessed = preprocessed + this.preprocessToken(column);
        }
        preprocessed = preprocessed + ddl.substring(closePos);
        return preprocessed;
    }

    private StatementNode postprocessCreateIndex(StatementNode stmt, String preprocessed) throws StandardException {
        CreateIndexNode createIndex = (CreateIndexNode)stmt;
        TableName indexTable = createIndex.getIndexTableName();
        int tableNameEndOffset = indexTable.getEndOffset();
        int indexOfOpenParen = preprocessed.indexOf(40, tableNameEndOffset);
        int indexOfCloseParen = preprocessed.indexOf(41, indexOfOpenParen + 1);
        String indexColumnsText = preprocessed.substring(indexOfOpenParen + 1, indexOfCloseParen);
        String[] indexColumnsTexts = indexColumnsText.split(",");
        IndexColumnList indexColumns = createIndex.getColumnList();
        int numColumns = indexColumns.size();
        for (int i = 0; i < numColumns; ++i) {
            IndexColumn indexColumn = (IndexColumn)indexColumns.get(i);
            String preprocessedColumn = indexColumnsTexts[i];
            String tablePart = null;
            String columnPart = null;
            if (preprocessedColumn.contains(".")) {
                int periodPos = preprocessedColumn.indexOf(".");
                tablePart = preprocessedColumn.substring(0, periodPos);
                tablePart = this.postprocessTable(tablePart);
                columnPart = preprocessedColumn.substring(periodPos + 1);
                columnPart = this.postprocessColumn(columnPart);
            } else {
                columnPart = this.postprocessColumn(preprocessedColumn);
            }
            TableName indexTableName = indexColumn.makeTableName(null, tablePart);
            indexColumn.init((Object)indexTableName, (Object)columnPart, (Object)indexColumn.isAscending());
        }
        return stmt;
    }

    public Result parseQuery(String query) throws QueryParseException {
        String sql = this.preprocessStatement(query);
        try {
            StatementNode stmt = this.parser.parseStatement(sql);
            this.validator.validateSelect(stmt);
            return new Result(query, sql, stmt);
        }
        catch (StandardException e) {
            throw new QueryParseException(e.getMessage(), 0);
        }
    }

    private SelectNode getSelect(Result result) throws QueryParseException {
        CursorNode cursor;
        ResultSetNode resultSet;
        StatementNode stmt = result.getStatement();
        if (stmt.getNodeType() == 147 && (resultSet = (cursor = (CursorNode)stmt).getResultSetNode()).getNodeType() == 129) {
            return (SelectNode)resultSet;
        }
        throw new QueryParseException("Statement is not SELECT", 0);
    }

    private List<Column> getColumnList(Result parseResult) {
        SelectNode select = parseResult.getSelect();
        ArrayList columns = Lists.newArrayList();
        ResultColumnList resultColumns = select.getResultColumns();
        int numColumns = resultColumns.size();
        for (int i = 0; i < numColumns; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumns.get(i);
            Column column = this.getColumn(parseResult, (QueryTreeNode)resultColumn);
            columns.add(column);
        }
        return columns;
    }

    public boolean isDistinct(Result parseResult) {
        SelectNode select = parseResult.getSelect();
        return select.isDistinct();
    }

    private List<String> getFromList(Result parseResult) throws QueryParseException {
        SelectNode select = parseResult.getSelect();
        ArrayList tables = Lists.newArrayList();
        FromList fromList = select.getFromList();
        int numTables = fromList.size();
        for (int i = 0; i < numTables; ++i) {
            FromTable fromTable = (FromTable)fromList.get(i);
            try {
                TableName tableName = fromTable.getTableName();
                String schema = tableName.getSchemaName();
                schema = this.postProcessFrom(schema);
                String table = tableName.getTableName();
                String qualifiedTableName = QueryParser.qualify(schema, table);
                tables.add(qualifiedTableName);
                continue;
            }
            catch (StandardException e) {
                throw new QueryParseException("Could not find table", fromTable.getBeginOffset());
            }
        }
        return tables;
    }

    private Condition getWhere(Result parseResult) throws QueryParseException {
        SelectNode select = parseResult.getSelect();
        ValueNode where = select.getWhereClause();
        return this.getCondition(parseResult, where);
    }

    private Condition getCondition(Result parseResult, ValueNode where) throws QueryParseException {
        if (where == null) {
            return null;
        }
        Condition condition = null;
        switch (where.getNodeType()) {
            case 24: 
            case 25: {
                LeafCondition leaf;
                UnaryComparisonOperatorNode unaryOperator = (UnaryComparisonOperatorNode)where;
                String operator = unaryOperator.getOperator();
                Column column = this.getColumn(parseResult, (QueryTreeNode)unaryOperator.getOperand());
                condition = leaf = new LeafCondition(column, operator);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: {
                BinaryRelationalOperatorNode binaryOperator = (BinaryRelationalOperatorNode)where;
                String operator = binaryOperator.getOperator();
                Column column = this.getColumn(parseResult, (QueryTreeNode)binaryOperator.getLeftOperand());
                ValueNode right = binaryOperator.getRightOperand();
                Object value = this.getConstant(right);
                LeafCondition leaf = new LeafCondition(column, operator);
                leaf.addValue(value);
                condition = leaf;
                break;
            }
            case 51: {
                String likeMask;
                LikeEscapeOperatorNode likeOperator = (LikeEscapeOperatorNode)where;
                String operator = likeOperator.getOperator();
                Column column = this.getColumn(parseResult, (QueryTreeNode)likeOperator.getReceiver());
                ValueNode right = likeOperator.getLeftOperand();
                Object value = this.getConstant(right);
                if (value instanceof String && (likeMask = (String)value).startsWith("NVX:REGEX:")) {
                    operator = "REGEX_LIKE";
                    value = likeMask.substring("NVX:REGEX:".length());
                }
                LeafCondition leaf = new LeafCondition(column, operator);
                leaf.addValue(value);
                condition = leaf;
                break;
            }
            case 53: {
                BetweenOperatorNode between = (BetweenOperatorNode)where;
                Column column = this.getColumn(parseResult, (QueryTreeNode)between.getLeftOperand());
                ValueNodeList lowHighValues = between.getRightOperandList();
                ValueNode lowValue = (ValueNode)lowHighValues.get(0);
                ValueNode highValue = (ValueNode)lowHighValues.get(1);
                Object low = this.getConstant(lowValue);
                Object high = this.getConstant(highValue);
                LeafCondition leaf = new LeafCondition(column, "BETWEEN");
                leaf.addValue(low);
                leaf.addValue(high);
                condition = leaf;
                break;
            }
            case 55: {
                InListOperatorNode in = (InListOperatorNode)where;
                RowConstructorNode left = in.getLeftOperand();
                ValueNodeList leftList = left.getNodeList();
                Column column = this.getColumn(parseResult, leftList.get(0));
                LeafCondition leaf = new LeafCondition(column, "IN");
                RowConstructorNode rightIn = in.getRightOperandList();
                ValueNodeList rightList = rightIn.getNodeList();
                int rightSize = rightList.size();
                for (int i = 0; i < rightSize; ++i) {
                    ValueNode inValue = (ValueNode)rightList.get(i);
                    Object inConstant = this.getConstant(inValue);
                    leaf.addValue(inConstant);
                }
                condition = leaf;
                break;
            }
            case 26: {
                NotNode notNode = (NotNode)where;
                CompoundCondition compound = new CompoundCondition(CompoundCondition.Type.NOT);
                ValueNode notOperand = notNode.getOperand();
                Condition child = this.getCondition(parseResult, notOperand);
                compound.addChild(child);
                condition = compound;
                break;
            }
            case 39: {
                AndNode and = (AndNode)where;
                CompoundCondition compound = new CompoundCondition(CompoundCondition.Type.AND);
                Condition leftAnd = this.getCondition(parseResult, and.getLeftOperand());
                compound.addChild(leftAnd);
                Condition rightAnd = this.getCondition(parseResult, and.getRightOperand());
                compound.addChild(rightAnd);
                condition = compound;
                break;
            }
            case 52: {
                OrNode or = (OrNode)where;
                CompoundCondition compound = new CompoundCondition(CompoundCondition.Type.OR);
                Condition leftOr = this.getCondition(parseResult, or.getLeftOperand());
                compound.addChild(leftOr);
                Condition rightOr = this.getCondition(parseResult, or.getRightOperand());
                compound.addChild(rightOr);
                condition = compound;
                break;
            }
            default: {
                throw new QueryParseException("Unrecognized operator", where.getBeginOffset());
            }
        }
        return condition;
    }

    private <T> T getConstant(ValueNode valueNode) throws QueryParseException {
        if (valueNode == null) {
            return null;
        }
        Object value = null;
        switch (valueNode.getNodeType()) {
            case 61: 
            case 77: {
                CharConstantNode charConstant = (CharConstantNode)valueNode;
                value = charConstant.getValue();
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 75: {
                NumericConstantNode numConstant = (NumericConstantNode)valueNode;
                value = numConstant.getValue();
                break;
            }
            case 60: {
                CastNode castNode = (CastNode)valueNode;
                DataTypeDescriptor type = castNode.getType();
                String typeName = type.getTypeName();
                ValueNode castOperand = castNode.getCastOperand();
                value = this.getConstant(castOperand);
                String text = (String)value;
                if (typeName.equals("TIMESTAMP")) {
                    SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
                    try {
                        value = f.parse(text);
                        break;
                    }
                    catch (ParseException e) {
                        try {
                            value = UtlTime.parse((String)text);
                            break;
                        }
                        catch (ParseException e2) {
                            throw new QueryParseException("invalid timestamp: " + text + " expected to be in form of 'yyyy-MM-dd hh:mm:ss.SSS' or '" + UtlTime.getTimestampFormat() + SINGLE_QUOTE, castNode.getBeginOffset());
                        }
                    }
                }
                if (!typeName.equals("DATE")) break;
                SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    value = f.parse(text);
                    break;
                }
                catch (ParseException e) {
                    throw new QueryParseException("invalid date: " + text + " expected to be in form of 'yyyy-MM-dd'", castNode.getBeginOffset());
                }
            }
            default: {
                value = null;
            }
        }
        return (T)value;
    }

    private Column getColumn(Result parseResult, QueryTreeNode node) {
        Column column;
        int nodeType = node.getNodeType();
        switch (nodeType) {
            case 80: {
                column = parseResult.getColumn((ResultColumn)node);
                break;
            }
            case 62: {
                column = parseResult.getColumn((ColumnReference)node);
                break;
            }
            case 16: {
                column = SELECT_ALL;
                break;
            }
            case 35: {
                GroupByColumn groupByColumn = (GroupByColumn)node;
                column = this.getColumn(parseResult, (QueryTreeNode)groupByColumn.getColumnExpression());
                break;
            }
            case 104: {
                OrderByColumn orderByColumn = (OrderByColumn)node;
                column = this.getColumn(parseResult, (QueryTreeNode)orderByColumn.getExpression());
                column.setAscending(orderByColumn.isAscending());
                break;
            }
            case 115: {
                AggregateNode aggNode = (AggregateNode)node;
                column = parseResult.getColumn(aggNode);
                break;
            }
            default: {
                column = null;
            }
        }
        return column;
    }

    public static final class LeafCondition
    implements Condition {
        private Column columnName;
        private String operator;
        private List<Object> values = Lists.newArrayList();

        public LeafCondition(Column columnName, String operator) {
            this.columnName = columnName;
            this.operator = operator;
        }

        public Column getColumn() {
            return this.columnName;
        }

        public String getOperator() {
            return this.operator;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public void addValue(Object value) {
            this.values.add(value);
        }

        public void addValues(Collection<Object> values) {
            values.addAll(values);
        }

        public String toString() {
            return this.columnName + " " + this.operator + " " + this.values.toString();
        }
    }

    public static final class CompoundCondition
    implements Condition {
        private Type type;
        private List<Condition> children = Lists.newArrayList();

        private CompoundCondition(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public void addChild(Condition child) {
            if (this.type == Type.NOT && !this.children.isEmpty()) {
                throw new QueryException("NOT can only modify one condition");
            }
            this.children.add(child);
        }

        public List<Condition> getChildren() {
            return this.children;
        }

        public static enum Type {
            AND,
            OR,
            NOT;

        }
    }

    public static interface Condition {
    }

    public static class Column {
        private String tableName;
        private String columnName;
        private String as;
        private String functionName;
        private Boolean ascending = null;

        public Column(String tableName, String columnName) {
            this.tableName = tableName;
            this.columnName = columnName;
        }

        public String getAs() {
            return this.as;
        }

        public void setAs(String as) {
            this.as = as;
        }

        public Column(String columnName) {
            this(null, columnName);
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        private void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public Boolean isAscending() {
            return this.ascending;
        }

        private void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public String toString() {
            return QueryParser.qualify(this.tableName, this.columnName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) {
                return false;
            }
            Column other = (Column)obj;
            return Objects.equal((Object)this.tableName, (Object)other.tableName) && Objects.equal((Object)this.columnName, (Object)other.columnName);
        }
    }

    public final class Result {
        private String xsql;
        private String preprocessed;
        private StatementNode statement;
        private SelectNode select;

        private Result(String xsql, String preprocessed, StatementNode statement) {
            this.xsql = xsql;
            this.preprocessed = preprocessed;
            this.statement = statement;
        }

        public String getSql() {
            return this.xsql;
        }

        private StatementNode getStatement() {
            return this.statement;
        }

        public SelectNode getSelect() {
            if (this.select == null) {
                this.select = QueryParser.this.getSelect(this);
            }
            return this.select;
        }

        public List<Column> getColumnList() {
            return QueryParser.this.getColumnList(this);
        }

        public boolean isDistinct() {
            return QueryParser.this.isDistinct(this);
        }

        public List<String> getFromList() {
            return QueryParser.this.getFromList(this);
        }

        public Condition getWhere() {
            return QueryParser.this.getWhere(this);
        }

        public List<Column> getGroupBy() {
            return QueryParser.this.getGroupBy(this);
        }

        public Condition getHaving() {
            return QueryParser.this.getHaving(this);
        }

        public List<Column> getOrderBy() {
            return QueryParser.this.getOrderBy(this);
        }

        public Range<Integer> getLimitRange() {
            return QueryParser.this.getLimitRange(this);
        }

        private Column getColumn(ResultColumn resultColumn) {
            ValueNode expression = resultColumn.getExpression();
            if (expression instanceof ColumnReference) {
                ColumnReference columnReference = (ColumnReference)expression;
                Column c = this.getColumn(columnReference);
                if (resultColumn.getName() != columnReference.getColumnName()) {
                    c.setAs(resultColumn.getName());
                }
                return c;
            }
            if (expression instanceof AggregateNode) {
                AggregateNode aggregate = (AggregateNode)expression;
                Column c = this.getColumn(aggregate);
                if (resultColumn.getName() != null && !resultColumn.getName().equals(aggregate.getColumnName())) {
                    c.setAs(resultColumn.getName());
                }
                return c;
            }
            throw new QueryParseException("Unrecognized ResultColumn", resultColumn.getBeginOffset());
        }

        private Column getColumn(AggregateNode aggregate) {
            String aggregateName = aggregate.getAggregateName();
            if ("COUNT(*)".equalsIgnoreCase(aggregateName)) {
                Column countAll = new Column(null, QueryParser.NVX_RECORD);
                countAll.setFunctionName("COUNT");
                return countAll;
            }
            ValueNode operand = aggregate.getOperand();
            Column targetColumn = this.getColumn((ColumnReference)operand);
            targetColumn.setFunctionName(aggregateName);
            return targetColumn;
        }

        private Column getColumn(ColumnReference columnReference) {
            TableName tableNameNode = columnReference.getTableNameNode();
            String tableName = this.getPreprocessed((QueryTreeNode)tableNameNode);
            tableName = QueryParser.this.postprocessTable(tableName);
            String columnName = this.getPreprocessed((QueryTreeNode)columnReference);
            columnName = QueryParser.this.postprocessColumn(columnName);
            return new Column(tableName, columnName);
        }

        private String getPreprocessed(QueryTreeNode node) {
            if (node == null) {
                return null;
            }
            int beginOffset = node.getBeginOffset();
            int endOffset = node.getEndOffset();
            if (beginOffset == -1 || endOffset == -1) {
                return null;
            }
            return this.preprocessed.substring(beginOffset, endOffset + 1);
        }
    }
}

