/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.neeve.query.QueryResult;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryCompositeResult;
import com.neeve.query.impl.QueryResultImpl;
import com.neeve.query.impl.util.collect.UtlSorted;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class QueryInterleavedResult<T>
extends QueryCompositeResult<T> {
    private UtlSorted.InterleaveComparator<QueryResultSet.Row<T>> iteratorComparator;

    public QueryInterleavedResult(Iterable<QueryResult<T>> queryResults, Comparator<QueryResultSet.Row<T>> rowComparator) {
        super(queryResults);
        this.iteratorComparator = UtlSorted.InterleaveComparator.create(rowComparator);
    }

    @Override
    public Iterator<QueryResultSet.Row<T>> iterator() {
        final ArrayList iterators = Lists.newArrayList();
        for (QueryResult qr : this.queryResults) {
            QueryResultImpl queryResult = (QueryResultImpl)qr;
            QueryResultImpl.QueryResultIterator iter = queryResult.iterator();
            iterators.add(iter);
        }
        if (iterators.isEmpty()) {
            return ImmutableSet.of().iterator();
        }
        if (iterators.size() == 1) {
            return (Iterator)iterators.get(0);
        }
        return new AbstractIterator<QueryResultSet.Row<T>>(){

            protected QueryResultSet.Row<T> computeNext() {
                Collections.sort(iterators, QueryInterleavedResult.this.iteratorComparator);
                QueryResultImpl.QueryResultIterator firstIter = (QueryResultImpl.QueryResultIterator)iterators.get(0);
                QueryInterleavedResult.this.currentQueryResult = firstIter.getQueryResult();
                if (!firstIter.hasNext()) {
                    return (QueryResultSet.Row)this.endOfData();
                }
                return firstIter.next();
            }
        };
    }
}

