/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkBlockingReader;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOBufferPacket;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.OdsObject;
import com.neeve.ods.impl.EStoreReplicatorMemberLinkException;
import com.neeve.ods.impl.StoreReplicatorMember;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlTime;
import java.util.Map;

final class StoreReplicatorMemberLink
extends OdsObject {
    private final StoreReplicatorMember member;
    private final EmxNwLnk link;
    private final int autoFlushSize;
    private final IOElasticBuffer outputBuffer;
    private final IOBuffer[] directPacketWriteBuffers;
    private final int[] directPacketWriteOffsets;
    private final int[] directPacketWriteLengths;
    private final Reader reader;
    static final String PROP_SPINREAD = "spinread";

    StoreReplicatorMemberLink(StoreReplicatorMember member, EmxNwLnk link, Map<String, Object> linkParams, long linkReaderAffinityMask) throws Exception {
        super(null);
        this.member = member;
        this.autoFlushSize = 8192;
        this.outputBuffer = IOElasticBuffer.create((int)this.autoFlushSize);
        this.directPacketWriteBuffers = new IOBuffer[16];
        this.directPacketWriteOffsets = new int[16];
        this.directPacketWriteLengths = new int[16];
        this.link = link;
        this.link.configureBlockingWrite(true);
        this.reader = new Reader(this.link, linkReaderAffinityMask, linkParams);
        this.reader.start();
    }

    private final void writePacketDirect(PktPacket packet) throws EStoreReplicatorMemberLinkException {
        PktHeader header = packet.getHeader();
        PktSubheaderODS subheader = header.getODSSubheader();
        PktBody body = packet.getBody();
        int bufferIndex = 0;
        long expectedBytesWritten = 0L;
        IOElasticBuffer buffer = header.getBuffer();
        this.directPacketWriteBuffers[bufferIndex] = buffer.getBackingBufferUnsafe();
        this.directPacketWriteOffsets[bufferIndex] = buffer.getOffset();
        this.directPacketWriteLengths[bufferIndex] = 34;
        expectedBytesWritten += (long)34;
        if (subheader != null) {
            buffer = subheader.getBuffer();
            this.directPacketWriteBuffers[++bufferIndex] = buffer.getBackingBufferUnsafe();
            this.directPacketWriteOffsets[bufferIndex] = buffer.getOffset();
            this.directPacketWriteLengths[bufferIndex] = buffer.getLength();
            expectedBytesWritten += (long)this.directPacketWriteLengths[bufferIndex];
        }
        buffer = body.getBuffer();
        this.directPacketWriteBuffers[++bufferIndex] = buffer.getBackingBufferUnsafe();
        this.directPacketWriteOffsets[bufferIndex] = buffer.getOffset();
        this.directPacketWriteLengths[bufferIndex] = buffer.getLength();
        expectedBytesWritten += (long)this.directPacketWriteLengths[bufferIndex];
        try {
            long actualBytesWritten;
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Writing " + expectedBytesWritten + " bytes [h=" + this.directPacketWriteLengths[0] + ", s=" + (bufferIndex == 1 ? 0 : this.directPacketWriteLengths[1]) + ", b=" + (bufferIndex == 1 ? this.directPacketWriteLengths[1] : this.directPacketWriteLengths[2]) + "]...", Tracer.Level.DEBUG);
            }
            if ((actualBytesWritten = this.link.write(this.directPacketWriteBuffers, this.directPacketWriteOffsets, this.directPacketWriteLengths, bufferIndex + 1)) != expectedBytesWritten) {
                throw new EStoreReplicatorMemberLinkException("full packet could not be written [exp=" + expectedBytesWritten + ", actual=" + actualBytesWritten + "]");
            }
        }
        catch (EEmxException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
    }

    private final void writeOutputBuffer() throws EStoreReplicatorMemberLinkException {
        try {
            int expectedBytesWritten = this.outputBuffer.getLength();
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Writing " + expectedBytesWritten + " bytes...", Tracer.Level.DEBUG);
            }
            long actualBytesWritten = this.link.write(this.outputBuffer.getBackingBufferUnsafe(), 0, expectedBytesWritten);
            this.outputBuffer.setLength((int)((long)expectedBytesWritten - actualBytesWritten));
            if (this.outputBuffer.getLength() > 0) {
                throw new EStoreReplicatorMemberLinkException("full buffer could not be written [exp=" + expectedBytesWritten + ", actual=" + actualBytesWritten + "]");
            }
        }
        catch (EEmxException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
    }

    private final void writePacketDirect(IOElasticBuffer serializedPacket) throws EStoreReplicatorMemberLinkException {
        try {
            long actualBytesWritten;
            int expectedBytesWritten = serializedPacket.getLength();
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Writing " + expectedBytesWritten + " bytes...", Tracer.Level.DEBUG);
            }
            if ((long)expectedBytesWritten != (actualBytesWritten = this.link.write(serializedPacket.getBackingBufferUnsafe(), 0, expectedBytesWritten))) {
                throw new EStoreReplicatorMemberLinkException("full buffer could not be written [exp=" + expectedBytesWritten + ", actual=" + actualBytesWritten + "]");
            }
        }
        catch (EEmxException e) {
            throw new EStoreReplicatorMemberLinkException(e);
        }
    }

    final long write(PktPacket packet, boolean sync, boolean flush) throws EStoreReplicatorMemberLinkException {
        long preWireTs;
        if (sync) {
            packet.sync();
        }
        if (this.tracer.debug) {
            this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Sending packet (outputBufferLength=" + this.outputBuffer.getLength() + ", packetSerializedLength=" + packet.getSerializedLength() + ", flush=" + flush + ")...", Tracer.Level.DEBUG);
        }
        if (this.outputBuffer.getLength() == 0 && flush) {
            preWireTs = UtlTime.now();
            packet.getHeader().setPreWireTs(preWireTs);
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Writing packet direct...", Tracer.Level.DEBUG);
            }
            this.writePacketDirect(packet);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Writing packet to buffer (outputBufferLength=" + this.outputBuffer.getLength() + ")...", Tracer.Level.DEBUG);
            }
            int serializedPacketPosInOutputBuffer = this.outputBuffer.getLength();
            packet.getTo(this.outputBuffer, serializedPacketPosInOutputBuffer);
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Packet written to buffer (outputBufferLength=" + this.outputBuffer.getLength() + ")...", Tracer.Level.DEBUG);
            }
            preWireTs = UtlTime.now();
            PktHeader.setPreWireTs((IOElasticBuffer)this.outputBuffer, (int)serializedPacketPosInOutputBuffer, (long)preWireTs);
            if (flush || this.outputBuffer.getLength() >= this.autoFlushSize) {
                if (this.tracer.debug) {
                    this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Flushing buffer...", Tracer.Level.DEBUG);
                }
                this.writeOutputBuffer();
            }
        }
        return preWireTs;
    }

    final long write(IOElasticBuffer serializedPacket, boolean flush) throws EStoreReplicatorMemberLinkException {
        long preWireTs;
        if (this.tracer.debug) {
            this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Sending serialized packet (outputBufferLength=" + this.outputBuffer.getLength() + ", packetSerializedLength=" + serializedPacket.getLength() + ", flush=" + flush + ")...", Tracer.Level.DEBUG);
        }
        if (this.link.usingNativeIOForWrite() && this.outputBuffer.getLength() == 0 && flush) {
            preWireTs = UtlTime.now();
            PktHeader.setPreWireTs((IOElasticBuffer)serializedPacket, (int)0, (long)preWireTs);
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Writing serialized packet direct...", Tracer.Level.DEBUG);
            }
            this.writePacketDirect(serializedPacket);
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Writing serialized packet to buffer (outputBufferLength=" + this.outputBuffer.getLength() + ")...", Tracer.Level.DEBUG);
            }
            int serializedPacketPosInOutputBuffer = this.outputBuffer.getLength();
            this.outputBuffer.putFrom(serializedPacketPosInOutputBuffer, serializedPacket, 0, serializedPacket.getLength());
            if (this.tracer.debug) {
                this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Serialized packet written to buffer (outputBufferLength=" + this.outputBuffer.getLength() + ")...", Tracer.Level.DEBUG);
            }
            preWireTs = UtlTime.now();
            PktHeader.setPreWireTs((IOElasticBuffer)this.outputBuffer, (int)serializedPacketPosInOutputBuffer, (long)preWireTs);
            if (flush || this.outputBuffer.getLength() > this.autoFlushSize) {
                if (this.tracer.debug) {
                    this.tracer.log(this.member.getReplicator().getTracePrefix() + "[Member '" + this.member.getName() + "'] Flushing buffer...", Tracer.Level.DEBUG);
                }
                this.writeOutputBuffer();
            }
        }
        return preWireTs;
    }

    final void close() throws EEmxException {
        this.reader.shutdown();
        this.link.close();
    }

    private final class Reader
    extends Thread {
        private final EmxNwLnkReader linkReader;
        private final long affinityMask;

        Reader(EmxNwLnk link, long affinityMask, Map<String, Object> linkParams) throws Exception {
            this.linkReader = EmxNwLnkBlockingReader.create((EmxNwLnk)link, (EmxNwLnkReader.Callback)new Callback(), (boolean)(linkParams.containsKey(StoreReplicatorMemberLink.PROP_SPINREAD) ? ((String)linkParams.get(StoreReplicatorMemberLink.PROP_SPINREAD)).equalsIgnoreCase("true") : false));
            this.affinityMask = affinityMask;
            this.setName("X-ODS-StoreReplicatorLinkReader-" + StoreReplicatorMemberLink.this.member.getReplicator().getStoreName() + "-" + StoreReplicatorMemberLink.this.member.getName());
            this.setDaemon(true);
        }

        final void shutdown() {
            this.linkReader.stop();
        }

        @Override
        public final void run() {
            if (((StoreReplicatorMemberLink)StoreReplicatorMemberLink.this).tracer.debug) {
                StoreReplicatorMemberLink.this.tracer.log(StoreReplicatorMemberLink.this.member.getReplicator().getTracePrefix() + "[Member '" + StoreReplicatorMemberLink.this.member.getName() + "'] Link reader thread has started.", Tracer.Level.DEBUG);
            }
            UtlThread.setCPUAffinityMask((long)this.affinityMask);
            this.linkReader.run();
        }

        private final class Callback
        implements EmxNwLnkReader.Callback {
            private final IOBufferPacket packet = new IOBufferPacket();

            private Callback() {
            }

            private final int parseAndDispatch(IOBuffer iobuf, int pos, int length, long postWireTs) {
                if (((StoreReplicatorMemberLink)StoreReplicatorMemberLink.this).tracer.debug) {
                    StoreReplicatorMemberLink.this.tracer.log(StoreReplicatorMemberLink.this.member.getReplicator().getTracePrefix() + "[Member '" + StoreReplicatorMemberLink.this.member.getName() + "'] Checking packet at (pos=" + pos + ", len=" + length + ").", Tracer.Level.DEBUG);
                }
                int serializedPacketLength = PktHeader.getSerializedPacketLength((IOBuffer)iobuf, (int)pos, (int)length);
                if (((StoreReplicatorMemberLink)StoreReplicatorMemberLink.this).tracer.debug) {
                    StoreReplicatorMemberLink.this.tracer.log(StoreReplicatorMemberLink.this.member.getReplicator().getTracePrefix() + "[Member '" + StoreReplicatorMemberLink.this.member.getName() + "'] Serialized packet length in buffer is " + serializedPacketLength + " bytes.", Tracer.Level.DEBUG);
                }
                if (serializedPacketLength > 0 && serializedPacketLength <= length) {
                    if (((StoreReplicatorMemberLink)StoreReplicatorMemberLink.this).tracer.debug) {
                        StoreReplicatorMemberLink.this.tracer.log(StoreReplicatorMemberLink.this.member.getReplicator().getTracePrefix() + "[Member '" + StoreReplicatorMemberLink.this.member.getName() + "'] Full packet received. Dispatching...", Tracer.Level.DEBUG);
                    }
                    StoreReplicatorMemberLink.this.member.onPacket(this.packet.init(iobuf, pos, serializedPacketLength, postWireTs));
                    return serializedPacketLength;
                }
                if (((StoreReplicatorMemberLink)StoreReplicatorMemberLink.this).tracer.debug) {
                    StoreReplicatorMemberLink.this.tracer.log(StoreReplicatorMemberLink.this.member.getReplicator().getTracePrefix() + "[Member '" + StoreReplicatorMemberLink.this.member.getName() + "'] Partial packet received. Waiting for full packet...", Tracer.Level.DEBUG);
                }
                return 0;
            }

            public final int handleReadData(EmxNwLnk link, IOBuffer iobuf, int length) {
                if (((StoreReplicatorMemberLink)StoreReplicatorMemberLink.this).tracer.debug) {
                    StoreReplicatorMemberLink.this.tracer.log(StoreReplicatorMemberLink.this.member.getReplicator().getTracePrefix() + "[Member '" + StoreReplicatorMemberLink.this.member.getName() + "'] Received data [numBytes=" + length + "].", Tracer.Level.DEBUG);
                }
                long postWireTs = UtlTime.now();
                int pos = 0;
                try {
                    int used;
                    while ((used = this.parseAndDispatch(iobuf, pos, length - pos, postWireTs)) != 0 && (pos += used) < length) {
                    }
                }
                catch (Throwable e) {
                    Reader.this.shutdown();
                    StoreReplicatorMemberLink.this.member.onPacketProcesssingFailure(e);
                }
                return pos;
            }

            public final void handleLinkClosure(EmxNwLnk link) {
                StoreReplicatorMemberLink.this.member.onLinkClosure();
            }

            public final void handleLinkFailure(EmxNwLnk link, Throwable cause) {
                StoreReplicatorMemberLink.this.member.onLinkFailure(cause);
            }
        }
    }
}

