/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkAcceptor;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.impl.StoreReplicator;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import java.util.concurrent.atomic.AtomicInteger;

final class StoreReplicatorLinkAcceptor
extends OdsObject {
    private final StoreReplicator replicator;
    private final EmxNwLnkAcceptor acceptor;
    private final AcceptorThread acceptorThread;
    private static AtomicInteger instanceCounter = new AtomicInteger(0);
    private volatile State state;

    StoreReplicatorLinkAcceptor(StoreReplicator replicator, UtlAddressDescriptor descriptor) throws OdsException {
        super(null);
        this.replicator = replicator;
        try {
            this.acceptor = EmxNwLnkAcceptor.create((UtlAddressDescriptor)descriptor, (EmxNwLnkAcceptor.Callback)new AcceptorCallback());
        }
        catch (EEmxException e) {
            throw new OdsException("Failed to create link acceptor [" + e.toString() + "]");
        }
        this.acceptorThread = new AcceptorThread(this.acceptor);
        this.state = State.Init;
        if (this.tracer.debug) {
            this.tracer.log(replicator.getTracePrefix() + "Created link acceptor '" + this.acceptorThread.getName() + "' using '" + descriptor.toString() + "'...", Tracer.Level.DEBUG);
        }
    }

    private final IllegalStateException prepareStateValidationErrorException() {
        switch (this.state) {
            case Init: {
                return new IllegalStateException("acceptor has not been opened");
            }
            case Open: {
                return new IllegalStateException("acceptor is open");
            }
            case Closed: {
                return new IllegalStateException("acceptor is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void open() throws OdsException {
        StoreReplicatorLinkAcceptor storeReplicatorLinkAcceptor = this;
        synchronized (storeReplicatorLinkAcceptor) {
            if (this.state != State.Init) {
                throw this.prepareStateValidationErrorException();
            }
            this.acceptorThread.start();
            this.state = State.Open;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() {
        StoreReplicatorLinkAcceptor storeReplicatorLinkAcceptor = this;
        synchronized (storeReplicatorLinkAcceptor) {
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "Closing link acceptor...", Tracer.Level.DEBUG);
            }
            if (this.state != State.Closed) {
                try {
                    this.acceptorThread.shutdown();
                }
                finally {
                    try {
                        this.acceptor.close();
                    }
                    catch (EEmxException e) {
                        this.tracer.log(this.replicator.getTracePrefix() + "Failed to close link acceptor during replicator link acceptor shutdown [" + e.toString() + "].", Tracer.Level.WARNING);
                    }
                    this.state = State.Closed;
                }
            }
            if (this.tracer.debug) {
                this.tracer.log(this.replicator.getTracePrefix() + "Already closed.", Tracer.Level.DEBUG);
            }
        }
    }

    private final class AcceptorThread
    extends Thread {
        private final EmxNwLnkAcceptor acceptor;
        private boolean stopped;

        AcceptorThread(EmxNwLnkAcceptor acceptor) {
            this.acceptor = acceptor;
            this.setName("X-ODS-StoreLinkAcceptor-" + instanceCounter.incrementAndGet());
            this.setDaemon(true);
        }

        private final void shutdown() {
            this.acceptor.stop();
        }

        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            try {
                this.acceptor.run();
                if (((StoreReplicatorLinkAcceptor)StoreReplicatorLinkAcceptor.this).tracer.debug) {
                    StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Acceptor thread done.", Tracer.Level.DEBUG);
                }
            }
            catch (Throwable e) {
                StoreReplicatorLinkAcceptor.this.tracer.log("Acceptor thread failed\n" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
            }
        }
    }

    private static enum State {
        Init,
        Open,
        Closed;

    }

    private final class AcceptorCallback
    implements EmxNwLnkAcceptor.Callback {
        AcceptorCallback() {
        }

        public final void handleAcceptedLink(EmxNwLnk link) {
            try {
                StoreReplicatorLinkAcceptor.this.replicator.handleLinkAccept(link);
            }
            catch (Exception e) {
                StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Failed to process newly accepted link [" + e.toString() + "]. Closing link...", Tracer.Level.SEVERE);
                try {
                    link.close();
                }
                catch (Exception e1) {
                    StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Failed to close link after accept processing failure [" + e1.toString() + "].", Tracer.Level.WARNING);
                }
            }
        }

        public final void handleAcceptorFailure(Throwable cause) {
            StoreReplicatorLinkAcceptor.this.tracer.log(StoreReplicatorLinkAcceptor.this.replicator.getTracePrefix() + "Link acceptor has failed [" + cause.toString() + "].", Tracer.Level.SEVERE);
        }
    }
}

