/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl;

import com.solace.messaging.trace.propagation.Baggage;
import com.solace.messaging.trace.propagation.TraceContext;
import com.solace.messaging.trace.propagation.impl.BaggageImpl;
import com.solace.messaging.trace.propagation.impl.TraceContextImpl;
import com.solacesystems.common.util.ByteArray;
import com.solacesystems.jcsmp.Destination;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.SDTStream;
import com.solacesystems.jcsmp.i18n.JCSMPRB;
import com.solacesystems.jcsmp.impl.HeaderStore;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import com.solacesystems.jcsmp.impl.sdt.TLVBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HeaderStoreImplRO
implements HeaderStore {
    private static final Log Trace = LogFactory.getLog(HeaderStoreImplRO.class);
    private Boolean mStructured = null;
    private Byte mMsgType = null;
    private Boolean mIsResponse = null;
    private TLVBuffer mBuffer;
    private boolean mLoaded;
    private SDTMap mHdrMap;
    private SDTMap mPropMap;
    private SDTStream mStream;
    private TraceContext creationContext;
    private Baggage baggage;

    public HeaderStoreImplRO(TLVBuffer buffer) {
        this.mBuffer = buffer;
        this.mLoaded = false;
        this.mHdrMap = null;
        this.mPropMap = null;
        this.mStream = null;
        this.creationContext = null;
        this.baggage = null;
        if (buffer == null) {
            this.mLoaded = true;
            return;
        }
        this.initializePreamble();
    }

    protected HeaderStoreImplRO(HeaderStoreImplRO toClone) {
        this(toClone.mBuffer);
        this.clone(toClone);
    }

    @Override
    public ByteArray asByteArray() {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public String getAppMessageID() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (String)this.mHdrMap.get("mi");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getAppMessageType() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (String)this.mHdrMap.get("mt");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getCorrelationID() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (String)this.mHdrMap.get("ci");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public SDTMap getPropertyMap() {
        this.initializeBody();
        return this.mPropMap;
    }

    @Override
    public Destination getReplyTo() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (Destination)this.mHdrMap.get("rt");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Long getSendTimestamp() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (Long)this.mHdrMap.get("ts");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getSenderID() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (String)this.mHdrMap.get("si");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Long getSequenceNumber() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (Long)this.mHdrMap.get("sn");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Long getExpiration() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (Long)this.mHdrMap.get("ex");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getHTTPContentType() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (String)this.mHdrMap.get("ct");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getHTTPContentEncoding() {
        this.initializeBody();
        if (this.mHdrMap != null) {
            try {
                return (String)this.mHdrMap.get("ce");
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Byte getStructuredMsgType() {
        return this.mMsgType;
    }

    @Override
    public Boolean isResponse() {
        return this.mIsResponse;
    }

    @Override
    public Boolean isStructured() {
        return this.mStructured;
    }

    @Override
    public TraceContext getTracingCreationContext() {
        this.initializeBody();
        if (this.creationContext != null) {
            return this.creationContext;
        }
        if (this.mHdrMap != null) {
            try {
                ByteArray creationContextBytes = (ByteArray)this.mHdrMap.get("ctx");
                this.creationContext = TraceContextImpl.from(creationContextBytes);
                return this.creationContext;
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Baggage getTracingBaggage() {
        this.initializeBody();
        if (this.baggage != null) {
            return this.baggage;
        }
        if (this.mHdrMap != null) {
            try {
                String baggageStr = (String)this.mHdrMap.get("bag");
                if (baggageStr != null) {
                    this.baggage = new BaggageImpl();
                    this.baggage.setBaggage(baggageStr);
                    return this.baggage;
                }
            }
            catch (SDTException sDTException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void reset(boolean resetMsgType) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setAppMessageID(String msgId) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setAppMessageType(String appMsgType) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setCorrelationId(String id) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setIsResponse(boolean isResponse) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setIsStructured(boolean structured) {
        this.mStructured = structured;
    }

    @Override
    public void setPropertyMap(SDTMap props) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setReplyTo(Destination destination) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setSendTimestamp(Long sendTS) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setSenderID(String senderID) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setSequenceNumber(long seqNum) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setExpiration(Long expiration) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setHTTPContentType(String contentType) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setHTTPContentEncoding(String contentEncoding) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setStructuredMsgType(byte msgType) {
    }

    @Override
    public void setTracingCreationContext(TraceContext creationContext) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    @Override
    public void setTracingBaggage(Baggage baggage) {
        throw new IllegalAccessError(JCSMPRB.BUNDLE.getStringSafely("JCSMPXMLMessage.mayNotWriteToReadOnlyMsg"));
    }

    protected synchronized void initializePreamble() {
        try {
            Object obj = this.mBuffer.read();
            if (obj instanceof SDTStream) {
                this.mStream = (SDTStream)obj;
                ByteArray ba = this.mStream.readByteArray();
                if (ba != null) {
                    if (ba.getLength() > 0) {
                        byte byte0 = ba.getBuffer()[ba.getOffset()];
                        if (byte0 >= 0) {
                            this.mStructured = true;
                            this.mMsgType = byte0;
                        } else {
                            this.mStructured = false;
                            this.mMsgType = (byte)(byte0 & 0x7F);
                        }
                    }
                    if (ba.getLength() > 1) {
                        byte byte1 = ba.getBuffer()[ba.getOffset() + 1];
                        this.mIsResponse = byte1 < 0;
                    }
                } else {
                    if (Trace.isDebugEnabled()) {
                        Trace.debug((Object)"Header store initialization failed - error reading byte array");
                    }
                    this.mLoaded = true;
                }
            } else {
                if (Trace.isDebugEnabled()) {
                    Trace.debug((Object)"Header store initialization failed - error reading stream");
                }
                this.mLoaded = true;
            }
        }
        catch (SDTException e) {
            if (Trace.isDebugEnabled()) {
                Trace.debug((Object)"Header store initialization failed", (Throwable)e);
            }
            this.mLoaded = true;
        }
    }

    protected synchronized void initializeBody() {
        if (!this.mLoaded) {
            block9: {
                this.mLoaded = true;
                try {
                    if (this.mStream.hasRemaining()) {
                        SDTMap container = this.mStream.readMap();
                        if (container != null) {
                            this.mHdrMap = container.getMap("h");
                            if (this.mHdrMap == null && Trace.isDebugEnabled()) {
                                Trace.debug((Object)"Header store initialization failed - expecting header map");
                            }
                            this.mPropMap = container.getMap("p");
                        } else if (Trace.isDebugEnabled()) {
                            Trace.debug((Object)"Header store initialization failed - expecting container map");
                        }
                    }
                }
                catch (SDTException e) {
                    if (!Trace.isErrorEnabled()) break block9;
                    Trace.error((Object)"Error reading Header store", (Throwable)e);
                }
            }
            if (this.mHdrMap == null) {
                this.mHdrMap = new MapImpl();
            }
        }
    }

    private void clone(HeaderStoreImplRO toClone) {
        block7: {
            if (toClone != null) {
                this.mStructured = toClone.mStructured;
                this.mMsgType = toClone.mMsgType;
                this.mIsResponse = toClone.mIsResponse;
                this.mBuffer = new TLVBuffer(toClone.mBuffer);
                this.mLoaded = toClone.mLoaded;
                if (toClone.mHdrMap != null) {
                    this.mHdrMap = new MapImpl(toClone.mHdrMap);
                }
                if (toClone.mPropMap != null) {
                    this.mPropMap = new MapImpl(toClone.mPropMap);
                }
                if (toClone.creationContext != null) {
                    this.creationContext = toClone.creationContext;
                }
                if (toClone.baggage != null) {
                    this.baggage = toClone.baggage;
                }
                try {
                    this.mStream = (SDTStream)this.mBuffer.read();
                }
                catch (SDTException ex) {
                    if (!Trace.isDebugEnabled()) break block7;
                    Trace.debug((Object)"Header store clone failed", (Throwable)ex);
                }
            }
        }
    }
}

