/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoFloatArrayField
extends StoVariableLengthField<float[]> {
    private StoFloatArrayField(String name) {
        super(StoField.Type.FLOAT_ARRAY, name);
    }

    private StoFloatArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoFloatArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(float[] val) {
        return StoFloatArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, float[] val) {
        StoFloatArrayField.put(buffer, offset, val);
    }

    @Override
    protected final float[] deserialize(ByteBuffer buffer, int offset) {
        return StoFloatArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(float[] val1, float[] val2) {
        return Arrays.equals(val1, val2);
    }

    @Override
    protected final float[] clone(float[] val) {
        return Arrays.copyOf(val, val.length);
    }

    @Override
    protected final String toString(float[] val) {
        return Arrays.toString(val);
    }

    public static StoFloatArrayField create(String name) {
        return new StoFloatArrayField(name);
    }

    public static StoFloatArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoFloatArrayField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        return 2 + (len < 0 ? (short)0 : len) * 4;
    }

    public static int getSerializedLength(float[] val) {
        return 2 + (val != null ? val.length * 4 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ByteBuffer buffer, int offset, float[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        if (val != null) {
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asFloatBuffer().put(val);
            }
            finally {
                buffer.position(pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            float[] val = new float[len];
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).asFloatBuffer().get(val);
                float[] fArray = val;
                return fArray;
            }
            finally {
                buffer.position(pos);
            }
        }
        if (len < 0) {
            return new float[0];
        }
        return null;
    }
}

