/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoByteArrayField
extends StoVariableLengthField<byte[]> {
    private StoByteArrayField(String name) {
        super(StoField.Type.BYTE_ARRAY, name);
    }

    private StoByteArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoByteArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(byte[] val) {
        return StoByteArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, byte[] val) {
        StoByteArrayField.put(buffer, offset, val);
    }

    @Override
    protected final byte[] deserialize(ByteBuffer buffer, int offset) {
        return StoByteArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(byte[] val1, byte[] val2) {
        return Arrays.equals(val1, val2);
    }

    @Override
    protected final byte[] clone(byte[] val) {
        return Arrays.copyOf(val, val.length);
    }

    @Override
    protected final String toString(byte[] val) {
        return Arrays.toString(val);
    }

    public static StoByteArrayField create(String name) {
        return new StoByteArrayField(name);
    }

    public static StoByteArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoByteArrayField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        return 2 + (len < 0 ? (short)0 : len) * 1;
    }

    public static int getSerializedLength(byte[] val) {
        return 2 + (val != null ? val.length * 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ByteBuffer buffer, int offset, byte[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        if (val != null) {
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).put(val);
            }
            finally {
                buffer.position(pos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            byte[] val = new byte[len];
            int pos = buffer.position();
            try {
                ((ByteBuffer)buffer.position(offset + 2)).get(val);
                byte[] byArray = val;
                return byArray;
            }
            finally {
                buffer.position(pos);
            }
        }
        if (len < 0) {
            return new byte[0];
        }
        return null;
    }
}

