/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import cern.colt.bitvector.BitVector;
import com.neeve.config.Config;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.link.ELnkInvalidStaticLTPException;
import com.neeve.link.ELnkNoMoreLTPException;
import com.neeve.link.LnkObject;
import com.neeve.trace.Tracer;
import java.util.HashMap;
import java.util.Map;

public final class LnkLTPAuthority
extends LnkObject {
    private final BitVector ltpVector;
    private final BitVector ltpVectorStatic;
    private final Map<String, StaticLTP> ltpTable = new HashMap<String, StaticLTP>();
    private static final LnkLTPAuthority instance = new LnkLTPAuthority();
    public static final short MAX_LTP = 255;

    private LnkLTPAuthority() {
        super(null);
        Config.setTraceLevel((Tracer)this.tracer, (String)"nv.link.ltpauthority.trace");
        this.ltpVector = new BitVector(256);
        this.ltpVectorStatic = new BitVector(256);
        this.initStatic();
    }

    public static LnkLTPAuthority getInstance() {
        return instance;
    }

    private final void initStatic() {
        this.ltpVector.put(0, true);
        this.ltpVectorStatic.put(0, true);
        IConfigRepository repo = Config.getRepository();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/ltps");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                this.tracer.log("Loading config info for static LTP '" + entity.getName() + "'...", Tracer.Level.VERBOSE);
                String ltpStr = entity.getProperty("LTP", null);
                if (ltpStr != null) {
                    short ltp = Short.parseShort(ltpStr);
                    if (ltp > 0 && ltp <= 255) {
                        if (!this.ltpVector.get((int)ltp)) {
                            this.ltpVector.put((int)ltp, true);
                            this.ltpVectorStatic.put((int)ltp, true);
                            this.ltpTable.put(entity.getName(), new StaticLTP(entity.getName(), ltp));
                            this.tracer.log("...success (ltp=" + ltp + ")", Tracer.Level.VERBOSE);
                            continue;
                        }
                        this.tracer.log("LTP value [ltp=" + ltp + "] configured for static LTP '" + entity.getName() + "' has already been taken. The static LTP will not be loaded.", Tracer.Level.WARNING);
                        continue;
                    }
                    this.tracer.log("Invalid LTP value [ltp=" + ltp + "] configured for static LTP '" + entity.getName() + "'. The static LTP will not be loaded.", Tracer.Level.WARNING);
                    continue;
                }
                this.tracer.log("The LTP configuration entity '" + entity + "' needs to specify the LTP number. The static LTP represented by that entity will not be loaded.", Tracer.Level.WARNING);
            }
        } else {
            this.tracer.log("No static LTPs configured.", Tracer.Level.VERBOSE);
        }
    }

    public final short alloc() throws ELnkNoMoreLTPException {
        BitVector bitVector = this.ltpVector;
        synchronized (bitVector) {
            short ltp = (short)this.ltpVector.indexOfFromTo(1, 255, false);
            if (ltp != -1) {
                this.ltpVector.put((int)ltp, true);
                return ltp;
            }
            throw new ELnkNoMoreLTPException();
        }
    }

    public final short getStatic(String name) throws ELnkInvalidStaticLTPException {
        StaticLTP ltp = this.ltpTable.get(name);
        if (ltp != null) {
            return ltp.val;
        }
        throw new ELnkInvalidStaticLTPException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(short ltp) {
        BitVector bitVector = this.ltpVector;
        synchronized (bitVector) {
            if (ltp < 1 || ltp > 255) {
                throw new IllegalArgumentException("ltp must be between 1 and 255 inclusive");
            }
            if (this.ltpVectorStatic.get((int)ltp)) {
                throw new IllegalArgumentException("cannot release static LTP [" + ltp + "]");
            }
            this.ltpVector.put((int)ltp, false);
        }
    }

    private final class StaticLTP {
        final String name;
        final short val;

        StaticLTP(String name, short val) {
            this.name = name;
            this.val = val;
        }
    }
}

