/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkNotOwnerException;
import com.neeve.link.ELnkOpCancelledException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ELnkOpTimeoutException;
import com.neeve.link.ELnkOpWouldAsyncException;
import com.neeve.link.ILnkClientEndpoint;
import com.neeve.link.ILnkClientEndpointCore;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkEvents;
import com.neeve.link.LnkObject;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;

public final class LnkClientEndpoint
extends LnkObject
implements ILnkClientEndpoint {
    private final ILnkClientEndpointCore cep;
    private final ConnectCompleteEventHandler connectCompleteEventHandler;
    private final TimeoutEventHandler timeoutEventHandler;
    private final NotifyEventHandler notifyEventHandler;
    private ConnectPostContext context;
    private State state;

    private LnkClientEndpoint(RootConfig.ObjectConfig config, ILnkClientEndpointCore cep) {
        super(config);
        this.cep = cep;
        this.connectCompleteEventHandler = new ConnectCompleteEventHandler();
        this.timeoutEventHandler = new TimeoutEventHandler();
        this.notifyEventHandler = new NotifyEventHandler();
        this.state = State.INIT;
    }

    private final void dispatchCompletion(LnkEvents.ConnectAcceptCompleteEventData completionEvent) {
        if (this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new InternalError("Completion event is being dispatched in the context of the wrong thread!");
        }
        try {
            this.context.handler.onEvent(this.context.dispatcher, this, 1, completionEvent);
        }
        catch (Exception e) {
            if (completionEvent.status) {
                this.tracer.log("Exception thrown by handler of the event indicating successful establishment of a '' link [" + e.toString() + "].", Tracer.Level.DIAGNOSE);
                this.context.pep = completionEvent.pep;
                this.state = State.FAILED;
            }
            this.tracer.log("Exception thrown by handler of the event indicating failed establishment of '' link [" + e.toString() + "]. Ignoring.", Tracer.Level.DIAGNOSE);
        }
    }

    private final void onEvent(Event event, Object data) throws ELnkInvalidStateException, ELnkOpFailedException {
        if (this.tracer.debug) {
            this.tracer.log("Client endpoint state machine ENTRY [state=" + (Object)((Object)this.state) + " event=" + (Object)((Object)event) + "]", Tracer.Level.DEBUG);
        }
        block0 : switch (this.state) {
            case INIT: {
                switch (event) {
                    case ON_CONNECT: {
                        this.context = (ConnectPostContext)data;
                        if (this.tracer.debug) {
                            this.tracer.log("Connecting...", Tracer.Level.DEBUG);
                        }
                        this.cep.connectPost(this.context.dispatcher, this.connectCompleteEventHandler, this.context.flags);
                        if (this.state != State.INIT) break block0;
                        if (this.tracer.debug) {
                            this.tracer.log("Connect pending...", Tracer.Level.DEBUG);
                        }
                        if ((this.context.flags & 2) == 2) {
                            if (this.tracer.debug) {
                                this.tracer.log("NO_ASYNC flag specified. Returning with exception...", Tracer.Level.DEBUG);
                            }
                            throw new ELnkOpWouldAsyncException();
                        }
                        this.onEvent(Event.ON_CONNECT_PENDING, null);
                        break block0;
                    }
                    case ON_CONNECT_PENDING: {
                        if (this.context.timeout > 0) {
                            if (this.tracer.debug) {
                                this.tracer.log("Starting connect timer alarm [timeout=" + this.context.timeout + "ms]...", Tracer.Level.DEBUG);
                            }
                            this.context.alarmEvent = EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, this.timeoutEventHandler, this.context.timeout);
                            this.context.dispatcher.schedAlarmEv(this.context.alarmEvent);
                        } else if (this.tracer.debug) {
                            this.tracer.log("Inifinite timeout requested [" + this.context.timeout + "ms]. Not starting timer alarm.", Tracer.Level.DEBUG);
                        }
                        this.state = State.CONNECTING;
                        break block0;
                    }
                    case ON_CONNECT_COMPLETE: {
                        if ((this.context.flags & 1) == 1) {
                            if (this.tracer.debug) {
                                this.tracer.log("IMMEDIATE_DISPATCH flag specified. Dispatching completion event " + data + "...", Tracer.Level.DEBUG);
                            }
                            this.state = ((LnkEvents.ConnectAcceptCompleteEventData)data).status ? State.CONNECTED : State.FAILED;
                            this.dispatchCompletion((LnkEvents.ConnectAcceptCompleteEventData)data);
                            break block0;
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("IMMEDIATE_DISPATCH flag not specified. Scheduling completion event " + data + "]...", Tracer.Level.DEBUG);
                        }
                        this.context.userEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, this.notifyEventHandler);
                        this.context.dispatcher.schedUserEv((IEmxUserEvent)this.context.userEvent.setAttachment(data));
                        this.state = State.NOTIFYING;
                        break block0;
                    }
                    case ON_CLOSE: {
                        if (this.context != null && this.context.pep != null) {
                            throw new InternalError("Peer endpoint in post context is non-null for [state=" + (Object)((Object)this.state) + " event=" + (Object)((Object)event) + "]!");
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Closing wrapped endpoint...", Tracer.Level.DEBUG);
                        }
                        this.cep.close();
                        this.state = State.CLOSED;
                        break block0;
                    }
                    default: {
                        throw new ELnkInvalidStateException(event.toString(), this.state.toString());
                    }
                }
            }
            case CONNECTING: {
                switch (event) {
                    case ON_CONNECT_COMPLETE: {
                        if (this.context.alarmEvent != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("Stopping alarm...", Tracer.Level.DEBUG);
                            }
                            this.context.dispatcher.unschedAlarmEv(this.context.alarmEvent);
                        } else if (this.tracer.debug) {
                            this.tracer.log("Alarm not started.", Tracer.Level.DEBUG);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Dispatching completion event " + data + "...", Tracer.Level.DEBUG);
                        }
                        this.state = ((LnkEvents.ConnectAcceptCompleteEventData)data).status ? State.CONNECTED : State.FAILED;
                        this.dispatchCompletion((LnkEvents.ConnectAcceptCompleteEventData)data);
                        break block0;
                    }
                    case ON_CANCEL: {
                        if (this.context.alarmEvent != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("Stopping alarm...", Tracer.Level.DEBUG);
                            }
                            this.context.dispatcher.unschedAlarmEv(this.context.alarmEvent);
                        } else if (this.tracer.debug) {
                            this.tracer.log("Alarm not started.", Tracer.Level.DEBUG);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("Cancelling connect on wrapped endpoint.", Tracer.Level.DEBUG);
                        }
                        this.cep.connectCancel(0);
                        LnkEvents.ConnectAcceptCompleteEventData completionEvent = new LnkEvents.ConnectAcceptCompleteEventData(new ELnkOpCancelledException());
                        if (this.tracer.debug) {
                            this.tracer.log("Scheduling completion event " + completionEvent + "...", Tracer.Level.DEBUG);
                        }
                        this.context.userEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, this.notifyEventHandler);
                        this.context.dispatcher.schedUserEv((IEmxUserEvent)this.context.userEvent.setAttachment(completionEvent));
                        this.state = State.CANCELLING;
                        break block0;
                    }
                    case ON_TIMEOUT: {
                        if (this.tracer.debug) {
                            this.tracer.log("Cancelling connect on wrapped endpoint.", Tracer.Level.DEBUG);
                        }
                        this.cep.connectCancel(0);
                        LnkEvents.ConnectAcceptCompleteEventData completionEvent = new LnkEvents.ConnectAcceptCompleteEventData(new ELnkOpTimeoutException());
                        if (this.tracer.debug) {
                            this.tracer.log("Dispatching completion event " + completionEvent + "...", Tracer.Level.DEBUG);
                        }
                        this.state = State.FAILED;
                        this.dispatchCompletion(completionEvent);
                        break block0;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case NOTIFYING: {
                switch (event) {
                    case ON_NOTIFY: {
                        if (this.tracer.debug) {
                            this.tracer.log("Dispatching completion event " + data + "...", Tracer.Level.DEBUG);
                        }
                        this.state = State.CONNECTED;
                        this.dispatchCompletion((LnkEvents.ConnectAcceptCompleteEventData)data);
                        break block0;
                    }
                    case ON_CANCEL: {
                        LnkEvents.ConnectAcceptCompleteEventData oldCompletionEvent = (LnkEvents.ConnectAcceptCompleteEventData)this.context.userEvent.getAttachment();
                        LnkEvents.ConnectAcceptCompleteEventData newCompletionEvent = new LnkEvents.ConnectAcceptCompleteEventData(new ELnkOpCancelledException());
                        if (this.tracer.debug) {
                            this.tracer.log("Replacing completion event " + oldCompletionEvent + " with completion event " + newCompletionEvent + "...", Tracer.Level.DEBUG);
                        }
                        this.context.pep = oldCompletionEvent.pep;
                        this.context.userEvent.setAttachment(newCompletionEvent);
                        this.state = State.CANCELLING;
                        break block0;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case CANCELLING: {
                switch (event) {
                    case ON_NOTIFY: {
                        if (this.tracer.debug) {
                            this.tracer.log("Dispatching completion event " + data + "...", Tracer.Level.DEBUG);
                        }
                        this.state = State.CANCELLED;
                        this.dispatchCompletion((LnkEvents.ConnectAcceptCompleteEventData)data);
                        break block0;
                    }
                    case ON_CANCEL: {
                        break block0;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case FAILED: {
                switch (event) {
                    case ON_CLOSE: {
                        if (this.context.pep != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("Closing abandoned peer endpoint...", Tracer.Level.DEBUG);
                            }
                            this.context.pep.close((short)-1);
                        } else {
                            if (this.tracer.debug) {
                                this.tracer.log("Closing wrapped endpoint...", Tracer.Level.DEBUG);
                            }
                            this.cep.close();
                        }
                        this.state = State.CLOSED;
                        break block0;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case CANCELLED: {
                switch (event) {
                    case ON_CANCEL: {
                        break block0;
                    }
                    case ON_CLOSE: {
                        if (this.context.pep != null) {
                            if (this.tracer.debug) {
                                this.tracer.log("Closing abandoned peer endpoint...", Tracer.Level.DEBUG);
                            }
                            this.context.pep.close((short)-1);
                        } else {
                            if (this.tracer.debug) {
                                this.tracer.log("Closing wrapped endpoint...", Tracer.Level.DEBUG);
                            }
                            this.cep.close();
                        }
                        this.state = State.CLOSED;
                        break block0;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case CONNECTED: {
                switch (event) {
                    default: 
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            case CLOSED: {
                switch (event) {
                    case ON_CLOSE: {
                        break block0;
                    }
                }
                throw new ELnkInvalidStateException(event.toString(), this.state.toString());
            }
            default: {
                throw new InternalError("Invalid state [" + this.state.toString() + "]");
            }
        }
    }

    public static ILnkClientEndpoint create(RootConfig.ObjectConfig config, ILnkClientEndpointCore cep) {
        return new LnkClientEndpoint(config, cep);
    }

    @Override
    public final void connectPost(IEmxDispatcher dispatcher, ILnkEventHandler handler, int timeout, int flags) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (dispatcher.getOwner() != Thread.currentThread()) {
            throw new ELnkNotOwnerException();
        }
        this.onEvent(Event.ON_CONNECT, new ConnectPostContext(dispatcher, handler, timeout, flags));
    }

    @Override
    public final void connectCancel(int flags) throws ELnkInvalidStateException, ELnkNotOwnerException {
        if (this.context != null && this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new ELnkNotOwnerException();
        }
        try {
            this.onEvent(Event.ON_CANCEL, new ConnectCancelContext(flags));
        }
        catch (ELnkOpFailedException e) {
            throw new InternalError("Connect cancel operation threw ELnkOpFailedException!");
        }
    }

    @Override
    public final void close() throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkOpFailedException {
        if (this.context != null && this.context.dispatcher.getOwner() != Thread.currentThread()) {
            throw new ELnkNotOwnerException();
        }
        this.onEvent(Event.ON_CLOSE, null);
    }

    protected final void finalize() {
        block2: {
            try {
                this.onEvent(Event.ON_CLOSE, null);
            }
            catch (Exception e) {
                if (!this.tracer.debug) break block2;
                this.tracer.log("Failed to close client endpoint on finalization [" + e.toString() + "]", Tracer.Level.DEBUG);
            }
        }
    }

    private final class ConnectCancelContext {
        final int flags;

        ConnectCancelContext(int flags) {
            this.flags = flags;
        }
    }

    private final class ConnectPostContext {
        final IEmxDispatcher dispatcher;
        final ILnkEventHandler handler;
        final int timeout;
        final int flags;
        IEmxAlarmEvent alarmEvent;
        IEmxUserEvent userEvent;
        ILnkPeerEndpoint pep;

        ConnectPostContext(IEmxDispatcher dispatcher, ILnkEventHandler handler, int timeout, int flags) {
            this.dispatcher = dispatcher;
            this.handler = handler;
            this.timeout = timeout;
            this.flags = flags;
        }
    }

    private final class NotifyEventHandler
    implements IEmxEventHandler {
        private NotifyEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            try {
                LnkClientEndpoint.this.onEvent(Event.ON_NOTIFY, event.getAttachment());
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class TimeoutEventHandler
    implements IEmxEventHandler {
        private TimeoutEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            try {
                LnkClientEndpoint.this.onEvent(Event.ON_TIMEOUT, null);
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class ConnectCompleteEventHandler
    implements ILnkEventHandlerCore {
        private ConnectCompleteEventHandler() {
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, int event, Object data) {
            if (event != 1) {
                throw new InternalError("Received unexpected event [" + event + "] from wrapped endpoint");
            }
            try {
                LnkClientEndpoint.this.onEvent(Event.ON_CONNECT_COMPLETE, data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static enum Event {
        ON_CONNECT,
        ON_CONNECT_PENDING,
        ON_CONNECT_COMPLETE,
        ON_NOTIFY,
        ON_CANCEL,
        ON_TIMEOUT,
        ON_CLOSE;

    }

    private static enum State {
        INIT,
        CONNECTING,
        NOTIFYING,
        CANCELLING,
        FAILED,
        CANCELLED,
        CONNECTED,
        CLOSED;

    }
}

