/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxNwLnkClosedGracefullyException;
import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;

public final class EmxNwLnkBlockingReader
extends EmxNwLnkReader {
    private final EmxNwLnk link;
    private final boolean spinRead;

    private EmxNwLnkBlockingReader(EmxNwLnk link, EmxNwLnkReader.Callback cb, boolean spinRead) throws EEmxException {
        super(cb);
        if (link == null) {
            throw new IllegalArgumentException("link cannot be null");
        }
        this.link = link;
        this.spinRead = spinRead;
        this.link.configureBlockingRead(!this.spinRead);
    }

    public static final EmxNwLnkBlockingReader create(EmxNwLnk link, EmxNwLnkReader.Callback cb, boolean spinRead) throws EEmxException {
        return new EmxNwLnkBlockingReader(link, cb, spinRead);
    }

    public static final EmxNwLnkBlockingReader create(EmxNwLnk link, EmxNwLnkReader.Callback cb) throws EEmxException {
        return EmxNwLnkBlockingReader.create(link, cb, false);
    }

    @Override
    protected final void doRunPrepare() {
    }

    @Override
    protected final void doRun() {
        while (!this.stopped) {
            try {
                if (this.readAndDispatch(this.link) || this.spinRead) continue;
                throw new InternalError("nothing was read for a blocking read!");
            }
            catch (Throwable e) {
                if (e instanceof EEmxNwLnkClosedGracefullyException) {
                    this.cb.handleLinkClosure(this.link);
                    break;
                }
                if (this.stopped) break;
                this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                this.cb.handleLinkFailure(this.link, e);
                break;
            }
        }
    }

    @Override
    protected final void doUnblock() {
        ((Thread)this.runner.get()).interrupt();
    }
}

