/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.tck;

import com.neeve.aep.AepEngine;
import com.neeve.config.VMConfigurer;
import com.neeve.server.Configurer;
import com.neeve.server.Main;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.embedded.EmbeddedXVM;
import com.neeve.sma.tck.AbstractSMATckTestApp;
import com.neeve.util.UtlTailoring;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class SMATckTestServer<T extends AbstractSMATckTestApp>
extends EmbeddedXVM {
    private static final boolean useMulticastDiscovery = new Boolean(System.getProperty("nv.test.usemcastdiscovery"));
    private final Class<T> applicationClass;
    private final String appName;
    private final String instanceId;
    private final String serverName;
    private final Map<String, String> configOverrides;
    private T application;

    private SMATckTestServer(AepServerTestAppConfigurer<T> configurer, SrvConfigDescriptor descriptor, Map<String, String> configOverides) {
        super(configurer, descriptor);
        this.appName = configurer.getAppName();
        this.instanceId = configurer.getInstanceId();
        this.serverName = configurer.getServerName();
        this.applicationClass = configurer.getApplicationClass();
        this.configOverrides = configOverides;
    }

    public static final <T extends AbstractSMATckTestApp> SMATckTestServer<T> create(String appName, String instanceId, Class<T> applicationClass, Map<String, String> configOverrides) {
        HashMap<String, String> config = configOverrides != null ? new HashMap<String, String>(configOverrides) : null;
        AepServerTestAppConfigurer<T> configurer = new AepServerTestAppConfigurer<T>(appName, instanceId, applicationClass, configOverrides);
        try {
            SrvConfigDescriptor descriptor = Main.seedServerConfig(configurer, new String[0]);
            return new SMATckTestServer<T>(configurer, descriptor, config);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading aep test server for " + appName, e);
        }
    }

    @Override
    public void onStartEnd(Throwable error) throws Exception {
        SrvAppLoader loader;
        if (error == null && (loader = this.getServerController().getAppManager().getAppLoader(this.appName)) != null) {
            Object main = loader.getAppMain();
            if (this.applicationClass == main.getClass()) {
                this.application = (AbstractSMATckTestApp)main;
                ((AbstractSMATckTestApp)this.application).setServer(this);
            } else {
                throw new Exception("Application '" + this.appName + "' main class was expected to be type '" + this.applicationClass.getCanonicalName() + "' but loaded class was '" + main.getClass().getCanonicalName() + ".");
            }
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public T getApplication() {
        if (this.application != null) {
            return this.application;
        }
        if (this.getState() != EmbeddedXVM.State.Started) {
            throw new IllegalStateException("Application not available until server started");
        }
        throw new IllegalStateException("Application not loaded.");
    }

    public String toString() {
        return "ToaTestServer " + this.getServerName() + " (" + this.applicationClass.getSimpleName() + ")";
    }

    public Map<String, String> getConfigOverrides() {
        return this.configOverrides;
    }

    private static class AepServerTestAppConfigurer<T extends AbstractSMATckTestApp>
    implements Configurer,
    UtlTailoring.PropertySource {
        private final String appName;
        private final String instanceId;
        private final String serverName;
        private final Class<T> applicationClass;
        private final UtlTailoring.PropertySource envResolver = UtlTailoring.ENV_SUBSTITUTION_RESOLVER;
        final Map<String, String> overrides = new HashMap<String, String>();
        private String ddlPath = "single-app-server-template.xml";

        AepServerTestAppConfigurer(String appName, String instanceId, Class<T> applicationClass, Map<String, String> configOverrides) {
            this.appName = appName;
            this.instanceId = instanceId;
            this.serverName = appName + "-" + instanceId;
            this.applicationClass = applicationClass;
            System.getProperties().setProperty("nv.server.autostop.onlastappstop", "false");
            this.overrides.put("store.clustering.enabled", "false");
            this.overrides.put("application.name", appName);
            this.overrides.put("application.server.name", appName + "-" + instanceId);
            this.overrides.put("application.main.class", applicationClass.getName());
            this.overrides.put("transport.descriptor", "loopback://.");
            String additionalDiscoveryParams = this.overrides.get("additionalDiscoveryParams");
            additionalDiscoveryParams = additionalDiscoveryParams == null ? "" : "&" + additionalDiscoveryParams;
            if (!useMulticastDiscovery) {
                this.overrides.put("store.discovery.descriptor", "loopback://clusterdiscovery&initWaitTime=1&memberName=" + this.serverName + additionalDiscoveryParams);
                this.overrides.put("server.discoveryDescriptor", "loopback://serverdiscovery&initWaitTime=3" + additionalDiscoveryParams);
            } else {
                this.overrides.put("store.discovery.descriptor", "mcast://224.0.1.200:4090&initWaitTime=1&memberName=" + this.serverName + additionalDiscoveryParams);
                this.overrides.put("server.discoveryDescriptor", "mcast://224.0.1.200:4090&initWaitTime=3" + additionalDiscoveryParams);
            }
            if (configOverrides != null) {
                String ddlPath;
                this.overrides.putAll(configOverrides);
                System.getProperties().putAll(configOverrides);
                String string = ddlPath = configOverrides != null ? configOverrides.get("ddlPath") : null;
                if (ddlPath != null) {
                    this.ddlPath = ddlPath;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String[] configure(String[] args) throws Exception {
            URL ddl = SMATckTestServer.class.getResource(this.ddlPath);
            if (ddl == null) {
                throw new Exception("Could not resolve ddl '" + this.ddlPath + "'");
            }
            try (InputStream is = ddl.openStream();){
                VMConfigurer.configure((InputStream)is, (UtlTailoring.PropertySource)this);
            }
            return new String[]{"--name", this.serverName};
        }

        public String getValue(String key, String defaultValue) {
            String override = this.overrides.get(key);
            if (override != null) {
                return override;
            }
            return this.envResolver.getValue(key, defaultValue);
        }

        public final String getAppName() {
            return this.appName;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final Class<T> getApplicationClass() {
            return this.applicationClass;
        }
    }

    public static final class Config
    extends HashMap<String, String> {
        private static final long serialVersionUID = 1L;
        public static final String PROP_NAME_STORE_ENABLED = "store.enabled";
        public static final String PROP_NAME_OUTBOUND_MESSAGE_LOGGING_POLICY = "outbound.message.logging.policy";

        public Config withStoreEnabled(boolean val) {
            this.put(PROP_NAME_STORE_ENABLED, "" + val);
            return this;
        }

        public Config withOutboundMessageLoggingPolicy(AepEngine.OutboundMessageLoggingPolicy val) {
            this.put(PROP_NAME_OUTBOUND_MESSAGE_LOGGING_POLICY, "" + val);
            return this;
        }

        public Config withOutboundMessageLoggingPolicyProperty(AepEngine.OutboundMessageLoggingPolicy val) {
            this.put(PROP_NAME_OUTBOUND_MESSAGE_LOGGING_POLICY, "" + val);
            return this;
        }

        public Config withOutboundMessageLoggingDetached(boolean val) {
            this.put("outbound.message.logging.policy.detachedWrite.enabled", "" + val);
            return this;
        }
    }
}

