/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.link;

import com.neeve.event.IEventHandler;
import com.neeve.lang.XLinkedList;
import com.neeve.server.link.SrvLinkSmaMessageChannel;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.trace.Tracer;

public final class SrvLinkSmaMessageBusBinding
extends MessageBusBindingBase {
    private XLinkedList<SrvLinkSmaMessageChannel> clients;

    SrvLinkSmaMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(null, userName, descriptor, eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushBlocking() {
        XLinkedList<SrvLinkSmaMessageChannel> xLinkedList = this.clients;
        synchronized (xLinkedList) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Flushing client channels (channel count=" + this.clients.size() + ")...", Tracer.Level.DEBUG);
            }
            try {
                for (SrvLinkSmaMessageChannel channel : this.clients) {
                    try {
                        channel.flush();
                    }
                    catch (SmaException e) {
                        this.tracer.log(this.tracePrefix + "Failed to flush channel " + (Object)((Object)channel) + " [" + e.toString() + "].", Tracer.Level.WARNING);
                    }
                }
                return;
            }
            finally {
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Flush complete.", Tracer.Level.DEBUG);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onClientConnected(SrvLinkSmaMessageChannel channel) {
        XLinkedList<SrvLinkSmaMessageChannel> xLinkedList = this.clients;
        synchronized (xLinkedList) {
            this.clients.add((Object)channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onClientDisconnected(SrvLinkSmaMessageChannel channel) {
        XLinkedList<SrvLinkSmaMessageChannel> xLinkedList = this.clients;
        synchronized (xLinkedList) {
            int index = this.clients.indexOf((Object)channel);
            if (index >= 0) {
                this.clients.remove(index);
            }
        }
    }

    protected final void doOpen() throws SmaException {
        this.clients = new XLinkedList(256);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Binding opened for user '" + this.userName + "'.", Tracer.Level.DEBUG);
        }
    }

    protected final MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Creating new channel '" + descriptor.getName() + "'.", Tracer.Level.DEBUG);
        }
        return new SrvLinkSmaMessageChannel(descriptor, this);
    }

    protected final void doStart() throws SmaException {
    }

    protected final void doFlush() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Flushing...", Tracer.Level.DEBUG);
        }
        this.flushBlocking();
    }

    protected final boolean doCanFail() {
        return false;
    }

    protected final boolean doAcksRequireFlush() {
        return false;
    }

    protected final void doClose() throws SmaException {
    }
}

