/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.config;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigComplexEntity;
import com.neeve.config.IConfigComplexEntityContainer;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.daemon.config.DmnConfigDescriptor;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.server.config.ESrvConfigException;
import com.neeve.server.config.SrvConfigAppDescriptor;
import com.neeve.server.config.SrvConfigConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlUnit;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public final class SrvConfigDescriptor
extends DmnConfigDescriptor {
    public static final String SERVER_ENABLE_BACKGROUND_COMMANDINVOCATION = "nv.server.backgroundcommandinvocation";
    public static final boolean SERVER_ENABLE_BACKGROUND_COMMANDINVOCATION_DEFAULT = true;
    private String name;
    private String group;
    private String displayName;
    private String systemName;
    private String systemVersion;
    private short version;
    private boolean multiThreaded;
    private boolean printDescriptor;
    private int ioThreadCount;
    private long[] ioThreadCpuAffinityMasks;
    private int maxOnDemandThreadCount;
    private int maxTraceHistory;
    private Set<String> acceptors;
    private int clientHandshakeTimeout;
    private boolean autoStopOnAppStartFail;
    private boolean autoStopOnLastAppStop;
    private int adminClientOutputQueueCapacity;
    private String discoveryDescriptor;
    private Map<String, SrvConfigAppDescriptor> apps;
    private Heartbeats heartbeats;
    private Admin admin;
    private Properties otherProps;

    private SrvConfigDescriptor(String name) {
        super(SrvConfigConfig.getConfig());
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.init(name);
    }

    private final SrvConfigDescriptor init(String name) {
        this.name = name;
        this.group = "default";
        this.version = 1;
        this.multiThreaded = false;
        this.printDescriptor = false;
        this.ioThreadCount = 1;
        this.ioThreadCpuAffinityMasks = new long[this.ioThreadCount];
        this.maxOnDemandThreadCount = 0;
        this.maxTraceHistory = 512;
        this.acceptors = new LinkedHashSet<String>();
        this.acceptors.add("tcp://0.0.0.0:0");
        this.clientHandshakeTimeout = 10;
        this.autoStopOnAppStartFail = false;
        this.autoStopOnLastAppStop = true;
        this.adminClientOutputQueueCapacity = (int)UtlUnit.parseBytes((String)"10mb", (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Megabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
        this.apps = new LinkedHashMap<String, SrvConfigAppDescriptor>();
        this.otherProps = new Properties();
        this.heartbeats = new Heartbeats();
        this.admin = new Admin();
        this.discoveryDescriptor = null;
        return this;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setGroup(String group) {
        if (group == null) {
            throw new IllegalArgumentException("group cannot be null");
        }
        this.group = group;
    }

    @Override
    public final String getGroup() {
        return this.group;
    }

    @Override
    public final short getVersion() {
        return this.version;
    }

    @Override
    public final boolean isChecked() {
        return this.checked;
    }

    @Override
    public final void setPrintDescriptor(boolean printDescriptor) {
        this.printDescriptor = printDescriptor;
    }

    @Override
    public final boolean isPrintDescriptor() {
        return this.printDescriptor;
    }

    @Override
    public final void setMultiThreaded(boolean multiThreaded) {
        if (this.multiThreaded != multiThreaded && !(this.multiThreaded = multiThreaded)) {
            this.setIOThreadCount(1);
        }
    }

    @Override
    public final boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    @Override
    public final void setIOThreadCount(int ioThreadCount) {
        if (ioThreadCount < 1) {
            throw new IllegalArgumentException("count must be >= 1");
        }
        if (ioThreadCount > 1 && !this.isMultiThreaded()) {
            throw new IllegalStateException("must set server as multi-threaded before setting the IO thread count > 1");
        }
        this.ioThreadCount = ioThreadCount;
        this.ioThreadCpuAffinityMasks = new long[ioThreadCount];
    }

    @Override
    public final int getIOThreadCount() {
        return this.ioThreadCount;
    }

    @Override
    public final void setIOThreadCPUAffinityMask(int threadId, long mask) {
        if (threadId < 0 || threadId >= this.ioThreadCount) {
            throw new IllegalArgumentException("Illegal thread id value '" + threadId + "', thread id must be between 0 and (IOThreadCount - 1) both inclusive");
        }
        this.ioThreadCpuAffinityMasks[threadId] = mask;
    }

    @Override
    public final long getIOThreadCPUAffinityMask(int threadId) {
        if (threadId < 0 || threadId >= this.ioThreadCount) {
            throw new IllegalArgumentException("thread id must be between 0 and IO thread count both exclusive");
        }
        return this.ioThreadCpuAffinityMasks[threadId];
    }

    @Override
    public final long[] getIOThreadCPUAffinityMasks() {
        return (long[])this.ioThreadCpuAffinityMasks.clone();
    }

    @Override
    public final void setMaxOnDemandThreadCount(int maxOnDemandThreadCount) {
        if (maxOnDemandThreadCount < 0) {
            throw new IllegalArgumentException("count must be >= 0");
        }
        if (maxOnDemandThreadCount > 0 && !this.isMultiThreaded()) {
            throw new IllegalStateException("must set server as multi-threaded before setting the on demand thread count > 0");
        }
        this.maxOnDemandThreadCount = maxOnDemandThreadCount;
    }

    @Override
    public final int getMaxOnDemandThreadCount() {
        return this.maxOnDemandThreadCount;
    }

    public final void setMaxTraceHistory(int val) {
        if (val <= 0) {
            throw new IllegalArgumentException("record count must be > 0");
        }
        this.maxTraceHistory = val;
    }

    public final int getMaxTraceHistory() {
        return this.maxTraceHistory;
    }

    public void setDiscoveryDescriptor(String discoveryDescriptor) {
        this.discoveryDescriptor = discoveryDescriptor;
    }

    public String getDiscoveryDescriptor() {
        return this.discoveryDescriptor;
    }

    public final void addAcceptor(String descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        this.acceptors.add(descriptor);
    }

    public final void removeAcceptor(String descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        this.acceptors.remove(descriptor);
    }

    public final Set<String> getAcceptors() {
        return this.acceptors;
    }

    public final void setClientHandshakeTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("timeout must be > 0");
        }
        this.clientHandshakeTimeout = timeout;
    }

    public final int getClientHandshakeTimeout() {
        return this.clientHandshakeTimeout;
    }

    public final void setAutoStopOnAppStartFail(boolean autoStopOnAppStartFail) {
        this.autoStopOnAppStartFail = autoStopOnAppStartFail;
    }

    public final boolean isAutoStopOnAppStartFail() {
        return this.autoStopOnAppStartFail;
    }

    public final void setAutoStopOnLastAppStop(boolean autoStopOnLastAppStop) {
        this.autoStopOnLastAppStop = autoStopOnLastAppStop;
    }

    public final boolean isAutoStopOnLastAppStop() {
        return this.autoStopOnLastAppStop;
    }

    public final void setAdminClientOutputQueueCapacity(float capacity) {
        this.adminClientOutputQueueCapacity = (int)UtlUnit.convertBytes((double)capacity, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Megabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
    }

    public final void setAdminClientOutputQueueCapacity(String capacity) {
        this.adminClientOutputQueueCapacity = (int)UtlUnit.parseBytes((String)capacity, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Megabytes, (UtlUnit.ByteUnit)UtlUnit.ByteUnit.Bytes);
    }

    public final int getAdminClientOutputQueueCapacity() {
        return this.adminClientOutputQueueCapacity;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public final void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public void setSystemVersion(String systemVersion) {
        this.systemVersion = systemVersion;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public final void addApp(SrvConfigAppDescriptor app) {
        if (app == null) {
            throw new IllegalArgumentException("app cannot be null");
        }
        this.apps.put(app.getName(), app);
    }

    public final SrvConfigAppDescriptor getApp(String appName) {
        return this.apps.get(appName);
    }

    public final void removeApp(String appName) {
        if (appName == null) {
            throw new IllegalArgumentException("app name cannot be null");
        }
        this.apps.remove(appName);
    }

    public final Set<SrvConfigAppDescriptor> getApps() {
        Iterator<SrvConfigAppDescriptor> iterator = this.apps.values().iterator();
        LinkedHashSet<SrvConfigAppDescriptor> apps = new LinkedHashSet<SrvConfigAppDescriptor>();
        while (iterator.hasNext()) {
            apps.add(iterator.next());
        }
        return apps;
    }

    public final Set<String> getAppNames() {
        Iterator<SrvConfigAppDescriptor> iterator = this.apps.values().iterator();
        LinkedHashSet<String> appNames = new LinkedHashSet<String>();
        while (iterator.hasNext()) {
            appNames.add(iterator.next().getName());
        }
        return appNames;
    }

    public final Heartbeats getHeartbeats() {
        return this.heartbeats;
    }

    public final HeartbeatTracing getHeartbeatTracing() {
        return this.heartbeats.getTracing();
    }

    public final SrvConfigDescriptor setHeartbeatLoggingProperty(String name, String val) {
        if (name == null || val == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.heartbeats.logging.setProperty(name, val);
        return this;
    }

    public final String getHeartbeatLoggingProperty(String name) {
        return this.heartbeats.logging.getProperty(name);
    }

    public final SrvConfigDescriptor clearHeartbeatLoggingProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("property name or value cannot be null");
        }
        this.heartbeats.logging.remove(name);
        return this;
    }

    public final SrvConfigDescriptor setHeartbeatLoggingProperties(Properties val) {
        this.heartbeats.logging = val;
        if (this.heartbeats.logging == null) {
            this.heartbeats.logging = new Properties();
        }
        return this;
    }

    public final Properties getHeartbeatLoggingProperties() {
        return this.heartbeats.logging;
    }

    public final Admin getAdmin() {
        return this.admin;
    }

    public final void setOtherProperty(String name, String val) {
        if (name == null) {
            throw new IllegalArgumentException("prop name cannot be null");
        }
        this.otherProps.setProperty(name, val);
    }

    public final String getOtherProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("app name cannot be null");
        }
        return this.otherProps.getProperty(name);
    }

    public final Properties getOtherProperties() {
        return this.otherProps;
    }

    public final SrvConfigDescriptor load(Properties props, boolean shortForm) {
        StringTokenizer tokenizer;
        int numThreads;
        String propname;
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        Properties propsCopy = new Properties();
        propsCopy.putAll((Map<?, ?>)props);
        String string = propname = shortForm ? "group" : "nv.server.group";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setGroup(UtlProps.getValue((Properties)propsCopy, (String)propname));
            propsCopy.remove(propname);
        }
        String string2 = propname = shortForm ? "multithreaded" : "nv.server.multithreaded";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setMultiThreaded(UtlProps.getValue((Properties)propsCopy, (String)propname, (boolean)false));
            propsCopy.remove(propname);
        }
        String string3 = propname = shortForm ? "printdesc" : "nv.server.printdesc";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setPrintDescriptor(UtlProps.getValue((Properties)propsCopy, (String)propname, (boolean)false));
            propsCopy.remove(propname);
        }
        String string4 = propname = shortForm ? "numiothreads" : "nv.server.numiothreads";
        if (this.isMultiThreaded() && UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            numThreads = UtlProps.getValue((Properties)propsCopy, (String)propname, (int)0);
            if (numThreads <= 0) {
                this.tracer.log("Invalid number of server I/O threads (=" + numThreads + ") configured. Using default=1.", Tracer.Level.WARNING);
                numThreads = 1;
            }
            this.setIOThreadCount(numThreads);
            propsCopy.remove(propname);
        }
        for (int i = 0; i < this.ioThreadCount; ++i) {
            propname = (shortForm ? "iothread" : "nv.server.iothread") + "." + i + ".cpuaffinitymask";
            if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
                this.setIOThreadCPUAffinityMask(i, UtlThread.parseAffinityMask((String)UtlProps.getValue((Properties)propsCopy, (String)propname, (String)"0")));
                propsCopy.remove(propname);
                continue;
            }
            this.setIOThreadCPUAffinityMask(i, 0L);
        }
        String string5 = propname = shortForm ? "maxondemandthreads" : "nv.server.maxondemandthreads";
        if (this.isMultiThreaded() && UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            numThreads = UtlProps.getValue((Properties)propsCopy, (String)propname, (int)0);
            if (numThreads < 0) {
                this.tracer.log("Invalid number of server on-demand threads (=" + numThreads + ") configured. Using default=0.", Tracer.Level.WARNING);
                numThreads = 0;
            }
            this.setMaxOnDemandThreadCount(numThreads);
            propsCopy.remove(propname);
        }
        String string6 = propname = shortForm ? "maxtracehistory" : "nv.server.maxtracehistory";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            int val = UtlProps.getValue((Properties)propsCopy, (String)propname, (int)256);
            if (val <= 0) {
                this.tracer.log("Invalid maximum trace history (=" + val + ") configured. Using default=256.", Tracer.Level.WARNING);
                val = 256;
            }
            this.setMaxTraceHistory(val);
            propsCopy.remove(propname);
        }
        String string7 = propname = shortForm ? "discoverydescriptor" : "nv.server.discoverydescriptor";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            String val = UtlProps.getValue((Properties)propsCopy, (String)propname);
            this.setDiscoveryDescriptor(val);
            propsCopy.remove(propname);
        } else {
            this.setDiscoveryDescriptor(null);
        }
        String string8 = propname = shortForm ? "clientacceptors" : "nv.server.clientacceptors";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.acceptors.clear();
            String acceptorList = UtlProps.getValue((Properties)propsCopy, (String)propname);
            tokenizer = new StringTokenizer(acceptorList, ",");
            if (tokenizer.hasMoreTokens()) {
                while (tokenizer.hasMoreTokens()) {
                    this.addAcceptor(tokenizer.nextToken().trim());
                }
            }
            propsCopy.remove(propname);
        }
        String string9 = propname = shortForm ? "clienthandshaketimeout" : "nv.server.clienthandshaketimeout";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setClientHandshakeTimeout(UtlProps.getValue((Properties)propsCopy, (String)propname, (int)0));
            propsCopy.remove(propname);
        }
        String string10 = propname = shortForm ? "autostop.onappstartfail" : "nv.server.autostop.onappstartfail";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setAutoStopOnAppStartFail(UtlProps.getValue((Properties)propsCopy, (String)propname, (boolean)false));
            propsCopy.remove(propname);
        }
        String string11 = propname = shortForm ? "autostop.onlastappstop" : "nv.server.autostop.onlastappstop";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setAutoStopOnLastAppStop(UtlProps.getValue((Properties)propsCopy, (String)propname, (boolean)true));
            propsCopy.remove(propname);
        }
        String string12 = propname = shortForm ? "adminclient.outputqueue.capacity" : "nv.server.adminclient.outputqueue.capacity";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setAdminClientOutputQueueCapacity(UtlProps.getValue((Properties)propsCopy, (String)propname, (String)"10mb"));
            propsCopy.remove(propname);
        }
        String string13 = propname = shortForm ? "systemname" : "nv.server.systemname";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setSystemName(UtlProps.getValue((Properties)propsCopy, (String)propname));
            propsCopy.remove(propname);
        }
        String string14 = propname = shortForm ? "systemversion" : "nv.server.systemversion";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setSystemVersion(UtlProps.getValue((Properties)propsCopy, (String)propname));
            propsCopy.remove(propname);
        }
        String string15 = propname = shortForm ? "displayname" : "nv.server.displayname";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            this.setDisplayName(UtlProps.getValue((Properties)propsCopy, (String)propname));
            propsCopy.remove(propname);
        }
        String string16 = propname = shortForm ? "apps" : "nv.server.apps";
        if (UtlProps.getValue((Properties)propsCopy, (String)propname) != null) {
            String appList = UtlProps.getValue((Properties)propsCopy, (String)propname);
            tokenizer = new StringTokenizer(appList, ",");
            if (tokenizer.hasMoreTokens()) {
                while (tokenizer.hasMoreTokens()) {
                    String appName = tokenizer.nextToken().trim();
                    if (SrvConfigAppDescriptor.exists(this.getName(), appName)) {
                        try {
                            this.addApp(SrvConfigAppDescriptor.load(this.getName(), appName));
                            continue;
                        }
                        catch (ESrvConfigException e) {
                            throw new InternalError("Failure to load app descriptor when reported that it exists!");
                        }
                    }
                    this.tracer.log("App '" + appName + "' configured for server does not exist in repository. Ignoring...", Tracer.Level.WARNING);
                }
            }
            propsCopy.remove(propname);
        }
        this.heartbeats.load(propsCopy, shortForm);
        this.admin.load(propsCopy, shortForm);
        this.otherProps.putAll((Map<?, ?>)propsCopy);
        return this;
    }

    public final Properties save(Properties props, boolean shortForm) {
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        String propname = shortForm ? "name" : "nv.server.name";
        props.setProperty(propname, this.name);
        propname = shortForm ? "group" : "nv.server.group";
        props.setProperty(propname, this.group);
        propname = shortForm ? "checked" : "nv.server.checked";
        props.setProperty(propname, String.valueOf(this.isChecked()));
        propname = shortForm ? "multithreaded" : "nv.server.multithreaded";
        props.setProperty(propname, String.valueOf(this.isMultiThreaded()));
        propname = shortForm ? "printdesc" : "nv.server.printdesc";
        props.setProperty(propname, String.valueOf(this.isPrintDescriptor()));
        propname = shortForm ? "numiothreads" : "nv.server.numiothreads";
        props.setProperty(propname, String.valueOf(this.getIOThreadCount()));
        for (int i = 0; i < this.getIOThreadCount(); ++i) {
            propname = (shortForm ? "iothread" : "nv.server.iothread") + "." + i + ".cpuaffinitymask";
            props.setProperty(propname, String.valueOf(this.getIOThreadCPUAffinityMask(i)));
        }
        propname = shortForm ? "maxondemandthreads" : "nv.server.maxondemandthreads";
        props.setProperty(propname, String.valueOf(this.getMaxOnDemandThreadCount()));
        propname = shortForm ? "maxtracehistory" : "nv.server.maxtracehistory";
        props.setProperty(propname, String.valueOf(this.getMaxTraceHistory()));
        if (this.discoveryDescriptor != null) {
            propname = shortForm ? "discoverydescriptor" : "nv.server.discoverydescriptor";
            props.setProperty(propname, String.valueOf(this.getDiscoveryDescriptor()));
        }
        propname = shortForm ? "clientacceptors" : "nv.server.clientacceptors";
        StringBuilder builder = new StringBuilder();
        builder.append("");
        Iterator<String> iterator = this.getAcceptors().iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        props.setProperty(propname, builder.toString());
        propname = shortForm ? "clienthandshaketimeout" : "nv.server.clienthandshaketimeout";
        props.setProperty(propname, String.valueOf(this.getClientHandshakeTimeout()));
        propname = shortForm ? "autostop.onappstartfail" : "nv.server.autostop.onappstartfail";
        props.setProperty(propname, String.valueOf(this.isAutoStopOnAppStartFail()));
        propname = shortForm ? "autostop.onlastappstop" : "nv.server.autostop.onlastappstop";
        props.setProperty(propname, String.valueOf(this.isAutoStopOnLastAppStop()));
        propname = shortForm ? "adminclient.outputqueue.capacity" : "nv.server.adminclient.outputqueue.capacity";
        props.setProperty(propname, UtlUnit.readableBytesSize((long)this.getAdminClientOutputQueueCapacity()));
        if (this.getSystemName() != null) {
            propname = shortForm ? "systemname" : "nv.server.systemname";
            props.setProperty(propname, String.valueOf(this.getSystemName()));
        }
        if (this.getSystemVersion() != null) {
            propname = shortForm ? "systemversion" : "nv.server.systemversion";
            props.setProperty(propname, String.valueOf(this.getSystemVersion()));
        }
        if (this.getSystemVersion() != null) {
            propname = shortForm ? "displayname" : "nv.server.displayname";
            props.setProperty(propname, String.valueOf(this.getDisplayName()));
        }
        builder = new StringBuilder();
        builder.append("");
        iterator = this.getAppNames().iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        propname = shortForm ? "apps" : "nv.server.apps";
        props.setProperty(propname, builder.toString());
        this.heartbeats.save(props, shortForm);
        this.admin.save(props, shortForm);
        props.putAll((Map<?, ?>)this.otherProps);
        return props;
    }

    public final void save(IConfigRepository repo) throws ESrvConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigComplexEntity entity;
            IConfigComplexEntityContainer serverContainer = repo.getComplexEntityContainer("/servers");
            if (serverContainer == null) {
                serverContainer = repo.createComplexEntityContainer("/servers");
            }
            if ((entity = (IConfigComplexEntity)serverContainer.getEntity(this.name)) == null) {
                entity = (IConfigComplexEntity)serverContainer.createEntity(this.name);
            }
            entity.setProperties("server.properties", null).setProperties("server.properties", this.save(new Properties(), false));
            String appContainerAddr = "/servers/" + this.getName() + "/apps";
            IConfigSimpleEntityContainer appContainer = repo.getSimpleEntityContainer(appContainerAddr);
            if (appContainer == null) {
                appContainer = repo.createSimpleEntityContainer(appContainerAddr);
            }
        }
        catch (EConfigException e) {
            throw new ESrvConfigException(e);
        }
    }

    public final void save() throws ESrvConfigException {
        this.save(Config.getRepository());
    }

    public final void delete(IConfigRepository repo) throws ESrvConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        Iterator<SrvConfigAppDescriptor> iterator = SrvConfigAppDescriptor.loadAll(repo, this.getName()).iterator();
        while (iterator.hasNext()) {
            iterator.next().delete(repo, this.getName());
        }
        repo.removeSimpleEntityContainer("/servers/" + this.getName() + "/apps");
        IConfigComplexEntityContainer container = repo.getComplexEntityContainer("/servers");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final void delete() throws ESrvConfigException {
        this.delete(Config.getRepository());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Server '" + this.getName() + "' Configuration {").append("\n");
        sb.append("...group=").append(this.getGroup()).append("\n");
        sb.append("...apps {\n");
        for (SrvConfigAppDescriptor app : this.getApps()) {
            sb.append("......").append(app.getName()).append("{\n");
            sb.append(".........mainClass=").append(app.getMainClass()).append("\n");
            sb.append(".........autoStart=").append(app.getAutoStart()).append("\n");
            sb.append("......}\n");
        }
        sb.append("...checked=").append(this.isChecked()).append("\n");
        sb.append("...clientacceptors {\n");
        for (String acceptor : this.acceptors) {
            sb.append("......").append(acceptor).append("\n");
        }
        sb.append("...}\n");
        sb.append("...clientHandshakeTimeout=").append(this.getClientHandshakeTimeout()).append("\n");
        sb.append("...autostop.onlastappstop=").append(this.isAutoStopOnLastAppStop()).append("\n");
        sb.append("...adminclient.outputqueue.capacity=").append(UtlUnit.readableBytesSize((long)this.getAdminClientOutputQueueCapacity())).append("\n");
        sb.append("...discovery=").append(this.getDiscoveryDescriptor() == null ? "default" : UtlAddressDescriptor.parse((String)this.getDiscoveryDescriptor(), null).toPasswordSanitizedFullString()).append("\n");
        sb.append("...iothreads {\n");
        for (int i = 0; i < this.ioThreadCount; ++i) {
            sb.append("......Thread[").append(i).append("] {cpuAff=").append(UtlThread.decodeAffinityMask((long)this.getIOThreadCPUAffinityMask(0))).append("}\n");
        }
        sb.append("...}\n");
        sb.append("...heartbeats {\n");
        sb.append("......enabled=").append(this.getHeartbeats().isEnabled()).append("\n");
        sb.append("......interval=").append(this.getHeartbeats().getInterval()).append("\n");
        sb.append("......collectIndividualThreadStats=").append(this.getHeartbeats().isCollectIndividualThreadStats()).append("\n");
        sb.append("......collectNonZGStats=").append(this.getHeartbeats().isCollectNonZGStats()).append("\n");
        sb.append("......collectPoolStats=").append(this.getHeartbeats().isCollectPoolStats()).append("\n");
        sb.append("......collectAllPoolStats=").append(this.getHeartbeats().isCollectAllPoolStats()).append("\n");
        sb.append("......collectSeriesStats=").append(this.getHeartbeats().isCollectSeriesStats()).append("\n");
        sb.append("......collectSeriesDatapoints=").append(this.getHeartbeats().isCollectSeriesDatapoints()).append("\n");
        sb.append("......inactiveMessageTypeStatsInclusionFrequency=").append(this.getHeartbeats().getInactiveMessageTypeStatsInclusionFrequency()).append("\n");
        sb.append("......includeMessageTypeStats=").append(this.getHeartbeats().isIncludeMessageTypeStats()).append("\n");
        sb.append("......maxTrackableSeriesValue=").append(this.getHeartbeats().getMaxTrackableSeriesValue()).append("\n");
        sb.append("......poolDepletionThreshold=").append(this.getHeartbeats().getPoolDepletionThreshold()).append("%").append("\n");
        sb.append("......tracing {\n");
        sb.append(".........enabled=").append(this.getHeartbeatTracing().isEnabled()).append("\n");
        sb.append(".........traceAppStats=").append(this.getHeartbeatTracing().isTraceAppStats()).append("\n");
        sb.append(".........tracePoolStats=").append(this.getHeartbeatTracing().isTracePoolStats()).append("\n");
        sb.append(".........traceSysStats=").append(this.getHeartbeatTracing().isTraceSysStats()).append("\n");
        sb.append(".........traceThreadStats=").append(this.getHeartbeatTracing().isTraceThreadStats()).append("\n");
        sb.append(".........traceUserStats=").append(this.getHeartbeatTracing().isTraceUserStats()).append("\n");
        sb.append("......}\n");
        sb.append("......logging {\n");
        Properties properties = this.getHeartbeatLoggingProperties();
        if (properties != null) {
            for (String name : properties.stringPropertyNames()) {
                sb.append(".........").append(name).append("=").append(properties.getProperty(name)).append("\n");
            }
        }
        sb.append("......}\n");
        sb.append("...}\n");
        this.getAdmin().dump("...", sb);
        sb.append("\n");
        sb.append("...maxOnDemandThreadCount=").append(this.getMaxOnDemandThreadCount()).append("\n");
        sb.append("...maxTraceHistory=").append(this.getMaxTraceHistory()).append("\n");
        sb.append("...multithreaded=").append(this.isMultiThreaded()).append("\n");
        sb.append("...version=").append(this.getVersion()).append("\n");
        sb.append("...}\n");
        sb.append("}");
        return sb.toString();
    }

    public static SrvConfigDescriptor create(String name) {
        return new SrvConfigDescriptor(name);
    }

    public static SrvConfigDescriptor createFromEnvironment() {
        return SrvConfigDescriptor.create((String)null).load(Config.getPropertiesCopy(), false);
    }

    public static SrvConfigDescriptor create(UtlAddressDescriptor descriptor) {
        SrvConfigDescriptor configDescriptor = SrvConfigDescriptor.create(descriptor.address);
        String appDescriptorsStr = UtlProps.getValue((Map)descriptor.props, (String)"apps", null);
        if (appDescriptorsStr != null) {
            descriptor.props.remove("apps");
            StringTokenizer tokenizer = new StringTokenizer(appDescriptorsStr, ",");
            if (tokenizer.hasMoreTokens()) {
                while (tokenizer.hasMoreTokens()) {
                    configDescriptor.addApp(SrvConfigAppDescriptor.create(UtlAddressDescriptor.parse((String)tokenizer.nextToken().trim(), null)));
                }
            }
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)descriptor.props);
        configDescriptor.load(props, true);
        return configDescriptor;
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("engine name cannot be null");
        }
        return repo.getComplexEntity("/servers/" + name) != null;
    }

    public static boolean exists(String name) {
        return SrvConfigDescriptor.exists(Config.getRepository(), name);
    }

    public static SrvConfigDescriptor load(IConfigRepository repo, String name) throws ESrvConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("server name cannot be null");
        }
        IConfigComplexEntity entity = repo.getComplexEntity("/servers/" + name);
        if (entity != null) {
            return SrvConfigDescriptor.create(name).load(entity.getProperties("server.properties"), false);
        }
        throw new ESrvConfigException("Server '" + name + "' not found in repository");
    }

    public static Set<SrvConfigDescriptor> loadAll(IConfigRepository repo) throws ESrvConfigException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<SrvConfigDescriptor> servers = new LinkedHashSet<SrvConfigDescriptor>();
        IConfigComplexEntityContainer container = repo.getComplexEntityContainer("/servers");
        if (container != null) {
            for (IConfigComplexEntity entity : container) {
                try {
                    servers.add(SrvConfigDescriptor.load(repo, entity.getName()));
                }
                catch (ESrvConfigException e) {
                    throw new ESrvConfigException("Failure in loading descriptor for server '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return servers;
    }

    public static SrvConfigDescriptor load(String name) throws ESrvConfigException {
        return SrvConfigDescriptor.load(Config.getRepository(), name);
    }

    public static Set<SrvConfigDescriptor> loadAll() throws ESrvConfigException {
        return SrvConfigDescriptor.loadAll(Config.getRepository());
    }

    private static String propName(String propname, boolean shortForm) {
        return shortForm ? propname : "nv.server." + propname;
    }

    public static final class Admin {
        private Sma sma = new Sma();
        private boolean passiveMonitoringOnly = false;

        public Sma getSma() {
            return this.sma;
        }

        public void setPassiveMonitoringOnly(boolean passiveMonitoringOnly) {
            this.passiveMonitoringOnly = passiveMonitoringOnly;
        }

        public boolean getPassiveMonitoringOnly() {
            return Config.getValue((String)"nv.server.admin.passivemonitoringonly", (boolean)this.passiveMonitoringOnly);
        }

        final void save(Properties props, boolean shortForm) {
            this.sma.save(props, shortForm);
            props.put(SrvConfigDescriptor.propName("admin.passiveMonitoringOnly", shortForm), String.valueOf(this.passiveMonitoringOnly));
        }

        final void load(Properties props, boolean shortForm) {
            this.sma.load(props, shortForm);
            String propname = SrvConfigDescriptor.propName("admin.passiveMonitoringOnly", shortForm);
            this.passiveMonitoringOnly = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.passiveMonitoringOnly);
            props.remove(propname);
        }

        public void dump(String prefix, StringBuilder sb) {
            sb.append(prefix).append("admin {\n");
            this.sma.dump(prefix + "...", sb);
            sb.append("\n");
            sb.append(prefix).append("}");
        }

        public static final class Sma {
            private Boolean enabled = null;
            private String busName;
            private final Channel requestChannel = new Channel("request", "xvm-request", true);
            private final Channel responseChannel = new Channel("response", "xvm-response", false);
            private final Channel heartbeatChannel = new Channel("heartbeat", "xvm-heartbeat", false);
            private final Channel traceChannel = new Channel("trace", "xvm-trace", false);
            private final Channel eventChannel = new Channel("event", "xvm-event", false);
            private final Map<String, Channel> adminChannels = new XLinkedHashMap();

            Sma() {
                if (Config.getValue((String)"nv.server.admin.transports") != null) {
                    LinkedHashSet<String> transports = new LinkedHashSet<String>(Arrays.asList(Config.getValue((String)"nv.server.admin.transports", (String)"direct").toLowerCase().split(",")));
                    this.enabled = transports.contains("sma");
                }
                this.adminChannels.put("request", this.requestChannel);
                this.adminChannels.put("response", this.responseChannel);
                this.adminChannels.put("heartbeat", this.heartbeatChannel);
                this.adminChannels.put("trace", this.traceChannel);
                this.adminChannels.put("event", this.eventChannel);
            }

            public final String getBusName() {
                return Config.getValue((String)"nv.server.admin.sma.bus.name", (String)(this.busName != null ? this.busName : "xvm-admin"));
            }

            public final void setBusName(String busName) {
                this.busName = busName;
            }

            public final boolean isEnabled() {
                return this.enabled == null ? false : this.enabled;
            }

            public final void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public final Collection<Channel> getAdminChannels() {
                return this.adminChannels.values();
            }

            public final Channel getAdminChannel(String name) {
                return this.adminChannels.get(name);
            }

            public final Channel getTraceChannel() {
                return this.traceChannel;
            }

            public final Channel getEventChannel() {
                return this.eventChannel;
            }

            public final Channel getHeartbeatChannel() {
                return this.heartbeatChannel;
            }

            public final Channel getRequestChannel() {
                return this.requestChannel;
            }

            public final Channel getResponseChannel() {
                return this.responseChannel;
            }

            void save(Properties props, boolean shortForm) {
                if (this.enabled != null) {
                    props.put(SrvConfigDescriptor.propName("admin.sma.enabled", shortForm), String.valueOf(this.enabled));
                }
                if (this.busName != null) {
                    props.put(SrvConfigDescriptor.propName("admin.sma.busName", shortForm), String.valueOf(this.busName));
                }
                this.traceChannel.save(props, shortForm);
                this.heartbeatChannel.save(props, shortForm);
                this.eventChannel.save(props, shortForm);
                this.requestChannel.save(props, shortForm);
                this.responseChannel.save(props, shortForm);
            }

            void load(Properties props, boolean shortForm) {
                String propname = SrvConfigDescriptor.propName("admin.sma.enabled", shortForm);
                if (props.containsKey(propname)) {
                    this.enabled = UtlProps.getValue((Properties)props, (String)propname, (boolean)(this.enabled == null ? false : this.enabled));
                    props.remove(propname);
                }
                propname = SrvConfigDescriptor.propName("admin.sma.busName", shortForm);
                this.setBusName(UtlProps.getValue((Properties)props, (String)propname, (String)this.busName));
                props.remove(propname);
                this.traceChannel.load(props, shortForm);
                this.heartbeatChannel.load(props, shortForm);
                this.eventChannel.load(props, shortForm);
                this.requestChannel.load(props, shortForm);
                this.responseChannel.load(props, shortForm);
            }

            public void dump(String prefix, StringBuilder sb) {
                sb.append(prefix).append("sma {").append("\n");
                sb.append(prefix).append("...").append("enabled=").append(this.isEnabled()).append("\n");
                if (this.isEnabled()) {
                    sb.append(prefix).append("...").append("busName=").append(this.getBusName()).append("\n");
                    sb.append(prefix).append("...").append("channels {").append("\n");
                    for (Channel channel : this.adminChannels.values()) {
                        channel.dump(prefix + "......", sb);
                        sb.append("\n");
                    }
                    sb.append(prefix).append("...").append("}").append("\n");
                }
                sb.append(prefix).append("}");
            }

            public static class Channel {
                private final String type;
                private String channelName;
                private boolean enabled = true;
                private boolean join = false;

                private Channel(String type, String channelName, boolean join) {
                    this.channelName = channelName;
                    this.type = type;
                    this.join = join;
                }

                public String getType() {
                    return this.type;
                }

                public boolean getJoin() {
                    return this.join;
                }

                public final boolean isEnabled() {
                    return this.enabled;
                }

                public final void setEnabled(boolean enabled) {
                    this.enabled = enabled;
                }

                public final String getChannelName() {
                    return this.channelName;
                }

                public final void setChannelName(String channelName) {
                    this.channelName = channelName;
                }

                final void save(Properties props, boolean shortForm) {
                    props.put(SrvConfigDescriptor.propName("admin.sma.channels." + this.type + ".enabled", shortForm), String.valueOf(this.enabled));
                    props.put(SrvConfigDescriptor.propName("admin.sma.channels." + this.type + ".channelName", shortForm), String.valueOf(this.channelName));
                    props.put(SrvConfigDescriptor.propName("admin.sma.channels." + this.type + ".join", shortForm), String.valueOf(this.join));
                }

                final void load(Properties props, boolean shortForm) {
                    String propname = SrvConfigDescriptor.propName("admin.sma.channels." + this.type + ".enabled", shortForm);
                    this.enabled = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
                    props.remove(propname);
                    propname = SrvConfigDescriptor.propName("admin.sma.channels." + this.type + ".channelName", shortForm);
                    this.channelName = UtlProps.getValue((Properties)props, (String)propname, (String)this.channelName);
                    props.remove(propname);
                    propname = SrvConfigDescriptor.propName("admin.sma.channels." + this.type + ".join", shortForm);
                    this.join = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.join);
                    props.remove(propname);
                }

                public void dump(String prefix, StringBuilder sb) {
                    sb.append(prefix).append(this.channelName).append(" {\n");
                    sb.append(prefix).append("...").append("enabled=").append(this.enabled).append(" {\n");
                    sb.append(prefix).append("...").append("join=").append(this.join).append("\n");
                    sb.append(prefix).append("...").append("type=").append(this.type).append("\n");
                    sb.append(prefix).append("}");
                }
            }
        }
    }

    public static final class HeartbeatTracing {
        private boolean enabled;
        private boolean traceAdminClientStats = true;
        private boolean traceAppStats = true;
        private boolean tracePoolStats = true;
        private boolean traceSysStats = true;
        private boolean traceThreadStats = true;
        private boolean traceUserStats = true;

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public final boolean isTraceAdminClientStats() {
            return this.traceAdminClientStats;
        }

        public final void setTraceAdminClientStats(boolean enabled) {
            this.traceAdminClientStats = enabled;
        }

        public final boolean isTraceAppStats() {
            return this.traceAppStats;
        }

        public final void setTraceAppStats(boolean enabled) {
            this.traceAppStats = enabled;
        }

        public final boolean isTracePoolStats() {
            return this.tracePoolStats;
        }

        public final void setTracePoolStats(boolean enabled) {
            this.tracePoolStats = enabled;
        }

        public final boolean isTraceSysStats() {
            return this.traceSysStats;
        }

        public final void setTraceSysStats(boolean enabled) {
            this.traceSysStats = enabled;
        }

        public final boolean isTraceThreadStats() {
            return this.traceThreadStats;
        }

        public final void setTraceThreadStats(boolean enabled) {
            this.traceThreadStats = enabled;
        }

        public final boolean isTraceUserStats() {
            return this.traceUserStats;
        }

        public final void setTraceUserStats(boolean enabled) {
            this.traceUserStats = enabled;
        }

        public void save(Properties props, boolean shortForm) {
            props.put(SrvConfigDescriptor.propName("heartbeats.tracing.enabled", shortForm), String.valueOf(this.enabled));
            props.put(SrvConfigDescriptor.propName("heartbeats.tracing.traceAdminClientStats", shortForm), String.valueOf(this.traceAdminClientStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.tracing.traceAppStats", shortForm), String.valueOf(this.traceAppStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.tracing.tracePoolStats", shortForm), String.valueOf(this.tracePoolStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.tracing.traceSysStats", shortForm), String.valueOf(this.traceSysStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.tracing.traceThreadStats", shortForm), String.valueOf(this.traceThreadStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.tracing.traceUserStats", shortForm), String.valueOf(this.traceUserStats));
        }

        public void load(Properties props, boolean shortForm) {
            String propname = SrvConfigDescriptor.propName("heartbeats.tracing.enabled", shortForm);
            this.enabled = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.tracing.traceAdminClientStats", shortForm);
            this.traceAdminClientStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.tracing.traceAppStats", shortForm);
            this.traceAppStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.tracing.tracePoolStats", shortForm);
            this.tracePoolStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.tracing.traceSysStats", shortForm);
            this.traceSysStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.tracing.traceThreadStats", shortForm);
            this.traceThreadStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.tracing.traceUserStats", shortForm);
            this.traceUserStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
            props.remove(propname);
        }
    }

    public static final class Heartbeats {
        private boolean enabled = false;
        private long interval = 30L;
        private boolean collectSeriesStats = true;
        private boolean collectSeriesDatapoints = false;
        private boolean collectPoolStats = true;
        private boolean collectAllPoolStats = false;
        private boolean collectIndividualThreadStats = true;
        private int maxTrackableSeriesValue = (int)TimeUnit.MINUTES.toMicros(10L);
        private float poolDepletionThreshold = 1.0f;
        private boolean collectNonZGStats = true;
        private boolean includeMessageTypeStats = false;
        private int inactiveMessageTypeStatsInclusionFrequency = 1;
        private final HeartbeatTracing tracing = new HeartbeatTracing();
        private Properties logging = new Properties();

        private Heartbeats() {
        }

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public final void setInterval(long interval) {
            this.interval = interval;
        }

        public final long getInterval() {
            return (long)Math.ceil(Double.valueOf(this.interval * 1000L) / 1000.0);
        }

        public final boolean isCollectSeriesStats() {
            return this.collectSeriesStats;
        }

        public final void setCollectSeriesStats(boolean collectSeriesStats) {
            this.collectSeriesStats = collectSeriesStats;
        }

        public final boolean isCollectSeriesDatapoints() {
            return this.collectSeriesDatapoints;
        }

        public final void setCollectSeriesDatapoints(boolean collectSeriesDatapoints) {
            this.collectSeriesDatapoints = collectSeriesDatapoints;
        }

        public final int getMaxTrackableSeriesValue() {
            return this.maxTrackableSeriesValue;
        }

        public final void setMaxTrackableSeriesValue(int maxTrackableSeriesValue) {
            this.maxTrackableSeriesValue = maxTrackableSeriesValue;
        }

        public final float getPoolDepletionThreshold() {
            return this.poolDepletionThreshold;
        }

        public final void setPoolDepletionThreshold(float poolDepletionThreshold) {
            this.poolDepletionThreshold = poolDepletionThreshold;
        }

        public final boolean isCollectPoolStats() {
            return this.collectPoolStats;
        }

        public final void setCollectPoolStats(boolean collectPoolStats) {
            this.collectPoolStats = collectPoolStats;
        }

        public final void setCollectAllPoolStats(boolean val) {
            this.collectAllPoolStats = val;
        }

        public final boolean isCollectAllPoolStats() {
            return this.collectAllPoolStats;
        }

        public final boolean isCollectIndividualThreadStats() {
            return this.collectIndividualThreadStats;
        }

        public final void setCollectIndividualThreadStats(boolean collectIndividualThreadStats) {
            this.collectIndividualThreadStats = collectIndividualThreadStats;
        }

        public boolean isCollectNonZGStats() {
            return this.collectNonZGStats;
        }

        public void setCollectNonZGStats(boolean collectNonZGStats) {
            this.collectNonZGStats = collectNonZGStats;
        }

        public boolean isIncludeMessageTypeStats() {
            return this.includeMessageTypeStats;
        }

        public void setIncludeMessageTypeStats(boolean includeMessageTypeStats) {
            this.includeMessageTypeStats = includeMessageTypeStats;
        }

        public void setInactiveMessageTypeStatsInclusionFrequency(int inactiveMessageTypeStatsInclusionFrequency) {
            this.inactiveMessageTypeStatsInclusionFrequency = inactiveMessageTypeStatsInclusionFrequency;
        }

        public int getInactiveMessageTypeStatsInclusionFrequency() {
            return this.inactiveMessageTypeStatsInclusionFrequency;
        }

        public HeartbeatTracing getTracing() {
            return this.tracing;
        }

        public Properties getLogging() {
            return this.logging;
        }

        public void save(Properties props, boolean shortForm) {
            props.put(SrvConfigDescriptor.propName("heartbeats.enabled", shortForm), String.valueOf(this.enabled));
            props.put(SrvConfigDescriptor.propName("heartbeats.interval", shortForm), String.valueOf(this.interval));
            props.put(SrvConfigDescriptor.propName("heartbeats.collectSeriesStats", shortForm), String.valueOf(this.collectSeriesStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.collectSeriesDatapoints", shortForm), String.valueOf(this.collectSeriesDatapoints));
            props.put(SrvConfigDescriptor.propName("heartbeats.maxTrackableSeriesValue", shortForm), String.valueOf(this.maxTrackableSeriesValue));
            props.put(SrvConfigDescriptor.propName("heartbeats.poolDepletionThreshold", shortForm), String.valueOf(this.poolDepletionThreshold));
            props.put(SrvConfigDescriptor.propName("heartbeats.collectPoolStats", shortForm), String.valueOf(this.collectPoolStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.collectAllPoolStats", shortForm), String.valueOf(this.collectAllPoolStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.collectIndividualThreadStats", shortForm), String.valueOf(this.collectIndividualThreadStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.collectNonZGStats", shortForm), String.valueOf(this.collectNonZGStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.includeMessageTypeStats", shortForm), String.valueOf(this.includeMessageTypeStats));
            props.put(SrvConfigDescriptor.propName("heartbeats.inactiveMessageTypeStatsInclusionFrequency", shortForm), String.valueOf(this.inactiveMessageTypeStatsInclusionFrequency));
            this.tracing.save(props, shortForm);
            StringWriter writer = new StringWriter();
            try {
                this.logging.store(writer, null);
                props.setProperty(SrvConfigDescriptor.propName("heartbeatLoggingProperties", shortForm), writer.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Error setting heartbeat logging properties: " + e.getMessage(), e);
            }
        }

        public void load(Properties props, boolean shortForm) {
            String propname = SrvConfigDescriptor.propName("heartbeats.enabled", shortForm);
            this.enabled = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.enabled);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.interval", shortForm);
            this.interval = UtlProps.getValue((Properties)props, (String)propname, (long)this.interval);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.collectSeriesStats", shortForm);
            this.collectSeriesStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.collectSeriesStats);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.collectSeriesDatapoints", shortForm);
            this.collectSeriesDatapoints = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.collectSeriesDatapoints);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.maxTrackableSeriesValue", shortForm);
            this.maxTrackableSeriesValue = UtlProps.getValue((Properties)props, (String)propname, (int)this.maxTrackableSeriesValue);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.poolDepletionThreshold", shortForm);
            this.poolDepletionThreshold = UtlProps.getValue((Properties)props, (String)propname, (float)this.poolDepletionThreshold);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.collectPoolStats", shortForm);
            this.collectPoolStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.collectPoolStats);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.collectAllPoolStats", shortForm);
            this.collectAllPoolStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.collectAllPoolStats);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.collectIndividualThreadStats", shortForm);
            this.collectIndividualThreadStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.collectIndividualThreadStats);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.collectNonZGStats", shortForm);
            this.collectNonZGStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.collectNonZGStats);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.includeMessageTypeStats", shortForm);
            this.includeMessageTypeStats = UtlProps.getValue((Properties)props, (String)propname, (boolean)this.includeMessageTypeStats);
            props.remove(propname);
            propname = SrvConfigDescriptor.propName("heartbeats.inactiveMessageTypeStatsInclusionFrequency", shortForm);
            this.inactiveMessageTypeStatsInclusionFrequency = UtlProps.getValue((Properties)props, (String)propname, (int)this.inactiveMessageTypeStatsInclusionFrequency);
            props.remove(propname);
            this.tracing.load(props, shortForm);
            propname = SrvConfigDescriptor.propName("heartbeatLoggingProperties", shortForm);
            if (UtlProps.getValue((Properties)props, (String)propname) != null) {
                this.logging = new Properties();
                try {
                    this.logging.load(new StringReader(UtlProps.getValue((Properties)props, (String)SrvConfigDescriptor.propName("heartbeatLoggingProperties", shortForm))));
                }
                catch (IOException e) {
                    throw new RuntimeException("Failure to load heartbeat properties: " + e.getMessage(), e);
                }
                props.remove(SrvConfigDescriptor.propName("heartbeatLoggingProperties", shortForm));
            } else {
                this.logging.clear();
            }
        }
    }
}

