/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin;

import com.neeve.config.Config;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.server.admin.AdminObject;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionProvider;
import com.neeve.server.admin.AdminSessionProviderRegistry;
import com.neeve.server.admin.EAdminException;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.SmaException;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

public class AdminSessionFactory
extends AdminObject {
    private static final AdminSessionFactory defaultInstance = new AdminSessionFactory();

    private AdminSessionFactory() {
    }

    public static final AdminSessionFactory getDefaultInstance() {
        return defaultInstance;
    }

    public static MessageBusDescriptor loadAdminBusDescriptor(Properties adminConfigProps) throws EAdminException {
        String busName = UtlProps.getValue((Properties)adminConfigProps, (String)"nv.server.admin.sma.bus.name", (String)"xvm-admin");
        String busDescriptorStr = UtlProps.getValue((Properties)adminConfigProps, (String)"nv.server.admin.sma.bus.descriptor", null);
        String busProvider = UtlProps.getValue((Properties)adminConfigProps, (String)"nv.server.admin.sma.bus.provider", null);
        String busAddress = UtlProps.getValue((Properties)adminConfigProps, (String)"nv.server.admin.sma.bus.address", null);
        String busPort = UtlProps.getValue((Properties)adminConfigProps, (String)"nv.server.admin.sma.bus.port", null);
        HashMap busProps = (HashMap)UtlProps.getSubProps((Properties)adminConfigProps, (String)"nv.server.admin.sma.bus.properties.", (boolean)true, new HashMap());
        MessageBusDescriptor adminOverSmaBusDescriptor = null;
        if (!MessageBusDescriptor.exists((String)busName)) {
            UtlAddressDescriptor busAddressDescriptor = null;
            if (busDescriptorStr == null) {
                if (busProvider == null) {
                    throw new EAdminException("No admin bus named '" + busName + "' configured and neither '" + "nv.server.admin.sma.bus.descriptor" + "' nor '" + "nv.server.admin.sma.bus.provider" + "' has been configured!");
                }
                if (busAddress == null) {
                    throw new EAdminException("No admin bus named '" + busName + "' configured and neither '" + "nv.server.admin.sma.bus.descriptor" + "' nor '" + "nv.server.admin.sma.bus.address" + "' has been configured!");
                }
                busAddressDescriptor = UtlAddressDescriptor.parse((String)(busProvider + "://" + busAddress + (busPort != null ? ":" + busPort : "")), (HashMap)busProps);
            } else {
                busAddressDescriptor = UtlAddressDescriptor.parse((String)busDescriptorStr, null);
                if (busProvider != null && !busProvider.equals(busAddressDescriptor.type)) {
                    throw new EAdminException("No admin bus named '" + busName + "' configured and both '" + "nv.server.admin.sma.bus.descriptor" + "' and '" + "nv.server.admin.sma.bus.provider" + "' are specified and conflict (" + busAddressDescriptor.type + " != " + busProvider + ")!");
                }
                if (busAddress != null && !busAddress.equals(busAddressDescriptor.address)) {
                    throw new EAdminException("No admin bus named '" + busName + "' configured and both '" + "nv.server.admin.sma.bus.descriptor" + "' and '" + "nv.server.admin.sma.bus.address" + "' are specified and conflict (" + busAddressDescriptor.address + " != " + busAddress + ")!");
                }
            }
            if (busAddressDescriptor != null) {
                adminOverSmaBusDescriptor = MessageBusDescriptor.create((String)busName);
                try {
                    adminOverSmaBusDescriptor.setProviderConfig(busAddressDescriptor.toFullString());
                }
                catch (Exception e) {
                    throw new EAdminException("Error configuring admin bus: " + e.getMessage(), e);
                }
            }
        } else {
            try {
                adminOverSmaBusDescriptor = MessageBusDescriptor.load((String)busName);
            }
            catch (SmaException e) {
                throw new EAdminException("Error loading admin bus '" + busName);
            }
        }
        String adminChanelPrefix = Config.getValue((String)"nv.server.admin.sma.channelkeyprefix", (String)"xvm-admin").trim();
        if (adminChanelPrefix.length() > 0) {
            adminChanelPrefix = adminChanelPrefix + "/";
        }
        MessageChannelDescriptor requestChannelDescriptor = MessageChannelDescriptor.create((String)"xvm-request", (MessageBusDescriptor)adminOverSmaBusDescriptor);
        requestChannelDescriptor.setChannelId(Config.getValue((String)"nv.server.admin.sma.requestchanneid", (short)30000));
        requestChannelDescriptor.setChannelKey(adminChanelPrefix + Config.getValue((String)"nv.server.admin.sma.requestchannelkey", (String)"${xvmName}/request"));
        requestChannelDescriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        adminOverSmaBusDescriptor.addChannel(requestChannelDescriptor);
        MessageChannelDescriptor responseChannelDescriptor = MessageChannelDescriptor.create((String)"xvm-response", (MessageBusDescriptor)adminOverSmaBusDescriptor);
        responseChannelDescriptor.setChannelId(Config.getValue((String)"nv.server.admin.sma.responsechannelid", (short)30001));
        responseChannelDescriptor.setChannelKey(adminChanelPrefix + Config.getValue((String)"nv.server.admin.sma.responsechannelkey", (String)"${adminClientId}/response"));
        responseChannelDescriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        adminOverSmaBusDescriptor.addChannel(responseChannelDescriptor);
        MessageChannelDescriptor heartbeatChannelDescriptor = MessageChannelDescriptor.create((String)"xvm-heartbeat", (MessageBusDescriptor)adminOverSmaBusDescriptor);
        heartbeatChannelDescriptor.setChannelId(Config.getValue((String)"nv.server.admin.sma.heartbeatchannelid", (short)30002));
        heartbeatChannelDescriptor.setChannelKey(adminChanelPrefix + Config.getValue((String)"nv.server.admin.sma.heartbeatchannelkey", (String)"${xvmName}/heartbeat"));
        heartbeatChannelDescriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        adminOverSmaBusDescriptor.addChannel(heartbeatChannelDescriptor);
        MessageChannelDescriptor traceChannelDescriptor = MessageChannelDescriptor.create((String)"xvm-trace", (MessageBusDescriptor)adminOverSmaBusDescriptor);
        traceChannelDescriptor.setChannelId(Config.getValue((String)"nv.server.admin.sma.tracechannelid", (short)30003));
        traceChannelDescriptor.setChannelKey(adminChanelPrefix + Config.getValue((String)"nv.server.admin.sma.tracechannelkey", (String)"${xvmName}/trace"));
        traceChannelDescriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        adminOverSmaBusDescriptor.addChannel(traceChannelDescriptor);
        MessageChannelDescriptor eventChannelDescriptor = MessageChannelDescriptor.create((String)"xvm-event", (MessageBusDescriptor)adminOverSmaBusDescriptor);
        eventChannelDescriptor.setChannelId(Config.getValue((String)"nv.server.admin.sma.eventchannelid", (short)30004));
        eventChannelDescriptor.setChannelKey(adminChanelPrefix + Config.getValue((String)"nv.server.admin.sma.eventchannelkey", (String)"${xvmName}/event"));
        eventChannelDescriptor.setChannelQos(MessageChannel.Qos.BestEffort);
        adminOverSmaBusDescriptor.addChannel(eventChannelDescriptor);
        return adminOverSmaBusDescriptor;
    }

    public AdminSession createAdminClientSession(String adminClientId, String xvmName, AdminSession.EventHandler eventHandler, IDiscoveryCache discoveryCache, Tracer tracer, Properties sessionProps) throws EAdminException {
        IDiscoveryEntity xvmEntity;
        if (discoveryCache == null) {
            discoveryCache = DiscoveryCacheFactory.getInstance().getDefaultCache();
        }
        if ((xvmEntity = discoveryCache.get("Server", xvmName)) == null) {
            throw new EAdminException("XVM '" + xvmName + "' not discovered");
        }
        return this.createAdminClientSession(adminClientId, xvmName, eventHandler, xvmEntity, tracer, sessionProps);
    }

    public AdminSession createAdminClientSession(String adminClientId, String xvmName, AdminSession.EventHandler eventHandler, IDiscoveryEntity discoveredXvm, Tracer tracer, Properties sessionProps) throws EAdminException {
        String transportsList;
        List<String> transports;
        if (sessionProps == null) {
            sessionProps = new Properties();
        }
        if ((transports = Arrays.asList((transportsList = UtlProps.getValue((Properties)sessionProps, (String)"nv.server.admin.transports", (String)Config.getValue((String)"nv.server.admin.transports", (String)"direct")).trim().toLowerCase()).split(","))).isEmpty()) {
            throw new EAdminException("No admin transports configured");
        }
        if (transports.size() > 1) {
            throw new EAdminException("Only a single admin transport is currently supported for client connections, but multiple transports are configured: " + transportsList);
        }
        AdminSessionProvider provider = AdminSessionProviderRegistry.getInstance().getProvider(transports.get(0).trim());
        if (tracer != null && tracer.fine) {
            tracer.log("Creating " + provider.getName() + " admin session for '" + xvmName + "'", Tracer.Level.FINE);
        }
        return provider.create(adminClientId, xvmName, discoveredXvm, eventHandler, sessionProps, tracer);
    }
}

