/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.clock.impl;

import java.util.logging.Logger;
import vanilla.java.clock.IClock;

public final class JNIClock
extends Enum<JNIClock>
implements IClock {
    public static final /* enum */ JNIClock INSTANCE;
    private static final Logger LOGGER;
    public static final boolean LOADED;
    private static final int FACTOR_BITS = 17;
    private static long RDTSC_FACTOR;
    private static long CPU_FREQUENCY;
    private static final long START;
    private static final /* synthetic */ JNIClock[] $VALUES;

    public static JNIClock[] values() {
        return (JNIClock[])$VALUES.clone();
    }

    public static JNIClock valueOf(String name) {
        return Enum.valueOf(JNIClock.class, name);
    }

    @Override
    public long nanoTime() {
        return JNIClock.tscToNano(JNIClock.rdtsc0() - START);
    }

    static long tscToNano(long tsc) {
        return tsc * RDTSC_FACTOR >> 17;
    }

    private static void estimateFrequency(int factor) {
        long now;
        long start = System.nanoTime();
        while ((now = System.nanoTime()) == start) {
        }
        long end = start + (long)(factor * 1000000);
        long start0 = JNIClock.rdtsc0();
        while ((now = System.nanoTime()) < end) {
        }
        long end0 = JNIClock.rdtsc0();
        end = now;
        RDTSC_FACTOR = (end - start << 17) / (end0 - start0) - 1L;
        CPU_FREQUENCY = (end0 - start0 + 1L) * 1000L / (end - start);
    }

    static native long rdtsc0();

    static {
        boolean loaded;
        long start;
        INSTANCE = new JNIClock();
        $VALUES = new JNIClock[]{INSTANCE};
        LOGGER = Logger.getLogger(JNIClock.class.getName());
        RDTSC_FACTOR = 131072L;
        CPU_FREQUENCY = 1000L;
        try {
            System.loadLibrary("affinity");
            JNIClock.estimateFrequency(50);
            JNIClock.estimateFrequency(200);
            LOGGER.info("Estimated clock frequency was " + CPU_FREQUENCY + " MHz");
            start = JNIClock.rdtsc0();
            loaded = true;
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.fine("Unable to find libaffinity in [" + System.getProperty("java.library.path") + "] " + ule);
            start = 0L;
            loaded = false;
        }
        LOADED = loaded;
        START = start;
    }
}

