/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.busywaiting.impl;

import java.lang.reflect.Field;
import sun.misc.Unsafe;
import vanilla.java.busywaiting.IBusyWaiter;

public enum JavaBusyWaiting implements IBusyWaiter
{
    INSTANCE;

    static final Unsafe UNSAFE;

    @Override
    public void pause() {
        Thread.yield();
    }

    @Override
    public long whileEqual(Object obj, long address, int iterations, long value) {
        long value2 = UNSAFE.getLongVolatile(null, address);
        while (value2 == value && iterations-- > 0) {
            this.pause();
            value2 = UNSAFE.getLongVolatile(obj, address);
        }
        return value2;
    }

    @Override
    public long whileLessThan(Object obj, long address, int iterations, long value) {
        long value2 = UNSAFE.getLongVolatile(null, address);
        while (value2 < value && iterations-- > 0) {
            this.pause();
            value2 = UNSAFE.getLongVolatile(obj, address);
        }
        return value2;
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

