/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import com.neeve.rog.IRogMessage;
import java.util.Properties;

public final class AepScheduleEvent
extends Event {
    private long id;
    private IRogMessage message;
    private Object object;
    private boolean repeating;
    private HAPolicy haPolicy;
    private long createTime;
    private Event schedulingEvent;
    private State state;

    private AepScheduleEvent() {
        super((short)524);
    }

    public static Event create(Properties props) {
        return new AepScheduleEvent();
    }

    static AepScheduleEvent create(long id, IRogMessage message, int delay, HAPolicy haPolicy) {
        return ((AepScheduleEvent)EventFactory.getInstance().createEvent((short)524)).init(id, message, null, false, delay, haPolicy);
    }

    static AepScheduleEvent create(long id, Object object, int interval, HAPolicy haPolicy) {
        return ((AepScheduleEvent)EventFactory.getInstance().createEvent((short)524)).init(id, null, object, interval > 0, interval, haPolicy);
    }

    private final AepScheduleEvent init(long id, IRogMessage message, Object object, boolean repeating, int delayOrInterval, HAPolicy haPolicy) {
        super.init(null, null);
        this.id = id;
        this.message = message;
        this.object = object;
        this.repeating = repeating;
        this.setDelay(delayOrInterval);
        this.haPolicy = haPolicy;
        this.createTime = System.currentTimeMillis();
        this.state = State.NotActivated;
        return this;
    }

    protected final void reset() {
        this.id = 0L;
        this.message = null;
        this.object = null;
        this.repeating = false;
        this.haPolicy = null;
        this.createTime = 0L;
        this.schedulingEvent = null;
        this.state = null;
    }

    protected final void preDispose() {
        if (this.message != null) {
            this.message.dispose();
        }
        if (this.schedulingEvent != null) {
            this.schedulingEvent.dispose();
        }
    }

    public final long getId() {
        return this.id;
    }

    final AepScheduleEvent setState(State state) {
        this.state = state;
        return this;
    }

    public final State getState() {
        return this.state;
    }

    final void setInternalSchedulingEvent(Event event) {
        if (this.schedulingEvent != null) {
            this.schedulingEvent.dispose();
        }
        this.schedulingEvent = event;
    }

    final Event getInternalSchedulingEvent() {
        return this.schedulingEvent;
    }

    public final IRogMessage getMessage() {
        return this.message;
    }

    public final Object getObject() {
        return this.object;
    }

    public final boolean isRepeating() {
        return this.repeating;
    }

    public final HAPolicy getHAPolicy() {
        return this.haPolicy;
    }

    public final long getCreateTime() {
        return this.createTime;
    }

    public String toString() {
        return "[event=SCHEDULE, " + super.toString() + ", id=" + this.id + ", repeating=" + this.repeating + ", haPolicy=" + (Object)((Object)this.haPolicy) + ", message=" + (this.message != null ? this.message.getClass().getSimpleName() : "null") + ", object=" + (this.object != null ? this.object.getClass().getSimpleName() : "null") + ", state=" + (Object)((Object)this.state) + ", createTime=" + this.createTime + "]";
    }

    public static enum HAPolicy {
        Cancel,
        Reactivate,
        Resume;

    }

    public static enum State {
        NotActivated,
        Activated,
        Cancelling,
        Cancelled;

    }
}

