/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepFlow;
import com.neeve.aep.AepObject;
import com.neeve.aep.IAepApplicationStateFactory;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepClientConnectedEvent;
import com.neeve.aep.event.AepClientDisconnectedEvent;
import com.neeve.event.Event;
import com.neeve.event.IEvent;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventSource;
import com.neeve.event.alert.AlertEvent;
import com.neeve.event.alert.IAlertEvent;
import com.neeve.event.lifecycle.ILifecycleEvent;
import com.neeve.event.lifecycle.LifecycleEvent;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.sma.event.MessageBusBindingEvent;
import com.neeve.sma.event.MessageChannelEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlReflection;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class AepEventDispatcher
extends AepObject
implements IEventHandler {
    private final Set<Object> eventHandlerContainers;
    private final ConcurrentHashMap<String, MessageChannel> clients;
    private final Map<Class<?>, UtlList> eventHandlersWithoutRepository;
    private final Map<Class<?>, UtlList> eventHandlersWithRepository;
    private final Map<Class<?>, Class<?>[]> classInterfaces;
    private final IEventHandler defaultEventHandler;
    private final Tracer tracer;
    private DefaultHandlerDispatchPolicy defaultHandlerDispatchPolicy;

    private AepEventDispatcher(AepEngine engine, Tracer tracer, Set<Object> eventHandlerContainers, IEventHandler defaultEventHandler, Object repository) {
        this.eventHandlerContainers = eventHandlerContainers;
        this.clients = new ConcurrentHashMap();
        this.eventHandlersWithoutRepository = new HashMap();
        this.eventHandlersWithRepository = new HashMap();
        this.classInterfaces = new HashMap();
        this.defaultEventHandler = defaultEventHandler;
        this.defaultHandlerDispatchPolicy = DefaultHandlerDispatchPolicy.DispatchIfNoAnnotatedHandlers;
        this.tracer = tracer == null ? Tracer.get((String)"nv.aep.dispatcher") : tracer;
        this.prepareEventHandlerTable(eventHandlerContainers, repository, engine);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final AepEventDispatcher create(Set<Object> eventHandlerContainers, IEventHandler defaultEventHandler, IAepApplicationStateFactory stateFactory) {
        if (eventHandlerContainers == null) {
            throw new IllegalArgumentException("event handler container set cannot be null");
        }
        if (stateFactory == null) return new AepEventDispatcher(null, null, eventHandlerContainers, defaultEventHandler, null);
        try {
            IRogNode repository = stateFactory.createState(null);
            try {
                if (repository == null) throw new IllegalArgumentException("repository factory instantiated a null repository!");
                AepEventDispatcher aepEventDispatcher = new AepEventDispatcher(null, null, eventHandlerContainers, defaultEventHandler, repository);
                return aepEventDispatcher;
            }
            finally {
                repository.dispose();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static final AepEventDispatcher create(AepEngine engine, Tracer tracer, Set<Object> eventHandlerContainers, IEventHandler defaultEventHandler, IAepApplicationStateFactory stateFactory) {
        if (eventHandlerContainers == null) {
            throw new IllegalArgumentException("event handler container set cannot be null");
        }
        if (stateFactory != null) {
            try {
                IRogNode repository = stateFactory.createState(null);
                if (repository != null) {
                    return new AepEventDispatcher(engine, tracer, eventHandlerContainers, defaultEventHandler, repository);
                }
                throw new IllegalArgumentException("repository factory instantiated a null repository!");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return new AepEventDispatcher(engine, tracer, eventHandlerContainers, defaultEventHandler, null);
    }

    public static final AepEventDispatcher create(Set<Object> eventHandlerContainers, IEventHandler defaultEventHandler) {
        return AepEventDispatcher.create(eventHandlerContainers, defaultEventHandler, null);
    }

    private final void prepareEventHandlerTable(Set<Object> eventHandlerContainers, Object repository, AepEngine engine) {
        for (Object eventHandlerContainer : eventHandlerContainers) {
            if (eventHandlerContainer == null) {
                throw new IllegalArgumentException("null event handler container supplied to event dispatcher in the event handler container set!");
            }
            Class<?> clazz = eventHandlerContainer.getClass();
            if (this.tracer.debug) {
                this.tracer.log("Introspecting '" + clazz.getName() + "' for @EvenHandler annotated methods...", Tracer.Level.DEBUG);
            }
            ArrayList<Method> methodList = new ArrayList<Method>();
            methodList.addAll(Arrays.asList(clazz.getMethods()));
            UtlReflection.collectNonPublicMethods(clazz, methodList);
            Method[] methods = methodList.toArray(new Method[0]);
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] paramTypes;
                if (!methods[i].isAnnotationPresent(EventHandler.class)) continue;
                if (this.tracer.debug) {
                    this.tracer.log("...found method=" + methods[i], Tracer.Level.DEBUG);
                }
                if ((paramTypes = methods[i].getParameterTypes()).length == 1 || repository != null && paramTypes.length == 2 && paramTypes[1] == repository.getClass()) {
                    Map<Class<?>, UtlList> eventHandlerTable = paramTypes.length == 1 ? this.eventHandlersWithoutRepository : this.eventHandlersWithRepository;
                    UtlList eventHandlerList = eventHandlerTable.get(paramTypes[0]);
                    if (!methods[i].isAccessible()) {
                        try {
                            methods[i].setAccessible(true);
                        }
                        catch (SecurityException se) {
                            this.tracer.log("Event handler method '" + methods[i].toString() + " declared in " + clazz.getCanonicalName() + " is not accessible.", Tracer.Level.WARNING);
                        }
                        if (this.tracer.debug) {
                            this.tracer.log("......Event handler method '" + methods[i].toString() + " declared in " + clazz.getCanonicalName() + " was made accessible.", Tracer.Level.DEBUG);
                        }
                    }
                    if (eventHandlerList == null) {
                        eventHandlerList = UtlList.create();
                        eventHandlerTable.put(paramTypes[0], eventHandlerList);
                    }
                    Handler eventHandler = new Handler(eventHandlerContainer, methods[i]);
                    eventHandlerList.append((UtlListElement)eventHandler);
                    if (!this.tracer.debug) continue;
                    this.tracer.log("......added (subsource=" + eventHandler.subsourceName + ", source=" + eventHandler.sourceName + ")", Tracer.Level.DEBUG);
                    continue;
                }
                if (this.tracer.debug) {
                    this.tracer.log("......ignored (repository=" + (repository == null ? repository : repository.getClass().getCanonicalName()) + ")", Tracer.Level.DEBUG);
                }
                if (paramTypes.length == 0) {
                    this.tracer.log("Ignoring EventHandler '" + methods[i].toString() + "' ... too few method parameters", Tracer.Level.WARNING);
                    continue;
                }
                if (paramTypes.length == 2) {
                    if (repository == null) {
                        if (engine == null) continue;
                        if (engine.getHAPolicy() == AepEngine.HAPolicy.StateReplication) {
                            this.tracer.log("Ignoring EventHandler '" + methods[i].toString() + "' ... (application did not provide a state factory). Did you forget to provide an @AppStateFactoryAccessor?", Tracer.Level.WARNING);
                            continue;
                        }
                        this.tracer.log("Ignoring EventHandler '" + methods[i].toString() + "' ... Application state cannot be passed to an application using an HAPolicy=" + (Object)((Object)engine.getHAPolicy()), Tracer.Level.WARNING);
                        continue;
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(".....ignored (param count != 2 or param count == 2 and second param not repository class)", Tracer.Level.DEBUG);
                    }
                    if (paramTypes[1] == repository.getClass()) continue;
                    this.tracer.log("Ignoring EventHandler '" + methods[i].toString() + "' ... Second argument is not of type '" + repository.getClass().getCanonicalName() + "' returned by application's state factory.", Tracer.Level.WARNING);
                    continue;
                }
                if (paramTypes.length <= 2) continue;
                this.tracer.log("Ignoring EventHandler '" + methods[i].toString() + "' ... too many method parameters", Tracer.Level.WARNING);
            }
        }
    }

    private final Class<?>[] getClassInterfaces(Class<?> clazz) {
        Class<?>[] interfaces = this.classInterfaces.get(clazz);
        if (interfaces == null) {
            interfaces = clazz.getInterfaces();
            this.classInterfaces.put(clazz, interfaces);
        }
        return interfaces;
    }

    private final boolean dispatchToEventHandlers(UtlList eventHandlerList, Object object, IEventSource source, IEventSource subsource, boolean local, Object repository) {
        boolean dispatched = false;
        UtlList element = eventHandlerList;
        while ((element = element.next()) != null) {
            dispatched |= ((Handler)element).dispatch(object, source, subsource, local, repository);
        }
        return dispatched;
    }

    private final boolean dispatchToEventHandlers(Class<?> clazz, Object object, Event event, Object repository) {
        boolean local;
        MessageChannel subsource;
        MessageBusBinding source;
        UtlList eventHandlerWithRepositoryList;
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Getting event handlers for event class='" + clazz.getName() + "'...", Tracer.Level.DEBUG);
        }
        UtlList eventHandlerList = this.eventHandlersWithoutRepository.get(clazz);
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Handler (without repository) list fetch result [" + (eventHandlerList == null ? "null" : "count=" + String.valueOf(eventHandlerList.count())) + "].", Tracer.Level.DEBUG);
        }
        UtlList utlList = eventHandlerWithRepositoryList = repository != null ? this.eventHandlersWithRepository.get(clazz) : null;
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Handler (with repository) list fetch result [" + (eventHandlerWithRepositoryList == null ? "null" : "count=" + String.valueOf(eventHandlerWithRepositoryList.count())) + "].", Tracer.Level.DEBUG);
        }
        if (event instanceof MessageChannelEvent) {
            MessageChannel channel = ((MessageChannelEvent)event).getMessageChannel();
            if (channel != null) {
                source = channel.getMessageBusBinding();
                subsource = channel;
                local = false;
            } else {
                source = null;
                subsource = null;
                local = true;
            }
        } else if (event instanceof MessageBusBindingEvent) {
            source = ((MessageBusBindingEvent)event).getMessageBusBinding();
            subsource = null;
            local = true;
        } else {
            subsource = null;
            source = null;
            local = true;
        }
        boolean dispatched = eventHandlerList != null && this.dispatchToEventHandlers(eventHandlerList, object, (IEventSource)source, (IEventSource)subsource, local, null);
        dispatched |= eventHandlerWithRepositoryList != null && this.dispatchToEventHandlers(eventHandlerWithRepositoryList, object, (IEventSource)source, (IEventSource)subsource, local, repository);
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Dispatched = " + dispatched, Tracer.Level.DEBUG);
        }
        return dispatched;
    }

    private final void clearEventHandlerCache() {
        UtlList element;
        UtlList handlers;
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Flushing handler caches...", Tracer.Level.DEBUG);
        }
        Iterator<UtlList> iterator = this.eventHandlersWithoutRepository.values().iterator();
        while (iterator.hasNext()) {
            element = handlers = iterator.next();
            while ((element = element.next()) != null) {
                ((Handler)element).clearCache();
            }
        }
        iterator = this.eventHandlersWithRepository.values().iterator();
        while (iterator.hasNext()) {
            element = handlers = iterator.next();
            while ((element = element.next()) != null) {
                ((Handler)element).clearCache();
            }
        }
    }

    public final Set<Object> getEventHandlerContainers() {
        return this.eventHandlerContainers;
    }

    public final Set<Class<?>> getHandledEventClasses() {
        LinkedHashSet ret = new LinkedHashSet();
        ret.addAll(this.eventHandlersWithoutRepository.keySet());
        ret.addAll(this.eventHandlersWithRepository.keySet());
        return ret;
    }

    public final Set<Class<? extends IRogMessage>> getHandledMessageClasses() {
        LinkedHashSet<Class<? extends IRogMessage>> ret = new LinkedHashSet<Class<? extends IRogMessage>>();
        for (Class<?> c : this.eventHandlersWithoutRepository.keySet()) {
            if (!IRogMessage.class.isAssignableFrom(c)) continue;
            ret.add(c);
        }
        for (Class<?> c : this.eventHandlersWithRepository.keySet()) {
            if (!IRogMessage.class.isAssignableFrom(c)) continue;
            ret.add(c);
        }
        return ret;
    }

    public final void getHandlerMethodsFor(Class<?> eventType, List<Method> results) {
        UtlList eventHandlerList = this.eventHandlersWithoutRepository.get(eventType);
        UtlList element = eventHandlerList;
        if (element != null) {
            while ((element = element.next()) != null) {
                results.add(((Handler)element).method);
            }
        }
        if ((element = (eventHandlerList = this.eventHandlersWithRepository.get(eventType))) != null) {
            while ((element = element.next()) != null) {
                results.add(((Handler)element).method);
            }
        }
    }

    public final void appendEventHandlerDeclarations(Class<?> eventType, String prefix, StringBuilder builder) {
        UtlList eventHandlerWithoutRepositoryList = this.eventHandlersWithoutRepository.get(eventType);
        UtlList eventHandlerWithRepositoryList = this.eventHandlersWithRepository.get(eventType);
        if (eventHandlerWithoutRepositoryList != null && eventHandlerWithoutRepositoryList.count > 0 || eventHandlerWithRepositoryList != null && eventHandlerWithRepositoryList.count > 0) {
            builder.append(prefix).append("Event handler declarations for '" + eventType.getName() + "':\n{\n");
            int i = 0;
            UtlList element = eventHandlerWithoutRepositoryList;
            if (element != null) {
                while ((element = element.next()) != null) {
                    builder.append(prefix).append(" ").append(i + 1).append(".) ");
                    UtlReflection.appendMethodAndCodeSource((Method)((Handler)element).method, (StringBuilder)builder);
                    builder.append("\n");
                    ++i;
                }
            }
            if ((element = eventHandlerWithRepositoryList) != null) {
                while ((element = element.next()) != null) {
                    builder.append(prefix).append(" ").append(i + 1).append(".) ");
                    UtlReflection.appendMethodAndCodeSource((Method)((Handler)element).method, (StringBuilder)builder);
                    builder.append("\n");
                    ++i;
                }
            }
            builder.append("}");
        } else {
            builder.append(prefix).append("No event handler declarations for '" + eventType.getName() + "'");
        }
    }

    public final void setDefaultHandlerDispatchPolicy(DefaultHandlerDispatchPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy cannot be null");
        }
        this.defaultHandlerDispatchPolicy = policy;
    }

    public final DefaultHandlerDispatchPolicy getDefaultHandlerDispatchPolicy() {
        return this.defaultHandlerDispatchPolicy;
    }

    public final void dispatchToEventHandlers(Object event) {
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Getting event handlers for event class='" + event.getClass().getName() + "'...", Tracer.Level.DEBUG);
        }
        UtlList eventHandlerList = this.eventHandlersWithoutRepository.get(event.getClass());
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Handler list fetch result [" + (eventHandlerList == null ? "null" : "count=" + String.valueOf(eventHandlerList.count())) + "].", Tracer.Level.DEBUG);
        }
        boolean dispatched = false;
        if (eventHandlerList != null) {
            UtlList element = eventHandlerList;
            while ((element = element.next()) != null) {
                dispatched |= ((Handler)element).dispatch(event, null, null, true, null);
            }
        }
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Dispatched = " + dispatched, Tracer.Level.DEBUG);
        }
    }

    public final void onEvent(Event event) {
        if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Received event " + event + " for dispatch.", Tracer.Level.DEBUG);
        }
        short eventType = event.getType();
        switch (eventType) {
            case 501: {
                AepClientConnectedEvent clientConnectedEvent = (AepClientConnectedEvent)event;
                MessageChannel client = clientConnectedEvent.getClient();
                this.clients.put(client.getName(), client);
                break;
            }
            case 502: {
                AepClientDisconnectedEvent clientDisconnectedEvent = (AepClientDisconnectedEvent)event;
                MessageChannel client = clientDisconnectedEvent.getClient();
                this.clients.remove(client.getName());
                try {
                    client.close();
                }
                catch (Exception e) {
                    this.tracer.log("Failed to close client " + client + " on disconnect [" + e.toString() + "].", Tracer.Level.WARNING);
                }
                break;
            }
        }
        boolean dispatched = false;
        if (this.eventHandlersWithoutRepository.size() > 0) {
            if (eventType == 505) {
                this.clearEventHandlerCache();
            }
            IRogNode repository = null;
            if (eventType == 105) {
                MessageEvent messageEvent = (MessageEvent)event;
                MessageView messageView = messageEvent.getMessageView();
                AepFlow flow = (AepFlow)((Object)messageView.getTag(1));
                repository = flow != null ? flow.getApplicationState() : null;
                dispatched = this.dispatchToEventHandlers(messageView.getClass(), messageView, (Event)messageEvent, repository);
                if (!dispatched) {
                    dispatched = this.dispatchToEventHandlers(MessageView.class, messageView, (Event)messageEvent, repository);
                }
            }
            if (!dispatched) {
                dispatched |= this.dispatchToEventHandlers(event.getClass(), event, event, repository);
                if (event instanceof LifecycleEvent) {
                    dispatched |= this.dispatchToEventHandlers(LifecycleEvent.class, event, event, null);
                }
                if (event instanceof ILifecycleEvent) {
                    dispatched |= this.dispatchToEventHandlers(ILifecycleEvent.class, event, event, null);
                }
                if (event instanceof AlertEvent) {
                    dispatched |= this.dispatchToEventHandlers(AlertEvent.class, event, event, null);
                }
                if (event instanceof IAlertEvent) {
                    dispatched |= this.dispatchToEventHandlers(IAlertEvent.class, event, event, null);
                }
                for (Class<?> clazz : this.getClassInterfaces(event.getClass())) {
                    dispatched |= this.dispatchToEventHandlers(clazz, event, event, null);
                }
                dispatched |= this.dispatchToEventHandlers(Event.class, event, event, null);
                dispatched |= this.dispatchToEventHandlers(IEvent.class, event, event, null);
            }
        } else if (this.tracer.debug) {
            this.tracer.log("[Aep, Dispatcher] Event handler table is empty.", Tracer.Level.DEBUG);
        }
        DefaultHandlerDispatchPolicy defaultHandlerDispatchPolicy = this.defaultHandlerDispatchPolicy;
        if (defaultHandlerDispatchPolicy == DefaultHandlerDispatchPolicy.DispatchAlways || !dispatched) {
            if (this.tracer.debug) {
                this.tracer.log("[Aep, Dispatcher] Dispatching to default event handler...", Tracer.Level.DEBUG);
            }
            if (this.defaultEventHandler != null) {
                this.defaultEventHandler.onEvent(event);
                dispatched = true;
            } else if (this.tracer.debug) {
                this.tracer.log("[Aep, Dispatcher] Default event handler is null. Dropping event.", Tracer.Level.DEBUG);
            }
        }
        if (dispatched) {
            event.setHandled();
        }
    }

    private final class Handler
    extends UtlListElement {
        private final String sourceName;
        private final String subsourceName;
        private final boolean localOnly;
        private final Object container;
        private final Method method;
        private final Object[] parameters;
        private final Object[] parametersWithRepository;
        private IEventSource source;
        private IEventSource subsource;
        private boolean cached;

        Handler(Object container, Method method) {
            EventHandler handlerAnnotation = method.getAnnotation(EventHandler.class);
            this.container = container;
            this.method = method;
            this.sourceName = this.getSourceFromAnnotationSourceDescriptor(handlerAnnotation.source());
            this.subsourceName = this.getSubSourceFromAnnotationSourceDescriptor(handlerAnnotation.source());
            this.localOnly = handlerAnnotation.localOnly();
            this.cached = this.sourceName == null && this.subsourceName == null;
            this.parameters = new Object[1];
            this.parametersWithRepository = new Object[2];
        }

        private final String getSourceFromAnnotationSourceDescriptor(String descriptor) {
            if (descriptor.length() == 0) {
                return null;
            }
            int index = descriptor.indexOf(64);
            String source = index == -1 ? descriptor : descriptor.substring(index + 1, descriptor.length());
            return source.equals("*") ? null : source;
        }

        private final String getSubSourceFromAnnotationSourceDescriptor(String descriptor) {
            if (descriptor.length() == 0) {
                return null;
            }
            int index = descriptor.indexOf(64);
            String subsource = index == -1 ? null : descriptor.substring(0, index);
            return subsource == null || subsource.equals("*") ? null : subsource;
        }

        final void clearCache() {
            this.source = null;
            this.subsource = null;
            this.cached = false;
        }

        final boolean dispatch(Object object, IEventSource source, IEventSource subsource, boolean local, Object repository) {
            if (((AepEventDispatcher)AepEventDispatcher.this).tracer.debug) {
                AepEventDispatcher.this.tracer.log("[Aep, Dispatcher] Checking and dispatching to handler '" + this.method.getName() + "' <object source=" + (source == null ? "null" : source.getName()) + ", object subsource=" + (subsource == null ? "null" : subsource.getName()) + ">...", Tracer.Level.DEBUG);
            }
            boolean dispatched = false;
            if (this.localOnly && !local) {
                if (((AepEventDispatcher)AepEventDispatcher.this).tracer.debug) {
                    AepEventDispatcher.this.tracer.log("[Aep, Dispatcher] '" + this.method.getName() + "' is localOnly and object is not local ... not dispatching.", Tracer.Level.DEBUG);
                }
                return false;
            }
            if (this.cached) {
                if (((AepEventDispatcher)AepEventDispatcher.this).tracer.debug) {
                    AepEventDispatcher.this.tracer.log("[Aep, Dispatcher] Source information is cached <this.source=" + (this.source == null ? "null" : this.source.getName()) + ", this.subsource=" + (this.subsource == null ? "null" : this.subsource.getName()) + ">", Tracer.Level.DEBUG);
                }
                if (!(this.source != null && this.source != source || this.subsource != null && this.subsource != subsource)) {
                    if (((AepEventDispatcher)AepEventDispatcher.this).tracer.debug) {
                        AepEventDispatcher.this.tracer.log("[Aep, Dispatcher] Object source matches handler source descriptor. Dispatching to handler...", Tracer.Level.DEBUG);
                    }
                    try {
                        if (repository == null) {
                            this.parameters[0] = object;
                            this.method.invoke(this.container, this.parameters);
                        }
                        this.parametersWithRepository[0] = object;
                        this.parametersWithRepository[1] = repository;
                        this.method.invoke(this.container, this.parametersWithRepository);
                    }
                    catch (InvocationTargetException e) {
                        Throwable targetException = e.getTargetException();
                        AepEventDispatcher.this.tracer.log("AEP event handler '" + this.method + "' threw exception [" + targetException.toString() + "]. Rethrowing...", Tracer.Level.WARNING);
                        if (targetException instanceof Error) {
                            throw (Error)targetException;
                        }
                        if (targetException instanceof RuntimeException) {
                            throw (RuntimeException)targetException;
                        }
                        throw new RuntimeException(targetException);
                    }
                    catch (Throwable e) {
                        AepEventDispatcher.this.tracer.log("Error in invoking AEP event handler '" + this.method + "' [" + e.toString() + "]. Rethrowing...", Tracer.Level.WARNING);
                        if (e instanceof Error) {
                            throw (Error)e;
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    finally {
                        dispatched = true;
                    }
                } else if (((AepEventDispatcher)AepEventDispatcher.this).tracer.debug) {
                    AepEventDispatcher.this.tracer.log("[Aep, Dispatcher] Object source does not match handler source descriptor. Dropping...", Tracer.Level.DEBUG);
                }
            } else {
                if (((AepEventDispatcher)AepEventDispatcher.this).tracer.debug) {
                    AepEventDispatcher.this.tracer.log("[Aep, Dispatcher] Source information is not cached <this.sourceName=" + this.sourceName + ", this.subsourceName=" + this.subsourceName + ">", Tracer.Level.DEBUG);
                }
                if ((this.sourceName == null || source != null && this.sourceName.compareToIgnoreCase(source.getName()) == 0) && (this.subsourceName == null || subsource != null && this.subsourceName.compareToIgnoreCase(subsource.getName()) == 0)) {
                    if (((AepEventDispatcher)AepEventDispatcher.this).tracer.debug) {
                        AepEventDispatcher.this.tracer.log("[Aep, Dispatcher] Object source matches handler source descriptor. Caching and dispatching...", Tracer.Level.DEBUG);
                    }
                    this.source = this.sourceName == null ? null : source;
                    this.subsource = this.subsourceName == null ? null : subsource;
                    this.cached = true;
                    dispatched = this.dispatch(object, source, subsource, local, repository);
                } else if (((AepEventDispatcher)AepEventDispatcher.this).tracer.debug) {
                    AepEventDispatcher.this.tracer.log("[Aep, Dispatcher] Object source does not match handler source descriptor. Dropping...", Tracer.Level.DEBUG);
                }
            }
            return dispatched;
        }
    }

    public static enum DefaultHandlerDispatchPolicy {
        DispatchAlways,
        DispatchIfNoAnnotatedHandlers;

    }
}

