/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ddl;

import com.google.common.io.Files;
import com.neeve.aep.AepEngine;
import com.neeve.config.Config;
import com.neeve.ddl.DdlConfigConstants;
import com.neeve.ddl.DdlConfigException;
import com.neeve.ddl.DdlConfigNode;
import com.neeve.ddl.DdlConfigTree;
import com.neeve.ddl.DdlXMLParser;
import com.neeve.ddl.jaxb.AppBus;
import com.neeve.ddl.jaxb.AppConfig;
import com.neeve.ddl.jaxb.AppConfigList;
import com.neeve.ddl.jaxb.BusConfig;
import com.neeve.ddl.jaxb.BusConfigList;
import com.neeve.ddl.jaxb.BusProvider;
import com.neeve.ddl.jaxb.BusProviderList;
import com.neeve.ddl.jaxb.CdcConfig;
import com.neeve.ddl.jaxb.ChannelQos;
import com.neeve.ddl.jaxb.CompactionConfig;
import com.neeve.ddl.jaxb.DiscoveryDescriptor;
import com.neeve.ddl.jaxb.HierarchicalPropertySet;
import com.neeve.ddl.jaxb.JvmConfig;
import com.neeve.ddl.jaxb.LogEmptinessExpectation;
import com.neeve.ddl.jaxb.MessageLogger;
import com.neeve.ddl.jaxb.Model;
import com.neeve.ddl.jaxb.StoreBindingRoleExpectation;
import com.neeve.ddl.jaxb.XvmAdminChannelConfig;
import com.neeve.ddl.jaxb.XvmConfig;
import com.neeve.ddl.jaxb.XvmConfigList;
import com.neeve.ods.IStoreBinding;
import com.neeve.rog.log.RogLog;
import com.neeve.sma.MessageChannel;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlReflection;
import com.neeve.util.UtlTailoring;
import com.neeve.util.UtlText;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DdlPropertyParser {
    private static final Tracer tracer = Tracer.get((String)"nv.ddl");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File toXcs(Properties ddl, boolean echo, UtlTailoring.PropertySource overrides) throws Exception {
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        File xcsFile = new File(tempDir.getPath() + File.separator + "config.xcs");
        PrintWriter writer = new PrintWriter(xcsFile);
        if (DdlPropertyParser.tracer.getLevel().val >= Tracer.Level.CONFIG.val) {
            tracer.log("XCS File=" + xcsFile.getAbsolutePath(), Tracer.Level.CONFIG);
        }
        try {
            DdlPropertyParser.toXcs(ddl, echo, overrides, writer);
        }
        finally {
            writer.close();
        }
        tracer.log("XCS File=" + xcsFile.getAbsolutePath(), Tracer.Level.CONFIG);
        return xcsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void toXcs(Properties ddl, boolean echo, UtlTailoring.PropertySource overrides, final Appendable out) throws Exception {
        if (DdlPropertyParser.tracer.debug) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ddl.list(pw);
            tracer.log("Converting DDL properties to XCS:\n" + sw.toString(), Tracer.Level.DEBUG);
        }
        final StringBuilder debugTrace = DdlPropertyParser.tracer.debug ? new StringBuilder() : null;
        PrintWriter writer = new PrintWriter(new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                String append = String.valueOf(cbuf, off, len);
                if (debugTrace != null) {
                    debugTrace.append(append);
                }
                out.append(append);
            }

            @Override
            public void flush() throws IOException {
                if (out instanceof Flushable) {
                    ((Flushable)((Object)out)).flush();
                }
            }

            @Override
            public void close() throws IOException {
                this.flush();
            }
        });
        try {
            DdlConfigNode ddlConfigNode;
            DdlConfigNode ddlConfigNode2;
            DdlConfigNode busProviders;
            DdlConfigNode envConfig;
            DdlConfigNode xConfig;
            String xConfigRootPath;
            writer.println("echo " + (echo ? "on" : "off"));
            String string = xConfigRootPath = overrides != null ? overrides.getValue("nv.ddl.prefix", "x") : "x";
            if (xConfigRootPath.trim().length() == 0) {
                throw new IllegalArgumentException("nv.ddl.prefix cannot be empty");
            }
            DdlConfigTree config = DdlPropertyParser.toConfigTree(ddl, overrides);
            if (DdlPropertyParser.tracer.debug) {
                tracer.log("Parsed DDL config tree:\n" + config, Tracer.Level.DEBUG);
            }
            if ((xConfig = config.get(xConfigRootPath)) == null) {
                tracer.log("No X config specified (no properties starting with '" + xConfigRootPath + ") no configuration will be seeded.')", Tracer.Level.WARNING);
                return;
            }
            DdlPropertyParser.applyConfigTreeProfiles(xConfig, overrides, true);
            if (DdlPropertyParser.tracer.debug) {
                tracer.log("Applied DDL profiles:\n" + config, Tracer.Level.DEBUG);
            }
            if ((envConfig = xConfig.get("env")) != null) {
                for (DdlConfigNode ddlConfigNode3 : envConfig.collectDescendents(new TreeSet<DdlConfigNode>())) {
                    if (ddlConfigNode3.getValue() == null) continue;
                    String string2 = ddlConfigNode3.getFullName().substring(envConfig.getFullName().length() + 1);
                    writer.println("repo_set_simple_entity_property /env default " + UtlText.quoteAndEscape((String)string2) + " " + UtlText.quoteAndEscape((String)ddlConfigNode3.getValue()));
                }
            }
            if ((busProviders = xConfig.get("busProviders")) != null) {
                for (DdlConfigNode ddlConfigNode4 : busProviders.getChildren()) {
                    String string4 = ddlConfigNode4.getName();
                    string4 = ddlConfigNode4.getValue("name", string4);
                    String busProviderClass = ddlConfigNode4.getRequiredValue("providerClass");
                    if (!ddlConfigNode4.getValue("enabled", true)) continue;
                    writer.println("bus_provider_create " + string4 + " " + busProviderClass);
                }
                writer.println("");
            }
            if ((ddlConfigNode2 = xConfig.get("buses")) != null) {
                for (DdlConfigNode ddlConfigNode5 : ddlConfigNode2.getChildren()) {
                    String busName = ddlConfigNode5.getName();
                    if ("templates".equals(busName = ddlConfigNode5.getValue("name", busName))) continue;
                    DdlPropertyParser.templatize(ddlConfigNode5, ddlConfigNode2.get("templates"));
                    if (!ddlConfigNode5.getValue("enabled", true)) continue;
                    writer.println("bus_create " + busName);
                    DdlConfigNode channels = ddlConfigNode5.get("channels");
                    if (channels != null) {
                        for (DdlConfigNode channelConfig : channels.getChildren()) {
                            Object key;
                            String qos;
                            String channelName = channelConfig.getName();
                            channelName = channelConfig.getValue("name", channelName);
                            writer.println("channel_add " + busName + " " + channelName);
                            String string5 = channelConfig.getValue("id");
                            if (string5 != null) {
                                writer.println("channel_set_id " + busName + " " + channelName + " " + string5);
                            }
                            if ((qos = channelConfig.getValue("qos")) != null) {
                                writer.println("channel_set_qos " + busName + " " + channelName + " " + qos);
                            }
                            if ((key = channelConfig.getValue("key")) == null) continue;
                            writer.println("channel_set_key " + busName + " " + channelName + " " + UtlText.quoteAndEscape((String)key));
                        }
                    }
                    String descriptor = DdlPropertyParser.parseDescriptor(ddlConfigNode5, ddlConfigNode5.get("descriptor"));
                    writer.println("bus_localize " + busName + " " + UtlText.quoteAndEscape((String)descriptor.toString()) + " force");
                    writer.println("");
                }
            }
            if ((ddlConfigNode = xConfig.get("apps")) != null) {
                for (DdlConfigNode appConfig : ddlConfigNode.getChildren()) {
                    LogEmptinessExpectation logEmptiness;
                    StoreBindingRoleExpectation role;
                    Object perTransactionStatsLoggingConfig;
                    DdlConfigNode outboundMessageLoggingConfig;
                    DdlConfigNode ddlConfigNode6;
                    DdlConfigNode inboundEventMultiplexingConfig;
                    DdlConfigNode messagingConfig;
                    String appName = appConfig.getName();
                    if ((appName = appConfig.getValue("name", appName)).equals("templates")) continue;
                    DdlPropertyParser.templatize(appConfig, ddlConfigNode.get("templates"));
                    if (!appConfig.getValue("enabled", true)) continue;
                    DdlConfigNode storageConfig = appConfig.get("storage");
                    if (storageConfig != null && storageConfig.getValue("enabled", true)) {
                        DdlConfigNode icrConfig;
                        DdlConfigNode persistenceConfig;
                        String string6;
                        String storeDescriptor = storageConfig.getValue("descriptor");
                        Object clusteringConfig = storageConfig.get("clustering");
                        if (storeDescriptor != null) {
                            if (storageConfig.get("clustering") != null) {
                                throw new DdlConfigException("only one of '" + storageConfig.get("descriptor").getFullName() + " and " + storageConfig.get("clustering").getFullName() + "' can be present in DDL config properties.");
                            }
                            UtlAddressDescriptor utlAddressDescriptor = UtlAddressDescriptor.parse((String)storeDescriptor, null);
                            StringBuilder linkParams = new StringBuilder();
                            clusteringConfig = storageConfig.add("clustering", null);
                            for (Map.Entry entry : utlAddressDescriptor.props.entrySet()) {
                                if (((String)entry.getKey()).equalsIgnoreCase("storeName")) {
                                    ((DdlConfigNode)clusteringConfig).add("storeName", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("localIfAddr")) {
                                    ((DdlConfigNode)clusteringConfig).add("localIfAddr", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("localPort")) {
                                    ((DdlConfigNode)clusteringConfig).add("localPort", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("cpuAffinityMask")) {
                                    ((DdlConfigNode)clusteringConfig).add("linkReaderCpuAffinityMask", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("initWaitTime")) {
                                    ((DdlConfigNode)clusteringConfig).add("initWaitTime(new BigInteger", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("detachedSend")) {
                                    ((DdlConfigNode)clusteringConfig).add("detachedSend.enabled", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("senderCpuAffinityMask")) {
                                    ((DdlConfigNode)clusteringConfig).add("detachedSend.queueDrainerCpuAffinityMask", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("senderQueueDepth")) {
                                    ((DdlConfigNode)clusteringConfig).add("detachedSend.queueDepth", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("senderQueueWaitStrategy")) {
                                    ((DdlConfigNode)clusteringConfig).add("detachedSend.queueWaitStrategy", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("detachedDispatch")) {
                                    ((DdlConfigNode)clusteringConfig).add("detachedDispatch.enabled", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("dispatcherCpuAffinityMask")) {
                                    ((DdlConfigNode)clusteringConfig).add("detachedDispatch.queueDrainerCpuAffinityMask", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("dispatcherQueueDepth")) {
                                    ((DdlConfigNode)clusteringConfig).add("detachedDispatch.queueDepth", (String)entry.getValue());
                                    continue;
                                }
                                if (((String)entry.getKey()).equalsIgnoreCase("dispatcherQueueWaitStrategy")) {
                                    ((DdlConfigNode)clusteringConfig).add("detachedDispatch.queueWaitStrategy", (String)entry.getValue());
                                    continue;
                                }
                                String linkParam = (String)entry.getKey() + "=" + entry.getValue();
                                if (linkParams.length() > 0) {
                                    linkParams.append(",");
                                }
                                linkParams.append(linkParam);
                            }
                            if (linkParams.length() > 0) {
                                ((DdlConfigNode)clusteringConfig).add("linkParams", linkParams.toString());
                            }
                        }
                        if ((string6 = storageConfig.getValue("discoveryDescriptor")) != null) {
                            if (clusteringConfig != null && (((DdlConfigNode)clusteringConfig).getValue("discoveryDescriptor") != null || ((DdlConfigNode)clusteringConfig).get("discovery") != null)) {
                                throw new DdlConfigException("only one of '" + storageConfig.get("discoveryDescriptor").getFullName() + " and " + ((DdlConfigNode)clusteringConfig).get("discoveryDescriptor").getFullName() + "' can be present in DDL config properties.");
                            }
                            tracer.log("'" + storageConfig.get("discoveryDescriptor").getFullName() + "' is deprecated. Use '" + storageConfig.getFullName() + ".clustering.discovery.address' or '" + storageConfig.getFullName() + ".clustering.discoveryDescriptor' instead.", Tracer.Level.WARNING);
                            if (clusteringConfig == null) {
                                clusteringConfig = storageConfig.add("clustering", null);
                            }
                            ((DdlConfigNode)clusteringConfig).add("discoveryDescriptor", string6);
                        }
                        if ((clusteringConfig = storageConfig.get("clustering")) != null && ((DdlConfigNode)clusteringConfig).getValue("enabled", true)) {
                            DdlConfigNode detachedDispatch;
                            writer.println("store_replicator_create " + appName);
                            DdlConfigNode discoveryConfig = ((DdlConfigNode)clusteringConfig).get("discovery");
                            if (discoveryConfig != null || ((DdlConfigNode)clusteringConfig).get("discoveryDescriptor") != null) {
                                writer.println("store_replicator_set_property " + appName + " discoveryDescriptor " + UtlText.quoteAndEscape((String)DdlPropertyParser.parseDescriptor(discoveryConfig, ((DdlConfigNode)clusteringConfig).get("discoveryDescriptor"))));
                            }
                            DdlPropertyParser.writeBeanPathProperties("store_replicator_set_property " + appName, writer, AppConfig.Storage.Clustering.class, (DdlConfigNode)clusteringConfig, "enabled", "discoveryDescriptor");
                            DdlConfigNode detachedSend = ((DdlConfigNode)clusteringConfig).get("detachedSend");
                            if (detachedSend != null) {
                                if (detachedSend.getValue("enabled", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " detachedSend " + detachedSend.getValue("enabled", "false"));
                                }
                                if (detachedSend.getValue("queueDepth", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " senderQueueDepth " + detachedSend.getValue("queueDepth", 1024));
                                }
                                if (detachedSend.getValue("queueWaitStrategy", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " senderQueueWaitStrategy " + detachedSend.getValue("queueWaitStrategy", null));
                                }
                                if (detachedSend.getValue("queueOfferStrategy", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " senderQueueOfferStrategy " + detachedSend.getValue("queueOfferStrategy", null));
                                }
                                if (detachedSend.getValue("queueDrainerCpuAffinityMask", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " senderCpuAffinityMask " + UtlText.quoteAndEscape((String)detachedSend.getValue("queueDrainerCpuAffinityMask", "0")));
                                }
                                if (detachedSend.getValue("queueFeedMaxConcurrency", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " senderQueueFeedMaxConcurrency " + detachedSend.getValue("queueFeedMaxConcurrency", "16"));
                                }
                            }
                            if ((detachedDispatch = ((DdlConfigNode)clusteringConfig).get("detachedDispatch")) != null) {
                                if (detachedDispatch.getValue("enabled", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " detachedDispatch " + detachedDispatch.getValue("enabled", "false"));
                                }
                                if (detachedDispatch.getValue("queueDepth", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " dispatcherQueueDepth " + detachedDispatch.getValue("queueDepth", 1024));
                                }
                                if (detachedDispatch.getValue("queueWaitStrategy", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " dispatcherQueueWaitStrategy " + detachedDispatch.getValue("queueWaitStrategy", null));
                                }
                                if (detachedDispatch.getValue("queueOfferStrategy", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " dispatcherQueueOfferStrategy " + detachedDispatch.getValue("queueOfferStrategy", null));
                                }
                                if (detachedDispatch.getValue("queueDrainerCpuAffinityMask", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " dispatcherCpuAffinityMask " + UtlText.quoteAndEscape((String)detachedDispatch.getValue("queueDrainerCpuAffinityMask", "0")));
                                }
                                if (detachedDispatch.getValue("queueFeedMaxConcurrency", null) != null) {
                                    writer.println("store_replicator_set_property " + appName + " dispatcherQueueFeedMaxConcurrency " + detachedDispatch.getValue("queueFeedMaxConcurrency", "16"));
                                }
                            }
                            DdlPropertyParser.writeBeanPathProperties("store_replicator_set_property " + appName, writer, AppConfig.Storage.Clustering.class, (DdlConfigNode)clusteringConfig, "enabled");
                            writer.println("");
                        }
                        if ((persistenceConfig = storageConfig.get("persistence")) != null && persistenceConfig.getValue("enabled", true)) {
                            DdlConfigNode cdc;
                            persistenceConfig.getValue("class", RogLog.class.getName());
                            writer.println("store_persister_create " + appName + " " + persistenceConfig.getValue("class", RogLog.class.getName()));
                            DdlPropertyParser.writeBeanPathProperties("store_persister_set_property " + appName, writer, AppConfig.Storage.Persistence.class, persistenceConfig, "enabled", "class");
                            DdlConfigNode detachedPersist = persistenceConfig.get("detachedPersist");
                            if (detachedPersist != null) {
                                if (detachedPersist.getValue("enabled", null) != null) {
                                    writer.println("store_persister_set_property " + appName + " detachedPersist " + detachedPersist.getValue("enabled", "false"));
                                }
                                DdlPropertyParser.writeBeanPathProperties("store_persister_set_property " + appName, writer, AppConfig.Storage.Persistence.DetachedPersist.class, detachedPersist, "enabled");
                            }
                            writer.println("");
                            DdlConfigNode compaction = persistenceConfig.get("compaction");
                            if (compaction != null) {
                                DdlPropertyParser.writeBeanPathProperties("store_persister_set_compaction_property " + appName, writer, CompactionConfig.class, compaction, "properties");
                                DdlConfigNode compactionProperties = compaction.get("properties");
                                if (compactionProperties != null) {
                                    for (DdlConfigNode ddlConfigNode7 : compactionProperties.collectDescendents(new TreeSet<DdlConfigNode>())) {
                                        if (ddlConfigNode7.getValue() == null) continue;
                                        String propName = ddlConfigNode7.getFullName().substring(compactionProperties.getFullName().length() + 1);
                                        writer.println("store_persister_set_compaction_property " + appName + " " + UtlText.quoteAndEscape((String)propName) + " " + UtlText.quoteAndEscape((String)ddlConfigNode7.getValue()));
                                    }
                                }
                            }
                            if ((cdc = persistenceConfig.get("cdc")) != null) {
                                DdlPropertyParser.writeBeanPathProperties("store_persister_set_cdc_property " + appName, writer, CdcConfig.class, cdc, "properties");
                                DdlConfigNode cdcProperties = cdc.get("properties");
                                if (cdcProperties != null) {
                                    for (DdlConfigNode prop2 : cdcProperties.collectDescendents(new TreeSet<DdlConfigNode>())) {
                                        if (prop2.getValue() == null) continue;
                                        String propName = prop2.getFullName().substring(cdcProperties.getFullName().length() + 1);
                                        writer.println("store_persister_set_cdc_property " + appName + " " + UtlText.quoteAndEscape((String)propName) + " " + UtlText.quoteAndEscape((String)prop2.getValue()));
                                    }
                                }
                            }
                        }
                        if ((icrConfig = storageConfig.get("icr")) != null && icrConfig.getValue("enabled", true)) {
                            IStoreBinding.InterClusterReplicationRole icrRole = icrConfig.getValue("role", IStoreBinding.InterClusterReplicationRole.class, null, true);
                            DdlConfigNode icrBusConfig = icrConfig.get("bus");
                            DdlConfigNode icrBusDecriptor = icrConfig.get("busDescriptor");
                            if (icrBusConfig == null && icrBusDecriptor == null) {
                                throw new DdlConfigException("Either '" + icrConfig.getFullName() + ".bus' or '" + icrConfig.getFullName() + ".busDescriptor' must be specified to configure the ICR bus.");
                            }
                            String string7 = DdlPropertyParser.parseDescriptor(icrConfig.get("bus"), icrConfig.get("busDescriptor"));
                            writer.println("store_icr_create " + appName + " " + icrRole.name() + " " + UtlText.quoteAndEscape((String)string7));
                            DdlPropertyParser.writeBeanPathProperties("store_icr_set_property " + appName, writer, AppConfig.Storage.Icr.class, icrConfig, "enabled", "busDescriptor", "role");
                            DdlConfigNode detachedSend = icrConfig.get("detachedSend");
                            if (detachedSend != null) {
                                if (detachedSend.getValue("enabled", null) != null) {
                                    writer.println("store_icr_set_property " + appName + " detachedSend " + detachedSend.getValue("enabled", "false"));
                                }
                                DdlPropertyParser.writeBeanPathProperties("store_icr_set_property " + appName, writer, AppConfig.Storage.Icr.DetachedSend.class, detachedSend, "enabled");
                            }
                            writer.println("");
                        }
                        writer.println("store_create " + appName);
                        if (clusteringConfig != null && ((DdlConfigNode)clusteringConfig).getValue("enabled", true)) {
                            writer.println("store_set_replicator " + appName + " " + appName);
                        }
                        if (persistenceConfig != null && persistenceConfig.getValue("enabled", true)) {
                            writer.println("store_set_persister " + appName + " " + appName);
                        }
                        if (icrConfig != null && icrConfig.getValue("enabled", true)) {
                            writer.println("store_set_icr " + appName + " " + appName);
                        }
                        DdlPropertyParser.writeBeanPathProperties("store_set_property " + appName, writer, AppConfig.Storage.class, storageConfig, "enabled", "discoveryDescriptor", "descriptor");
                        writer.println("");
                    }
                    writer.println("aep_engine_create " + appName);
                    if (storageConfig != null && storageConfig.getValue("enabled", true)) {
                        writer.println("aep_engine_set_store " + appName + " " + appName);
                        DdlConfigNode factoriesConfig = storageConfig.get("factories");
                        if (factoriesConfig != null) {
                            for (DdlConfigNode ddlConfigNode8 : factoriesConfig.getChildren()) {
                                String factory = ddlConfigNode8.getValue();
                                if (factory == null || factory.length() == 0) continue;
                                writer.println("aep_engine_add_state_factory " + appName + " " + factory);
                            }
                        }
                    }
                    if ((messagingConfig = appConfig.get("messaging")) != null) {
                        DdlConfigNode ddlConfigNode9;
                        DdlConfigNode factoriesConfig = messagingConfig.get("factories");
                        if (factoriesConfig != null) {
                            for (Object factoryConfig2 : factoriesConfig.getChildren()) {
                                String factory = ((DdlConfigNode)factoryConfig2).getValue();
                                if (factory == null || factory.length() == 0) continue;
                                writer.println("aep_engine_add_message_factory " + appName + " " + factory);
                            }
                        }
                        if ((ddlConfigNode9 = messagingConfig.get("buses")) != null) {
                            Object factoryConfig2;
                            factoryConfig2 = ddlConfigNode9.getChildren().iterator();
                            while (factoryConfig2.hasNext()) {
                                DdlConfigNode busConfig = (DdlConfigNode)factoryConfig2.next();
                                String busName = busConfig.getName();
                                busName = busConfig.getValue("name", busName);
                                if (!busConfig.getValue("enabled", true)) continue;
                                writer.println("aep_engine_add_bus " + appName + " " + busName);
                                DdlConfigNode channels = busConfig.get("channels");
                                if (channels != null) {
                                    for (DdlConfigNode ddlConfigNode10 : channels.getChildren()) {
                                        String preserveChannelJoins;
                                        String channelName = ddlConfigNode10.getName();
                                        channelName = ddlConfigNode10.getValue("name", channelName);
                                        Object params = " join=" + ddlConfigNode10.getValue("join", false);
                                        String filter = ddlConfigNode10.getValue("filter");
                                        if (filter != null) {
                                            params = (String)params + " filter=" + UtlText.quoteAndEscape((String)filter.trim());
                                        }
                                        if ((preserveChannelJoins = ddlConfigNode10.getValue("preserveJoinsOnClose")) != null) {
                                            params = (String)params + " preserveJoinsOnClose=" + MessageChannel.PreserveJoinPolicy.valueOf((String)preserveChannelJoins);
                                        }
                                        writer.println("aep_engine_add_channel " + appName + " " + busName + " " + channelName + (String)params);
                                    }
                                }
                                DdlPropertyParser.writeBeanPathProperties("aep_engine_set_bus_connection_property " + appName + " " + busName, writer, AppBus.class, busConfig, "enabled");
                                DdlConfigNode detachedSend = busConfig.get("detachedSend");
                                if (detachedSend == null) continue;
                                if (detachedSend.getValue("enabled", null) != null) {
                                    writer.println("aep_engine_set_bus_connection_property " + appName + " " + busName + " detachedSend " + detachedSend.getValue("enabled", "false"));
                                }
                                DdlPropertyParser.writeBeanPathProperties("aep_engine_set_bus_connection_property " + appName + " " + busName, writer, AppBus.DetachedSend.class, detachedSend, "enabled");
                            }
                        }
                    }
                    if ((inboundEventMultiplexingConfig = appConfig.get("inboundEventMultiplexing")) != null) {
                        if (inboundEventMultiplexingConfig.getValue("type") != null) {
                            writer.println("aep_engine_set_event_multiplexer_type " + appName + " " + AepEngine.EventMultiplexerType.valueOf((String)inboundEventMultiplexingConfig.getValue("type")));
                        }
                        DdlPropertyParser.writeBeanPathProperties("aep_engine_set_event_multiplexer_property " + appName, writer, AppConfig.InboundEventMultiplexing.class, inboundEventMultiplexingConfig, "type");
                    }
                    if ((ddlConfigNode6 = appConfig.get("inboundMessageLogging")) != null) {
                        DdlPropertyParser.writeBeanPathProperties("aep_engine_set_inbound_message_logging_property " + appName, writer, AppConfig.InboundMessageLogging.class, ddlConfigNode6, new String[0]);
                        DdlConfigNode detachedWrite = ddlConfigNode6.get("detachedWrite");
                        if (detachedWrite != null) {
                            if (detachedWrite.getValue("enabled", null) != null) {
                                writer.println("aep_engine_set_inbound_message_logging_property " + appName + " detachedWrite " + detachedWrite.getValue("enabled", "false"));
                            }
                            DdlPropertyParser.writeBeanPathProperties("aep_engine_set_inbound_message_logging_property " + appName, writer, MessageLogger.DetachedWrite.class, detachedWrite, "enabled");
                        }
                    }
                    if ((outboundMessageLoggingConfig = appConfig.get("outboundMessageLogging")) != null) {
                        DdlPropertyParser.writeBeanPathProperties("aep_engine_set_outbound_message_logging_property " + appName, writer, AppConfig.OutboundMessageLogging.class, outboundMessageLoggingConfig, new String[0]);
                        DdlConfigNode detachedWrite = outboundMessageLoggingConfig.get("detachedWrite");
                        if (detachedWrite != null) {
                            if (detachedWrite.getValue("enabled", null) != null) {
                                writer.println("aep_engine_set_outbound_message_logging_property " + appName + " detachedWrite " + detachedWrite.getValue("enabled", "false"));
                            }
                            DdlPropertyParser.writeBeanPathProperties("aep_engine_set_outbound_message_logging_property " + appName, writer, MessageLogger.DetachedWrite.class, detachedWrite, "enabled");
                        }
                    }
                    if ((perTransactionStatsLoggingConfig = appConfig.get("perTransactionStatsLogging")) != null) {
                        DdlPropertyParser.writeBeanPathProperties("aep_engine_set_per_transaction_stats_logging_property " + appName, writer, AppConfig.PerTransactionStatsLogging.class, (DdlConfigNode)perTransactionStatsLoggingConfig, new String[0]);
                        DdlConfigNode detachedWrite = ((DdlConfigNode)perTransactionStatsLoggingConfig).get("detachedWrite");
                        if (detachedWrite != null) {
                            if (detachedWrite.getValue("enabled", null) != null) {
                                writer.println("aep_engine_set_per_transaction_stats_logging_property " + appName + " detachedWrite " + detachedWrite.getValue("enabled", "false"));
                            }
                            DdlPropertyParser.writeBeanPathProperties("aep_engine_set_per_transaction_stats_logging_property " + appName, writer, MessageLogger.DetachedWrite.class, detachedWrite, "enabled");
                        }
                    }
                    if ((role = (StoreBindingRoleExpectation)appConfig.getValue("startupExpectations.role", StoreBindingRoleExpectation.class, null, false)) != null && role != StoreBindingRoleExpectation.NONE) {
                        writer.println("aep_engine_set_startup_role_expectation " + appName + " " + role.value());
                    }
                    if ((logEmptiness = (LogEmptinessExpectation)appConfig.getValue("startupExpectations.logEmptiness", LogEmptinessExpectation.class, null, false)) != null) {
                        writer.println("aep_engine_set_startup_log_emptiness_expectation " + appName + " " + logEmptiness.value());
                    }
                    DdlPropertyParser.writeBeanPathProperties("aep_engine_set_descriptor_property " + appName, writer, AppConfigList.App.class, appConfig, "enabled", "template", "mainClass", "name");
                    writer.println("");
                }
                DdlConfigNode ddlConfigNode11 = xConfig.get("systemDetails");
                String systemName = ddlConfigNode11 != null ? ddlConfigNode11.getValue("name") : null;
                String systemVersion = ddlConfigNode11 != null ? ddlConfigNode11.getValue("version") : null;
                DdlConfigNode xvmsConfig = xConfig.get("xvms");
                if (xvmsConfig == null) {
                    xvmsConfig = xConfig.get("servers");
                } else if (xConfig.get("servers") != null) {
                    throw new DdlConfigException("Only one of '" + xvmsConfig.getFullName() + "' and '" + xConfig.get("servers").getFullName() + "' can be used.");
                }
                if (xvmsConfig != null) {
                    for (DdlConfigNode xvmConfig : xvmsConfig.getChildren()) {
                        DdlConfigNode adminConfig;
                        DdlConfigNode discoveryConfig;
                        void var25_71;
                        DdlConfigNode multiThreadingConfig;
                        DdlConfigNode acceptorsConfig;
                        DdlConfigNode xvmAppsConfig;
                        Object dataDirectory;
                        DdlConfigNode provisioningConfig;
                        String string8;
                        String string9 = xvmConfig.getValue("name", string8 = xvmConfig.getName());
                        if ("templates".equals(string9)) continue;
                        DdlPropertyParser.templatize(xvmConfig, xvmsConfig.get("templates"));
                        if (!xvmConfig.getValue("enabled", true)) continue;
                        writer.println("server_create " + string9);
                        DdlConfigNode xvmEnvConfig = xvmConfig.get("env");
                        if (xvmEnvConfig != null) {
                            writer.println("repo_create_simple_entity_container /env/servers");
                            writer.println("repo_create_simple_entity /env/servers " + string9);
                            for (DdlConfigNode prop : xvmEnvConfig.collectDescendents(new TreeSet<DdlConfigNode>())) {
                                if (prop.getValue() == null) continue;
                                String propName = prop.getFullName().substring(xvmEnvConfig.getFullName().length() + 1);
                                writer.println("repo_set_simple_entity_property /env/servers " + string9 + " " + UtlText.quoteAndEscape((String)propName) + " " + UtlText.quoteAndEscape((String)prop.getValue()));
                            }
                        }
                        if ((provisioningConfig = xvmConfig.get("provisioning")) != null) {
                            String traceLogDirectory;
                            String runDirectory = provisioningConfig.getValue("runDirectory");
                            if (runDirectory != null) {
                                writer.println("repo_set_simple_entity_property /env/servers " + string9 + " NVROOT " + UtlText.quoteAndEscape((String)runDirectory));
                            }
                            if ((dataDirectory = provisioningConfig.getValue("dataDirectory")) != null) {
                                writer.println("repo_set_simple_entity_property /env/servers " + string9 + " nv.data.directory " + UtlText.quoteAndEscape((String)dataDirectory));
                            }
                            if ((traceLogDirectory = provisioningConfig.getValue("traceLogDirectory")) != null) {
                                writer.println("repo_set_simple_entity_property /env/servers " + string9 + " nv.log.directory " + UtlText.quoteAndEscape((String)traceLogDirectory));
                            }
                        }
                        if ((xvmAppsConfig = xvmConfig.get("apps")) != null) {
                            dataDirectory = xvmAppsConfig.getChildren().iterator();
                            while (dataDirectory.hasNext()) {
                                DdlConfigNode xvmAppConfig = (DdlConfigNode)dataDirectory.next();
                                String string11 = xvmAppConfig.getName();
                                string11 = xvmAppConfig.getValue("name", string11);
                                if (!xvmAppConfig.getValue("enabled", true)) continue;
                                DdlConfigNode appConfig = xConfig.get(DdlConfigNode.escapedPath("apps", string11));
                                if (appConfig == null && xConfig.get("apps") != null) {
                                    for (DdlConfigNode appConfingCandidate : xConfig.get("apps").getChildren()) {
                                        if (!string11.equals(appConfingCandidate.getValue("name"))) continue;
                                        appConfig = appConfingCandidate;
                                        break;
                                    }
                                    if (appConfig == null) {
                                        throw new DdlConfigException("cannot find app '" + xConfigRootPath + ".apps." + string11 + "' or any app with name '" + string11 + "' referenced by '" + xvmAppConfig.getFullName() + "'");
                                    }
                                }
                                if (!appConfig.getValue("enabled", true)) continue;
                                String string13 = appConfig.getName();
                                string13 = appConfig.getValue("name", string13);
                                writer.println("server_add_app " + string9 + " " + string13 + " " + appConfig.getRequiredValue("mainClass"));
                                writer.println("server_set_app_autostart " + string9 + " " + string13 + " " + xvmAppConfig.getValue("autoStart", true));
                            }
                        }
                        if ((acceptorsConfig = xvmConfig.get("acceptors")) != null && !acceptorsConfig.getChildren().isEmpty()) {
                            writer.println("server_remove_acceptor " + string9 + " tcp://0.0.0.0:0");
                            for (DdlConfigNode ddlConfigNode12 : acceptorsConfig.getChildren()) {
                                if (!ddlConfigNode12.getValue("enabled", true)) continue;
                                StringBuilder descriptor = new StringBuilder(ddlConfigNode12.getRequiredValue("descriptor"));
                                String linkParams = ddlConfigNode12.getValue("linkParams");
                                if (linkParams != null) {
                                    StringTokenizer tokenizer = new StringTokenizer(linkParams, ",");
                                    while (tokenizer.hasMoreTokens()) {
                                        descriptor.append("&").append(tokenizer.nextToken().trim());
                                    }
                                }
                                writer.println("server_add_acceptor " + string9 + " " + UtlText.quoteAndEscape((String)descriptor.toString()));
                            }
                        }
                        if ((multiThreadingConfig = xvmConfig.get("multiThreading")) != null) {
                            writer.println("server_set_multithreaded " + string9 + " " + multiThreadingConfig.getValue("enabled", true));
                            DdlConfigNode ddlConfigNode13 = multiThreadingConfig.get("ioThreads");
                            if (ddlConfigNode13 != null) {
                                writer.println("server_set_iothreadcount " + string9 + " " + ddlConfigNode13.getChildren().size());
                                for (int i = 0; i < ddlConfigNode13.getChildren().size(); ++i) {
                                    DdlConfigNode ioThreadConfig = ddlConfigNode13.getRequiredChild("" + i);
                                    if (!ioThreadConfig.getValue("enabled", true)) {
                                        if (i + 1 == ddlConfigNode13.getChildren().size()) break;
                                        tracer.log(string9 + " io thread '" + i + "' is disabled, subsequent io threads will be ignored", Tracer.Level.WARNING);
                                        break;
                                    }
                                    writer.println("server_set_iothreadcpuaffmask " + string9 + " " + ioThreadConfig.getName() + " " + UtlText.quoteAndEscape((String)ioThreadConfig.getValue("affinity", "0")));
                                }
                            }
                        }
                        DdlConfigNode ddlConfigNode14 = xvmConfig.get("heartbeats");
                        DdlConfigNode hearbeatLoggingConfig = xvmConfig.get("heartbeatLogging");
                        if (hearbeatLoggingConfig != null) {
                            tracer.log("'" + hearbeatLoggingConfig.getFullName() + "' is deprecated. Use '" + xvmConfig.getFullName() + ".heartbeats.logging' instead.", Tracer.Level.WARNING);
                            if (ddlConfigNode14 == null) {
                                DdlConfigNode ddlConfigNode15 = xvmConfig.add("heartbeats", null);
                                ddlConfigNode15.add("enabled", "false");
                            } else if (ddlConfigNode14.get("logging") != null) {
                                throw new DdlConfigException("Can't specify both '" + hearbeatLoggingConfig.getFullName() + "' and '" + ddlConfigNode14.get("logging").getFullName() + "'!");
                            }
                        }
                        if (var25_71 != null) {
                            writer.println("server_set_heartbeats_property " + string9 + " enabled " + var25_71.getValue("enabled", true));
                            DdlPropertyParser.writeBeanPathProperties("server_set_heartbeats_property " + string9, writer, XvmConfig.Heartbeats.class, (DdlConfigNode)var25_71, "enabled");
                            DdlConfigNode hearbeatTracingConfig = var25_71.get("tracing");
                            if (hearbeatTracingConfig != null) {
                                writer.println("server_set_heartbeat_tracing_property " + string9 + " enabled " + hearbeatTracingConfig.getValue("enabled", true));
                                DdlPropertyParser.writeBeanPathProperties("server_set_heartbeat_tracing_property " + string9, writer, XvmConfig.Heartbeats.Tracing.class, hearbeatTracingConfig, "enabled");
                            }
                            DdlConfigNode ddlConfigNode16 = hearbeatLoggingConfig = hearbeatLoggingConfig != null ? hearbeatLoggingConfig : var25_71.get("logging");
                            if (hearbeatLoggingConfig != null) {
                                writer.println("server_set_heartbeat_logging_property " + string9 + " enabled " + hearbeatLoggingConfig.getValue("enabled", true));
                                DdlPropertyParser.writeBeanPathProperties("server_set_heartbeat_logging_property " + string9, writer, XvmConfig.Heartbeats.Logging.class, hearbeatLoggingConfig, "enabled");
                                DdlConfigNode detachedWrite = hearbeatLoggingConfig.get("detachedWrite");
                                if (detachedWrite != null) {
                                    if (detachedWrite.getValue("enabled", null) != null) {
                                        writer.println("server_set_heartbeat_logging_property " + string9 + " detachedWrite " + detachedWrite.getValue("enabled", "false"));
                                    }
                                    DdlPropertyParser.writeBeanPathProperties("server_set_heartbeat_logging_property " + string9, writer, MessageLogger.DetachedWrite.class, detachedWrite, "enabled");
                                }
                            }
                        }
                        if ((discoveryConfig = xvmConfig.get("discovery")) != null || xvmConfig.get("discoveryDescriptor") != null) {
                            writer.println("server_set_property " + string9 + " discoveryDescriptor " + UtlText.quoteAndEscape((String)DdlPropertyParser.parseDescriptor(discoveryConfig, xvmConfig.get("discoveryDescriptor"))));
                        }
                        if ((adminConfig = xvmConfig.get("admin")) != null) {
                            DdlConfigNode adminSmaConfig;
                            DdlPropertyParser.writeBeanPathProperties("server_set_admin_property " + string9, writer, XvmConfig.Admin.class, adminConfig, "enabled");
                            DdlConfigNode transportsConfig = adminConfig.get("transports");
                            if (transportsConfig != null && (adminSmaConfig = transportsConfig.get("sma")) != null) {
                                writer.println("server_set_admin_sma_property " + string9 + " enabled " + adminSmaConfig.getValue("enabled", true));
                                DdlPropertyParser.writeBeanPathProperties("server_set_admin_sma_property " + string9, writer, XvmConfig.Admin.Transports.Sma.class, adminSmaConfig, "enabled");
                                DdlConfigNode adminSmaChannelsConfig = adminSmaConfig.get("channels");
                                if (adminSmaChannelsConfig != null) {
                                    for (DdlConfigNode adminMessagingChannelConfig : adminSmaChannelsConfig.getChildren()) {
                                        writer.println("server_set_admin_sma_channel_property " + string9 + " " + adminMessagingChannelConfig.getName() + " enabled " + adminMessagingChannelConfig.getValue("enabled", true));
                                        DdlPropertyParser.writeBeanPathProperties("server_set_admin_sma_channel_property " + string9 + " " + adminMessagingChannelConfig.getName(), writer, XvmAdminChannelConfig.class, adminMessagingChannelConfig, "enabled");
                                    }
                                }
                            }
                        }
                        DdlPropertyParser.writeBeanPathProperties("server_set_property " + string9, writer, XvmConfigList.Xvm.class, xvmConfig, "name", "template", "enabled", "discoveryDescriptor");
                        writer.println("");
                        if (systemName != null) {
                            writer.println("server_set_property " + string9 + " systemName " + UtlText.quoteAndEscape((String)systemName));
                        }
                        if (systemName != null) {
                            writer.println("server_set_property " + string9 + " systemVersion " + UtlText.quoteAndEscape((String)systemVersion));
                        }
                        writer.println("");
                    }
                }
                writer.println("repo_commit");
            }
        }
        finally {
            writer.close();
            if (DdlPropertyParser.tracer.debug) {
                tracer.log("Converted DDL properties to XCS\n" + debugTrace.toString(), Tracer.Level.DEBUG);
            }
        }
    }

    private static final void applyConfigTreeProfiles(DdlConfigNode config, UtlTailoring.PropertySource envAndOverrides, boolean removeProfiles) {
        Map<String, DdlConfigNode> activatedProfiles = DdlPropertyParser.getActivatedProfiles(config, envAndOverrides);
        if (!activatedProfiles.isEmpty()) {
            if (DdlPropertyParser.tracer.debug) {
                tracer.log("Applying DDL configuration profiles: " + activatedProfiles.keySet(), Tracer.Level.DEBUG);
            }
            for (DdlConfigNode profile : activatedProfiles.values()) {
                DdlConfigNode activationNode = profile.remove("activation");
                DdlConfigNode orderNode = profile.remove("order");
                String profileName = profile.getName();
                if (DdlPropertyParser.tracer.debug) {
                    tracer.log("Applying profile '" + profileName + "'", Tracer.Level.DEBUG);
                }
                config.merge(profile, true);
                if (activationNode != null) {
                    profile.addNode("activation", activationNode);
                }
                if (orderNode == null) continue;
                profile.addNode("order", orderNode);
            }
        } else if (config.get("profiles") != null) {
            tracer.log("No DDL profiles activated", Tracer.Level.DEBUG);
        }
        if (removeProfiles) {
            config.remove("profiles");
        }
    }

    private static final Map<String, DdlConfigNode> getActivatedProfiles(DdlConfigNode config, UtlTailoring.PropertySource envAndOverrides) {
        DdlConfigNode profiles = null;
        if (config != null) {
            profiles = config.get("profiles");
        }
        if (profiles == null) {
            return Collections.emptyMap();
        }
        final ArrayList<String> manuallyActivatedProfiles = new ArrayList<String>();
        if (envAndOverrides != null && envAndOverrides.getValue("nv.ddl.profiles", DdlConfigConstants.DDL_PROFILES_DEFAULT) != null) {
            manuallyActivatedProfiles.addAll(Arrays.asList(envAndOverrides.getValue("nv.ddl.profiles", DdlConfigConstants.DDL_PROFILES_DEFAULT).split(",")));
        }
        final HashMap profileOrders = new HashMap();
        Comparator<String> profileSorter = new Comparator<String>(){

            @Override
            public int compare(String p1, String p2) {
                int o2;
                int o1 = profileOrders.get(p1) == null ? Short.MAX_VALUE : (int)((Short)profileOrders.get(p1)).shortValue();
                int n = o2 = profileOrders.get(p2) == null ? Short.MAX_VALUE : (int)((Short)profileOrders.get(p2)).shortValue();
                if (o1 != o2) {
                    return o1 - o2;
                }
                int i1 = manuallyActivatedProfiles.indexOf(p1);
                int i2 = manuallyActivatedProfiles.indexOf(p2);
                if (i1 == -1) {
                    i1 = Short.MAX_VALUE;
                }
                if (i2 == -1) {
                    i1 = Short.MAX_VALUE;
                }
                return i1 - i2;
            }
        };
        TreeMap<String, DdlConfigNode> sortedActivatedProfiles = new TreeMap<String, DdlConfigNode>(profileSorter);
        if (DdlPropertyParser.tracer.debug) {
            tracer.log("nv.ddl.profiles ... manually activated profiles: " + manuallyActivatedProfiles, Tracer.Level.DEBUG);
        }
        for (DdlConfigNode profile : profiles.getChildren()) {
            if (manuallyActivatedProfiles.contains(profile.getName())) {
                sortedActivatedProfiles.put(profile.getName(), profile);
                continue;
            }
            DdlConfigNode activationPropertiesNode = profile.get("activation.properties");
            if (activationPropertiesNode == null) continue;
            Properties matchProps = new Properties();
            boolean matched = true;
            for (DdlConfigNode prop : activationPropertiesNode.collectDescendents(new TreeSet<DdlConfigNode>())) {
                if (prop.getValue() == null) continue;
                String propName = prop.getFullName().substring(activationPropertiesNode.getFullName().length() + 1);
                String envValue = envAndOverrides != null ? envAndOverrides.getValue(propName, null) : null;
                matchProps.put(propName, prop.getValue());
                if (envValue == null) {
                    if (DdlPropertyParser.tracer.debug) {
                        tracer.log(profile + " not activated, '" + propName + "=" + prop.getValue() + "' is not set in current environment", Tracer.Level.DEBUG);
                    }
                    matched = false;
                    break;
                }
                if (prop.getValue().equals(envValue)) continue;
                if (DdlPropertyParser.tracer.debug) {
                    tracer.log(profile + " not activated, '" + propName + "=" + prop.getValue() + "' does not match env value of '" + envValue + "'", Tracer.Level.DEBUG);
                }
                matched = false;
                break;
            }
            if (matchProps.isEmpty() || !matched) continue;
            sortedActivatedProfiles.put(profile.getName(), profile);
        }
        for (int i = 0; i < manuallyActivatedProfiles.size(); ++i) {
            DdlConfigNode profile;
            profile = profiles.get((String)manuallyActivatedProfiles.get(i));
            if (profile != null) continue;
            tracer.log("Activated DDL config profile '" + (String)manuallyActivatedProfiles.get(i) + "' not found.", Tracer.Level.WARNING);
        }
        return sortedActivatedProfiles;
    }

    /*
     * WARNING - void declaration
     */
    static final Model toModel(Properties ddl, UtlTailoring.PropertySource overrides, boolean validateDdlPropertyNames, boolean applyProfilesAndTemplates) throws Exception {
        DdlConfigNode ddlConfigNode;
        void var13_21;
        DdlConfigNode ddlConfigNode2;
        DdlConfigNode apps;
        DdlConfigNode buses;
        DdlConfigNode busProviders;
        DdlConfigNode systemDetailsConfig;
        DdlConfigNode xConfig;
        if (DdlPropertyParser.tracer.debug) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ddl.list(pw);
            tracer.log("Converting DDL properties to model:\n" + sw.toString(), Tracer.Level.DEBUG);
        }
        Model model = new Model();
        String xConfigRootPath = ddl.getProperty("nv.ddl.prefix", "x");
        String string = xConfigRootPath = overrides != null ? overrides.getValue("nv.ddl.prefix", xConfigRootPath) : xConfigRootPath;
        if (xConfigRootPath.trim().length() == 0) {
            throw new IllegalArgumentException("nv.ddl.prefix cannot be empty");
        }
        DdlConfigTree config = DdlPropertyParser.toConfigTree(ddl, overrides);
        if (DdlPropertyParser.tracer.debug) {
            tracer.log("Parsed Config Tree:\n" + config, Tracer.Level.DEBUG);
        }
        if ((xConfig = config.get(xConfigRootPath)) == null) {
            tracer.log("No X config specified (no properties starting with '" + xConfigRootPath + ") no configuration will be seeded.')", Tracer.Level.WARNING);
            if (DdlPropertyParser.tracer.debug) {
                StringBuilder xml = new StringBuilder();
                DdlXMLParser.toXml(model, xml);
                tracer.log("Converted DDL properties to (empty) model:" + xml, Tracer.Level.DEBUG);
            }
            return model;
        }
        if (applyProfilesAndTemplates) {
            DdlPropertyParser.applyConfigTreeProfiles(xConfig, overrides, true);
            if (DdlPropertyParser.tracer.debug) {
                tracer.log("Applied DDL profiles:\n" + config, Tracer.Level.DEBUG);
            }
        }
        DdlPropertyParser.setBeanPathProperties(model, xConfig, validateDdlPropertyNames, new String[0]);
        DdlConfigNode envConfig = xConfig.get("env");
        if (envConfig != null) {
            Model.Env modelEnv = new Model.Env();
            model.setEnv(modelEnv);
            DdlPropertyParser.setEnvElements(modelEnv, envConfig);
        }
        if ((systemDetailsConfig = xConfig.get("systemDetails")) != null) {
            Model.SystemDetails modelSystemDetails = new Model.SystemDetails();
            DdlPropertyParser.setBeanPathProperties(modelSystemDetails, systemDetailsConfig, validateDdlPropertyNames, new String[0]);
            model.setSystemDetails(modelSystemDetails);
        }
        if ((busProviders = xConfig.get("busProviders")) != null) {
            Model.BusProviders modelBusProviders = new Model.BusProviders();
            model.setBusProviders(modelBusProviders);
            for (DdlConfigNode ddlConfigNode3 : busProviders.getChildren()) {
                String string3 = ddlConfigNode3.getName();
                string3 = ddlConfigNode3.getValue("name", string3);
                BusProviderList.Provider provider = new BusProviderList.Provider();
                DdlPropertyParser.toModelBusProvider(string3, ddlConfigNode3, provider, validateDdlPropertyNames);
                modelBusProviders.getProvider().add(provider);
            }
        }
        if ((buses = xConfig.get("buses")) != null) {
            Model.Buses modelBuses = new Model.Buses();
            model.setBuses(modelBuses);
            for (DdlConfigNode ddlConfigNode4 : buses.getChildren()) {
                String string4;
                String string5 = ddlConfigNode4.getValue("name", string4 = ddlConfigNode4.getName());
                if ("templates".equals(string5)) {
                    if (applyProfilesAndTemplates) continue;
                    if (!ddlConfigNode4.getChildren().isEmpty()) {
                        modelBuses.setTemplates(new BusConfigList.Templates());
                    }
                    for (DdlConfigNode ddlConfigNode5 : ddlConfigNode4.getChildren()) {
                        String string7 = ddlConfigNode5.getName();
                        string7 = ddlConfigNode5.getValue("name", string7);
                        BusConfigList.Templates.Bus templateBus = new BusConfigList.Templates.Bus();
                        DdlPropertyParser.toModelBus(string7, ddlConfigNode5, templateBus, validateDdlPropertyNames, true);
                        modelBuses.getTemplates().getBus().add(templateBus);
                    }
                    continue;
                }
                if (applyProfilesAndTemplates) {
                    DdlPropertyParser.templatize(ddlConfigNode4, buses.get("templates"));
                }
                BusConfigList.Bus modelBus = new BusConfigList.Bus();
                DdlPropertyParser.toModelBus(string5, ddlConfigNode4, modelBus, validateDdlPropertyNames, false);
                modelBuses.getBus().add(modelBus);
            }
        }
        if ((apps = xConfig.get("apps")) != null) {
            Model.Apps apps2 = new Model.Apps();
            model.setApps(apps2);
            for (DdlConfigNode ddlConfigNode6 : apps.getChildren()) {
                String appName = ddlConfigNode6.getName();
                if ("templates".equals(appName = ddlConfigNode6.getValue("name", appName))) {
                    if (applyProfilesAndTemplates) continue;
                    if (!ddlConfigNode6.getChildren().isEmpty()) {
                        apps2.setTemplates(new AppConfigList.Templates());
                    }
                    for (DdlConfigNode ddlConfigNode7 : ddlConfigNode6.getChildren()) {
                        String templateName = ddlConfigNode7.getName();
                        templateName = ddlConfigNode7.getValue("name", templateName);
                        AppConfigList.Templates.App templateApp = new AppConfigList.Templates.App();
                        DdlPropertyParser.toModelApp(templateName, ddlConfigNode7, templateApp, validateDdlPropertyNames, true);
                        apps2.getTemplates().getApp().add(templateApp);
                    }
                    continue;
                }
                if (applyProfilesAndTemplates) {
                    DdlPropertyParser.templatize(ddlConfigNode6, apps.get("templates"));
                }
                AppConfigList.App app = new AppConfigList.App();
                DdlPropertyParser.toModelApp(appName, ddlConfigNode6, app, validateDdlPropertyNames, false);
                if (app.getMainClass() == null) {
                    throw new DdlConfigException("'" + ddlConfigNode6.getFullName() + "' must specify a mainClass.");
                }
                apps2.getApp().add(app);
            }
        }
        if ((ddlConfigNode2 = xConfig.get("xvms")) == null) {
            DdlConfigNode ddlConfigNode8 = xConfig.get("servers");
        } else if (xConfig.get("servers") != null) {
            throw new DdlConfigException("Only one of '" + ddlConfigNode2.getFullName() + "' and '" + xConfig.get("servers").getFullName() + "' can be used.");
        }
        if (var13_21 != null) {
            Model.Xvms xvms = new Model.Xvms();
            model.setXvms(xvms);
            for (DdlConfigNode xvmConfig : var13_21.getChildren()) {
                String string8;
                String string9 = xvmConfig.getValue("name", string8 = xvmConfig.getName());
                if ("templates".equals(string9)) {
                    if (applyProfilesAndTemplates) continue;
                    if (!xvmConfig.getChildren().isEmpty()) {
                        xvms.setTemplates(new XvmConfigList.Templates());
                    }
                    for (DdlConfigNode templateConfig : xvmConfig.getChildren()) {
                        String templateName = templateConfig.getName();
                        templateName = templateConfig.getValue("name", templateName);
                        XvmConfigList.Templates.Xvm templateXvm = new XvmConfigList.Templates.Xvm();
                        DdlPropertyParser.toModelXvm(templateName, templateConfig, templateXvm, validateDdlPropertyNames, true);
                        xvms.getTemplates().getXvm().add(templateXvm);
                    }
                    continue;
                }
                if (applyProfilesAndTemplates) {
                    DdlPropertyParser.templatize(xvmConfig, var13_21.get("templates"));
                }
                XvmConfigList.Xvm xvm = new XvmConfigList.Xvm();
                DdlPropertyParser.toModelXvm(string9, xvmConfig, xvm, validateDdlPropertyNames, false);
                xvms.getXvm().add(xvm);
            }
        }
        if ((ddlConfigNode = xConfig.get("profiles")) != null) {
            Model.Profiles profiles = new Model.Profiles();
            model.setProfiles(profiles);
            for (DdlConfigNode ddlConfigNode9 : ddlConfigNode.getChildren()) {
                void var24_66;
                DdlConfigNode ddlConfigNode10;
                DdlConfigNode profileApps;
                DdlConfigNode profileBuses;
                DdlConfigNode profileBusProviders;
                DdlConfigNode profileSystemDetailsConfig;
                Model.Profiles.Profile profile = new Model.Profiles.Profile();
                profile.setName(ddlConfigNode9.getName());
                profiles.getProfile().add(profile);
                DdlConfigNode profileEnvConfig = ddlConfigNode9.get("env");
                if (profileEnvConfig != null) {
                    Model.Profiles.Profile.Env modelEnv = new Model.Profiles.Profile.Env();
                    profile.setEnv(modelEnv);
                    DdlPropertyParser.setEnvElements(modelEnv, profileEnvConfig);
                }
                if ((profileSystemDetailsConfig = ddlConfigNode9.get("systemDetails")) != null) {
                    Model.Profiles.Profile.SystemDetails modelSystemDetails = new Model.Profiles.Profile.SystemDetails();
                    DdlPropertyParser.setBeanPathProperties(modelSystemDetails, profileSystemDetailsConfig, validateDdlPropertyNames, new String[0]);
                    profile.setSystemDetails(modelSystemDetails);
                }
                if ((profileBusProviders = ddlConfigNode9.get("busProviders")) != null) {
                    Model.Profiles.Profile.BusProviders modelBusProviders = new Model.Profiles.Profile.BusProviders();
                    profile.setBusProviders(modelBusProviders);
                    for (DdlConfigNode ddlConfigNode11 : profileBusProviders.getChildren()) {
                        String busProviderName = ddlConfigNode11.getName();
                        busProviderName = ddlConfigNode11.getValue("name", busProviderName);
                        BusProviderList.Provider modelBusProvider = new BusProviderList.Provider();
                        DdlPropertyParser.toModelBusProvider(busProviderName, ddlConfigNode11, modelBusProvider, validateDdlPropertyNames);
                        modelBusProviders.getProvider().add(modelBusProvider);
                    }
                }
                if ((profileBuses = ddlConfigNode9.get("buses")) != null) {
                    Model.Profiles.Profile.Buses modelBuses = new Model.Profiles.Profile.Buses();
                    profile.setBuses(modelBuses);
                    for (Object busConfig : profileBuses.getChildren()) {
                        String busName = ((DdlConfigNode)busConfig).getName();
                        if ("templates".equals(busName = ((DdlConfigNode)busConfig).getValue("name", busName))) {
                            if (applyProfilesAndTemplates) continue;
                            if (!((DdlConfigNode)busConfig).getChildren().isEmpty()) {
                                modelBuses.setTemplates(new BusConfigList.Templates());
                            }
                            for (DdlConfigNode ddlConfigNode12 : ((DdlConfigNode)busConfig).getChildren()) {
                                String templateName = ddlConfigNode12.getName();
                                templateName = ddlConfigNode12.getValue("name", templateName);
                                BusConfigList.Templates.Bus templateBus = new BusConfigList.Templates.Bus();
                                DdlPropertyParser.toModelBus(templateName, ddlConfigNode12, templateBus, validateDdlPropertyNames, true);
                                modelBuses.getTemplates().getBus().add(templateBus);
                            }
                            continue;
                        }
                        if (applyProfilesAndTemplates) {
                            DdlPropertyParser.templatize((DdlConfigNode)busConfig, profileBuses.get("templates"));
                        }
                        BusConfigList.Bus modelBus = new BusConfigList.Bus();
                        DdlPropertyParser.toModelBus(busName, (DdlConfigNode)busConfig, modelBus, validateDdlPropertyNames, false);
                        modelBuses.getBus().add(modelBus);
                    }
                }
                if ((profileApps = ddlConfigNode9.get("apps")) != null) {
                    Object busConfig;
                    Model.Profiles.Profile.Apps apps3 = new Model.Profiles.Profile.Apps();
                    profile.setApps(apps3);
                    busConfig = profileApps.getChildren().iterator();
                    while (busConfig.hasNext()) {
                        DdlConfigNode appConfig = (DdlConfigNode)busConfig.next();
                        String appName = appConfig.getName();
                        if ("templates".equals(appName = appConfig.getValue("name", appName))) {
                            if (applyProfilesAndTemplates) continue;
                            if (!appConfig.getChildren().isEmpty()) {
                                apps3.setTemplates(new AppConfigList.Templates());
                            }
                            for (Object templateConfig2 : appConfig.getChildren()) {
                                String templateName = ((DdlConfigNode)templateConfig2).getName();
                                templateName = ((DdlConfigNode)templateConfig2).getValue("name", templateName);
                                AppConfigList.Templates.App templateApp = new AppConfigList.Templates.App();
                                DdlPropertyParser.toModelApp(templateName, (DdlConfigNode)templateConfig2, templateApp, validateDdlPropertyNames, true);
                                apps3.getTemplates().getApp().add(templateApp);
                            }
                            continue;
                        }
                        if (applyProfilesAndTemplates) {
                            DdlPropertyParser.templatize(appConfig, profileApps.get("templates"));
                        }
                        AppConfigList.App app = new AppConfigList.App();
                        DdlPropertyParser.toModelApp(appName, appConfig, app, validateDdlPropertyNames, false);
                        apps3.getApp().add(app);
                    }
                }
                if ((ddlConfigNode10 = ddlConfigNode9.get("xvms")) == null) {
                    DdlConfigNode ddlConfigNode13 = ddlConfigNode9.get("servers");
                } else if (ddlConfigNode9.get("servers") != null) {
                    throw new DdlConfigException("Only one of '" + ddlConfigNode10.getFullName() + "' and '" + ddlConfigNode9.get("servers").getFullName() + "' can be used.");
                }
                if (var24_66 == null) continue;
                Model.Profiles.Profile.Xvms modelXvms = new Model.Profiles.Profile.Xvms();
                profile.setXvms(modelXvms);
                for (DdlConfigNode xvmConfig : var24_66.getChildren()) {
                    String string10;
                    String string11 = xvmConfig.getValue("name", string10 = xvmConfig.getName());
                    if ("templates".equals(string11)) {
                        Object templateConfig2;
                        if (applyProfilesAndTemplates) continue;
                        if (!xvmConfig.getChildren().isEmpty()) {
                            modelXvms.setTemplates(new XvmConfigList.Templates());
                        }
                        templateConfig2 = xvmConfig.getChildren().iterator();
                        while (templateConfig2.hasNext()) {
                            DdlConfigNode templateConfig = (DdlConfigNode)templateConfig2.next();
                            String templateName = templateConfig.getName();
                            templateName = templateConfig.getValue("name", templateName);
                            XvmConfigList.Templates.Xvm templateXvm = new XvmConfigList.Templates.Xvm();
                            DdlPropertyParser.toModelXvm(templateName, templateConfig, templateXvm, validateDdlPropertyNames, true);
                            modelXvms.getTemplates().getXvm().add(templateXvm);
                        }
                        continue;
                    }
                    if (applyProfilesAndTemplates) {
                        DdlPropertyParser.templatize(xvmConfig, var24_66.get("templates"));
                    }
                    XvmConfigList.Xvm modelXvm = new XvmConfigList.Xvm();
                    DdlPropertyParser.toModelXvm(string11, xvmConfig, modelXvm, validateDdlPropertyNames, false);
                    modelXvms.getXvm().add(modelXvm);
                }
            }
        }
        if (DdlPropertyParser.tracer.debug) {
            StringBuilder stringBuilder = new StringBuilder();
            DdlXMLParser.toXml(model, stringBuilder);
            tracer.log("Converted DDL properties to model:" + stringBuilder, Tracer.Level.DEBUG);
        }
        return model;
    }

    private static void toModelBusProvider(String busName, DdlConfigNode busProviderConfig, BusProvider modelBusProvider, boolean validateDdlPropertyNames) {
        modelBusProvider.setEnabled(busProviderConfig.getValue("enabled", true));
        modelBusProvider.setName(busName);
        DdlPropertyParser.setBeanPathProperties(modelBusProvider, busProviderConfig, validateDdlPropertyNames, "enabled");
    }

    private static void toModelBus(String busName, DdlConfigNode busConfig, BusConfig modelBus, boolean validateDdlPropertyNames, boolean isTemplate) {
        modelBus.setEnabled(busConfig.getValue("enabled", true));
        modelBus.setName(busName);
        DdlConfigNode channels = busConfig.get("channels");
        if (channels != null) {
            BusConfig.Channels modelChannels = new BusConfig.Channels();
            modelBus.setChannels(modelChannels);
            for (DdlConfigNode channelConfig : channels.getChildren()) {
                String key;
                String qos;
                String channelName = channelConfig.getName();
                channelName = channelConfig.getValue("name", channelName);
                BusConfig.Channels.Channel modelChannel = new BusConfig.Channels.Channel();
                modelChannel.setName(channelName);
                String id = channelConfig.getValue("id");
                if (id != null) {
                    modelChannel.setId(Short.valueOf(id));
                }
                if ((qos = channelConfig.getValue("qos")) != null) {
                    modelChannel.setQos(ChannelQos.fromValue(qos));
                }
                if ((key = channelConfig.getValue("key")) != null) {
                    modelChannel.setKey(key);
                }
                DdlPropertyParser.setBeanPathProperties(modelChannel, channelConfig, validateDdlPropertyNames, "name", "id", "qos", "key");
                modelChannels.getChannel().add(modelChannel);
            }
        }
        DdlPropertyParser.setBeanPathProperties(modelBus, busConfig, validateDdlPropertyNames, "enabled");
        if (busConfig.get("properties") != null) {
            BusConfig.Properties busProps = new BusConfig.Properties();
            DdlPropertyParser.addAnyElements(busProps.getAny(), busConfig.get("properties"));
            if (!busProps.getAny().isEmpty()) {
                modelBus.setProperties(busProps);
            }
        }
    }

    private static void toModelApp(String appName, DdlConfigNode appConfig, AppConfig modelApp, boolean validateDdlPropertyNames, boolean isTemplate) {
        DdlConfigNode ddlConfigNode;
        DdlConfigNode perTransactionStatsLoggingConfig;
        DdlConfigNode outboundMessageLoggingConfig;
        DdlConfigNode inboundMessageLoggingConfig;
        DdlConfigNode inboundEventMultiplexingConfig;
        DdlConfigNode messagingConfig;
        modelApp.setName(appName);
        modelApp.setEnabled(appConfig.getValue("enabled", true));
        DdlConfigNode storageConfig = appConfig.get("storage");
        if (storageConfig != null) {
            DdlConfigNode factoriesConfig;
            DdlConfigNode ddlConfigNode2;
            Object persistenceConfig;
            String discoveryDescriptor;
            AppConfig.Storage modelStorage = new AppConfig.Storage();
            modelApp.setStorage(modelStorage);
            modelStorage.setEnabled(storageConfig.getValue("enabled", true));
            String storeDescriptor = storageConfig.getValue("descriptor");
            DdlConfigNode clusteringConfig = storageConfig.get("clustering");
            if (storeDescriptor != null) {
                if (storageConfig.get("clustering") != null) {
                    throw new DdlConfigException("only one of '" + storageConfig.get("descriptor").getFullName() + " and " + storageConfig.get("clustering").getFullName() + "' can be present in DDL config properties.");
                }
                UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse((String)storeDescriptor, null);
                StringBuilder linkParams = new StringBuilder();
                clusteringConfig = storageConfig.add("clustering", null);
                for (Map.Entry entry : descriptor.props.entrySet()) {
                    if (((String)entry.getKey()).equalsIgnoreCase("storeName")) {
                        clusteringConfig.add("storeName", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("localIfAddr")) {
                        clusteringConfig.add("localIfAddr", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("localPort")) {
                        clusteringConfig.add("localPort", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("cpuAffinityMask")) {
                        clusteringConfig.add("linkReaderCpuAffinityMask", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("initWaitTime")) {
                        clusteringConfig.add("initWaitTime(new BigInteger", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("detachedSend")) {
                        clusteringConfig.add("detachedSend.enabled", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("senderCpuAffinityMask")) {
                        clusteringConfig.add("detachedSend.queueDrainerCpuAffinityMask", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("senderQueueDepth")) {
                        clusteringConfig.add("detachedSend.queueDepth", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("senderQueueWaitStrategy")) {
                        clusteringConfig.add("detachedSend.queueWaitStrategy", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("detachedDispatch")) {
                        clusteringConfig.add("detachedDispatch.enabled", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("dispatcherCpuAffinityMask")) {
                        clusteringConfig.add("detachedDispatch.queueDrainerCpuAffinityMask", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("dispatcherQueueDepth")) {
                        clusteringConfig.add("detachedDispatch.queueDepth", (String)entry.getValue());
                        continue;
                    }
                    if (((String)entry.getKey()).equalsIgnoreCase("dispatcherQueueWaitStrategy")) {
                        clusteringConfig.add("detachedDispatch.queueWaitStrategy", (String)entry.getValue());
                        continue;
                    }
                    String linkParam = (String)entry.getKey() + "=" + entry.getValue();
                    if (linkParams.length() > 0) {
                        linkParams.append(",");
                    }
                    linkParams.append(linkParam);
                }
                if (linkParams.length() > 0) {
                    clusteringConfig.add("linkParams", linkParams.toString());
                }
            }
            if ((discoveryDescriptor = storageConfig.getValue("discoveryDescriptor")) != null) {
                if (clusteringConfig != null && (clusteringConfig.getValue("discoveryDescriptor") != null || clusteringConfig.get("discovery") != null)) {
                    throw new DdlConfigException("only one of '" + storageConfig.get("discoveryDescriptor").getFullName() + " and " + clusteringConfig.get("discoveryDescriptor").getFullName() + "' can be present in DDL config properties.");
                }
                tracer.log("'" + storageConfig.get("discoveryDescriptor").getFullName() + "' is deprecated. Use '" + storageConfig.getFullName() + ".clustering.discovery.xxx' or '" + storageConfig.getFullName() + ".clustering.discoveryDescriptor' instead.", Tracer.Level.WARNING);
                if (clusteringConfig == null) {
                    clusteringConfig = storageConfig.add("clustering", null);
                }
                clusteringConfig.add("discoveryDescriptor", discoveryDescriptor);
            }
            if ((clusteringConfig = storageConfig.get("clustering")) != null) {
                DdlConfigNode detachedDispatch;
                AppConfig.Storage.Clustering modelClustering = new AppConfig.Storage.Clustering();
                modelStorage.setClustering(modelClustering);
                modelClustering.setEnabled(clusteringConfig.getValue("enabled", true));
                DdlConfigNode ddlConfigNode3 = clusteringConfig.get("discovery");
                if (ddlConfigNode3 != null) {
                    DiscoveryDescriptor modelClusterDiscovery = new DiscoveryDescriptor();
                    DdlPropertyParser.toModelDescriptor(ddlConfigNode3, modelClusterDiscovery, validateDdlPropertyNames);
                    modelClustering.setDiscovery(modelClusterDiscovery);
                }
                if (clusteringConfig.getValue("discoveryDescriptor") != null) {
                    modelClustering.setDiscoveryDescriptor(clusteringConfig.getValue("discoveryDescriptor"));
                }
                DdlPropertyParser.setBeanPathProperties(modelClustering, clusteringConfig, validateDdlPropertyNames, "enabled", "discoveryDescriptor");
                DdlConfigNode detachedSend = clusteringConfig.get("detachedSend");
                if (detachedSend != null) {
                    AppConfig.Storage.Clustering.DetachedSend modelDetachedSend = new AppConfig.Storage.Clustering.DetachedSend();
                    modelClustering.setDetachedSend(modelDetachedSend);
                    if (detachedSend.getValue("enabled", null) != null) {
                        modelDetachedSend.setEnabled(detachedSend.getValue("enabled", false));
                    }
                    DdlPropertyParser.setBeanPathProperties(modelDetachedSend, detachedSend, validateDdlPropertyNames, "enabled");
                }
                if ((detachedDispatch = clusteringConfig.get("detachedDispatch")) != null) {
                    AppConfig.Storage.Clustering.DetachedDispatch modelDetachedDispatch = new AppConfig.Storage.Clustering.DetachedDispatch();
                    modelClustering.setDetachedDispatch(modelDetachedDispatch);
                    if (detachedDispatch.getValue("enabled", null) != null) {
                        modelDetachedDispatch.setEnabled(detachedDispatch.getValue("enabled", false));
                    }
                    DdlPropertyParser.setBeanPathProperties(modelDetachedDispatch, detachedDispatch, validateDdlPropertyNames, "enabled");
                }
            }
            if ((persistenceConfig = storageConfig.get("persistence")) != null) {
                DdlConfigNode cdc;
                DdlConfigNode compaction;
                AppConfig.Storage.Persistence persistence = new AppConfig.Storage.Persistence();
                modelStorage.setPersistence(persistence);
                persistence.setClazz(((DdlConfigNode)persistenceConfig).getValue("class", null));
                persistence.setEnabled(((DdlConfigNode)persistenceConfig).getValue("enabled", true));
                DdlPropertyParser.setBeanPathProperties(persistence, (DdlConfigNode)persistenceConfig, validateDdlPropertyNames, "enabled", "class");
                DdlConfigNode detachedPersist = ((DdlConfigNode)persistenceConfig).get("detachedPersist");
                if (detachedPersist != null) {
                    AppConfig.Storage.Persistence.DetachedPersist modelDetachedPersist = new AppConfig.Storage.Persistence.DetachedPersist();
                    persistence.setDetachedPersist(modelDetachedPersist);
                    if (detachedPersist.getValue("enabled", null) != null) {
                        modelDetachedPersist.setEnabled(detachedPersist.getValue("enabled", false));
                    }
                    DdlPropertyParser.setBeanPathProperties(modelDetachedPersist, detachedPersist, validateDdlPropertyNames, "enabled");
                }
                if ((compaction = ((DdlConfigNode)persistenceConfig).get("compaction")) != null) {
                    CompactionConfig modelCompaction = new CompactionConfig();
                    persistence.setCompaction(modelCompaction);
                    DdlPropertyParser.setBeanPathProperties(modelCompaction, compaction, validateDdlPropertyNames, "properties");
                    DdlConfigNode compactionProperties = compaction.get("properties");
                    if (compactionProperties != null) {
                        HierarchicalPropertySet modelCompactionProperties = new HierarchicalPropertySet();
                        DdlPropertyParser.addAnyElements(modelCompactionProperties.getAny(), compactionProperties);
                        if (!modelCompactionProperties.getAny().isEmpty()) {
                            modelCompaction.setProperties(modelCompactionProperties);
                        }
                    }
                }
                if ((cdc = ((DdlConfigNode)persistenceConfig).get("cdc")) != null) {
                    CdcConfig modelCdc = new CdcConfig();
                    persistence.setCdc(modelCdc);
                    DdlPropertyParser.setBeanPathProperties(modelCdc, cdc, validateDdlPropertyNames, "properties");
                    DdlConfigNode cdcProperties = cdc.get("properties");
                    if (cdcProperties != null) {
                        HierarchicalPropertySet modelCdcProperties = new HierarchicalPropertySet();
                        DdlPropertyParser.addAnyElements(modelCdcProperties.getAny(), cdcProperties);
                        if (!modelCdcProperties.getAny().isEmpty()) {
                            modelCdc.setProperties(modelCdcProperties);
                        }
                    }
                }
            }
            if ((ddlConfigNode2 = storageConfig.get("icr")) != null && ddlConfigNode2.getValue("enabled", true)) {
                AppConfig.Storage.Icr modelIcr = new AppConfig.Storage.Icr();
                modelStorage.setIcr(modelIcr);
                modelIcr.setEnabled(ddlConfigNode2.getValue("enabled", true));
                DdlConfigNode icrBusConfig = ddlConfigNode2.get("bus");
                if (icrBusConfig != null) {
                    AppConfig.Storage.Icr.Bus modelIcrBus = new AppConfig.Storage.Icr.Bus();
                    DdlPropertyParser.setBeanPathProperties(modelIcrBus, icrBusConfig, validateDdlPropertyNames, new String[0]);
                    if (icrBusConfig.get("properties") != null) {
                        AppConfig.Storage.Icr.Bus.Properties busProps = new AppConfig.Storage.Icr.Bus.Properties();
                        DdlPropertyParser.addAnyElements(busProps.getAny(), icrBusConfig.get("properties"));
                        if (!busProps.getAny().isEmpty()) {
                            modelIcrBus.setProperties(busProps);
                        }
                    }
                    modelIcr.setBus(modelIcrBus);
                }
                DdlPropertyParser.setBeanPathProperties(modelIcr, ddlConfigNode2, validateDdlPropertyNames, "enabled");
                DdlConfigNode detachedSend = ddlConfigNode2.get("detachedSend");
                if (detachedSend != null) {
                    AppConfig.Storage.Icr.DetachedSend modelDetachedSend = new AppConfig.Storage.Icr.DetachedSend();
                    modelIcr.setDetachedSend(modelDetachedSend);
                    if (detachedSend.getValue("enabled", null) != null) {
                        modelDetachedSend.setEnabled(detachedSend.getValue("enabled", false));
                    }
                    DdlPropertyParser.setBeanPathProperties(modelDetachedSend, detachedSend, validateDdlPropertyNames, "enabled");
                }
            }
            if ((factoriesConfig = storageConfig.get("factories")) != null) {
                AppConfig.Storage.Factories modelFactories = new AppConfig.Storage.Factories();
                modelStorage.setFactories(modelFactories);
                for (DdlConfigNode factoryConfig : factoriesConfig.getChildren()) {
                    String factory = factoryConfig.getValue();
                    if (factory == null || factory.length() == 0) continue;
                    AppConfig.Storage.Factories.Factory modelFactory = new AppConfig.Storage.Factories.Factory();
                    modelFactory.setName(factory);
                    DdlPropertyParser.setBeanPathProperties(modelFactory, factoryConfig, validateDdlPropertyNames, "name");
                    modelFactories.getFactory().add(modelFactory);
                }
            }
            DdlPropertyParser.setBeanPathProperties(modelStorage, storageConfig, validateDdlPropertyNames, "enabled", "descriptor", "discoveryDescriptor");
        }
        if ((messagingConfig = appConfig.get("messaging")) != null) {
            DdlConfigNode busesConfig;
            AppConfig.Messaging modelMessaging = new AppConfig.Messaging();
            modelApp.setMessaging(modelMessaging);
            DdlConfigNode factoriesConfig = messagingConfig.get("factories");
            if (factoriesConfig != null) {
                AppConfig.Messaging.Factories modelFactories = new AppConfig.Messaging.Factories();
                modelMessaging.setFactories(modelFactories);
                for (DdlConfigNode ddlConfigNode4 : factoriesConfig.getChildren()) {
                    String factory = ddlConfigNode4.getValue();
                    if (factory == null || factory.length() == 0) continue;
                    AppConfig.Messaging.Factories.Factory modelFactory = new AppConfig.Messaging.Factories.Factory();
                    modelFactory.setName(factory);
                    DdlPropertyParser.setBeanPathProperties(modelFactory, ddlConfigNode4, validateDdlPropertyNames, "name");
                    modelFactories.getFactory().add(modelFactory);
                }
            }
            if ((busesConfig = messagingConfig.get("buses")) != null) {
                AppConfig.Messaging.Buses modelBuses = new AppConfig.Messaging.Buses();
                modelMessaging.setBuses(modelBuses);
                for (DdlConfigNode busConfig : busesConfig.getChildren()) {
                    String busName = busConfig.getName();
                    busName = busConfig.getValue("name", busName);
                    AppBus modelBus = new AppBus();
                    modelBuses.getBus().add(modelBus);
                    modelBus.setName(busName);
                    modelBus.setEnabled(busConfig.getValue("enabled", true));
                    DdlConfigNode channels = busConfig.get("channels");
                    if (channels != null) {
                        AppBus.Channels modelChannels = new AppBus.Channels();
                        modelBus.setChannels(modelChannels);
                        for (DdlConfigNode channelConfig : channels.getChildren()) {
                            String channelName = channelConfig.getName();
                            channelName = channelConfig.getValue("name", channelName);
                            AppBus.Channels.Channel modelChannel = new AppBus.Channels.Channel();
                            modelChannel.setName(channelName);
                            modelChannels.getChannel().add(modelChannel);
                            DdlPropertyParser.setBeanPathProperties(modelChannel, channelConfig, validateDdlPropertyNames, "enabled", "name");
                        }
                    }
                    DdlPropertyParser.setBeanPathProperties(modelBus, busConfig, validateDdlPropertyNames, "enabled", "name");
                    DdlConfigNode detachedSend = busConfig.get("detachedSend");
                    if (detachedSend == null) continue;
                    AppBus.DetachedSend modelDetachedSend = new AppBus.DetachedSend();
                    modelBus.setDetachedSend(modelDetachedSend);
                    if (detachedSend.getValue("enabled", null) != null) {
                        modelDetachedSend.setEnabled(detachedSend.getValue("enabled", false));
                    }
                    DdlPropertyParser.setBeanPathProperties(modelDetachedSend, detachedSend, validateDdlPropertyNames, "enabled");
                }
            }
            DdlPropertyParser.setBeanPathProperties(modelMessaging, messagingConfig, validateDdlPropertyNames, new String[0]);
        }
        if ((inboundEventMultiplexingConfig = appConfig.get("inboundEventMultiplexing")) != null) {
            AppConfig.InboundEventMultiplexing modelInboundEventMultiplexing = new AppConfig.InboundEventMultiplexing();
            modelApp.setInboundEventMultiplexing(modelInboundEventMultiplexing);
            DdlPropertyParser.setBeanPathProperties(modelInboundEventMultiplexing, inboundEventMultiplexingConfig, validateDdlPropertyNames, new String[0]);
        }
        if ((inboundMessageLoggingConfig = appConfig.get("inboundMessageLogging")) != null) {
            AppConfig.InboundMessageLogging modelInboundMessageLogging = new AppConfig.InboundMessageLogging();
            modelApp.setInboundMessageLogging(modelInboundMessageLogging);
            DdlPropertyParser.setBeanPathProperties(modelInboundMessageLogging, inboundMessageLoggingConfig, validateDdlPropertyNames, new String[0]);
            DdlConfigNode detachedWrite = inboundMessageLoggingConfig.get("detachedWrite");
            if (detachedWrite != null) {
                MessageLogger.DetachedWrite detachedWrite2 = new MessageLogger.DetachedWrite();
                modelInboundMessageLogging.setDetachedWrite(detachedWrite2);
                if (detachedWrite.getValue("enabled", null) != null) {
                    detachedWrite2.setEnabled(detachedWrite.getValue("enabled", false));
                }
                DdlPropertyParser.setBeanPathProperties(detachedWrite2, detachedWrite, validateDdlPropertyNames, "enabled");
            }
        }
        if ((outboundMessageLoggingConfig = appConfig.get("outboundMessageLogging")) != null) {
            AppConfig.OutboundMessageLogging modelOutboundMessageLogging = new AppConfig.OutboundMessageLogging();
            modelApp.setOutboundMessageLogging(modelOutboundMessageLogging);
            DdlPropertyParser.setBeanPathProperties(modelOutboundMessageLogging, outboundMessageLoggingConfig, validateDdlPropertyNames, new String[0]);
            DdlConfigNode ddlConfigNode5 = outboundMessageLoggingConfig.get("detachedWrite");
            if (ddlConfigNode5 != null) {
                MessageLogger.DetachedWrite modelDetachedWrite = new MessageLogger.DetachedWrite();
                modelOutboundMessageLogging.setDetachedWrite(modelDetachedWrite);
                if (ddlConfigNode5.getValue("enabled", null) != null) {
                    modelDetachedWrite.setEnabled(ddlConfigNode5.getValue("enabled", false));
                }
                DdlPropertyParser.setBeanPathProperties(modelDetachedWrite, ddlConfigNode5, validateDdlPropertyNames, "enabled");
            }
        }
        if ((perTransactionStatsLoggingConfig = appConfig.get("perTransactionStatsLogging")) != null) {
            AppConfig.PerTransactionStatsLogging perTransactionStatsLogging = new AppConfig.PerTransactionStatsLogging();
            modelApp.setPerTransactionStatsLogging(perTransactionStatsLogging);
            DdlPropertyParser.setBeanPathProperties(perTransactionStatsLogging, perTransactionStatsLoggingConfig, validateDdlPropertyNames, new String[0]);
            DdlConfigNode detachedWrite = perTransactionStatsLoggingConfig.get("detachedWrite");
            if (detachedWrite != null) {
                MessageLogger.DetachedWrite modelDetachedWrite = new MessageLogger.DetachedWrite();
                perTransactionStatsLogging.setDetachedWrite(modelDetachedWrite);
                if (detachedWrite.getValue("enabled", null) != null) {
                    modelDetachedWrite.setEnabled(detachedWrite.getValue("enabled", false));
                }
                DdlPropertyParser.setBeanPathProperties(modelDetachedWrite, detachedWrite, validateDdlPropertyNames, "enabled");
            }
        }
        if ((ddlConfigNode = appConfig.get("startupExpectations")) != null && !ddlConfigNode.getChildren().isEmpty()) {
            LogEmptinessExpectation logEmptiness;
            AppConfig.StartupExpectations modelStartupExpectations = new AppConfig.StartupExpectations();
            modelApp.setStartupExpectations(modelStartupExpectations);
            StoreBindingRoleExpectation role = appConfig.getValue("startupExpectations.role", StoreBindingRoleExpectation.class, null, false);
            if (role != null) {
                modelStartupExpectations.setRole(role);
            }
            if ((logEmptiness = (LogEmptinessExpectation)appConfig.getValue("startupExpectations.logEmptiness", LogEmptinessExpectation.class, null, false)) != null) {
                modelStartupExpectations.setLogEmptiness(logEmptiness);
            }
            DdlPropertyParser.setBeanPathProperties(modelStartupExpectations, ddlConfigNode, validateDdlPropertyNames, "role", "logEmptiness");
        }
        DdlPropertyParser.setBeanPathProperties(modelApp, appConfig, validateDdlPropertyNames, "enabled", "name");
    }

    /*
     * WARNING - void declaration
     */
    private static void toModelXvm(String xvmName, DdlConfigNode xvmConfig, XvmConfig modelXvm, boolean validateDdlPropertyNames, boolean isTemplate) {
        DdlConfigNode ddlConfigNode;
        DdlConfigNode discoveryConfig;
        void var10_19;
        DdlConfigNode multiThreadingConfig;
        DdlConfigNode acceptorsConfig;
        DdlConfigNode xvmAppsConfig;
        DdlConfigNode provisioningConfig;
        modelXvm.setName(xvmName);
        modelXvm.setEnabled(xvmConfig.getValue("enabled", true));
        DdlConfigNode envConfig = xvmConfig.get("env");
        if (envConfig != null) {
            XvmConfig.Env modelEnv = new XvmConfig.Env();
            modelXvm.setEnv(modelEnv);
            DdlPropertyParser.setEnvElements(modelEnv, envConfig);
        }
        if ((provisioningConfig = xvmConfig.get("provisioning")) != null) {
            XvmConfig.Provisioning modelProvisioning = new XvmConfig.Provisioning();
            DdlConfigNode jvmConfig = provisioningConfig.get("jvm");
            if (jvmConfig != null) {
                XvmConfig.Provisioning.Jvm modelJvm = new XvmConfig.Provisioning.Jvm();
                DdlConfigNode ddlConfigNode2 = jvmConfig.get("jvmParamSets");
                if (ddlConfigNode2 != null) {
                    JvmConfig.JvmParamSets modelJvmParamSets = new JvmConfig.JvmParamSets();
                    for (DdlConfigNode ddlConfigNode3 : ddlConfigNode2.getChildren()) {
                        String paramSetName = ddlConfigNode3.getName();
                        paramSetName = ddlConfigNode3.getValue("name", paramSetName);
                        JvmConfig.JvmParamSets.JvmParamSet modelJvmParamSet = new JvmConfig.JvmParamSets.JvmParamSet();
                        modelJvmParamSet.setEnabled(ddlConfigNode3.getValue("enabled", true));
                        modelJvmParamSet.setName(paramSetName);
                        DdlPropertyParser.setBeanPathProperties(modelJvmParamSet, ddlConfigNode3, validateDdlPropertyNames, "name", "enabled");
                        modelJvmParamSets.getJvmParamSet().add(modelJvmParamSet);
                    }
                    modelJvm.setJvmParamSets(modelJvmParamSets);
                }
                DdlPropertyParser.setBeanPathProperties(modelJvm, jvmConfig, validateDdlPropertyNames, "jvmParamSets");
                modelProvisioning.setJvm(modelJvm);
            }
            DdlPropertyParser.setBeanPathProperties(modelProvisioning, provisioningConfig, validateDdlPropertyNames, "jvm");
            modelXvm.setProvisioning(modelProvisioning);
        }
        if ((xvmAppsConfig = xvmConfig.get("apps")) != null) {
            XvmConfig.Apps modelXvmApps = new XvmConfig.Apps();
            modelXvm.setApps(modelXvmApps);
            for (DdlConfigNode ddlConfigNode4 : xvmAppsConfig.getChildren()) {
                String appName = ddlConfigNode4.getName();
                appName = ddlConfigNode4.getValue("name", appName);
                XvmConfig.Apps.App modelXvmApp = new XvmConfig.Apps.App();
                modelXvmApp.setName(appName);
                modelXvmApp.setEnabled(ddlConfigNode4.getValue("enabled", true));
                modelXvmApps.getApp().add(modelXvmApp);
                DdlPropertyParser.setBeanPathProperties(modelXvmApp, ddlConfigNode4, validateDdlPropertyNames, "name", "enabled");
            }
        }
        if ((acceptorsConfig = xvmConfig.get("acceptors")) != null) {
            XvmConfig.Acceptors modelXvmAcceptors = new XvmConfig.Acceptors();
            modelXvm.setAcceptors(modelXvmAcceptors);
            for (DdlConfigNode acceptorConfig : acceptorsConfig.getChildren()) {
                XvmConfig.Acceptors.Acceptor modelXvmAcceptor = new XvmConfig.Acceptors.Acceptor();
                DdlPropertyParser.setBeanPathProperties(modelXvmAcceptor, acceptorConfig, validateDdlPropertyNames, "name");
                modelXvmAcceptors.getAcceptor().add(modelXvmAcceptor);
            }
        }
        if ((multiThreadingConfig = xvmConfig.get("multiThreading")) != null) {
            XvmConfig.MultiThreading multiThreading = new XvmConfig.MultiThreading();
            modelXvm.setMultiThreading(multiThreading);
            DdlPropertyParser.setBeanPathProperties(multiThreading, multiThreadingConfig, validateDdlPropertyNames, new String[0]);
            DdlConfigNode ioThreadsConfig = multiThreadingConfig.get("ioThreads");
            if (ioThreadsConfig != null) {
                XvmConfig.MultiThreading.IoThreads modelXvmMultiThreadingIoThreads = new XvmConfig.MultiThreading.IoThreads();
                multiThreading.setIoThreads(modelXvmMultiThreadingIoThreads);
                DdlPropertyParser.setBeanPathProperties(modelXvmMultiThreadingIoThreads, ioThreadsConfig, false, new String[0]);
                for (DdlConfigNode ioThreadConfig : ioThreadsConfig.getChildren()) {
                    XvmConfig.MultiThreading.IoThreads.IoThread modelXvmIoThread = new XvmConfig.MultiThreading.IoThreads.IoThread();
                    long id = -1L;
                    try {
                        id = Long.parseLong(ioThreadConfig.getName());
                    }
                    catch (NumberFormatException nfe) {
                        throw new DdlConfigException("Invalid xvm io thread configuration '" + ioThreadConfig.getFullName() + "' ... property name should end in the numeric id of the io thread");
                    }
                    modelXvmIoThread.setId(BigInteger.valueOf(id));
                    DdlPropertyParser.setBeanPathProperties(modelXvmIoThread, ioThreadConfig, validateDdlPropertyNames, "id");
                    modelXvmMultiThreadingIoThreads.getIoThread().add(modelXvmIoThread);
                }
            }
        }
        DdlConfigNode ddlConfigNode5 = xvmConfig.get("heartbeats");
        DdlConfigNode hearbeatLoggingConfig = xvmConfig.get("heartbeatLogging");
        if (hearbeatLoggingConfig != null) {
            tracer.log("'" + hearbeatLoggingConfig.getFullName() + "' is deprecated. Use '" + xvmConfig.getFullName() + ".heartbeats.logging' instead.", Tracer.Level.WARNING);
            if (ddlConfigNode5 == null) {
                DdlConfigNode ddlConfigNode6 = xvmConfig.add("heartbeats", null);
                ddlConfigNode6.add("enabled", "false");
            } else if (ddlConfigNode5.get("logging") != null) {
                throw new DdlConfigException("Can't specify both '" + hearbeatLoggingConfig.getFullName() + "' and '" + ddlConfigNode5.get("logging").getFullName() + "'!");
            }
        }
        if (var10_19 != null) {
            XvmConfig.Heartbeats modeXvmHeartbeats = new XvmConfig.Heartbeats();
            modeXvmHeartbeats.setEnabled(var10_19.getValue("enabled", true));
            DdlPropertyParser.setBeanPathProperties(modeXvmHeartbeats, (DdlConfigNode)var10_19, validateDdlPropertyNames, "enabled");
            modelXvm.setHeartbeats(modeXvmHeartbeats);
            DdlConfigNode ddlConfigNode7 = var10_19.get("tracing");
            if (ddlConfigNode7 != null) {
                XvmConfig.Heartbeats.Tracing modelXvmHeartbeatTracing = new XvmConfig.Heartbeats.Tracing();
                modelXvmHeartbeatTracing.setEnabled(ddlConfigNode7.getValue("enabled", true));
                DdlPropertyParser.setBeanPathProperties(modelXvmHeartbeatTracing, ddlConfigNode7, validateDdlPropertyNames, "enabled");
                modeXvmHeartbeats.setTracing(modelXvmHeartbeatTracing);
            }
            DdlConfigNode ddlConfigNode8 = hearbeatLoggingConfig = hearbeatLoggingConfig != null ? hearbeatLoggingConfig : var10_19.get("logging");
            if (hearbeatLoggingConfig != null) {
                XvmConfig.Heartbeats.Logging modelXvmHeartbeatLogging = new XvmConfig.Heartbeats.Logging();
                modelXvmHeartbeatLogging.setEnabled(hearbeatLoggingConfig.getValue("enabled", true));
                DdlPropertyParser.setBeanPathProperties(modelXvmHeartbeatLogging, hearbeatLoggingConfig, validateDdlPropertyNames, "enabled");
                modeXvmHeartbeats.setLogging(modelXvmHeartbeatLogging);
                DdlConfigNode detachedWrite = hearbeatLoggingConfig.get("detachedWrite");
                if (detachedWrite != null) {
                    MessageLogger.DetachedWrite modelDetachedWrite = new MessageLogger.DetachedWrite();
                    modelXvmHeartbeatLogging.setDetachedWrite(modelDetachedWrite);
                    if (detachedWrite.getValue("enabled", null) != null) {
                        modelDetachedWrite.setEnabled(detachedWrite.getValue("enabled", false));
                    }
                    DdlPropertyParser.setBeanPathProperties(modelDetachedWrite, detachedWrite, validateDdlPropertyNames, "enabled");
                }
            }
        }
        if ((discoveryConfig = xvmConfig.get("discovery")) != null) {
            DiscoveryDescriptor discoveryDescriptor = new DiscoveryDescriptor();
            DdlPropertyParser.toModelDescriptor(discoveryConfig, discoveryDescriptor, validateDdlPropertyNames);
            modelXvm.setDiscovery(discoveryDescriptor);
        }
        if (xvmConfig.getValue("discoveryDescriptor") != null) {
            modelXvm.setDiscoveryDescriptor(xvmConfig.getValue("discoveryDescriptor"));
        }
        if ((ddlConfigNode = xvmConfig.get("admin")) != null) {
            XvmConfig.Admin modelAdmin = new XvmConfig.Admin();
            DdlPropertyParser.setBeanPathProperties(modelAdmin, ddlConfigNode, validateDdlPropertyNames, new String[0]);
            DdlConfigNode adminTransportsConfig = ddlConfigNode.get("transports");
            if (adminTransportsConfig != null) {
                XvmConfig.Admin.Transports modelTransports = new XvmConfig.Admin.Transports();
                DdlPropertyParser.setBeanPathProperties(modelTransports, adminTransportsConfig, validateDdlPropertyNames, "enabled");
                DdlConfigNode adminMessagingConfig = adminTransportsConfig.get("sma");
                if (adminMessagingConfig != null) {
                    XvmConfig.Admin.Transports.Sma modelSma = new XvmConfig.Admin.Transports.Sma();
                    modelSma.setEnabled(adminMessagingConfig.getValue("enabled", true));
                    DdlPropertyParser.setBeanPathProperties(modelSma, adminMessagingConfig, validateDdlPropertyNames, "enabled");
                    DdlConfigNode adminMessagingChannelsConfig = adminMessagingConfig.get("channels");
                    if (adminMessagingChannelsConfig != null) {
                        XvmConfig.Admin.Transports.Sma.Channels modelChannels = new XvmConfig.Admin.Transports.Sma.Channels();
                        DdlPropertyParser.setBeanPathProperties(modelChannels, adminMessagingChannelsConfig, validateDdlPropertyNames, "enabled");
                        for (DdlConfigNode adminMessagingChannelConfig : adminMessagingChannelsConfig.getChildren()) {
                            XvmAdminChannelConfig modelChannelConfig;
                            if ("heartbeat".equals(adminMessagingChannelConfig.getName())) {
                                modelChannelConfig = new XvmConfig.Admin.Transports.Sma.Channels.Heartbeat();
                                modelChannelConfig.setEnabled(adminMessagingConfig.getValue("enabled", true));
                                DdlPropertyParser.setBeanPathProperties(modelChannelConfig, adminMessagingChannelConfig, validateDdlPropertyNames, "enabled");
                                modelChannels.setHeartbeat((XvmConfig.Admin.Transports.Sma.Channels.Heartbeat)modelChannelConfig);
                                continue;
                            }
                            if ("events".equals(adminMessagingChannelConfig.getName())) {
                                modelChannelConfig = new XvmConfig.Admin.Transports.Sma.Channels.Event();
                                modelChannelConfig.setEnabled(adminMessagingConfig.getValue("enabled", true));
                                DdlPropertyParser.setBeanPathProperties(modelChannelConfig, adminMessagingChannelConfig, validateDdlPropertyNames, "enabled");
                                modelChannels.setEvent((XvmConfig.Admin.Transports.Sma.Channels.Event)modelChannelConfig);
                                continue;
                            }
                            if ("trace".equals(adminMessagingChannelConfig.getName())) {
                                modelChannelConfig = new XvmConfig.Admin.Transports.Sma.Channels.Trace();
                                modelChannelConfig.setEnabled(adminMessagingConfig.getValue("enabled", true));
                                DdlPropertyParser.setBeanPathProperties(modelChannelConfig, adminMessagingChannelConfig, validateDdlPropertyNames, "enabled");
                                modelChannels.setTrace((XvmConfig.Admin.Transports.Sma.Channels.Trace)modelChannelConfig);
                                continue;
                            }
                            if ("request".equals(adminMessagingChannelConfig.getName())) {
                                modelChannelConfig = new XvmConfig.Admin.Transports.Sma.Channels.Request();
                                modelChannelConfig.setEnabled(adminMessagingConfig.getValue("enabled", true));
                                DdlPropertyParser.setBeanPathProperties(modelChannelConfig, adminMessagingChannelConfig, validateDdlPropertyNames, "enabled");
                                modelChannels.setRequest((XvmConfig.Admin.Transports.Sma.Channels.Request)modelChannelConfig);
                                continue;
                            }
                            if ("response".equals(adminMessagingChannelConfig.getName())) {
                                modelChannelConfig = new XvmConfig.Admin.Transports.Sma.Channels.Response();
                                modelChannelConfig.setEnabled(adminMessagingConfig.getValue("enabled", true));
                                DdlPropertyParser.setBeanPathProperties(modelChannelConfig, adminMessagingChannelConfig, validateDdlPropertyNames, "enabled");
                                modelChannels.setResponse((XvmConfig.Admin.Transports.Sma.Channels.Response)modelChannelConfig);
                                continue;
                            }
                            if (!validateDdlPropertyNames) continue;
                            throw new DdlConfigException("Unrecognized admin channel name '" + adminMessagingChannelConfig.getFullName() + "'");
                        }
                        modelSma.setChannels(modelChannels);
                    }
                    modelTransports.setSma(modelSma);
                }
                modelAdmin.setTransports(modelTransports);
            }
            modelXvm.setAdmin(modelAdmin);
        }
        DdlPropertyParser.setBeanPathProperties(modelXvm, xvmConfig, validateDdlPropertyNames, "name", "enabled", "discoveryDescriptor");
    }

    static final void setEnvElements(HierarchicalPropertySet env, DdlConfigNode envConfig) {
        TreeSet<DdlConfigNode> envElements = new TreeSet<DdlConfigNode>();
        envConfig.collectDescendents(envElements);
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        dbFac.setValidating(false);
        try {
            Document doc = dbFac.newDocumentBuilder().newDocument();
            for (DdlConfigNode envNode : envElements) {
                if (envNode.getValue() == null) continue;
                Element element = doc.createElementNS("http://www.neeveresearch.com/schema/x-ddl", envNode.getFullName().substring(envConfig.getFullName().length() + 1));
                element.appendChild(doc.createTextNode(envNode.getValue()));
                env.getAny().add(element);
            }
        }
        catch (ParserConfigurationException e) {
            throw new DdlConfigException("Error adding environment values to DDL model: " + e.getMessage(), e);
        }
    }

    static final void addAnyElements(List<Element> domPropertyList, DdlConfigNode configProperties) {
        TreeSet<DdlConfigNode> propertyElements = new TreeSet<DdlConfigNode>();
        configProperties.collectDescendents(propertyElements);
        DocumentBuilderFactory dbFac = DocumentBuilderFactory.newInstance();
        dbFac.setValidating(false);
        try {
            Document doc = dbFac.newDocumentBuilder().newDocument();
            for (DdlConfigNode property : propertyElements) {
                if (property.getValue() == null) continue;
                Element element = doc.createElementNS("http://www.neeveresearch.com/schema/x-ddl", property.getFullName().substring(configProperties.getFullName().length() + 1));
                element.appendChild(doc.createTextNode(property.getValue()));
                domPropertyList.add(element);
            }
        }
        catch (ParserConfigurationException e) {
            throw new DdlConfigException("Error adding " + configProperties.getFullName() + " values to DDL model: " + e.getMessage(), e);
        }
    }

    static final Properties toDdlProperties(Model model) throws Exception {
        Properties ddl = new Properties();
        String xConfigPrefix = Config.getValue((String)"nv.ddl.prefix", (String)"x");
        DdlPropertyParser.convertModelElementToProperties(xConfigPrefix, null, model, ddl, new String[0]);
        if (DdlPropertyParser.tracer.debug) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ddl.list(pw);
            tracer.log("Converted XML DDL to properties:\n" + sw.toString(), Tracer.Level.DEBUG);
        }
        return ddl;
    }

    private static final void convertModelElementToProperties(String path, Object parentObject, Object modelObject, Properties ddl, String ... ignored) {
        if (modelObject == null) {
            return;
        }
        Class<?> type = modelObject.getClass();
        if (type.isPrimitive() || type.isEnum() || type == Double.class || type == Float.class || type == Long.class || type == Integer.class || type == Short.class || type == Character.class || type == Byte.class || type == Boolean.class || type == String.class || type == BigInteger.class || type == BigDecimal.class) {
            String value = null;
            if (type.isEnum() && modelObject.getClass().isAnnotationPresent(XmlEnum.class)) {
                try {
                    value = (String)UtlReflection.getMethod(type, (String)"value", (Class[])new Class[0]).invoke(modelObject, new Object[0]);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error retrieving DDL enum constant value for: " + type + " at path " + path);
                }
            } else {
                value = modelObject.toString();
            }
            if (path.endsWith("jvmParams") && (parentObject instanceof JvmConfig.JvmParamSets.JvmParamSet || parentObject instanceof JvmConfig)) {
                value = UtlText.removeLineBreaks((String)value);
            }
            ddl.put(path, value);
            if (DdlPropertyParser.tracer.debug) {
                tracer.log("Added " + path + "=" + value, Tracer.Level.DEBUG);
            }
            return;
        }
        if (modelObject instanceof HierarchicalPropertySet) {
            Properties envElements = new Properties();
            for (Element prop : ((HierarchicalPropertySet)modelObject).getAny()) {
                DdlXMLParser.collectAnyProperties(path, prop, envElements);
            }
            ddl.putAll((Map<?, ?>)envElements);
            if (DdlPropertyParser.tracer.debug) {
                tracer.log("Added '" + path + "' properties: " + envElements, Tracer.Level.DEBUG);
            }
            return;
        }
        if (modelObject instanceof Collection) {
            int i = 1;
            for (Object o : (Collection)modelObject) {
                String[] nameProps = new String[]{"name", "id"};
                String nameProp = null;
                String name = null;
                for (int n = 0; n < nameProps.length; ++n) {
                    Object id = UtlReflection.getProperty(o, (String)nameProps[n]);
                    if (id == null) continue;
                    nameProp = nameProps[n];
                    name = String.valueOf(id);
                    break;
                }
                if (name == null) {
                    name = "" + i++;
                }
                name = DdlConfigNode.escapedPath(name);
                if (o instanceof AppBus && parentObject != null && parentObject instanceof AppConfig.Messaging) {
                    name = "buses." + name;
                } else {
                    if (o instanceof AppConfig.Messaging.Factories.Factory) {
                        name = "" + i++;
                        ddl.put(path.substring(0, path.lastIndexOf(46)) + "." + name, ((AppConfig.Messaging.Factories.Factory)o).getName());
                        continue;
                    }
                    if (o instanceof AppConfig.Storage.Factories.Factory) {
                        name = "" + i++;
                        ddl.put(path.substring(0, path.lastIndexOf(46)) + "." + name, ((AppConfig.Storage.Factories.Factory)o).getName());
                        continue;
                    }
                }
                DdlPropertyParser.convertModelElementToProperties(path.substring(0, path.lastIndexOf(46)) + "." + name, modelObject, o, ddl, nameProp);
            }
            return;
        }
        block5: for (String prop : UtlReflection.getDecamelCasedNonObjectProperties(modelObject.getClass())) {
            for (int i = 0; i < ignored.length; ++i) {
                if (prop.equals(ignored[i])) continue block5;
            }
            Object value = UtlReflection.getProperty((Object)modelObject, (String)prop);
            if (modelObject instanceof AppConfig.Storage.Persistence && prop.equalsIgnoreCase("clazz")) {
                prop = "class";
            }
            DdlPropertyParser.convertModelElementToProperties(path + "." + prop, modelObject, value, ddl, new String[0]);
        }
    }

    private static String parseDescriptor(DdlConfigNode node, DdlConfigNode alternateValueNode) {
        DdlConfigNode busProperties;
        String port;
        StringBuilder descriptor = new StringBuilder();
        String descriptorString = alternateValueNode != null ? alternateValueNode.getValue() : null;
        String provider = node != null ? node.getValue("provider") : null;
        String address = node != null ? node.getValue("address") : null;
        String string = port = node != null ? node.getValue("port") : null;
        if (descriptorString != null) {
            if (provider != null) {
                throw new DdlConfigException("Both '" + node.getFullName() + ".provider' and '" + node.getFullName() + "." + alternateValueNode.getFullName() + "' cannot be specified.");
            }
            if (address != null) {
                throw new DdlConfigException("Both '" + node.getFullName() + ".address' and '" + node.getFullName() + "." + alternateValueNode.getFullName() + "' cannot be specified.");
            }
            if (port != null) {
                throw new DdlConfigException("Both '" + node.getFullName() + ".port' and '" + node.getFullName() + "." + alternateValueNode.getFullName() + "' ' cannot be specified.");
            }
            descriptor.append(descriptorString);
        } else {
            if (alternateValueNode != null) {
                if (provider == null) {
                    throw new DdlConfigException("'" + node.getFullName() + ".provider' is required when '" + node.getFullName() + "." + alternateValueNode.getFullName() + "'  is not specified");
                }
                if (address == null) {
                    throw new DdlConfigException("'" + node.getFullName() + ".address' is required when '" + node.getFullName() + "." + alternateValueNode.getFullName() + "'  is not specified");
                }
            } else {
                if (provider == null) {
                    throw new DdlConfigException("'" + node.getFullName() + ".provider' is required");
                }
                if (address == null) {
                    throw new DdlConfigException("'" + node.getFullName() + ".address' is required");
                }
            }
            descriptor.append(provider).append("://").append(address);
            if (port != null) {
                descriptor.append(":").append(port);
            }
        }
        DdlConfigNode ddlConfigNode = busProperties = node != null ? node.get("properties") : null;
        if (busProperties != null) {
            for (DdlConfigNode prop : busProperties.collectDescendents(new TreeSet<DdlConfigNode>())) {
                if (prop.getValue() == null) continue;
                String propName = prop.getFullName().substring(busProperties.getFullName().length() + 1);
                descriptor.append("&").append(propName).append("=").append(prop.getValue());
            }
        }
        return descriptor.toString();
    }

    private static void toModelDescriptor(DdlConfigNode node, DiscoveryDescriptor modelElement, boolean validateDdlPropertyNames) {
        DdlConfigNode descriptorProperties;
        DdlPropertyParser.setBeanPathProperties(modelElement, node, validateDdlPropertyNames, "enabled");
        DdlConfigNode ddlConfigNode = descriptorProperties = node != null ? node.get("properties") : null;
        if (descriptorProperties != null) {
            DiscoveryDescriptor.Properties discoveryProperties = new DiscoveryDescriptor.Properties();
            DdlPropertyParser.addAnyElements(discoveryProperties.getAny(), descriptorProperties);
            if (!discoveryProperties.getAny().isEmpty()) {
                modelElement.setProperties(discoveryProperties);
            }
        }
    }

    private static final void writeBeanPathProperties(String xcsCommandPrefix, PrintWriter writer, Class<?> beanClass, DdlConfigNode configNode, String ... ignored) {
        block0: for (String propName : UtlReflection.getDecamelCasedNonObjectProperties(beanClass)) {
            if (propName.indexOf(".") != -1 || configNode.getValue(propName) == null) continue;
            if (ignored != null) {
                for (String ignore : ignored) {
                    if (propName.equals(ignore)) continue block0;
                }
            }
            writer.println(xcsCommandPrefix + " " + propName + " " + UtlText.quoteAndEscape((String)configNode.getValue(propName)));
        }
    }

    private static final void setBeanPathProperties(Object modelElement, DdlConfigNode configNode, boolean validatePropertyNames, String ... ignored) {
        if (validatePropertyNames) {
            Set knownProps = UtlReflection.getDecamelCasedNonObjectProperties(modelElement.getClass());
            block4: for (DdlConfigNode node : configNode.getChildren()) {
                Class c;
                if (!knownProps.contains(node.getName())) {
                    if (ignored != null) {
                        for (String ignore : ignored) {
                            if (node.getName().equals(ignore)) continue block4;
                        }
                    }
                    throw new DdlConfigException("DDL config property: '" + node.getName() + "' at path '" + node.getParent().getFullName() + "' is not a valid property. Expected one of " + knownProps);
                }
                if (node.getChildren().isEmpty() || (c = UtlReflection.getUnwrappedReturnType(modelElement.getClass(), (String)node.getName())) != null && !c.isAnnotationPresent(XmlEnum.class) && c.isAnnotationPresent(XmlType.class)) continue;
                DdlConfigNode childNode = node.getChildren().iterator().next();
                throw new DdlConfigException("DDL config property: '" + childNode.getName() + "' at path '" + childNode.getParent().getFullName() + "' is not a valid property. Parent property is a leaf property.");
            }
        }
        block6: for (String propName : UtlReflection.getDecamelCasedNonObjectProperties(modelElement.getClass())) {
            String value;
            if (propName.indexOf(".") != -1 || (value = configNode.getValue(propName)) == null) continue;
            Class type = UtlReflection.getUnwrappedReturnType(modelElement.getClass(), (String)propName);
            if (type.isEnum() && type.isAnnotationPresent(XmlEnum.class)) {
                try {
                    value = String.valueOf(UtlReflection.getMethod((Class)type, (String)"fromValue", (Class[])new Class[]{String.class}).invoke(null, value));
                }
                catch (Throwable t) {
                    throw new DdlConfigException("Error retrieving DDL enum constant value for: " + type + " at path " + propName, t);
                }
            }
            if (ignored != null) {
                for (String ignore : ignored) {
                    if (propName.equals(ignore)) continue block6;
                }
            }
            try {
                UtlReflection.setNonNestedProperty((Object)modelElement, (String)propName, (Object)value);
            }
            catch (Throwable thrown) {
                throw new DdlConfigException("Error setting model property '" + modelElement.getClass().getCanonicalName() + "." + propName + "' on to '" + value + "': " + thrown.getMessage(), thrown);
            }
        }
    }

    private static void templatize(DdlConfigNode node, DdlConfigNode templatesNode) {
        String template = node.getValue("template", null);
        if (template == null) {
            return;
        }
        DdlConfigNode templateNode = null;
        if (templatesNode != null) {
            for (DdlConfigNode candidate : templatesNode.getChildren()) {
                String templateName = candidate.getName();
                if (!(templateName = candidate.getValue("name", templateName)).equals(template)) continue;
                templateNode = candidate;
            }
        }
        if (templateNode == null) {
            throw new DdlConfigException("Template '" + template + "' does not exist for '" + node.getFullName() + "'");
        }
        if (templateNode != null) {
            node.merge(templateNode, false);
        }
        node.remove("template");
    }

    private static DdlConfigTree toConfigTree(Properties props, UtlTailoring.PropertySource overrides) {
        DdlConfigTree configTree = new DdlConfigTree(overrides);
        for (Object key : props.keySet()) {
            configTree.add(key.toString(), String.valueOf(props.get(key)));
        }
        return configTree;
    }
}

