/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.QueryTreeNode;

public class SavepointNode
extends DDLStatementNode {
    private StatementType statementType;
    private String savepointName;

    @Override
    public void init(Object objectName, Object statementType) throws StandardException {
        this.initAndCheck(null);
        this.savepointName = (String)objectName;
        this.statementType = (StatementType)((Object)statementType);
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        SavepointNode other = (SavepointNode)node;
        this.statementType = other.statementType;
        this.savepointName = other.savepointName;
    }

    @Override
    public String toString() {
        String tempString = "savepointName: \n" + this.savepointName + "\n";
        tempString = tempString + "savepointStatementType: " + "\n" + (Object)((Object)this.statementType) + "\n";
        return super.toString() + tempString;
    }

    @Override
    public String statementToString() {
        switch (this.statementType) {
            case SET: {
                return "SAVEPOINT";
            }
            case ROLLBACK: {
                return "ROLLBACK WORK TO SAVEPOINT";
            }
            case RELEASE: {
                return "RELEASE TO SAVEPOINT";
            }
        }
        assert (false) : "Unknown savepoint statement type";
        return "UNKNOWN";
    }

    public static enum StatementType {
        SET,
        ROLLBACK,
        RELEASE;

    }
}

